/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.rubypeople.rdt.core.IRubyModelStatus;
import org.rubypeople.rdt.internal.core.RubyModelStatus;

public class RubyModelException
extends CoreException {
    private static final long serialVersionUID = -760398656505871287L;
    CoreException nestedCoreException;

    public RubyModelException(Throwable throwable, int n) {
        this(new RubyModelStatus(n, throwable));
    }

    public RubyModelException(CoreException coreException) {
        super(coreException.getStatus());
        this.nestedCoreException = coreException;
    }

    public RubyModelException(IRubyModelStatus iRubyModelStatus) {
        super((IStatus)iRubyModelStatus);
    }

    public Throwable getException() {
        if (this.nestedCoreException == null) {
            return this.getStatus().getException();
        }
        return this.nestedCoreException;
    }

    public IRubyModelStatus getRubyModelStatus() {
        IStatus iStatus = this.getStatus();
        if (iStatus instanceof IRubyModelStatus) {
            return (IRubyModelStatus)iStatus;
        }
        return new RubyModelStatus(this.nestedCoreException);
    }

    public boolean isDoesNotExist() {
        IRubyModelStatus iRubyModelStatus = this.getRubyModelStatus();
        return iRubyModelStatus != null && iRubyModelStatus.isDoesNotExist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            super.printStackTrace(printStream);
            Throwable throwable = this.getException();
            if (throwable != null) {
                printStream.print("Caused by: ");
                throwable.printStackTrace(printStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            super.printStackTrace(printWriter);
            Throwable throwable = this.getException();
            if (throwable != null) {
                printWriter.print("Caused by: ");
                throwable.printStackTrace(printWriter);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Ruby Model Exception: ");
        if (this.getException() != null) {
            if (this.getException() instanceof CoreException) {
                CoreException coreException = (CoreException)this.getException();
                stringBuffer.append("Core Exception [code ");
                stringBuffer.append(coreException.getStatus().getCode());
                stringBuffer.append("] ");
                stringBuffer.append(coreException.getStatus().getMessage());
            } else {
                stringBuffer.append(this.getException().toString());
            }
        } else {
            stringBuffer.append(this.getStatus().toString());
        }
        return stringBuffer.toString();
    }
}

