/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.folding;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.text.Assert;
import org.rubypeople.rdt.internal.ui.text.folding.EmptyRubyFoldingPreferenceBlock;
import org.rubypeople.rdt.ui.text.folding.IRubyFoldingPreferenceBlock;
import org.rubypeople.rdt.ui.text.folding.IRubyFoldingStructureProvider;

public final class RubyFoldingStructureProviderDescriptor {
    private static final String PREFERENCES_CLASS = "preferencesClass";
    private static final String CLASS = "class";
    private static final String NAME = "name";
    private static final String ID = "id";
    private String fId;
    private String fName;
    private String fClass;
    private boolean fHasPreferences;
    private IConfigurationElement fElement;

    RubyFoldingStructureProviderDescriptor(IConfigurationElement iConfigurationElement) {
        this.fElement = iConfigurationElement;
        this.fId = iConfigurationElement.getAttributeAsIs(ID);
        Assert.isLegal((this.fId != null ? 1 : 0) != 0);
        this.fName = iConfigurationElement.getAttribute(NAME);
        if (this.fName == null) {
            this.fName = this.fId;
        }
        this.fClass = iConfigurationElement.getAttributeAsIs(CLASS);
        Assert.isLegal((this.fClass != null ? 1 : 0) != 0);
        this.fHasPreferences = iConfigurationElement.getAttributeAsIs(PREFERENCES_CLASS) != null;
    }

    public IRubyFoldingStructureProvider createProvider() throws CoreException {
        IRubyFoldingStructureProvider iRubyFoldingStructureProvider = (IRubyFoldingStructureProvider)this.fElement.createExecutableExtension(CLASS);
        return iRubyFoldingStructureProvider;
    }

    public IRubyFoldingPreferenceBlock createPreferences() throws CoreException {
        if (this.fHasPreferences) {
            IRubyFoldingPreferenceBlock iRubyFoldingPreferenceBlock = (IRubyFoldingPreferenceBlock)this.fElement.createExecutableExtension(PREFERENCES_CLASS);
            return iRubyFoldingPreferenceBlock;
        }
        return new EmptyRubyFoldingPreferenceBlock();
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }
}

