/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.parts;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.ui.parts.GraphicalViewerImpl;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ScrollingGraphicalViewer
extends GraphicalViewerImpl {
    public final Control createControl(Composite parent) {
        FigureCanvas canvas = new FigureCanvas(parent, this.getLightweightSystem());
        super.setControl((Control)canvas);
        this.installRootFigure();
        return canvas;
    }

    protected FigureCanvas getFigureCanvas() {
        return (FigureCanvas)this.getControl();
    }

    private void installRootFigure() {
        if (this.getFigureCanvas() == null) {
            return;
        }
        if (this.rootFigure instanceof Viewport) {
            this.getFigureCanvas().setViewport((Viewport)this.rootFigure);
        } else {
            this.getFigureCanvas().setContents(this.rootFigure);
        }
    }

    public void reveal(EditPart part) {
        super.reveal(part);
        Viewport port = this.getFigureCanvas().getViewport();
        IFigure target = ((GraphicalEditPart)part).getFigure();
        Rectangle exposeRegion = target.getBounds().getCopy();
        target = target.getParent();
        while (target != null && target != port) {
            target.translateToParent((Translatable)exposeRegion);
            target = target.getParent();
        }
        exposeRegion.expand(5, 5);
        Dimension viewportSize = port.getClientArea().getSize();
        Point topLeft = exposeRegion.getTopLeft();
        Point bottomRight = exposeRegion.getBottomRight().translate(viewportSize.getNegated());
        Point finalLocation = new Point();
        finalLocation.x = viewportSize.width < exposeRegion.width ? Math.min(bottomRight.x, Math.max(topLeft.x, port.getViewLocation().x)) : Math.min(topLeft.x, Math.max(bottomRight.x, port.getViewLocation().x));
        finalLocation.y = viewportSize.height < exposeRegion.height ? Math.min(bottomRight.y, Math.max(topLeft.y, port.getViewLocation().y)) : Math.min(topLeft.y, Math.max(bottomRight.y, port.getViewLocation().y));
        this.getFigureCanvas().scrollSmoothTo(finalLocation.x, finalLocation.y);
    }

    protected void setRootFigure(IFigure figure) {
        this.rootFigure = figure;
        this.installRootFigure();
    }
}

