'''OpenGL extension NV.evaluators

Overview (from the spec)
	
	OpenGL evaluators provide applications with the capability to
	specify polynomial or rational curves and surfaces using control
	points relative to the Bezier basis.  The curves and surfaces are
	then drawn by evaluating the polynomials provided at various values
	for the u parameter of a curve or the (u,v) parameters of a surface.
	A tensor product formulation is used for the surfaces.
	
	For various historical reasons, evaluators have not been
	particularly popular as an interface for drawing curves and surfaces.
	This extension proposes a new interface for surfaces that provides a
	number of significant enhancements to the functionality provided by
	the original OpenGL evaluators.
	
	Many implementations never optimized evaluators, so applications
	often implemented their own algorithms instead.  This extension
	relaxes some restrictions that make it difficult to optimize
	evaluators.
	
	Also, new vertex attributes have been added to OpenGL through
	extensions, including multiple sets of texture coordinates, a
	secondary color, a fog coordinate, a vertex weight, and others.
	The extensions which added these vertex attributes never bothered
	to update the functionality of evaluators, since they were used so
	little in the first place.  In turn, evaluators have become more and
	more out of date, making it even less likely that developers will
	want to use them.  Most of the attributes are not a big loss, but
	support for multiple sets of texture coordinates would be absolutely
	essential to developers considering the use of evaluators.
	
	OpenGL evaluators only support rectangular patches, not triangular
	patches.  Although triangular patches can be converted into
	rectangular patches, direct support for triangular patches is likely
	to be more efficient.
	
	The tessellation algorithm used is too inflexible for most purposes;
	only the number of rows and columns can be specified.  Adjacent
	patches must then have identical numbers of rows and columns, or
	severe cracking will occur.  Ideally, a number of subdivisions could
	be specified for all four sides of a rectangular patch and for all
	three of a triangular patch.  This extension goes one step further
	and allows those numbers to be specified in floating-point, providing
	a mechanism for smoothly changing the level of detail of the surface.
	
	Meshes evaluated with EvalMesh are required to match up exactly
	with equivalent meshes evaluated with EvalCoord or EvalPoint.
	This makes it difficult or impossible to use optimizations such as
	forward differencing.
	
	Finally, little attention is given to some of the difficult problems
	that can arise when multiple patches are drawn.  Depending on the
	way evaluators are implemented, and depending on the orientation of
	edges, numerical accuracy problems can cause cracks to appear between
	patches with the same boundary control points.  This extension makes
	guarantees that an edge shared between two patches will match up
	exactly under certain conditions.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/NV/evaluators.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_NV_evaluators'
GL_EVAL_2D_NV = constant.Constant( 'GL_EVAL_2D_NV', 0x86C0 )
GL_EVAL_TRIANGULAR_2D_NV = constant.Constant( 'GL_EVAL_TRIANGULAR_2D_NV', 0x86C1 )
GL_MAP_TESSELLATION_NV = constant.Constant( 'GL_MAP_TESSELLATION_NV', 0x86C2 )
GL_MAP_ATTRIB_U_ORDER_NV = constant.Constant( 'GL_MAP_ATTRIB_U_ORDER_NV', 0x86C3 )
GL_MAP_ATTRIB_V_ORDER_NV = constant.Constant( 'GL_MAP_ATTRIB_V_ORDER_NV', 0x86C4 )
GL_EVAL_FRACTIONAL_TESSELLATION_NV = constant.Constant( 'GL_EVAL_FRACTIONAL_TESSELLATION_NV', 0x86C5 )
glget.addGLGetConstant( GL_EVAL_FRACTIONAL_TESSELLATION_NV, (1,) )
GL_EVAL_VERTEX_ATTRIB0_NV = constant.Constant( 'GL_EVAL_VERTEX_ATTRIB0_NV', 0x86C6 )
glget.addGLGetConstant( GL_EVAL_VERTEX_ATTRIB0_NV, (1,) )
GL_EVAL_VERTEX_ATTRIB1_NV = constant.Constant( 'GL_EVAL_VERTEX_ATTRIB1_NV', 0x86C7 )
glget.addGLGetConstant( GL_EVAL_VERTEX_ATTRIB1_NV, (1,) )
GL_EVAL_VERTEX_ATTRIB2_NV = constant.Constant( 'GL_EVAL_VERTEX_ATTRIB2_NV', 0x86C8 )
glget.addGLGetConstant( GL_EVAL_VERTEX_ATTRIB2_NV, (1,) )
GL_EVAL_VERTEX_ATTRIB3_NV = constant.Constant( 'GL_EVAL_VERTEX_ATTRIB3_NV', 0x86C9 )
glget.addGLGetConstant( GL_EVAL_VERTEX_ATTRIB3_NV, (1,) )
GL_EVAL_VERTEX_ATTRIB4_NV = constant.Constant( 'GL_EVAL_VERTEX_ATTRIB4_NV', 0x86CA )
glget.addGLGetConstant( GL_EVAL_VERTEX_ATTRIB4_NV, (1,) )
GL_EVAL_VERTEX_ATTRIB5_NV = constant.Constant( 'GL_EVAL_VERTEX_ATTRIB5_NV', 0x86CB )
glget.addGLGetConstant( GL_EVAL_VERTEX_ATTRIB5_NV, (1,) )
GL_EVAL_VERTEX_ATTRIB6_NV = constant.Constant( 'GL_EVAL_VERTEX_ATTRIB6_NV', 0x86CC )
glget.addGLGetConstant( GL_EVAL_VERTEX_ATTRIB6_NV, (1,) )
GL_EVAL_VERTEX_ATTRIB7_NV = constant.Constant( 'GL_EVAL_VERTEX_ATTRIB7_NV', 0x86CD )
glget.addGLGetConstant( GL_EVAL_VERTEX_ATTRIB7_NV, (1,) )
GL_EVAL_VERTEX_ATTRIB8_NV = constant.Constant( 'GL_EVAL_VERTEX_ATTRIB8_NV', 0x86CE )
glget.addGLGetConstant( GL_EVAL_VERTEX_ATTRIB8_NV, (1,) )
GL_EVAL_VERTEX_ATTRIB9_NV = constant.Constant( 'GL_EVAL_VERTEX_ATTRIB9_NV', 0x86CF )
glget.addGLGetConstant( GL_EVAL_VERTEX_ATTRIB9_NV, (1,) )
GL_EVAL_VERTEX_ATTRIB10_NV = constant.Constant( 'GL_EVAL_VERTEX_ATTRIB10_NV', 0x86D0 )
glget.addGLGetConstant( GL_EVAL_VERTEX_ATTRIB10_NV, (1,) )
GL_EVAL_VERTEX_ATTRIB11_NV = constant.Constant( 'GL_EVAL_VERTEX_ATTRIB11_NV', 0x86D1 )
glget.addGLGetConstant( GL_EVAL_VERTEX_ATTRIB11_NV, (1,) )
GL_EVAL_VERTEX_ATTRIB12_NV = constant.Constant( 'GL_EVAL_VERTEX_ATTRIB12_NV', 0x86D2 )
glget.addGLGetConstant( GL_EVAL_VERTEX_ATTRIB12_NV, (1,) )
GL_EVAL_VERTEX_ATTRIB13_NV = constant.Constant( 'GL_EVAL_VERTEX_ATTRIB13_NV', 0x86D3 )
glget.addGLGetConstant( GL_EVAL_VERTEX_ATTRIB13_NV, (1,) )
GL_EVAL_VERTEX_ATTRIB14_NV = constant.Constant( 'GL_EVAL_VERTEX_ATTRIB14_NV', 0x86D4 )
glget.addGLGetConstant( GL_EVAL_VERTEX_ATTRIB14_NV, (1,) )
GL_EVAL_VERTEX_ATTRIB15_NV = constant.Constant( 'GL_EVAL_VERTEX_ATTRIB15_NV', 0x86D5 )
glget.addGLGetConstant( GL_EVAL_VERTEX_ATTRIB15_NV, (1,) )
GL_MAX_MAP_TESSELLATION_NV = constant.Constant( 'GL_MAX_MAP_TESSELLATION_NV', 0x86D6 )
glget.addGLGetConstant( GL_MAX_MAP_TESSELLATION_NV, (1,) )
GL_MAX_RATIONAL_EVAL_ORDER_NV = constant.Constant( 'GL_MAX_RATIONAL_EVAL_ORDER_NV', 0x86D7 )
glget.addGLGetConstant( GL_MAX_RATIONAL_EVAL_ORDER_NV, (1,) )
glMapControlPointsNV = platform.createExtensionFunction( 
	'glMapControlPointsNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLuint, constants.GLenum, constants.GLsizei, constants.GLsizei, constants.GLint, constants.GLint, constants.GLboolean, ctypes.c_void_p,),
	doc = 'glMapControlPointsNV( GLenum(target), GLuint(index), GLenum(type), GLsizei(ustride), GLsizei(vstride), GLint(uorder), GLint(vorder), GLboolean(packed), c_void_p(points) ) -> None',
	argNames = ('target', 'index', 'type', 'ustride', 'vstride', 'uorder', 'vorder', 'packed', 'points',),
)

glMapParameterivNV = platform.createExtensionFunction( 
	'glMapParameterivNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, arrays.GLintArray,),
	doc = 'glMapParameterivNV( GLenum(target), GLenum(pname), GLintArray(params) ) -> None',
	argNames = ('target', 'pname', 'params',),
)

glMapParameterfvNV = platform.createExtensionFunction( 
	'glMapParameterfvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, arrays.GLfloatArray,),
	doc = 'glMapParameterfvNV( GLenum(target), GLenum(pname), GLfloatArray(params) ) -> None',
	argNames = ('target', 'pname', 'params',),
)

glGetMapControlPointsNV = platform.createExtensionFunction( 
	'glGetMapControlPointsNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLuint, constants.GLenum, constants.GLsizei, constants.GLsizei, constants.GLboolean, ctypes.c_void_p,),
	doc = 'glGetMapControlPointsNV( GLenum(target), GLuint(index), GLenum(type), GLsizei(ustride), GLsizei(vstride), GLboolean(packed), c_void_p(points) ) -> None',
	argNames = ('target', 'index', 'type', 'ustride', 'vstride', 'packed', 'points',),
)

glGetMapParameterivNV = platform.createExtensionFunction( 
	'glGetMapParameterivNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, arrays.GLintArray,),
	doc = 'glGetMapParameterivNV( GLenum(target), GLenum(pname), GLintArray(params) ) -> None',
	argNames = ('target', 'pname', 'params',),
)

glGetMapParameterfvNV = platform.createExtensionFunction( 
	'glGetMapParameterfvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum, arrays.GLfloatArray,),
	doc = 'glGetMapParameterfvNV( GLenum(target), GLenum(pname), GLfloatArray(params) ) -> None',
	argNames = ('target', 'pname', 'params',),
)

glGetMapAttribParameterivNV = platform.createExtensionFunction( 
	'glGetMapAttribParameterivNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLuint, constants.GLenum, arrays.GLintArray,),
	doc = 'glGetMapAttribParameterivNV( GLenum(target), GLuint(index), GLenum(pname), GLintArray(params) ) -> None',
	argNames = ('target', 'index', 'pname', 'params',),
)

glGetMapAttribParameterfvNV = platform.createExtensionFunction( 
	'glGetMapAttribParameterfvNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLuint, constants.GLenum, arrays.GLfloatArray,),
	doc = 'glGetMapAttribParameterfvNV( GLenum(target), GLuint(index), GLenum(pname), GLfloatArray(params) ) -> None',
	argNames = ('target', 'index', 'pname', 'params',),
)

glEvalMapsNV = platform.createExtensionFunction( 
	'glEvalMapsNV', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLenum,),
	doc = 'glEvalMapsNV( GLenum(target), GLenum(mode) ) -> None',
	argNames = ('target', 'mode',),
)


def glInitEvaluatorsNV():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( EXTENSION_NAME )
