/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ******************************************************************************
 *
 * Copyright (C) 1996-2005 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer
 *    unmodified other than the allowable addition of one or more
 *    copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
 *
 * Version: Onyx 5.1.2
 *
 ******************************************************************************/

/* Stack definitions. */
#define qs_head(a_type)							\
struct									\
{									\
    a_type *qsh_top;							\
}

#define qs_head_initializer(a_head) {NULL}

#define qs_elm(a_type)							\
struct									\
{									\
    a_type *qse_down;							\
}

/* Stack functions. */
#define qs_new(a_head)							\
    do									\
    {									\
	(a_head)->qsh_top = NULL;					\
    } while (0)

#define qs_elm_new(a_elm, a_field)					\
    do									\
    {									\
	(a_elm)->a_field.qse_down = NULL;				\
    } while (0)

#define qs_top(a_head) ((a_head)->qsh_top)

#define qs_down(a_elm, a_field)	((a_elm)->a_field.qse_down)

#define qs_push(a_head, a_elm, a_field)					\
    do									\
    {									\
	qs_down((a_elm), a_field) = qs_top(a_head);			\
	qs_top(a_head) = (a_elm);					\
    } while (0)

#define qs_under_push(a_qselm, a_elm, a_field)				\
    do									\
    {									\
	qs_down((a_elm), a_field) = qs_down((a_qselm), a_field);	\
	qs_down((a_qselm), a_field) = (a_elm);				\
    } while (0)

#define qs_pop(a_head, a_field)						\
    do									\
    {									\
	qs_top(a_head) = qs_down(qs_top(a_head), a_field);		\
    } while (0)

#define qs_foreach(a_var, a_head, a_field)				\
    for ((a_var) = qs_top(a_head); (a_var) != NULL;			\
	 (a_var) = qs_down((a_var), a_field))
