// File: uart_tx.v
// Generated by MyHDL 0.8dev
// Date: Fri Jul  6 10:58:05 2012


`timescale 1ns/10ps

module uart_tx (
    tx_bit,
    tx_valid,
    tx_byte,
    tx_clk,
    tx_rst
);


output tx_bit;
reg tx_bit;
input tx_valid;
input [7:0] tx_byte;
input tx_clk;
input tx_rst;

reg [2:0] index;
reg [1:0] state;





always @(posedge tx_clk, negedge tx_rst) begin: UART_TX_FSM
    if ((tx_rst == 0)) begin
        tx_bit <= 1;
        index <= 0;
        state <= 2'b00;
    end
    else begin
        case (state)
            2'b00: begin
                tx_bit <= 1;
                if (tx_valid) begin
                    state <= 2'b01;
                end
            end
            2'b01: begin
                tx_bit <= 0;
                index <= 7;
                state <= 2'b10;
            end
            2'b10: begin
                tx_bit <= tx_byte[index];
                if ((index == 0)) begin
                    state <= 2'b00;
                end
                else begin
                    index <= (index - 1);
                end
            end
        endcase
    end
end

endmodule
