/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.xalan;

import com.nwalsh.xalan.Params;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xml.utils.DOMBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Table {
    private static int pixelsPerInch = 96;
    protected static Hashtable unitHash = null;
    protected static String foURI = "http://www.w3.org/1999/XSL/Format";

    protected static void initializeHash() {
        unitHash = new Hashtable();
        unitHash.put("in", new Float(pixelsPerInch));
        unitHash.put("cm", new Float((double)pixelsPerInch / 2.54));
        unitHash.put("mm", new Float((double)pixelsPerInch / 25.4));
        unitHash.put("pc", new Float(pixelsPerInch / 72 * 12));
        unitHash.put("pt", new Float(pixelsPerInch / 72));
        unitHash.put("px", new Float(1.0f));
    }

    public static void setPixelsPerInch(int value) {
        if (value > 0) {
            pixelsPerInch = value;
            Table.initializeHash();
        }
    }

    public int getPixelsPerInch() {
        return pixelsPerInch;
    }

    public static int convertLength(String length) {
        int sign = 1;
        String digits = "";
        String units = "";
        char[] lench = length.toCharArray();
        float flength = 0.0f;
        boolean done = false;
        int pos = 0;
        float factor = 1.0f;
        int pixels = 0;
        if (unitHash == null) {
            Table.initializeHash();
        }
        if (lench[pos] == '+' || lench[pos] == '-') {
            if (lench[pos] == '-') {
                sign = -1;
            }
            ++pos;
        }
        while (!done) {
            if (pos >= lench.length) {
                done = true;
                continue;
            }
            if ((lench[pos] > '9' || lench[pos] < '0') && lench[pos] != '.') {
                done = true;
                units = length.substring(pos);
                continue;
            }
            digits = digits + lench[pos++];
        }
        try {
            flength = Float.parseFloat(digits);
        }
        catch (NumberFormatException e) {
            System.out.println(digits + " is not a number; 1 used instead.");
            flength = 1.0f;
        }
        Float f = null;
        if (!units.equals("")) {
            f = (Float)unitHash.get(units);
            if (f == null) {
                System.out.println(units + " is not a known unit; 1 used instead.");
                factor = 1.0f;
            } else {
                factor = f.floatValue();
            }
        } else {
            factor = 1.0f;
        }
        f = new Float(flength * factor);
        pixels = f.intValue() * sign;
        return pixels;
    }

    public DocumentFragment adjustColumnWidths(ExpressionContext context, NodeIterator xalanNI) {
        int count;
        Node child;
        int nominalWidth = Table.convertLength(Params.getString(context, "nominal.table.width"));
        String tableWidth = Params.getString(context, "table.width");
        String styleType = Params.getString(context, "stylesheet.result.type");
        boolean foStylesheet = styleType.equals("fo");
        DocumentFragment xalanRTF = (DocumentFragment)xalanNI.nextNode();
        Element colgroup = (Element)xalanRTF.getFirstChild();
        Node firstCol = null;
        firstCol = colgroup.getLocalName().equals("colgroup") ? colgroup.getFirstChild() : colgroup;
        int numColumns = 0;
        for (child = firstCol; child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !child.getNodeName().equals("col") && (!child.getNamespaceURI().equals(foURI) || !child.getLocalName().equals("table-column"))) continue;
            ++numColumns;
        }
        String[] widths = new String[numColumns];
        Element[] columns = new Element[numColumns];
        int colnum = 0;
        for (child = firstCol; child != null; child = child.getNextSibling()) {
            Element col;
            if (child.getNodeType() != 1 || !child.getNodeName().equals("col") && (!child.getNamespaceURI().equals(foURI) || !child.getLocalName().equals("table-column"))) continue;
            columns[colnum] = col = (Element)child;
            widths[colnum] = foStylesheet ? (col.getAttribute("column-width") == null ? "1*" : col.getAttribute("column-width")) : (col.getAttribute("width") == null ? "1*" : col.getAttribute("width"));
            ++colnum;
        }
        float relTotal = 0.0f;
        float[] relParts = new float[numColumns];
        float absTotal = 0.0f;
        float[] absParts = new float[numColumns];
        for (count = 0; count < numColumns; ++count) {
            String width = widths[count];
            int pos = width.indexOf("*");
            if (pos >= 0) {
                String relPart = width.substring(0, pos);
                String absPart = width.substring(pos + 1);
                try {
                    float rel = Float.parseFloat(relPart);
                    relTotal += rel;
                    relParts[count] = rel;
                }
                catch (NumberFormatException e) {
                    System.out.println(relPart + " is not a valid relative unit.");
                }
                int pixels = 0;
                if (absPart != null && !absPart.equals("")) {
                    pixels = Table.convertLength(absPart);
                }
                absTotal += (float)pixels;
                absParts[count] = pixels;
                continue;
            }
            relParts[count] = 0.0f;
            int pixels = 0;
            if (width != null && !width.equals("")) {
                pixels = Table.convertLength(width);
            }
            absTotal += (float)pixels;
            absParts[count] = pixels;
        }
        if (relTotal == 0.0f) {
            for (count = 0; count < numColumns; ++count) {
                Float f = new Float(absParts[count]);
                if (foStylesheet) {
                    int pixels = f.intValue();
                    float inches = (float)pixels / (float)pixelsPerInch;
                    widths[count] = inches + "in";
                    continue;
                }
                widths[count] = Integer.toString(f.intValue());
            }
        } else if (absTotal == 0.0f) {
            for (count = 0; count < numColumns; ++count) {
                float rel = relParts[count] / relTotal * 100.0f;
                Float f = new Float(rel);
                widths[count] = Integer.toString(f.intValue());
            }
            widths = this.correctRoundingError(widths);
        } else {
            int count2;
            int pixelWidth = nominalWidth;
            if (tableWidth.indexOf("%") <= 0) {
                pixelWidth = Table.convertLength(tableWidth);
            }
            if ((float)pixelWidth <= absTotal) {
                System.out.println("Table is wider than table width.");
            } else {
                pixelWidth = (int)((float)pixelWidth - absTotal);
            }
            absTotal = 0.0f;
            for (count2 = 0; count2 < numColumns; ++count2) {
                float rel = relParts[count2] / relTotal * (float)pixelWidth;
                relParts[count2] = rel + absParts[count2];
                absTotal += rel + absParts[count2];
            }
            if (tableWidth.indexOf("%") <= 0) {
                for (count2 = 0; count2 < numColumns; ++count2) {
                    Float f = new Float(relParts[count2]);
                    if (foStylesheet) {
                        int pixels = f.intValue();
                        float inches = (float)pixels / (float)pixelsPerInch;
                        widths[count2] = inches + "in";
                        continue;
                    }
                    widths[count2] = Integer.toString(f.intValue());
                }
            } else {
                for (count2 = 0; count2 < numColumns; ++count2) {
                    float rel = relParts[count2] / absTotal * 100.0f;
                    Float f = new Float(rel);
                    widths[count2] = Integer.toString(f.intValue());
                }
                widths = this.correctRoundingError(widths);
            }
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            System.out.println("PCE!");
            return xalanRTF;
        }
        Document doc = docBuilder.newDocument();
        DocumentFragment df = doc.createDocumentFragment();
        DOMBuilder rtf = new DOMBuilder(doc, df);
        try {
            String ns = colgroup.getNamespaceURI();
            String localName = colgroup.getLocalName();
            String name = colgroup.getTagName();
            if (colgroup.getLocalName().equals("colgroup")) {
                rtf.startElement(ns, localName, name, this.copyAttributes(colgroup));
            }
            for (colnum = 0; colnum < numColumns; ++colnum) {
                Element col = columns[colnum];
                NamedNodeMap domAttr = col.getAttributes();
                AttributesImpl attr = new AttributesImpl();
                for (int acount = 0; acount < domAttr.getLength(); ++acount) {
                    Node a = domAttr.item(acount);
                    String a_ns = a.getNamespaceURI();
                    String a_localName = a.getLocalName();
                    if ((!foStylesheet || a_localName.equals("column-width")) && a_localName.equalsIgnoreCase("width")) continue;
                    attr.addAttribute(a.getNamespaceURI(), a.getLocalName(), a.getNodeName(), "CDATA", a.getNodeValue());
                }
                if (foStylesheet) {
                    attr.addAttribute("", "column-width", "column-width", "CDATA", widths[colnum]);
                } else {
                    attr.addAttribute("", "width", "width", "CDATA", widths[colnum]);
                }
                rtf.startElement(col.getNamespaceURI(), col.getLocalName(), col.getTagName(), (Attributes)attr);
                rtf.endElement(col.getNamespaceURI(), col.getLocalName(), col.getTagName());
            }
            if (colgroup.getLocalName().equals("colgroup")) {
                rtf.endElement(ns, localName, name);
            }
        }
        catch (SAXException se) {
            System.out.println("SE!");
            return xalanRTF;
        }
        return df;
    }

    private Attributes copyAttributes(Element node) {
        AttributesImpl attrs = new AttributesImpl();
        NamedNodeMap nnm = node.getAttributes();
        for (int count = 0; count < nnm.getLength(); ++count) {
            Attr attr = (Attr)nnm.item(count);
            String name = attr.getName();
            if (name.startsWith("xmlns:") || name.equals("xmlns")) continue;
            attrs.addAttribute(attr.getNamespaceURI(), attr.getName(), attr.getName(), "CDATA", attr.getValue());
        }
        return attrs;
    }

    protected String[] correctRoundingError(String[] widths) {
        int totalWidth = 0;
        for (int count = 0; count < widths.length; ++count) {
            try {
                int width = Integer.parseInt(widths[count]);
                totalWidth += width;
                continue;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        float totalError = 100 - totalWidth;
        float columnError = totalError / (float)widths.length;
        float error = 0.0f;
        for (int count = 0; count < widths.length; ++count) {
            try {
                int width = Integer.parseInt(widths[count]);
                error += columnError;
                if ((double)error >= 1.0) {
                    int adj = (int)Math.round(Math.floor(error));
                    error -= (float)Math.floor(error);
                    widths[count] = Integer.toString(width += adj) + "%";
                    continue;
                }
                widths[count] = Integer.toString(width) + "%";
                continue;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return widths;
    }
}

