/*
 * Decompiled with CFR 0.152.
 */
package com.github.arara.utils;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class AraraLocalization {
    private static AraraLocalization selfRef;
    private ResourceBundle resources;

    private AraraLocalization() {
        selfRef = this;
        Locale.setDefault(Locale.ENGLISH);
        this.resources = ResourceBundle.getBundle("com.github.arara.localization.Messages");
    }

    public static final AraraLocalization getInstance() {
        if (selfRef == null) {
            selfRef = new AraraLocalization();
        }
        return selfRef;
    }

    public String getMessage(String message) {
        return this.resources.getString(message);
    }

    public String getMessage(String message, Object ... parameters) {
        return MessageFormat.format(this.resources.getString(message), parameters);
    }

    public void refresh() {
        this.resources = ResourceBundle.getBundle("com.github.arara.localization.Messages");
    }
}

