# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = "gsl"
  s.version = "1.14.7"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Yoshiki Tsunesada", "David MacMahon"]
  s.date = "2011-02-25"
  s.description = "Ruby/GSL is a Ruby interface to the GNU Scientific Library, for numerical computing with Ruby"
  s.email = "y-tsunesada@mm.em-net.ne.jp"
  s.extensions = ["ext/extconf.rb"]
  s.extra_rdoc_files = ["rdoc/alf.rdoc", "rdoc/blas.rdoc", "rdoc/bspline.rdoc", "rdoc/changes.rdoc", "rdoc/cheb.rdoc", "rdoc/cholesky_complex.rdoc", "rdoc/combi.rdoc", "rdoc/complex.rdoc", "rdoc/const.rdoc", "rdoc/dht.rdoc", "rdoc/diff.rdoc", "rdoc/ehandling.rdoc", "rdoc/eigen.rdoc", "rdoc/fft.rdoc", "rdoc/fit.rdoc", "rdoc/function.rdoc", "rdoc/graph.rdoc", "rdoc/hist.rdoc", "rdoc/hist2d.rdoc", "rdoc/hist3d.rdoc", "rdoc/index.rdoc", "rdoc/integration.rdoc", "rdoc/interp.rdoc", "rdoc/intro.rdoc", "rdoc/linalg.rdoc", "rdoc/linalg_complex.rdoc", "rdoc/math.rdoc", "rdoc/matrix.rdoc", "rdoc/min.rdoc", "rdoc/monte.rdoc", "rdoc/multimin.rdoc", "rdoc/multiroot.rdoc", "rdoc/narray.rdoc", "rdoc/ndlinear.rdoc", "rdoc/nonlinearfit.rdoc", "rdoc/ntuple.rdoc", "rdoc/odeiv.rdoc", "rdoc/perm.rdoc", "rdoc/poly.rdoc", "rdoc/qrng.rdoc", "rdoc/randist.rdoc", "rdoc/ref.rdoc", "rdoc/rng.rdoc", "rdoc/rngextra.rdoc", "rdoc/roots.rdoc", "rdoc/screenshot.rdoc", "rdoc/sf.rdoc", "rdoc/siman.rdoc", "rdoc/sort.rdoc", "rdoc/start.rdoc", "rdoc/stats.rdoc", "rdoc/sum.rdoc", "rdoc/tensor.rdoc", "rdoc/tut.rdoc", "rdoc/use.rdoc", "rdoc/vector.rdoc", "rdoc/vector_complex.rdoc", "rdoc/wavelet.rdoc"]
  s.files = ["rdoc/alf.rdoc", "rdoc/blas.rdoc", "rdoc/bspline.rdoc", "rdoc/changes.rdoc", "rdoc/cheb.rdoc", "rdoc/cholesky_complex.rdoc", "rdoc/combi.rdoc", "rdoc/complex.rdoc", "rdoc/const.rdoc", "rdoc/dht.rdoc", "rdoc/diff.rdoc", "rdoc/ehandling.rdoc", "rdoc/eigen.rdoc", "rdoc/fft.rdoc", "rdoc/fit.rdoc", "rdoc/function.rdoc", "rdoc/graph.rdoc", "rdoc/hist.rdoc", "rdoc/hist2d.rdoc", "rdoc/hist3d.rdoc", "rdoc/index.rdoc", "rdoc/integration.rdoc", "rdoc/interp.rdoc", "rdoc/intro.rdoc", "rdoc/linalg.rdoc", "rdoc/linalg_complex.rdoc", "rdoc/math.rdoc", "rdoc/matrix.rdoc", "rdoc/min.rdoc", "rdoc/monte.rdoc", "rdoc/multimin.rdoc", "rdoc/multiroot.rdoc", "rdoc/narray.rdoc", "rdoc/ndlinear.rdoc", "rdoc/nonlinearfit.rdoc", "rdoc/ntuple.rdoc", "rdoc/odeiv.rdoc", "rdoc/perm.rdoc", "rdoc/poly.rdoc", "rdoc/qrng.rdoc", "rdoc/randist.rdoc", "rdoc/ref.rdoc", "rdoc/rng.rdoc", "rdoc/rngextra.rdoc", "rdoc/roots.rdoc", "rdoc/screenshot.rdoc", "rdoc/sf.rdoc", "rdoc/siman.rdoc", "rdoc/sort.rdoc", "rdoc/start.rdoc", "rdoc/stats.rdoc", "rdoc/sum.rdoc", "rdoc/tensor.rdoc", "rdoc/tut.rdoc", "rdoc/use.rdoc", "rdoc/vector.rdoc", "rdoc/vector_complex.rdoc", "rdoc/wavelet.rdoc", "ext/extconf.rb"]
  s.homepage = "http://rb-gsl.rubyforge.org/"
  s.rdoc_options = ["--title", "Ruby/GSL", "--main", "rdoc/index.rdoc", "--exclude", "ext/", "--exclude", "include/", "--exclude", "lib/"]
  s.require_paths = ["lib", "lib/gsl", "lib/ool", "ext"]
  s.required_ruby_version = Gem::Requirement.new(">= 1.8.1")
  s.requirements = ["GSL (http://www.gnu.org/software/gsl/)"]
  s.rubyforge_project = "rb-gsl"
  s.rubygems_version = "1.8.23.2"
  s.summary = "Ruby interface to GNU Scientific Library"

  if s.respond_to? :specification_version then
    s.specification_version = 3

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
      s.add_runtime_dependency(%q<narray>, [">= 0.5.9"])
    else
      s.add_dependency(%q<narray>, [">= 0.5.9"])
    end
  else
    s.add_dependency(%q<narray>, [">= 0.5.9"])
  end
end
