'''OpenGL extension ARB.fragment_program_shadow

Overview (from the spec)
	
	This extension extends ARB_fragment_program to remove
	the interaction with ARB_shadow.
	
	This extension defines the program option
	"ARB_fragment_program_shadow".
	
	If a fragment program specifies the option "ARB_fragment_program_shadow"
	
	    SHADOW1D, SHADOW2D, SHADOWRECT
	
	are added as texture targets.  When shadow map comparisons are
	desired, specify the SHADOW1D, SHADOW2D, or SHADOWRECT texture
	targets in texture instructions.
	
	Programs must assure that the comparison mode for each depth
	texture (TEXTURE_COMPARE_MODE) and/or the internal texture
	format (DEPTH_COMPONENT) and the targets of the texture lookup
	instructions match.  Otherwise, if the comparison mode
	and/or the internal texture format are inconsistent with the
	texture target, the results of the texture lookup are undefined.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/ARB/fragment_program_shadow.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_ARB_fragment_program_shadow'



def glInitFragmentProgramShadowARB():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( EXTENSION_NAME )
