/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.fop.render.afp.modca.AbstractAFPObject;
import org.apache.fop.render.afp.tools.BinaryUtils;

public class TagLogicalElement
extends AbstractAFPObject {
    private String _tleName = null;
    private String _tleValue = null;
    private byte[] _tleByteName = null;
    private byte[] _tleByteValue = null;

    public TagLogicalElement(String name, String value) {
        this._tleName = name;
        this._tleValue = value;
        try {
            this._tleByteName = name.getBytes("Cp1146");
            this._tleByteValue = value.getBytes("Cp1146");
        }
        catch (UnsupportedEncodingException usee) {
            this._tleByteName = name.getBytes();
            this._tleByteValue = value.getBytes();
            log.warn((Object)("Constructor:: UnsupportedEncodingException translating the name " + name));
        }
    }

    public void writeDataStream(OutputStream os) throws IOException {
        byte[] data = new byte[17 + this._tleName.length() + this._tleValue.length()];
        data[0] = 90;
        byte[] rl1 = BinaryUtils.convert(16 + this._tleName.length() + this._tleValue.length(), 2);
        data[1] = rl1[0];
        data[2] = rl1[1];
        data[3] = -45;
        data[4] = -96;
        data[5] = -112;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        byte[] rl2 = BinaryUtils.convert(this._tleName.length() + 4, 1);
        data[9] = rl2[0];
        data[10] = 2;
        data[11] = 11;
        data[12] = 0;
        int pos = 13;
        for (int i = 0; i < this._tleByteName.length; ++i) {
            data[pos++] = this._tleByteName[i];
        }
        byte[] rl3 = BinaryUtils.convert(this._tleByteValue.length + 4, 1);
        data[pos++] = rl3[0];
        data[pos++] = 54;
        data[pos++] = 0;
        data[pos++] = 0;
        for (int i = 0; i < this._tleByteValue.length; ++i) {
            data[pos++] = this._tleByteValue[i];
        }
        os.write(data);
    }
}

