/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.AvailabilityTable;
import net.sf.mpxj.BookingType;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectEntity;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Rate;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.WorkGroup;
import net.sf.mpxj.listener.FieldListener;
import net.sf.mpxj.utility.BooleanUtility;
import net.sf.mpxj.utility.DateUtility;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Resource
extends ProjectEntity
implements Comparable<Resource>,
FieldContainer {
    private static final ResourceField[] ENTERPRISE_COST_FIELDS = new ResourceField[]{ResourceField.ENTERPRISE_COST1, ResourceField.ENTERPRISE_COST2, ResourceField.ENTERPRISE_COST3, ResourceField.ENTERPRISE_COST4, ResourceField.ENTERPRISE_COST5, ResourceField.ENTERPRISE_COST6, ResourceField.ENTERPRISE_COST7, ResourceField.ENTERPRISE_COST8, ResourceField.ENTERPRISE_COST9, ResourceField.ENTERPRISE_COST10};
    private static final ResourceField[] ENTERPRISE_DATE_FIELDS = new ResourceField[]{ResourceField.ENTERPRISE_DATE1, ResourceField.ENTERPRISE_DATE2, ResourceField.ENTERPRISE_DATE3, ResourceField.ENTERPRISE_DATE4, ResourceField.ENTERPRISE_DATE5, ResourceField.ENTERPRISE_DATE6, ResourceField.ENTERPRISE_DATE7, ResourceField.ENTERPRISE_DATE8, ResourceField.ENTERPRISE_DATE9, ResourceField.ENTERPRISE_DATE10, ResourceField.ENTERPRISE_DATE11, ResourceField.ENTERPRISE_DATE12, ResourceField.ENTERPRISE_DATE13, ResourceField.ENTERPRISE_DATE14, ResourceField.ENTERPRISE_DATE15, ResourceField.ENTERPRISE_DATE16, ResourceField.ENTERPRISE_DATE17, ResourceField.ENTERPRISE_DATE18, ResourceField.ENTERPRISE_DATE19, ResourceField.ENTERPRISE_DATE20, ResourceField.ENTERPRISE_DATE21, ResourceField.ENTERPRISE_DATE22, ResourceField.ENTERPRISE_DATE23, ResourceField.ENTERPRISE_DATE24, ResourceField.ENTERPRISE_DATE25, ResourceField.ENTERPRISE_DATE26, ResourceField.ENTERPRISE_DATE27, ResourceField.ENTERPRISE_DATE28, ResourceField.ENTERPRISE_DATE29, ResourceField.ENTERPRISE_DATE30};
    private static final ResourceField[] ENTERPRISE_DURATION_FIELDS = new ResourceField[]{ResourceField.ENTERPRISE_DURATION1, ResourceField.ENTERPRISE_DURATION2, ResourceField.ENTERPRISE_DURATION3, ResourceField.ENTERPRISE_DURATION4, ResourceField.ENTERPRISE_DURATION5, ResourceField.ENTERPRISE_DURATION6, ResourceField.ENTERPRISE_DURATION7, ResourceField.ENTERPRISE_DURATION8, ResourceField.ENTERPRISE_DURATION9, ResourceField.ENTERPRISE_DURATION10};
    private static final ResourceField[] ENTERPRISE_FLAG_FIELDS = new ResourceField[]{ResourceField.ENTERPRISE_FLAG1, ResourceField.ENTERPRISE_FLAG2, ResourceField.ENTERPRISE_FLAG3, ResourceField.ENTERPRISE_FLAG4, ResourceField.ENTERPRISE_FLAG5, ResourceField.ENTERPRISE_FLAG6, ResourceField.ENTERPRISE_FLAG7, ResourceField.ENTERPRISE_FLAG8, ResourceField.ENTERPRISE_FLAG9, ResourceField.ENTERPRISE_FLAG10, ResourceField.ENTERPRISE_FLAG11, ResourceField.ENTERPRISE_FLAG12, ResourceField.ENTERPRISE_FLAG13, ResourceField.ENTERPRISE_FLAG14, ResourceField.ENTERPRISE_FLAG15, ResourceField.ENTERPRISE_FLAG16, ResourceField.ENTERPRISE_FLAG17, ResourceField.ENTERPRISE_FLAG18, ResourceField.ENTERPRISE_FLAG19, ResourceField.ENTERPRISE_FLAG20};
    private static final ResourceField[] ENTERPRISE_NUMBER_FIELDS = new ResourceField[]{ResourceField.ENTERPRISE_NUMBER1, ResourceField.ENTERPRISE_NUMBER2, ResourceField.ENTERPRISE_NUMBER3, ResourceField.ENTERPRISE_NUMBER4, ResourceField.ENTERPRISE_NUMBER5, ResourceField.ENTERPRISE_NUMBER6, ResourceField.ENTERPRISE_NUMBER7, ResourceField.ENTERPRISE_NUMBER8, ResourceField.ENTERPRISE_NUMBER9, ResourceField.ENTERPRISE_NUMBER10, ResourceField.ENTERPRISE_NUMBER11, ResourceField.ENTERPRISE_NUMBER12, ResourceField.ENTERPRISE_NUMBER13, ResourceField.ENTERPRISE_NUMBER14, ResourceField.ENTERPRISE_NUMBER15, ResourceField.ENTERPRISE_NUMBER16, ResourceField.ENTERPRISE_NUMBER17, ResourceField.ENTERPRISE_NUMBER18, ResourceField.ENTERPRISE_NUMBER19, ResourceField.ENTERPRISE_NUMBER20, ResourceField.ENTERPRISE_NUMBER21, ResourceField.ENTERPRISE_NUMBER22, ResourceField.ENTERPRISE_NUMBER23, ResourceField.ENTERPRISE_NUMBER24, ResourceField.ENTERPRISE_NUMBER25, ResourceField.ENTERPRISE_NUMBER26, ResourceField.ENTERPRISE_NUMBER27, ResourceField.ENTERPRISE_NUMBER28, ResourceField.ENTERPRISE_NUMBER29, ResourceField.ENTERPRISE_NUMBER30, ResourceField.ENTERPRISE_NUMBER31, ResourceField.ENTERPRISE_NUMBER32, ResourceField.ENTERPRISE_NUMBER33, ResourceField.ENTERPRISE_NUMBER34, ResourceField.ENTERPRISE_NUMBER35, ResourceField.ENTERPRISE_NUMBER36, ResourceField.ENTERPRISE_NUMBER37, ResourceField.ENTERPRISE_NUMBER38, ResourceField.ENTERPRISE_NUMBER39, ResourceField.ENTERPRISE_NUMBER40};
    private static final ResourceField[] ENTERPRISE_TEXT_FIELDS = new ResourceField[]{ResourceField.ENTERPRISE_TEXT1, ResourceField.ENTERPRISE_TEXT2, ResourceField.ENTERPRISE_TEXT3, ResourceField.ENTERPRISE_TEXT4, ResourceField.ENTERPRISE_TEXT5, ResourceField.ENTERPRISE_TEXT6, ResourceField.ENTERPRISE_TEXT7, ResourceField.ENTERPRISE_TEXT8, ResourceField.ENTERPRISE_TEXT9, ResourceField.ENTERPRISE_TEXT10, ResourceField.ENTERPRISE_TEXT11, ResourceField.ENTERPRISE_TEXT12, ResourceField.ENTERPRISE_TEXT13, ResourceField.ENTERPRISE_TEXT14, ResourceField.ENTERPRISE_TEXT15, ResourceField.ENTERPRISE_TEXT16, ResourceField.ENTERPRISE_TEXT17, ResourceField.ENTERPRISE_TEXT18, ResourceField.ENTERPRISE_TEXT19, ResourceField.ENTERPRISE_TEXT20, ResourceField.ENTERPRISE_TEXT21, ResourceField.ENTERPRISE_TEXT22, ResourceField.ENTERPRISE_TEXT23, ResourceField.ENTERPRISE_TEXT24, ResourceField.ENTERPRISE_TEXT25, ResourceField.ENTERPRISE_TEXT26, ResourceField.ENTERPRISE_TEXT27, ResourceField.ENTERPRISE_TEXT28, ResourceField.ENTERPRISE_TEXT29, ResourceField.ENTERPRISE_TEXT30, ResourceField.ENTERPRISE_TEXT31, ResourceField.ENTERPRISE_TEXT32, ResourceField.ENTERPRISE_TEXT33, ResourceField.ENTERPRISE_TEXT34, ResourceField.ENTERPRISE_TEXT35, ResourceField.ENTERPRISE_TEXT36, ResourceField.ENTERPRISE_TEXT37, ResourceField.ENTERPRISE_TEXT38, ResourceField.ENTERPRISE_TEXT39, ResourceField.ENTERPRISE_TEXT40};
    private static final ResourceField[] BASELINE_COSTS = new ResourceField[]{ResourceField.BASELINE1_COST, ResourceField.BASELINE2_COST, ResourceField.BASELINE3_COST, ResourceField.BASELINE4_COST, ResourceField.BASELINE5_COST, ResourceField.BASELINE6_COST, ResourceField.BASELINE7_COST, ResourceField.BASELINE8_COST, ResourceField.BASELINE9_COST, ResourceField.BASELINE10_COST};
    private static final ResourceField[] BASELINE_WORKS = new ResourceField[]{ResourceField.BASELINE1_WORK, ResourceField.BASELINE2_WORK, ResourceField.BASELINE3_WORK, ResourceField.BASELINE4_WORK, ResourceField.BASELINE5_WORK, ResourceField.BASELINE6_WORK, ResourceField.BASELINE7_WORK, ResourceField.BASELINE8_WORK, ResourceField.BASELINE9_WORK, ResourceField.BASELINE10_WORK};
    private Object[] m_array = new Object[ResourceField.MAX_VALUE];
    private ProjectCalendar m_calendar;
    private List<ResourceAssignment> m_assignments = new LinkedList<ResourceAssignment>();
    private boolean m_eventsEnabled = true;
    private boolean m_null;
    private boolean m_generic;
    private boolean m_inactive;
    private String m_activeDirectoryGUID;
    private Duration m_actualOvertimeWorkProtected;
    private Duration m_actualWorkProtected;
    private BookingType m_bookingType;
    private boolean m_enterprise;
    private CostRateTable[] m_costRateTables = new CostRateTable[5];
    private AvailabilityTable m_availability = new AvailabilityTable();
    private List<FieldListener> m_listeners;

    Resource(ProjectFile projectFile) {
        super(projectFile);
        this.setType(ResourceType.WORK);
        if (projectFile.getAutoResourceUniqueID()) {
            this.setUniqueID(projectFile.getResourceUniqueID());
        }
        if (projectFile.getAutoResourceID()) {
            this.setID(projectFile.getResourceID());
        }
    }

    public void setName(String string) {
        this.set((FieldType)ResourceField.NAME, string);
    }

    public String getName() {
        return (String)this.getCachedValue(ResourceField.NAME);
    }

    public void setType(ResourceType resourceType) {
        this.set((FieldType)ResourceField.TYPE, resourceType);
    }

    public ResourceType getType() {
        return (ResourceType)this.getCachedValue(ResourceField.TYPE);
    }

    public void setIsNull(boolean bl) {
        this.m_null = bl;
    }

    public boolean getNull() {
        return this.m_null;
    }

    public void setInitials(String string) {
        this.set((FieldType)ResourceField.INITIALS, string);
    }

    public String getInitials() {
        return (String)this.getCachedValue(ResourceField.INITIALS);
    }

    public void setPhonetics(String string) {
        this.set((FieldType)ResourceField.PHONETICS, string);
    }

    public String getPhonetics() {
        return (String)this.getCachedValue(ResourceField.PHONETICS);
    }

    public void setNtAccount(String string) {
        this.set((FieldType)ResourceField.WINDOWS_USER_ACCOUNT, string);
    }

    public String getNtAccount() {
        return (String)this.getCachedValue(ResourceField.WINDOWS_USER_ACCOUNT);
    }

    public void setMaterialLabel(String string) {
        this.set((FieldType)ResourceField.MATERIAL_LABEL, string);
    }

    public String getMaterialLabel() {
        return (String)this.getCachedValue(ResourceField.MATERIAL_LABEL);
    }

    public void setCode(String string) {
        this.set((FieldType)ResourceField.CODE, string);
    }

    public String getCode() {
        return (String)this.getCachedValue(ResourceField.CODE);
    }

    public void setGroup(String string) {
        this.set((FieldType)ResourceField.GROUP, string);
    }

    public String getGroup() {
        return (String)this.getCachedValue(ResourceField.GROUP);
    }

    public void setWorkGroup(WorkGroup workGroup) {
        this.set((FieldType)ResourceField.WORKGROUP, workGroup);
    }

    public WorkGroup getWorkGroup() {
        return (WorkGroup)this.getCachedValue(ResourceField.WORKGROUP);
    }

    public void setEmailAddress(String string) {
        this.set((FieldType)ResourceField.EMAIL_ADDRESS, string);
    }

    public String getEmailAddress() {
        return (String)this.getCachedValue(ResourceField.EMAIL_ADDRESS);
    }

    public void setHyperlink(String string) {
        this.set((FieldType)ResourceField.HYPERLINK, string);
    }

    public String getHyperlink() {
        return (String)this.getCachedValue(ResourceField.HYPERLINK);
    }

    public void setHyperlinkAddress(String string) {
        this.set((FieldType)ResourceField.HYPERLINK_ADDRESS, string);
    }

    public String getHyperlinkAddress() {
        return (String)this.getCachedValue(ResourceField.HYPERLINK_ADDRESS);
    }

    public void setHyperlinkSubAddress(String string) {
        this.set((FieldType)ResourceField.HYPERLINK_SUBADDRESS, string);
    }

    public String getHyperlinkSubAddress() {
        return (String)this.getCachedValue(ResourceField.HYPERLINK_SUBADDRESS);
    }

    public void setMaxUnits(Number number) {
        this.set((FieldType)ResourceField.MAX_UNITS, number);
    }

    public Number getMaxUnits() {
        return (Number)this.getCachedValue(ResourceField.MAX_UNITS);
    }

    public void setPeakUnits(Number number) {
        this.set((FieldType)ResourceField.PEAK, number);
    }

    public Number getPeakUnits() {
        return (Number)this.getCachedValue(ResourceField.PEAK);
    }

    public void setOverAllocated(boolean bl) {
        this.set((FieldType)ResourceField.OVERALLOCATED, bl);
    }

    public boolean getOverAllocated() {
        Boolean bl = (Boolean)this.getCachedValue(ResourceField.OVERALLOCATED);
        if (bl == null) {
            Number number = this.getPeakUnits();
            Number number2 = this.getMaxUnits();
            bl = NumberUtility.getDouble(number) > NumberUtility.getDouble(number2);
            this.set((FieldType)ResourceField.OVERALLOCATED, bl);
        }
        return bl;
    }

    public Date getAvailableFrom() {
        return (Date)this.getCachedValue(ResourceField.AVAILABLE_FROM);
    }

    public void setAvailableFrom(Date date) {
        this.set((FieldType)ResourceField.AVAILABLE_FROM, date);
    }

    public Date getAvailableTo() {
        return (Date)this.getCachedValue(ResourceField.AVAILABLE_TO);
    }

    public void setAvailableTo(Date date) {
        this.set((FieldType)ResourceField.AVAILABLE_TO, date);
    }

    public Date getStart() {
        Date date = null;
        for (ResourceAssignment resourceAssignment : this.m_assignments) {
            if (date != null && DateUtility.compare(date, resourceAssignment.getStart()) <= 0) continue;
            date = resourceAssignment.getStart();
        }
        return date;
    }

    public Date getFinish() {
        Date date = null;
        for (ResourceAssignment resourceAssignment : this.m_assignments) {
            if (date != null && DateUtility.compare(date, resourceAssignment.getFinish()) >= 0) continue;
            date = resourceAssignment.getFinish();
        }
        return date;
    }

    public void setCanLevel(boolean bl) {
        this.set((FieldType)ResourceField.CAN_LEVEL, bl);
    }

    public boolean getCanLevel() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(ResourceField.CAN_LEVEL));
    }

    public void setAccrueAt(AccrueType accrueType) {
        this.set((FieldType)ResourceField.ACCRUE_AT, accrueType);
    }

    public AccrueType getAccrueAt() {
        return (AccrueType)this.getCachedValue(ResourceField.ACCRUE_AT);
    }

    public void setWork(Duration duration) {
        this.set((FieldType)ResourceField.WORK, duration);
    }

    public Duration getWork() {
        return (Duration)this.getCachedValue(ResourceField.WORK);
    }

    public Duration getRegularWork() {
        return (Duration)this.getCachedValue(ResourceField.REGULAR_WORK);
    }

    public void setRegularWork(Duration duration) {
        this.set((FieldType)ResourceField.REGULAR_WORK, duration);
    }

    public void setActualWork(Duration duration) {
        this.set((FieldType)ResourceField.ACTUAL_WORK, duration);
    }

    public Duration getActualWork() {
        return (Duration)this.getCachedValue(ResourceField.ACTUAL_WORK);
    }

    public void setOvertimeWork(Duration duration) {
        this.set((FieldType)ResourceField.OVERTIME_WORK, duration);
    }

    public Duration getOvertimeWork() {
        return (Duration)this.getCachedValue(ResourceField.OVERTIME_WORK);
    }

    public void setRemainingWork(Duration duration) {
        this.set((FieldType)ResourceField.REMAINING_WORK, duration);
    }

    public Duration getRemainingWork() {
        return (Duration)this.getCachedValue(ResourceField.REMAINING_WORK);
    }

    public Duration getActualOvertimeWork() {
        return (Duration)this.getCachedValue(ResourceField.ACTUAL_OVERTIME_WORK);
    }

    public void setActualOvertimeWork(Duration duration) {
        this.set((FieldType)ResourceField.ACTUAL_OVERTIME_WORK, duration);
    }

    public Duration getRemainingOvertimeWork() {
        return (Duration)this.getCachedValue(ResourceField.REMAINING_OVERTIME_WORK);
    }

    public void setRemainingOvertimeWork(Duration duration) {
        this.set((FieldType)ResourceField.REMAINING_OVERTIME_WORK, duration);
    }

    public void setPercentWorkComplete(Number number) {
        this.set((FieldType)ResourceField.PERCENT_WORK_COMPLETE, number);
    }

    public Number getPercentWorkComplete() {
        return (Number)this.getCachedValue(ResourceField.PERCENT_WORK_COMPLETE);
    }

    public void setStandardRate(Rate rate) {
        this.set((FieldType)ResourceField.STANDARD_RATE, rate);
    }

    public Rate getStandardRate() {
        return (Rate)this.getCachedValue(ResourceField.STANDARD_RATE);
    }

    public void setStandardRateUnits(TimeUnit timeUnit) {
        this.set((FieldType)ResourceField.STANDARD_RATE_UNITS, timeUnit);
    }

    public TimeUnit getStandardRateUnits() {
        return (TimeUnit)this.getCachedValue(ResourceField.STANDARD_RATE_UNITS);
    }

    public void setCost(Number number) {
        this.set((FieldType)ResourceField.COST, number);
    }

    public Number getCost() {
        return (Number)this.getCachedValue(ResourceField.COST);
    }

    public void setOvertimeRate(Rate rate) {
        this.set((FieldType)ResourceField.OVERTIME_RATE, rate);
    }

    public Rate getOvertimeRate() {
        return (Rate)this.getCachedValue(ResourceField.OVERTIME_RATE);
    }

    public void setOvertimeRateUnits(TimeUnit timeUnit) {
        this.set((FieldType)ResourceField.OVERTIME_RATE_UNITS, timeUnit);
    }

    public TimeUnit getOvertimeRateUnits() {
        return (TimeUnit)this.getCachedValue(ResourceField.OVERTIME_RATE_UNITS);
    }

    public Number getOvertimeCost() {
        return (Number)this.getCachedValue(ResourceField.OVERTIME_COST);
    }

    public void setOvertimeCost(Number number) {
        this.set((FieldType)ResourceField.OVERTIME_COST, number);
    }

    public void setCostPerUse(Number number) {
        this.set((FieldType)ResourceField.COST_PER_USE, number);
    }

    public Number getCostPerUse() {
        return (Number)this.getCachedValue(ResourceField.COST_PER_USE);
    }

    public void setActualCost(Number number) {
        this.set((FieldType)ResourceField.ACTUAL_COST, number);
    }

    public Number getActualCost() {
        return (Number)this.getCachedValue(ResourceField.ACTUAL_COST);
    }

    public Number getActualOvertimeCost() {
        return (Number)this.getCachedValue(ResourceField.ACTUAL_OVERTIME_COST);
    }

    public void setActualOvertimeCost(Number number) {
        this.set((FieldType)ResourceField.ACTUAL_OVERTIME_COST, number);
    }

    public void setRemainingCost(Number number) {
        this.set((FieldType)ResourceField.REMAINING_COST, number);
    }

    public Number getRemainingCost() {
        return (Number)this.getCachedValue(ResourceField.REMAINING_COST);
    }

    public Number getRemainingOvertimeCost() {
        return (Number)this.getCachedValue(ResourceField.REMAINING_OVERTIME_COST);
    }

    public void setRemainingOvertimeCost(Number number) {
        this.set((FieldType)ResourceField.REMAINING_OVERTIME_COST, number);
    }

    public void setWorkVariance(Duration duration) {
        this.set((FieldType)ResourceField.WORK_VARIANCE, duration);
    }

    public Duration getWorkVariance() {
        Duration duration = (Duration)this.getCachedValue(ResourceField.WORK_VARIANCE);
        if (duration == null) {
            Duration duration2 = this.getWork();
            Duration duration3 = this.getBaselineWork();
            if (duration2 != null && duration3 != null) {
                duration = Duration.getInstance(duration2.getDuration() - duration3.convertUnits(duration2.getUnits(), this.getParentFile().getProjectHeader()).getDuration(), duration2.getUnits());
                this.set((FieldType)ResourceField.WORK_VARIANCE, duration);
            }
        }
        return duration;
    }

    public void setCostVariance(Number number) {
        this.set((FieldType)ResourceField.COST_VARIANCE, number);
    }

    public Number getCostVariance() {
        Number number = (Number)this.getCachedValue(ResourceField.COST_VARIANCE);
        if (number == null) {
            Number number2 = this.getCost();
            Number number3 = this.getBaselineCost();
            if (number2 != null && number3 != null) {
                number = NumberUtility.getDouble(number2.doubleValue() - number3.doubleValue());
                this.set((FieldType)ResourceField.COST_VARIANCE, number);
            }
        }
        return number;
    }

    public void setSV(Number number) {
        this.set((FieldType)ResourceField.SV, number);
    }

    public Number getSV() {
        Number number = (Number)this.getCachedValue(ResourceField.SV);
        if (number == null) {
            Number number2 = this.getBCWP();
            Number number3 = this.getBCWS();
            if (number2 != null && number3 != null) {
                number = NumberUtility.getDouble(number2.doubleValue() - number3.doubleValue());
                this.set((FieldType)ResourceField.SV, number);
            }
        }
        return number;
    }

    public void setCV(Number number) {
        this.set((FieldType)ResourceField.CV, number);
    }

    public Number getCV() {
        Number number = (Number)this.getCachedValue(ResourceField.CV);
        if (number == null) {
            number = NumberUtility.getDouble(this.getBCWP()) - NumberUtility.getDouble(this.getACWP());
            this.set((FieldType)ResourceField.CV, number);
        }
        return number;
    }

    public void setACWP(Number number) {
        this.set((FieldType)ResourceField.ACWP, number);
    }

    public Number getACWP() {
        return (Number)this.getCachedValue(ResourceField.ACWP);
    }

    public void setNotes(String string) {
        this.set((FieldType)ResourceField.NOTES, string);
    }

    public String getNotes() {
        String string = (String)this.getCachedValue(ResourceField.NOTES);
        return string == null ? "" : string;
    }

    public void setBCWS(Number number) {
        this.set((FieldType)ResourceField.BCWS, number);
    }

    public Number getBCWS() {
        return (Number)this.getCachedValue(ResourceField.BCWS);
    }

    public void setBCWP(Number number) {
        this.set((FieldType)ResourceField.BCWP, number);
    }

    public Number getBCWP() {
        return (Number)this.getCachedValue(ResourceField.BCWP);
    }

    public void setIsGeneric(boolean bl) {
        this.m_generic = bl;
    }

    public boolean getGeneric() {
        return this.m_generic;
    }

    public void setIsInactive(boolean bl) {
        this.m_inactive = bl;
    }

    public boolean getInactive() {
        return this.m_inactive;
    }

    public void setActveDirectoryGUID(String string) {
        this.m_activeDirectoryGUID = string;
    }

    public String getActiveDirectoryGUID() {
        return this.m_activeDirectoryGUID;
    }

    public void setActualOvertimeWorkProtected(Duration duration) {
        this.m_actualOvertimeWorkProtected = duration;
    }

    public Duration getActualOvertimeWorkProtected() {
        return this.m_actualOvertimeWorkProtected;
    }

    public void setActualWorkProtected(Duration duration) {
        this.m_actualWorkProtected = duration;
    }

    public Duration getActualWorkProtected() {
        return this.m_actualWorkProtected;
    }

    public void setBookingType(BookingType bookingType) {
        this.m_bookingType = bookingType;
    }

    public BookingType getBookingType() {
        return this.m_bookingType;
    }

    public void setCreationDate(Date date) {
        this.set((FieldType)ResourceField.CREATED, date);
    }

    public Date getCreationDate() {
        return (Date)this.getCachedValue(ResourceField.CREATED);
    }

    public void setIsEnterprise(boolean bl) {
        this.m_enterprise = bl;
    }

    public boolean getEnterprise() {
        return this.m_enterprise;
    }

    public ProjectCalendar getResourceCalendar() {
        return this.m_calendar;
    }

    public void setResourceCalendar(ProjectCalendar projectCalendar) {
        this.m_calendar = projectCalendar;
        if (projectCalendar != null) {
            projectCalendar.setResource(this);
        }
    }

    public ProjectCalendar addResourceCalendar() throws MPXJException {
        if (this.m_calendar != null) {
            throw new MPXJException("Maximum number of records of this type exist");
        }
        this.m_calendar = new ProjectCalendar(this.getParentFile());
        this.m_calendar.setResource(this);
        return this.m_calendar;
    }

    public void setBaseCalendar(String string) {
        this.set((FieldType)ResourceField.BASE_CALENDAR, string == null || string.length() == 0 ? "Standard" : string);
    }

    public void setBaselineCost(Number number) {
        this.set((FieldType)ResourceField.BASELINE_COST, number);
    }

    public void setBaselineWork(Duration duration) {
        this.set((FieldType)ResourceField.BASELINE_WORK, duration);
    }

    public void setID(Integer n) {
        ProjectFile projectFile = this.getParentFile();
        Integer n2 = this.getID();
        if (n2 != null) {
            projectFile.unmapResourceID(n2);
        }
        projectFile.mapResourceID(n, this);
        this.set((FieldType)ResourceField.ID, n);
    }

    public void setLinkedFields(String string) {
        this.set((FieldType)ResourceField.LINKED_FIELDS, string);
    }

    public void setObjects(Integer n) {
        this.set((FieldType)ResourceField.OBJECTS, n);
    }

    public void setText1(String string) {
        this.set((FieldType)ResourceField.TEXT1, string);
    }

    public void setText2(String string) {
        this.set((FieldType)ResourceField.TEXT2, string);
    }

    public void setText3(String string) {
        this.set((FieldType)ResourceField.TEXT3, string);
    }

    public void setText4(String string) {
        this.set((FieldType)ResourceField.TEXT4, string);
    }

    public void setText5(String string) {
        this.set((FieldType)ResourceField.TEXT5, string);
    }

    public void setUniqueID(Integer n) {
        ProjectFile projectFile = this.getParentFile();
        Integer n2 = this.getUniqueID();
        if (n2 != null) {
            projectFile.unmapResourceUniqueID(n2);
        }
        projectFile.mapResourceUniqueID(n, this);
        this.set((FieldType)ResourceField.UNIQUE_ID, n);
        if (!this.m_assignments.isEmpty()) {
            for (ResourceAssignment resourceAssignment : this.m_assignments) {
                resourceAssignment.setResourceUniqueID(n);
            }
        }
    }

    public String getBaseCalendar() {
        return (String)this.getCachedValue(ResourceField.BASE_CALENDAR);
    }

    public Number getBaselineCost() {
        return (Number)this.getCachedValue(ResourceField.BASELINE_COST);
    }

    public Duration getBaselineWork() {
        return (Duration)this.getCachedValue(ResourceField.BASELINE_WORK);
    }

    public Integer getID() {
        return (Integer)this.getCachedValue(ResourceField.ID);
    }

    public String getLinkedFields() {
        return (String)this.getCachedValue(ResourceField.LINKED_FIELDS);
    }

    public Integer getObjects() {
        return (Integer)this.getCachedValue(ResourceField.OBJECTS);
    }

    public String getText1() {
        return (String)this.getCachedValue(ResourceField.TEXT1);
    }

    public String getText2() {
        return (String)this.getCachedValue(ResourceField.TEXT2);
    }

    public String getText3() {
        return (String)this.getCachedValue(ResourceField.TEXT3);
    }

    public String getText4() {
        return (String)this.getCachedValue(ResourceField.TEXT4);
    }

    public String getText5() {
        return (String)this.getCachedValue(ResourceField.TEXT5);
    }

    public Integer getUniqueID() {
        return (Integer)this.getCachedValue(ResourceField.UNIQUE_ID);
    }

    public String getText6() {
        return (String)this.getCachedValue(ResourceField.TEXT6);
    }

    public String getText7() {
        return (String)this.getCachedValue(ResourceField.TEXT7);
    }

    public String getText8() {
        return (String)this.getCachedValue(ResourceField.TEXT8);
    }

    public String getText9() {
        return (String)this.getCachedValue(ResourceField.TEXT9);
    }

    public String getText10() {
        return (String)this.getCachedValue(ResourceField.TEXT10);
    }

    public String getText11() {
        return (String)this.getCachedValue(ResourceField.TEXT11);
    }

    public String getText12() {
        return (String)this.getCachedValue(ResourceField.TEXT12);
    }

    public String getText13() {
        return (String)this.getCachedValue(ResourceField.TEXT13);
    }

    public String getText14() {
        return (String)this.getCachedValue(ResourceField.TEXT14);
    }

    public String getText15() {
        return (String)this.getCachedValue(ResourceField.TEXT15);
    }

    public String getText16() {
        return (String)this.getCachedValue(ResourceField.TEXT16);
    }

    public String getText17() {
        return (String)this.getCachedValue(ResourceField.TEXT17);
    }

    public String getText18() {
        return (String)this.getCachedValue(ResourceField.TEXT18);
    }

    public String getText19() {
        return (String)this.getCachedValue(ResourceField.TEXT19);
    }

    public String getText20() {
        return (String)this.getCachedValue(ResourceField.TEXT20);
    }

    public String getText21() {
        return (String)this.getCachedValue(ResourceField.TEXT21);
    }

    public String getText22() {
        return (String)this.getCachedValue(ResourceField.TEXT22);
    }

    public String getText23() {
        return (String)this.getCachedValue(ResourceField.TEXT23);
    }

    public String getText24() {
        return (String)this.getCachedValue(ResourceField.TEXT24);
    }

    public String getText25() {
        return (String)this.getCachedValue(ResourceField.TEXT25);
    }

    public String getText26() {
        return (String)this.getCachedValue(ResourceField.TEXT26);
    }

    public String getText27() {
        return (String)this.getCachedValue(ResourceField.TEXT27);
    }

    public String getText28() {
        return (String)this.getCachedValue(ResourceField.TEXT28);
    }

    public String getText29() {
        return (String)this.getCachedValue(ResourceField.TEXT29);
    }

    public String getText30() {
        return (String)this.getCachedValue(ResourceField.TEXT30);
    }

    public void setText6(String string) {
        this.set((FieldType)ResourceField.TEXT6, string);
    }

    public void setText7(String string) {
        this.set((FieldType)ResourceField.TEXT7, string);
    }

    public void setText8(String string) {
        this.set((FieldType)ResourceField.TEXT8, string);
    }

    public void setText9(String string) {
        this.set((FieldType)ResourceField.TEXT9, string);
    }

    public void setText10(String string) {
        this.set((FieldType)ResourceField.TEXT10, string);
    }

    public void setText11(String string) {
        this.set((FieldType)ResourceField.TEXT11, string);
    }

    public void setText12(String string) {
        this.set((FieldType)ResourceField.TEXT12, string);
    }

    public void setText13(String string) {
        this.set((FieldType)ResourceField.TEXT13, string);
    }

    public void setText14(String string) {
        this.set((FieldType)ResourceField.TEXT14, string);
    }

    public void setText15(String string) {
        this.set((FieldType)ResourceField.TEXT15, string);
    }

    public void setText16(String string) {
        this.set((FieldType)ResourceField.TEXT16, string);
    }

    public void setText17(String string) {
        this.set((FieldType)ResourceField.TEXT17, string);
    }

    public void setText18(String string) {
        this.set((FieldType)ResourceField.TEXT18, string);
    }

    public void setText19(String string) {
        this.set((FieldType)ResourceField.TEXT19, string);
    }

    public void setText20(String string) {
        this.set((FieldType)ResourceField.TEXT20, string);
    }

    public void setText21(String string) {
        this.set((FieldType)ResourceField.TEXT21, string);
    }

    public void setText22(String string) {
        this.set((FieldType)ResourceField.TEXT22, string);
    }

    public void setText23(String string) {
        this.set((FieldType)ResourceField.TEXT23, string);
    }

    public void setText24(String string) {
        this.set((FieldType)ResourceField.TEXT24, string);
    }

    public void setText25(String string) {
        this.set((FieldType)ResourceField.TEXT25, string);
    }

    public void setText26(String string) {
        this.set((FieldType)ResourceField.TEXT26, string);
    }

    public void setText27(String string) {
        this.set((FieldType)ResourceField.TEXT27, string);
    }

    public void setText28(String string) {
        this.set((FieldType)ResourceField.TEXT28, string);
    }

    public void setText29(String string) {
        this.set((FieldType)ResourceField.TEXT29, string);
    }

    public void setText30(String string) {
        this.set((FieldType)ResourceField.TEXT30, string);
    }

    public Date getStart1() {
        return (Date)this.getCachedValue(ResourceField.START1);
    }

    public Date getStart2() {
        return (Date)this.getCachedValue(ResourceField.START2);
    }

    public Date getStart3() {
        return (Date)this.getCachedValue(ResourceField.START3);
    }

    public Date getStart4() {
        return (Date)this.getCachedValue(ResourceField.START4);
    }

    public Date getStart5() {
        return (Date)this.getCachedValue(ResourceField.START5);
    }

    public Date getStart6() {
        return (Date)this.getCachedValue(ResourceField.START6);
    }

    public Date getStart7() {
        return (Date)this.getCachedValue(ResourceField.START7);
    }

    public Date getStart8() {
        return (Date)this.getCachedValue(ResourceField.START8);
    }

    public Date getStart9() {
        return (Date)this.getCachedValue(ResourceField.START9);
    }

    public Date getStart10() {
        return (Date)this.getCachedValue(ResourceField.START10);
    }

    public void setStart1(Date date) {
        this.set((FieldType)ResourceField.START1, date);
    }

    public void setStart2(Date date) {
        this.set((FieldType)ResourceField.START2, date);
    }

    public void setStart3(Date date) {
        this.set((FieldType)ResourceField.START3, date);
    }

    public void setStart4(Date date) {
        this.set((FieldType)ResourceField.START4, date);
    }

    public void setStart5(Date date) {
        this.set((FieldType)ResourceField.START5, date);
    }

    public void setStart6(Date date) {
        this.set((FieldType)ResourceField.START6, date);
    }

    public void setStart7(Date date) {
        this.set((FieldType)ResourceField.START7, date);
    }

    public void setStart8(Date date) {
        this.set((FieldType)ResourceField.START8, date);
    }

    public void setStart9(Date date) {
        this.set((FieldType)ResourceField.START9, date);
    }

    public void setStart10(Date date) {
        this.set((FieldType)ResourceField.START10, date);
    }

    public Date getFinish1() {
        return (Date)this.getCachedValue(ResourceField.FINISH1);
    }

    public Date getFinish2() {
        return (Date)this.getCachedValue(ResourceField.FINISH2);
    }

    public Date getFinish3() {
        return (Date)this.getCachedValue(ResourceField.FINISH3);
    }

    public Date getFinish4() {
        return (Date)this.getCachedValue(ResourceField.FINISH4);
    }

    public Date getFinish5() {
        return (Date)this.getCachedValue(ResourceField.FINISH5);
    }

    public Date getFinish6() {
        return (Date)this.getCachedValue(ResourceField.FINISH6);
    }

    public Date getFinish7() {
        return (Date)this.getCachedValue(ResourceField.FINISH7);
    }

    public Date getFinish8() {
        return (Date)this.getCachedValue(ResourceField.FINISH8);
    }

    public Date getFinish9() {
        return (Date)this.getCachedValue(ResourceField.FINISH9);
    }

    public Date getFinish10() {
        return (Date)this.getCachedValue(ResourceField.FINISH10);
    }

    public void setFinish1(Date date) {
        this.set((FieldType)ResourceField.FINISH1, date);
    }

    public void setFinish2(Date date) {
        this.set((FieldType)ResourceField.FINISH2, date);
    }

    public void setFinish3(Date date) {
        this.set((FieldType)ResourceField.FINISH3, date);
    }

    public void setFinish4(Date date) {
        this.set((FieldType)ResourceField.FINISH4, date);
    }

    public void setFinish5(Date date) {
        this.set((FieldType)ResourceField.FINISH5, date);
    }

    public void setFinish6(Date date) {
        this.set((FieldType)ResourceField.FINISH6, date);
    }

    public void setFinish7(Date date) {
        this.set((FieldType)ResourceField.FINISH7, date);
    }

    public void setFinish8(Date date) {
        this.set((FieldType)ResourceField.FINISH8, date);
    }

    public void setFinish9(Date date) {
        this.set((FieldType)ResourceField.FINISH9, date);
    }

    public void setFinish10(Date date) {
        this.set((FieldType)ResourceField.FINISH10, date);
    }

    public void setNumber1(Number number) {
        this.set((FieldType)ResourceField.NUMBER1, number);
    }

    public Number getNumber1() {
        return (Number)this.getCachedValue(ResourceField.NUMBER1);
    }

    public void setNumber2(Number number) {
        this.set((FieldType)ResourceField.NUMBER2, number);
    }

    public Number getNumber2() {
        return (Number)this.getCachedValue(ResourceField.NUMBER2);
    }

    public void setNumber3(Number number) {
        this.set((FieldType)ResourceField.NUMBER3, number);
    }

    public Number getNumber3() {
        return (Number)this.getCachedValue(ResourceField.NUMBER3);
    }

    public void setNumber4(Number number) {
        this.set((FieldType)ResourceField.NUMBER4, number);
    }

    public Number getNumber4() {
        return (Number)this.getCachedValue(ResourceField.NUMBER4);
    }

    public void setNumber5(Number number) {
        this.set((FieldType)ResourceField.NUMBER5, number);
    }

    public Number getNumber5() {
        return (Number)this.getCachedValue(ResourceField.NUMBER5);
    }

    public void setNumber6(Number number) {
        this.set((FieldType)ResourceField.NUMBER6, number);
    }

    public Number getNumber6() {
        return (Number)this.getCachedValue(ResourceField.NUMBER6);
    }

    public void setNumber7(Number number) {
        this.set((FieldType)ResourceField.NUMBER7, number);
    }

    public Number getNumber7() {
        return (Number)this.getCachedValue(ResourceField.NUMBER7);
    }

    public void setNumber8(Number number) {
        this.set((FieldType)ResourceField.NUMBER8, number);
    }

    public Number getNumber8() {
        return (Number)this.getCachedValue(ResourceField.NUMBER8);
    }

    public void setNumber9(Number number) {
        this.set((FieldType)ResourceField.NUMBER9, number);
    }

    public Number getNumber9() {
        return (Number)this.getCachedValue(ResourceField.NUMBER9);
    }

    public void setNumber10(Number number) {
        this.set((FieldType)ResourceField.NUMBER10, number);
    }

    public Number getNumber10() {
        return (Number)this.getCachedValue(ResourceField.NUMBER10);
    }

    public void setNumber11(Number number) {
        this.set((FieldType)ResourceField.NUMBER11, number);
    }

    public Number getNumber11() {
        return (Number)this.getCachedValue(ResourceField.NUMBER11);
    }

    public void setNumber12(Number number) {
        this.set((FieldType)ResourceField.NUMBER12, number);
    }

    public Number getNumber12() {
        return (Number)this.getCachedValue(ResourceField.NUMBER12);
    }

    public void setNumber13(Number number) {
        this.set((FieldType)ResourceField.NUMBER13, number);
    }

    public Number getNumber13() {
        return (Number)this.getCachedValue(ResourceField.NUMBER13);
    }

    public void setNumber14(Number number) {
        this.set((FieldType)ResourceField.NUMBER14, number);
    }

    public Number getNumber14() {
        return (Number)this.getCachedValue(ResourceField.NUMBER14);
    }

    public void setNumber15(Number number) {
        this.set((FieldType)ResourceField.NUMBER15, number);
    }

    public Number getNumber15() {
        return (Number)this.getCachedValue(ResourceField.NUMBER15);
    }

    public void setNumber16(Number number) {
        this.set((FieldType)ResourceField.NUMBER16, number);
    }

    public Number getNumber16() {
        return (Number)this.getCachedValue(ResourceField.NUMBER16);
    }

    public void setNumber17(Number number) {
        this.set((FieldType)ResourceField.NUMBER17, number);
    }

    public Number getNumber17() {
        return (Number)this.getCachedValue(ResourceField.NUMBER17);
    }

    public void setNumber18(Number number) {
        this.set((FieldType)ResourceField.NUMBER18, number);
    }

    public Number getNumber18() {
        return (Number)this.getCachedValue(ResourceField.NUMBER18);
    }

    public void setNumber19(Number number) {
        this.set((FieldType)ResourceField.NUMBER19, number);
    }

    public Number getNumber19() {
        return (Number)this.getCachedValue(ResourceField.NUMBER19);
    }

    public void setNumber20(Number number) {
        this.set((FieldType)ResourceField.NUMBER20, number);
    }

    public Number getNumber20() {
        return (Number)this.getCachedValue(ResourceField.NUMBER20);
    }

    public Duration getDuration1() {
        return (Duration)this.getCachedValue(ResourceField.DURATION1);
    }

    public Duration getDuration2() {
        return (Duration)this.getCachedValue(ResourceField.DURATION2);
    }

    public Duration getDuration3() {
        return (Duration)this.getCachedValue(ResourceField.DURATION3);
    }

    public Duration getDuration4() {
        return (Duration)this.getCachedValue(ResourceField.DURATION4);
    }

    public Duration getDuration5() {
        return (Duration)this.getCachedValue(ResourceField.DURATION5);
    }

    public Duration getDuration6() {
        return (Duration)this.getCachedValue(ResourceField.DURATION6);
    }

    public Duration getDuration7() {
        return (Duration)this.getCachedValue(ResourceField.DURATION7);
    }

    public Duration getDuration8() {
        return (Duration)this.getCachedValue(ResourceField.DURATION8);
    }

    public Duration getDuration9() {
        return (Duration)this.getCachedValue(ResourceField.DURATION9);
    }

    public Duration getDuration10() {
        return (Duration)this.getCachedValue(ResourceField.DURATION10);
    }

    public void setDuration1(Duration duration) {
        this.set((FieldType)ResourceField.DURATION1, duration);
    }

    public void setDuration2(Duration duration) {
        this.set((FieldType)ResourceField.DURATION2, duration);
    }

    public void setDuration3(Duration duration) {
        this.set((FieldType)ResourceField.DURATION3, duration);
    }

    public void setDuration4(Duration duration) {
        this.set((FieldType)ResourceField.DURATION4, duration);
    }

    public void setDuration5(Duration duration) {
        this.set((FieldType)ResourceField.DURATION5, duration);
    }

    public void setDuration6(Duration duration) {
        this.set((FieldType)ResourceField.DURATION6, duration);
    }

    public void setDuration7(Duration duration) {
        this.set((FieldType)ResourceField.DURATION7, duration);
    }

    public void setDuration8(Duration duration) {
        this.set((FieldType)ResourceField.DURATION8, duration);
    }

    public void setDuration9(Duration duration) {
        this.set((FieldType)ResourceField.DURATION9, duration);
    }

    public void setDuration10(Duration duration) {
        this.set((FieldType)ResourceField.DURATION10, duration);
    }

    public Date getDate1() {
        return (Date)this.getCachedValue(ResourceField.DATE1);
    }

    public Date getDate10() {
        return (Date)this.getCachedValue(ResourceField.DATE10);
    }

    public Date getDate2() {
        return (Date)this.getCachedValue(ResourceField.DATE2);
    }

    public Date getDate3() {
        return (Date)this.getCachedValue(ResourceField.DATE3);
    }

    public Date getDate4() {
        return (Date)this.getCachedValue(ResourceField.DATE4);
    }

    public Date getDate5() {
        return (Date)this.getCachedValue(ResourceField.DATE5);
    }

    public Date getDate6() {
        return (Date)this.getCachedValue(ResourceField.DATE6);
    }

    public Date getDate7() {
        return (Date)this.getCachedValue(ResourceField.DATE7);
    }

    public Date getDate8() {
        return (Date)this.getCachedValue(ResourceField.DATE8);
    }

    public Date getDate9() {
        return (Date)this.getCachedValue(ResourceField.DATE9);
    }

    public void setDate1(Date date) {
        this.set((FieldType)ResourceField.DATE1, date);
    }

    public void setDate10(Date date) {
        this.set((FieldType)ResourceField.DATE10, date);
    }

    public void setDate2(Date date) {
        this.set((FieldType)ResourceField.DATE2, date);
    }

    public void setDate3(Date date) {
        this.set((FieldType)ResourceField.DATE3, date);
    }

    public void setDate4(Date date) {
        this.set((FieldType)ResourceField.DATE4, date);
    }

    public void setDate5(Date date) {
        this.set((FieldType)ResourceField.DATE5, date);
    }

    public void setDate6(Date date) {
        this.set((FieldType)ResourceField.DATE6, date);
    }

    public void setDate7(Date date) {
        this.set((FieldType)ResourceField.DATE7, date);
    }

    public void setDate8(Date date) {
        this.set((FieldType)ResourceField.DATE8, date);
    }

    public void setDate9(Date date) {
        this.set((FieldType)ResourceField.DATE9, date);
    }

    public Number getCost1() {
        return (Number)this.getCachedValue(ResourceField.COST1);
    }

    public Number getCost2() {
        return (Number)this.getCachedValue(ResourceField.COST2);
    }

    public Number getCost3() {
        return (Number)this.getCachedValue(ResourceField.COST3);
    }

    public Number getCost4() {
        return (Number)this.getCachedValue(ResourceField.COST4);
    }

    public Number getCost5() {
        return (Number)this.getCachedValue(ResourceField.COST5);
    }

    public Number getCost6() {
        return (Number)this.getCachedValue(ResourceField.COST6);
    }

    public Number getCost7() {
        return (Number)this.getCachedValue(ResourceField.COST7);
    }

    public Number getCost8() {
        return (Number)this.getCachedValue(ResourceField.COST8);
    }

    public Number getCost9() {
        return (Number)this.getCachedValue(ResourceField.COST9);
    }

    public Number getCost10() {
        return (Number)this.getCachedValue(ResourceField.COST10);
    }

    public void setCost1(Number number) {
        this.set((FieldType)ResourceField.COST1, number);
    }

    public void setCost2(Number number) {
        this.set((FieldType)ResourceField.COST2, number);
    }

    public void setCost3(Number number) {
        this.set((FieldType)ResourceField.COST3, number);
    }

    public void setCost4(Number number) {
        this.set((FieldType)ResourceField.COST4, number);
    }

    public void setCost5(Number number) {
        this.set((FieldType)ResourceField.COST5, number);
    }

    public void setCost6(Number number) {
        this.set((FieldType)ResourceField.COST6, number);
    }

    public void setCost7(Number number) {
        this.set((FieldType)ResourceField.COST7, number);
    }

    public void setCost8(Number number) {
        this.set((FieldType)ResourceField.COST8, number);
    }

    public void setCost9(Number number) {
        this.set((FieldType)ResourceField.COST9, number);
    }

    public void setCost10(Number number) {
        this.set((FieldType)ResourceField.COST10, number);
    }

    public boolean getFlag1() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(ResourceField.FLAG1));
    }

    public boolean getFlag2() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(ResourceField.FLAG2));
    }

    public boolean getFlag3() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(ResourceField.FLAG3));
    }

    public boolean getFlag4() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(ResourceField.FLAG4));
    }

    public boolean getFlag5() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(ResourceField.FLAG5));
    }

    public boolean getFlag6() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(ResourceField.FLAG6));
    }

    public boolean getFlag7() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(ResourceField.FLAG7));
    }

    public boolean getFlag8() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(ResourceField.FLAG8));
    }

    public boolean getFlag9() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(ResourceField.FLAG9));
    }

    public boolean getFlag10() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(ResourceField.FLAG10));
    }

    public boolean getFlag11() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(ResourceField.FLAG11));
    }

    public boolean getFlag12() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(ResourceField.FLAG12));
    }

    public boolean getFlag13() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(ResourceField.FLAG13));
    }

    public boolean getFlag14() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(ResourceField.FLAG14));
    }

    public boolean getFlag15() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(ResourceField.FLAG15));
    }

    public boolean getFlag16() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(ResourceField.FLAG16));
    }

    public boolean getFlag17() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(ResourceField.FLAG17));
    }

    public boolean getFlag18() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(ResourceField.FLAG18));
    }

    public boolean getFlag19() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(ResourceField.FLAG19));
    }

    public boolean getFlag20() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(ResourceField.FLAG20));
    }

    public void setFlag1(boolean bl) {
        this.set((FieldType)ResourceField.FLAG1, bl);
    }

    public void setFlag2(boolean bl) {
        this.set((FieldType)ResourceField.FLAG2, bl);
    }

    public void setFlag3(boolean bl) {
        this.set((FieldType)ResourceField.FLAG3, bl);
    }

    public void setFlag4(boolean bl) {
        this.set((FieldType)ResourceField.FLAG4, bl);
    }

    public void setFlag5(boolean bl) {
        this.set((FieldType)ResourceField.FLAG5, bl);
    }

    public void setFlag6(boolean bl) {
        this.set((FieldType)ResourceField.FLAG6, bl);
    }

    public void setFlag7(boolean bl) {
        this.set((FieldType)ResourceField.FLAG7, bl);
    }

    public void setFlag8(boolean bl) {
        this.set((FieldType)ResourceField.FLAG8, bl);
    }

    public void setFlag9(boolean bl) {
        this.set((FieldType)ResourceField.FLAG9, bl);
    }

    public void setFlag10(boolean bl) {
        this.set((FieldType)ResourceField.FLAG10, bl);
    }

    public void setFlag11(boolean bl) {
        this.set((FieldType)ResourceField.FLAG11, bl);
    }

    public void setFlag12(boolean bl) {
        this.set((FieldType)ResourceField.FLAG12, bl);
    }

    public void setFlag13(boolean bl) {
        this.set((FieldType)ResourceField.FLAG13, bl);
    }

    public void setFlag14(boolean bl) {
        this.set((FieldType)ResourceField.FLAG14, bl);
    }

    public void setFlag15(boolean bl) {
        this.set((FieldType)ResourceField.FLAG15, bl);
    }

    public void setFlag16(boolean bl) {
        this.set((FieldType)ResourceField.FLAG16, bl);
    }

    public void setFlag17(boolean bl) {
        this.set((FieldType)ResourceField.FLAG17, bl);
    }

    public void setFlag18(boolean bl) {
        this.set((FieldType)ResourceField.FLAG18, bl);
    }

    public void setFlag19(boolean bl) {
        this.set((FieldType)ResourceField.FLAG19, bl);
    }

    public void setFlag20(boolean bl) {
        this.set((FieldType)ResourceField.FLAG20, bl);
    }

    public void setOutlineCode1(String string) {
        this.set((FieldType)ResourceField.OUTLINE_CODE1, string);
    }

    public String getOutlineCode1() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE1);
    }

    public void setOutlineCode2(String string) {
        this.set((FieldType)ResourceField.OUTLINE_CODE2, string);
    }

    public String getOutlineCode2() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE2);
    }

    public void setOutlineCode3(String string) {
        this.set((FieldType)ResourceField.OUTLINE_CODE3, string);
    }

    public String getOutlineCode3() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE3);
    }

    public void setOutlineCode4(String string) {
        this.set((FieldType)ResourceField.OUTLINE_CODE4, string);
    }

    public String getOutlineCode4() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE4);
    }

    public void setOutlineCode5(String string) {
        this.set((FieldType)ResourceField.OUTLINE_CODE5, string);
    }

    public String getOutlineCode5() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE5);
    }

    public void setOutlineCode6(String string) {
        this.set((FieldType)ResourceField.OUTLINE_CODE6, string);
    }

    public String getOutlineCode6() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE6);
    }

    public void setOutlineCode7(String string) {
        this.set((FieldType)ResourceField.OUTLINE_CODE7, string);
    }

    public String getOutlineCode7() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE7);
    }

    public void setOutlineCode8(String string) {
        this.set((FieldType)ResourceField.OUTLINE_CODE8, string);
    }

    public String getOutlineCode8() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE8);
    }

    public void setOutlineCode9(String string) {
        this.set((FieldType)ResourceField.OUTLINE_CODE9, string);
    }

    public String getOutlineCode9() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE9);
    }

    public void setOutlineCode10(String string) {
        this.set((FieldType)ResourceField.OUTLINE_CODE10, string);
    }

    public String getOutlineCode10() {
        return (String)this.getCachedValue(ResourceField.OUTLINE_CODE10);
    }

    public void remove() {
        this.getParentFile().removeResource(this);
    }

    public Object getFieldByAlias(String string) {
        return this.getCachedValue(this.getParentFile().getAliasResourceField(string));
    }

    public void setFieldByAlias(String string, Object object) {
        this.set((FieldType)this.getParentFile().getAliasResourceField(string), object);
    }

    public void addResourceAssignment(ResourceAssignment resourceAssignment) {
        this.m_assignments.add(resourceAssignment);
    }

    void removeResourceAssignment(ResourceAssignment resourceAssignment) {
        this.m_assignments.remove(resourceAssignment);
    }

    public List<ResourceAssignment> getTaskAssignments() {
        return this.m_assignments;
    }

    public Integer getSubprojectResourceUniqueID() {
        return (Integer)this.getCachedValue(ResourceField.SUBPROJECT_RESOURCE_UNIQUE_ID);
    }

    public void setSubprojectResourceUniqueID(Integer n) {
        this.set((FieldType)ResourceField.SUBPROJECT_RESOURCE_UNIQUE_ID, n);
    }

    public Number getEnterpriseCost(int n) {
        return (Number)this.getCachedValue(this.selectResourceField(ENTERPRISE_COST_FIELDS, n));
    }

    public void setEnterpriseCost(int n, Number number) {
        this.set((FieldType)this.selectResourceField(ENTERPRISE_COST_FIELDS, n), number);
    }

    public Date getEnterpriseDate(int n) {
        return (Date)this.getCachedValue(this.selectResourceField(ENTERPRISE_DATE_FIELDS, n));
    }

    public void setEnterpriseDate(int n, Date date) {
        this.set((FieldType)this.selectResourceField(ENTERPRISE_DATE_FIELDS, n), date);
    }

    public Duration getEnterpriseDuration(int n) {
        return (Duration)this.getCachedValue(this.selectResourceField(ENTERPRISE_DURATION_FIELDS, n));
    }

    public void setEnterpriseDuration(int n, Duration duration) {
        this.set((FieldType)this.selectResourceField(ENTERPRISE_DURATION_FIELDS, n), duration);
    }

    public boolean getEnterpriseFlag(int n) {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(this.selectResourceField(ENTERPRISE_FLAG_FIELDS, n)));
    }

    public void setEnterpriseFlag(int n, boolean bl) {
        this.set((FieldType)this.selectResourceField(ENTERPRISE_FLAG_FIELDS, n), bl);
    }

    public Number getEnterpriseNumber(int n) {
        return (Number)this.getCachedValue(this.selectResourceField(ENTERPRISE_NUMBER_FIELDS, n));
    }

    public void setEnterpriseNumber(int n, Number number) {
        this.set((FieldType)this.selectResourceField(ENTERPRISE_NUMBER_FIELDS, n), number);
    }

    public String getEnterpriseText(int n) {
        return (String)this.getCachedValue(this.selectResourceField(ENTERPRISE_TEXT_FIELDS, n));
    }

    public void setEnterpriseText(int n, String string) {
        this.set((FieldType)this.selectResourceField(ENTERPRISE_TEXT_FIELDS, n), string);
    }

    public void setBaselineCost(int n, Number number) {
        this.set((FieldType)this.selectResourceField(BASELINE_COSTS, n), number);
    }

    public void setBaselineWork(int n, Duration duration) {
        this.set((FieldType)this.selectResourceField(BASELINE_WORKS, n), duration);
    }

    public Number getBaselineCost(int n) {
        return (Number)this.getCachedValue(this.selectResourceField(BASELINE_COSTS, n));
    }

    public Duration getBaselineWork(int n) {
        return (Duration)this.getCachedValue(this.selectResourceField(BASELINE_WORKS, n));
    }

    public boolean getBudget() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(ResourceField.BUDGET));
    }

    public void setBudget(boolean bl) {
        this.set((FieldType)ResourceField.BUDGET, bl);
    }

    public UUID getGUID() {
        return (UUID)this.getCachedValue(ResourceField.GUID);
    }

    public void setGUID(UUID uUID) {
        this.set((FieldType)ResourceField.GUID, uUID);
    }

    public void setCostRateTable(int n, CostRateTable costRateTable) {
        this.m_costRateTables[n] = costRateTable;
    }

    public CostRateTable getCostRateTable(int n) {
        return this.m_costRateTables[n];
    }

    public AvailabilityTable getAvailability() {
        return this.m_availability;
    }

    private ResourceField selectResourceField(ResourceField[] resourceFieldArray, int n) {
        if (n < 1 || n > resourceFieldArray.length) {
            throw new IllegalArgumentException(n + " is not a valid field index");
        }
        return resourceFieldArray[n - 1];
    }

    @Override
    public Object getCachedValue(FieldType fieldType) {
        return fieldType == null ? null : this.m_array[fieldType.getValue()];
    }

    @Override
    public Object getCurrentValue(FieldType fieldType) {
        Object object = null;
        if (fieldType != null) {
            ResourceField resourceField = (ResourceField)fieldType;
            switch (resourceField) {
                case COST_VARIANCE: {
                    object = this.getCostVariance();
                    break;
                }
                case WORK_VARIANCE: {
                    object = this.getWorkVariance();
                    break;
                }
                case CV: {
                    object = this.getCV();
                    break;
                }
                case SV: {
                    object = this.getSV();
                    break;
                }
                case OVERALLOCATED: {
                    object = this.getOverAllocated();
                    break;
                }
                default: {
                    object = this.m_array[fieldType.getValue()];
                }
            }
        }
        return object;
    }

    @Override
    public void set(FieldType fieldType, Object object) {
        if (fieldType != null) {
            int n = fieldType.getValue();
            if (this.m_eventsEnabled) {
                this.fireFieldChangeEvent((ResourceField)fieldType, this.m_array[n], object);
            }
            this.m_array[n] = object;
        }
    }

    private void fireFieldChangeEvent(ResourceField resourceField, Object object, Object object2) {
        switch (resourceField) {
            case COST: 
            case BASELINE_COST: {
                this.m_array[ResourceField.COST_VARIANCE.getValue()] = null;
                break;
            }
            case WORK: 
            case BASELINE_WORK: {
                this.m_array[ResourceField.WORK_VARIANCE.getValue()] = null;
                break;
            }
            case BCWP: 
            case ACWP: {
                this.m_array[ResourceField.CV.getValue()] = null;
                this.m_array[ResourceField.SV.getValue()] = null;
                break;
            }
            case BCWS: {
                this.m_array[ResourceField.SV.getValue()] = null;
                break;
            }
            case PEAK: 
            case MAX_UNITS: {
                this.m_array[ResourceField.OVERALLOCATED.getValue()] = null;
                break;
            }
        }
        if (this.m_listeners != null) {
            for (FieldListener fieldListener : this.m_listeners) {
                fieldListener.fieldChange(this, resourceField, object, object2);
            }
        }
    }

    @Override
    public void addFieldListener(FieldListener fieldListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new LinkedList<FieldListener>();
        }
        this.m_listeners.add(fieldListener);
    }

    @Override
    public void removeFieldListener(FieldListener fieldListener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(fieldListener);
        }
    }

    private void set(FieldType fieldType, boolean bl) {
        this.set(fieldType, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void disableEvents() {
        this.m_eventsEnabled = false;
    }

    public void enableEvents() {
        this.m_eventsEnabled = true;
    }

    @Override
    public int compareTo(Resource resource) {
        int n;
        int n2 = NumberUtility.getInt(this.getID());
        return n2 < (n = NumberUtility.getInt(resource.getID())) ? -1 : (n2 == n ? 0 : 1);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Resource) {
            bl = this.compareTo((Resource)object) == 0;
        }
        return bl;
    }

    public int hashCode() {
        return NumberUtility.getInt(this.getID());
    }

    public String toString() {
        return "[Resource id=" + this.getID() + " uniqueID=" + this.getUniqueID() + " name=" + this.getName() + "]";
    }
}

