/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projity.dialog.AbstractDialog;
import com.projity.dialog.LicenseDialog;
import com.projity.dialog.TipOfTheDay;
import com.projity.pm.graphic.IconManager;
import com.projity.pm.graphic.frames.GraphicManager;
import com.projity.strings.Messages;
import com.projity.util.BrowserControl;
import com.projity.util.Environment;
import com.projity.util.VersionUtils;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class HelpDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private static final String helpUrl = "http://www.projectlibre.org/wiki/projectlibre-manual-community-contributed-wiki-manual-0";
    private static final String videosUrl = "http://www.projectlibre.com";
    public static final String donateUrl = "http://www.projectlibre.com";
    JButton link;
    JButton videos;
    JButton tipOfTheDay;
    JButton license;
    private JPanel donatePanel;

    public static HelpDialog getInstance(Frame frame) {
        return new HelpDialog(frame);
    }

    private HelpDialog(Frame frame) {
        super(frame, Messages.getString("HelpDialog.About") + " " + Messages.getContextString("Text.ApplicationTitle"), true);
    }

    protected void initComponents() {
        this.link = new JButton(Messages.getString("HelpDialog.GoToOnlineHelp"));
        this.link.setEnabled(true);
        this.link.setToolTipText(helpUrl);
        this.link.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserControl.displayURL(HelpDialog.helpUrl);
            }
        });
        if (Environment.isOpenProj()) {
            this.tipOfTheDay = new JButton(Messages.getString("HelpDialog.ShowTipsOfTheDay"));
            this.tipOfTheDay.setEnabled(true);
            this.tipOfTheDay.setToolTipText(Messages.getString("HelpDialog.ShowTipsOfTheDay"));
            this.tipOfTheDay.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TipOfTheDay.showDialog(HelpDialog.this.getOwner(), true);
                }
            });
        }
        this.license = new JButton(Messages.getString("HelpDialog.ShowLicense"));
        this.license.setEnabled(true);
        this.license.setToolTipText(Messages.getString("HelpDialog.ShowLicense"));
        this.license.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LicenseDialog.showDialog(GraphicManager.getFrameInstance(), true);
            }
        });
        super.initComponents();
    }

    public JComponent createContentPanel() {
        FormLayout formLayout = new FormLayout("120px,180px,120px", "p, 6dlu,  p,6dlu,p,6dlu,p,6dlu,p,6dlu,p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        JLabel jLabel = new JLabel(IconManager.getIcon("logo.ProjectLibre"));
        jLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                BrowserControl.displayURL("http://www.projectlibre.com");
            }
        });
        defaultFormBuilder.nextColumn();
        defaultFormBuilder.append(jLabel);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.nextColumn();
        defaultFormBuilder.append(this.link);
        if (Environment.isOpenProj()) {
            defaultFormBuilder.nextLine(2);
            defaultFormBuilder.nextColumn();
            defaultFormBuilder.append(this.tipOfTheDay);
        }
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.nextColumn();
        defaultFormBuilder.append(this.license);
        defaultFormBuilder.nextLine(2);
        String string = VersionUtils.getVersion();
        defaultFormBuilder.addLabel(Messages.getContextString("Text.ShortTitle") + " " + "Version " + (string == null ? "Unknown" : string), cellConstraints.xyw(1, 9, 3));
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.addLabel(Messages.getString("AboutDialog.copyright"), cellConstraints.xyw(1, 11, 3));
        if (Environment.isOpenProj()) {
            JPanel jPanel = new JPanel();
            jPanel.add(defaultFormBuilder.getPanel());
            return jPanel;
        }
        return defaultFormBuilder.getPanel();
    }

    protected boolean hasCloseButton() {
        return true;
    }

    protected boolean hasOkAndCancelButtons() {
        return false;
    }

    public static JPanel makeDonatePanel(boolean bl) {
        FormLayout formLayout = new FormLayout("250px", "p, 6dlu,  p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        if (bl) {
            defaultFormBuilder.setDefaultDialogBorder();
        }
        JLabel jLabel = new JLabel(Messages.getString("Text.donateMessage"));
        defaultFormBuilder.append(jLabel);
        defaultFormBuilder.nextLine(2);
        ImageIcon imageIcon = IconManager.getIcon("paypal.donate");
        JButton jButton = new JButton(imageIcon);
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        defaultFormBuilder.append(jButton);
        jButton.setEnabled(true);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserControl.displayURL("http://www.projectlibre.com");
            }
        });
        return defaultFormBuilder.getPanel();
    }
}

