<elements>
  <summary>To be added.</summary>
  <remarks>To be added.</remarks>
  <class name="BinaryReader" fullname="System.IO.BinaryReader" assembly="mscorlib">
    <summary>A simple class to do some limited binary I/O.</summary>
    <remarks>This class can be used to do some limited binary reading operations on a stream.  

<para>
   This class is not a general purpose binary file format reader.  Instead it is a class that allows data that was written with the <see cref="T:System.IO.BinaryWriter" /> class to be read.  The actual encoding of the data is little-endian.
</para></remarks>
  </class>
  <class name="BinaryWriter" fullname="System.IO.BinaryWriter" assembly="mscorlib">
    <summary>Limited binary writer.</summary>
    <remarks>This class can be used to do some limited binary writing operations on a stream.  

<para>
   This class is not a general purpose binary file format writer.  Instead it is a class that writes data in binary little-endian format.  The <see cref="T:System.IO.BinaryReader" /> class can be used to read streams that have been written with this class.  
</para></remarks>
  </class>
  <class name="BufferedStream" fullname="System.IO.BufferedStream" assembly="mscorlib">
    <summary>Provides a wrapper layer around an existing stream to enhance read/write performance.</summary>
    <remarks>To be added</remarks>
  </class>
  <class name="Directory" fullname="System.IO.Directory" assembly="mscorlib">
    <summary>
      <para> Provides information and performs operations
      on directories.</para>
    </summary>
    <remarks>
      <para>Implementations are required to preserve
      the case of file and directory path strings, and to be case
      sensitive if and only if the current platform is case-sensitive. </para>
      <para>
        <block subset="none" type="note">In most
   <see langword=" Directory" /> methods that accept <paramref name="path" />
   arguments, the path can refer to a file or a directory. </block>
      </para>
    </remarks>
  </class>
  <class name="DirectoryInfo" fullname="System.IO.DirectoryInfo" assembly="mscorlib">
    <summary>Represents information about a directory in the filesystem.</summary>
    <remarks>The <see cref="T:System.IO.DirectoryInfo" /> class encodes information about a directory.
It also allows basic manipulations of filesystem structure:

<list type="bullet"><item><term>Creation with <see cref="M:System.IO.DirectoryInfo.Create" /> or <see cref="M:System.IO.DirectoryInfo.CreateSubdirectory" />.</term></item><item><term>Deletion with <see cref="M:System.IO.DirectoryInfo.Delete" />.</term></item><item><term>Movement with <see cref="M:System.IO.DirectoryInfo.MoveTo" />.</term></item><item><term>Listing with <see cref="M:System.IO.DirectoryInfo.GetDirectories" />, <see cref="M:System.IO.DirectoryInfo.GetFiles" />, and <see cref="M:System.IO.DirectoryInfo.GetFileSystemInfos" />.</term></item></list></remarks>
  </class>
  <class name="DirectoryNotFoundException" fullname="System.IO.DirectoryNotFoundException" assembly="mscorlib">
    <summary>
      <para> Represents the error that occurs when part of a file or directory argument
 cannot be found.</para>
    </summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="DriveInfo" fullname="System.IO.DriveInfo" assembly="mscorlib">
    <summary>To be added.</summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="DriveNotFoundException" fullname="System.IO.DriveNotFoundException" assembly="mscorlib">
    <summary>To be added.</summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="DriveType" fullname="System.IO.DriveType" assembly="mscorlib">
    <summary>To be added.</summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="EndOfStreamException" fullname="System.IO.EndOfStreamException" assembly="mscorlib">
    <summary>
      <para>Represents the error that occurs when an attempt is made to read past the
      end of a stream.</para>
    </summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="File" fullname="System.IO.File" assembly="mscorlib">
    <summary>
      <para> Provides information and performs operations on
      files<SPAN>
      .</SPAN></para>
    </summary>
    <remarks>
      <para>Implementations of this class are required to
      preserve the case of path strings. Implementations are required to be case
      sensitive if and only if the platform is case-sensitive. </para>
      <para>The following table describes the enumerations that are
      used to customize the behavior of various <see cref="T:System.IO.File" /> methods.</para>
      <list type="table">
        <listheader>
          <term>Enumeration</term>
          <description>Description</description>
        </listheader>
        <item>
          <term>
            <see cref="T:System.IO.FileAccess" />
          </term>
          <description>Specifies read and write access to a
         file.</description>
        </item>
        <item>
          <term>
            <see cref="T:System.IO.FileShare" />
          </term>
          <description>Specifies the level of access permitted for a file that is already in
      use.</description>
        </item>
        <item>
          <term>
            <see cref="T:System.IO.FileMode" />
          </term>
          <description>Specifies whether the contents of an existing file are preserved or
   overwritten, and whether requests to create an existing file cause an
   exception.</description>
        </item>
      </list>
    </remarks>
  </class>
  <class name="FileAccess" fullname="System.IO.FileAccess" assembly="mscorlib">
    <summary>
      <para> Defines constants used to specify the level of file access being requested.</para>
    </summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="FileAttributes" fullname="System.IO.FileAttributes" assembly="mscorlib">
    <summary>To be added</summary>
    <remarks>To be added</remarks>
  </class>
  <class name="FileInfo" fullname="System.IO.FileInfo" assembly="mscorlib">
    <summary>To be added</summary>
    <remarks>To be added</remarks>
  </class>
  <class name="FileLoadException" fullname="System.IO.FileLoadException" assembly="mscorlib">
    <summary>
      <para> Represents the error that occurs when a <see cref="T:System.Reflection.Assembly" /> file is found
 but cannot be loaded.</para>
    </summary>
    <remarks>
      <para>
        <block subset="none" type="note">The <see cref="T:System.IO.FileNotFoundException" /> exception is thrown when
 the file fails to load because it cannot be located. If the file is located, but
 cannot be loaded due to insufficient permissions, a <see cref="T:System.Security.SecurityException" />
 is
 thrown.</block>
      </para>
    </remarks>
  </class>
  <class name="FileMode" fullname="System.IO.FileMode" assembly="mscorlib">
    <summary>
      <para> Specifies how the operating system opens a file.</para>
    </summary>
    <remarks>
      <para>
        <see cref="T:System.IO.FileMode" /> values specify whether a
   file is created if one does not exist, and determine whether the contents of existing
   files are retained or overwritten.</para>
    </remarks>
  </class>
  <class name="FileNotFoundException" fullname="System.IO.FileNotFoundException" assembly="mscorlib">
    <summary>
      <para> Represents the error that occurs when a file path
      argument specifies a file that does not exist.</para>
    </summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="FileOptions" fullname="System.IO.FileOptions" assembly="mscorlib">
    <summary>To be added.</summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="FileShare" fullname="System.IO.FileShare" assembly="mscorlib">
    <summary>
      <para> Specifies the level of
      access permitted for a file that is already in use.</para>
    </summary>
    <remarks>
      <para>This enumeration is used to specify the way
      in which multiple threads access the same file. The level of access is set by the
      first thread that requests access to the file. For example, if a thread opens a
      file and specifies <see langword="FileShare.Read" />,
      other
      threads are permitted to open the file for reading but not for writing.</para>
    </remarks>
  </class>
  <class name="FileStream" fullname="System.IO.FileStream" assembly="mscorlib">
    <summary>
      <para>Exposes a <see cref="T:System.IO.Stream" /> around a file,
   supporting both synchronous and asynchronous read and write operations.</para>
    </summary>
    <remarks>
      <para>
        <see cref="T:System.IO.FileStream" /> is used for reading and writing files on
   a file system, as well as other file-related operating system handles
   such as pipes, standard input, standard output. <see cref="T:System.IO.FileStream" />
   buffers input and output for better performance.</para>
      <para>The <see cref="T:System.IO.FileStream" />
class can open a file in one of two modes, either synchronously or
asynchronously, with significant performance consequences for the
synchronous methods (<see cref="M:System.IO.FileStream.Read(System.Byte[],System.Int32,System.Int32)" /> and
<see cref="M:System.IO.FileStream.Write(System.Byte[],System.Int32,System.Int32)" />) and the asynchronous
methods (<see cref="M:System.IO.FileStream.BeginRead(System.Byte[],System.Int32,System.Int32,System.AsyncCallback,System.Object)" /> and
<see cref="M:System.IO.FileStream.BeginWrite(System.Byte[],System.Int32,System.Int32,System.AsyncCallback,System.Object)" /> ). Both sets 
of methods will work in either mode; however, the mode will affect the
performance of these methods. <see cref="T:System.IO.FileStream" /> defaults
to opening files synchronously, but provides a constructor to open
files asynchronously.</para>
      <para> When accessing files, a security check is performed when
   the file is created or opened. The security check is typically not done again unless
   the file is closed and reopened. <block subset="none" type="note">Checking
   permissions when the file is first accessed minimizes the impact of the security
   check on application performance (since opening a file happens once, while
   reading and writing can happen multiple times).</block> Note that if an
opened file is passed to an untrusted caller, the security system can, but is
not required to prevent the caller from accessing the file.</para>
      <para>
        <see cref="T:System.IO.FileStream" /> objects support random access to files using the
<see cref="M:System.IO.FileStream.Seek(System.Int64,System.IO.SeekOrigin)" /> method, and the <see cref="P:System.IO.Stream.CanSeek" /> properties 
of <see cref="T:System.IO.FileStream" /> instances encapsulating files are set to <see langword="true" />. The <see cref="M:System.IO.FileStream.Seek(System.Int64,System.IO.SeekOrigin)" /> method allows the
read/write position to be moved to any position within the file. This is done
with byte offset reference point parameters. The byte offset is relative to the
seek reference point, which can be the beginning, the current position, or the
end of the underlying file, as represented by the three values of the
<see cref="T:System.IO.SeekOrigin" /> enumeration.</para>
      <para>If a <see cref="T:System.IO.FileStream" /> encapsulates a device that does not support
seeking, its <see cref="P:System.IO.FileStream.CanSeek" /> property is <see langword="false" />. <block subset="none" type="note">For additional information, see <see cref="P:System.IO.Stream.CanSeek" />.</block></para>
      <para>
        <block subset="none" type="note">The
<see cref="T:System.IO.File" /> class provides 
   methods for the creation of <see cref="T:System.IO.FileStream" />
   objects
   based on file paths. The <see cref="T:System.IO.MemoryStream" /> class creates a stream from a byte array and
   functions similarly to a <see cref="T:System.IO.FileStream" />.</block>
      </para>
    </remarks>
  </class>
  <class name="FileSystemInfo" fullname="System.IO.FileSystemInfo" assembly="mscorlib">
    <summary>To be added</summary>
    <remarks>To be added</remarks>
  </class>
  <class name="IOException" fullname="System.IO.IOException" assembly="mscorlib">
    <summary>
      <para>Represents the error that occurs when an I/O operation fails.</para>
    </summary>
    <remarks>
      <para>
        <see cref="T:System.IO.IOException" /> is the
   base
   class for exceptions thrown while accessing information using streams, files and
   directories.</para>
      <block subset="none" type="note">
        <para>The Base Class Library includes the following types, 
      each of which is derived from <see cref="T:System.IO.IOException" />:</para>
        <list type="bullet">
          <item>
            <term>
              <see cref="T:System.IO.DirectoryNotFoundException" />
            </term>
          </item>
          <item>
            <term>
              <see cref="T:System.IO.EndOfStreamException" />
            </term>
          </item>
          <item>
            <term>
              <see cref="T:System.IO.FileLoadException" />
            </term>
          </item>
          <item>
            <term>
              <see cref="T:System.IO.FileNotFoundException" />
            </term>
          </item>
          <item>
            <term>
              <see cref="T:System.IO.PathTooLongException" />
            </term>
          </item>
        </list>
        <para>Where appropriate, use these types instead of <see cref="T:System.IO.IOException" />.</para>
      </block>
    </remarks>
  </class>
  <class name="MemoryStream" fullname="System.IO.MemoryStream" assembly="mscorlib">
    <summary>
      <para> Provides support for creating and using a stream whose backing store is memory.</para>
    </summary>
    <remarks>
      <para>The <see cref="T:System.IO.MemoryStream" /> class creates streams that have memory as a backing
   store instead of a disk or a network connection. <see cref="T:System.IO.MemoryStream" />
   encapsulates data stored as an unsigned byte array. The encapsulated data is directly accessible
   in memory. Memory streams can reduce the need for temporary buffers and files
   in an application.</para>
      <para>The <paramref name="current position" /> of
a stream is the position at which the next read or write operation takes
place. The current position can be retrieved or set through the <see cref="M:System.IO.MemoryStream.Seek(System.Int64,System.IO.SeekOrigin)" />
method. When a new instance of <see cref="T:System.IO.MemoryStream" />
is created, the
current position is set to zero.</para>
      <para>The maximum length of a <see cref="T:System.IO.MemoryStream" /> is implementation-specific.</para>
      <para>
        <block subset="none" type="note">Memory streams created
   with an unsigned byte array provide a non-resizable stream view
   of the data. When using a byte array, you can neither
   append to nor shrink the stream, although you might be able to modify the existing
   contents depending on the parameters passed into the constructor.</block>
      </para>
    </remarks>
  </class>
  <class name="Path" fullname="System.IO.Path" assembly="mscorlib">
    <summary>
      <para>Performs operations on <see cref="T:System.String" /> instances that contain
   file or directory path information.</para>
    </summary>
    <remarks>
      <para> A path is a string that provides the location of a file
      or directory. A path does not necessarily point to a location on disk; for
      example, a path might map to a location in memory or on a device. Paths are
      composed of the components described below. Component names are shown in
   <paramref name="italics " />
   
   and the following table describes the symbols used in component definitions:</para>
      <list type="table">
        <listheader>
          <term>Symbol</term>
          <description>Description</description>
        </listheader>
        <item>
          <term> &lt; &gt;</term>
          <description>Indicates a path component.</description>
        </item>
        <item>
          <term> { } </term>
          <description>Indicates a grouping; either all components
         in a grouping are present, or none are permitted to be
         present.</description>
        </item>
        <item>
          <term> *</term>
          <description>Indicates that the component or grouping that immediately precedes
         this symbol can appear zero, one, or multiple times.</description>
        </item>
        <item>
          <term> ?</term>
          <description>Indicates that the component or grouping that immediately precedes
         this symbol can appear zero, or one times.</description>
        </item>
        <item>
          <term> +</term>
          <description>Indicates string concatenation.</description>
        </item>
      </list>
      <para> The components that define a path are as
   follows:</para>
      <para>
        <paramref name="Directory Name" />: A string that
specifies one or more directory levels in a file system. If a directory name
contains
multiple levels, a <paramref name="directory separator character" /> separates the levels; however, a directory name does not begin or
end with a directory separator character. In the example path <c>C:/foo/bar/bat.txt</c>, the directory
name is "<c>foo/bar</c>". <see cref="M:System.IO.Path.GetDirectoryName(System.String)" /> returns the directory name component of a path.
Note that this method does include a beginning separator character if one is
included
in the specified
path. </para>
      <para>
        <paramref name="Directory Separator Character" />:
An implementation-specific constant string containing a single printable
non-alphanumeric character used to separate levels in a file system. In the
example path <c>C:/foo/bar/bat.txt</c>, the directory separator character is "<c>/</c>". The <see cref="F:System.IO.Path.DirectorySeparatorChar" /> and <see cref="F:System.IO.Path.AltDirectorySeparatorChar" /> store
implementation-specific directory separator characters
.</para>
      <para>
        <paramref name="Extension" />: A string that consists of the
characters at the end of a file name, from and including the last <paramref name="extension separator character" />. The minimum and
maximum lengths of extension components are implementation-specific. In the example
path <c>C:/foo/bar/bat.txt</c>
, the <paramref name="extension" /> is "<c>.txt</c>". The <see cref="M:System.IO.Path.GetExtension(System.String)" /> method returns the
extension component of a
path.</para>
      <para>
        <paramref name="Extension Separator Character" />:
An implementation-specific constant string
composed of a single character that appears after the last character in the
<paramref name="file base" /> component indicating the beginning of the <paramref name="extension" /> 
component. If the extension separator character<paramref name=" " />is the first character
in a <paramref name="file name" />, it is not interpreted as a
extension separator character<paramref name="." /> If more than one extension separator
character<paramref name=" " />appears in a file name, only the last occurrence is the
extension separator character; all other occurrences are part of the file base
component<paramref name="." /> In the example path <c>C:/foo/bar/bat.txt</c>, the extension separator character
is "<c>.</c>". </para>
      <para>
        <paramref name="File Base" />: A string containing the
<paramref name="file" /><paramref name="name" /> with the <paramref name="extension " />component removed. In the example path <c>C:/foo/bar/bat.txt</c>, the file base
is "<c>bat</c>".
The <see cref="M:System.IO.Path.GetFileNameWithoutExtension(System.String)" /> method returns the
file base component of a
path.</para>
      <para>
        <paramref name="File Name" />: A string containing all information
required to uniquely identify a file within a directory. This component is defined
as follows:</para>
      <para>
        <c>&lt;file
   base&gt;{+&lt;extension&gt;}?</c>
      </para>
      <para> The file name component is commonly referred to as a
   relative file name. In the example path <c>C:/foo/bar/bat.txt</c>, the file name is "<c>bat.txt</c>". The <see cref="M:System.IO.Path.GetFileName(System.String)" />
method returns the file name component of a
path.</para>
      <para>
        <paramref name="Full Directory Name" />: A string containing all
information required to uniquely identify a directory within a file
system. This component is defined as
follows:</para>
      <para>
        <c>&lt;path
   root&gt;+&lt;directory name&gt;</c>
      </para>
      <para> The full directory name component is commonly referred to
   as the absolute directory name. In the example path <c>C:/foo/bar/bat.txt</c>, the full directory name is "<c>C:/foo/bar</c>
".</para>
      <para>
        <paramref name="Full" />
        <paramref name="Path" />: A string containing all
information required to uniquely identify a file within a file system. This
component is defined as
follows:</para>
      <para>
        <c>&lt;full
   directory name&gt;+&lt;directory separator character&gt;+&lt;file
   name&gt;</c>
      </para>
      <para> The full path component is commonly referred to as the
   absolute file name. In the example path <c>C:/foo/bar/bat.txt</c>, the full path is "<c>C:/foo/bar/bat.txt</c>". The <see cref="M:System.IO.Path.GetFullPath(System.String)" /> method returns the full path
component.</para>
      <para>
        <paramref name="Path Root" />: A string containing all information
required to uniquely identify the highest level in a file
system. The component is defined as
follows:</para>
      <para>
        <c>{&lt;volume
   identifier&gt;+&lt;volume separator character&gt;}?+&lt;directory separator
   character&gt;</c>
      </para>
      <para> In the example path <c>C:/foo/bar/bat.txt</c> , the path root is "<c>C:/</c>". The <see cref="M:System.IO.Path.GetPathRoot(System.String)" />
method returns the <paramref name="path root" />
component.</para>
      <para>
        <paramref name="Volume" />
        <paramref name="Identifier" />: A string composed of a single alphabetic
character that uniquely defines a drive or volume in a file system. This
component is optional; on systems that do not support volume identifiers, this
component is required to be a zero length string. In the example path <c>C:/foo/bar/bat.txt</c>
, the path root<paramref name=" " />is "<c>C:</c>". In the example path, <c>\\myserver\myshare\foo\bar\baz.txt</c>
the path root is "<c>\\myserver\myshare</c>". </para>
      <para>
        <paramref name="Volume Separator Character" />: A
string composed of a single alphabetic character used to separate the
<paramref name="volume" /><paramref name="identifier" /> from other components in a path. This
component can appear in a path only if a volume identifier is
present<paramref name="." /> This component is optional; on systems that do not
support the volume identifier<paramref name=" " />component, the volume separator character
component is required to be a zero length
string.</para>
      <para>The exact format of a path is determined by the current
   platform. For example, on Windows systems a path can start with a volume
   identifier, while this element is not present in Unix system paths. On some
   systems, paths containing file names can contain extensions. The format of an
   extension
   is platform dependent; for example, some systems limit extensions to
   three characters, while others do not. The current platform and possibly the current
   file system determine the set of characters used to separate the elements of
   a path, and the set of characters that cannot be used when specifying paths.
   Because of these differences, the fields of the <see cref="T:System.IO.Path" /> class as well as the exact behavior
   of some members of the <see cref="T:System.IO.Path" /> class are determined by the current platform and/or file
   system.</para>
      <para>A path contains either absolute or relative location
   information. Absolute paths fully specify a location: the file or directory can
   be uniquely identified regardless of the current location. A full path or full
   directory name component is present in an absolute path. Relative paths specify
   a partial location: the current working directory is used as the starting point
   when locating a file specified with a relative path. <block subset="none" type="note">To determine the current working directory, call <see cref="M:System.IO.Directory.GetCurrentDirectory" />
   .</block></para>
      <para> Most members of the <see langword="Path" /> class do not interact with the file system
and do not verify the existence of the file or directory specified by a path
string. <see cref="T:System.IO.Path" />
members that modify a path string, such
as <see cref="M:System.IO.Path.ChangeExtension(System.String,System.String)" />, have no effect on files and directories in the
file system. <see cref="T:System.IO.Path" />
members do, however, validate the contents of a specified path string, and
throw <see cref="T:System.ArgumentException" /> if the string contains
characters that are not valid in path strings, as defined by the current
platform and file system. Implementations are
required to preserve the case of file and directory path strings, and to be case
sensitive if and only if the current platform is case-sensitive.
</para>
    </remarks>
  </class>
  <class name="PathTooLongException" fullname="System.IO.PathTooLongException" assembly="mscorlib">
    <summary>
      <para> Represents the error that occurs when a directory or file name is longer than the system-defined maximum
      length.</para>
    </summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="SearchOption" fullname="System.IO.SearchOption" assembly="mscorlib">
    <summary>To be added.</summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="SeekOrigin" fullname="System.IO.SeekOrigin" assembly="mscorlib">
    <summary>
      <para> Defines the seek reference positions.</para>
    </summary>
    <remarks>
      <para> The <see cref="T:System.IO.SeekOrigin" /> enumeration is used by the overrides of the <see cref="M:System.IO.Stream.Seek(System.Int64,System.IO.SeekOrigin)" qualify="true" /> method to set
   the seek reference point in a stream, which allows you to specify an offset from
   the reference point.</para>
    </remarks>
  </class>
  <class name="Stream" fullname="System.IO.Stream" assembly="mscorlib">
    <summary>
      <para>Abstract base class for all stream implementations.</para>
    </summary>
    <remarks>
      <para>Streams involve three fundamental operations: </para>
      <list type="bullet">
        <item>
          <term>
         
         You can read from streams. Reading is the transfer of
         data from a stream into a data structure, such as an array of bytes.</term>
        </item>
        <item>
          <term>
         
         You can write to streams. Writing is the transfer of
         data from a data structure into a stream.</term>
        </item>
        <item>
          <term>
         
         Streams can support seeking. Seeking is the querying and modifying of the
         current position within a stream. Seek capability depends on the kind of
         backing store a stream has. For example, network streams have no unified
         concept of a current position, and therefore typically do not support seeking.</term>
        </item>
      </list>
      <para>All classes that represent streams inherit from the
<see cref="T:System.IO.Stream" /> class.
   The <see cref="T:System.IO.Stream" />
   class and its subclasses provide a generic view of
   data sources and repositories, isolating the programmer from
   the specific details of the operating system and underlying devices.</para>
      <para>Subclasses are required to provide implementations only 
   for the synchronous read and write methods. The asynchronous read and write
   methods are implemented via the synchronous ones. <block subset="none" type="note"> The <see cref="T:System.IO.Stream" /> synchronous read and write methods
   are <see cref="M:System.IO.Stream.Read(System.Byte[],System.Int32,System.Int32)" /> and <see cref="M:System.IO.Stream.Write(System.Byte[],System.Int32,System.Int32)" />. The asynchronous read and write methods are
<see cref="M:System.IO.Stream.BeginRead(System.Byte[],System.Int32,System.Int32,System.AsyncCallback,System.Object)" />, <see cref="M:System.IO.Stream.EndRead(System.IAsyncResult)" />, <see cref="M:System.IO.Stream.BeginWrite(System.Byte[],System.Int32,System.Int32,System.AsyncCallback,System.Object)" />, 
   and <see cref="M:System.IO.Stream.EndWrite(System.IAsyncResult)" />.</block></para>
      <para>Depending on the underlying data source or repository, streams might support
   only some of these capabilities. An application can query a stream for its
   capabilities by using the <see cref="P:System.IO.Stream.CanRead" />, <see cref="P:System.IO.Stream.CanWrite" />, and <see cref="P:System.IO.Stream.CanSeek" />
   properties.</para>
      <para>The <see cref="M:System.IO.Stream.Read(System.Byte[],System.Int32,System.Int32)" /> and <see cref="M:System.IO.Stream.Write(System.Byte[],System.Int32,System.Int32)" /> methods read and write data
in a variety of formats. For streams that support seeking, the <see cref="M:System.IO.Stream.Seek(System.Int64,System.IO.SeekOrigin)" /> and
<see cref="M:System.IO.Stream.SetLength(System.Int64)" /> methods, and the <see cref="P:System.IO.Stream.Position" /> and
<see cref="P:System.IO.Stream.Length" /> properties can be used to query and modify the
current position and length of a stream.</para>
      <para>Some stream implementations perform local buffering of the underlying data to
   improve performance. For such streams, the <see cref="M:System.IO.Stream.Flush" /> method can be used to clear
   any internal buffers and ensure that all data has been written to the underlying
   data source or repository.</para>
      <para>Calling <see cref="M:System.IO.Stream.Close" /> on a <see cref="T:System.IO.Stream" /> flushes any
buffered data, essentially calling <see cref="M:System.IO.Stream.Flush" /> for you. <see cref="M:System.IO.Stream.Close" /> also releases operating system resources such as file handles, network
connections, or memory used for any internal buffering.</para>
      <para>If you need a <see cref="T:System.IO.Stream" /> with no backing store (i.e., a bit bucket), use
<see cref="F:System.IO.Stream.Null" /> 
. </para>
    </remarks>
  </class>
  <class name="StreamReader" fullname="System.IO.StreamReader" assembly="mscorlib">
    <summary>
      <para>Implements a <see cref="T:System.IO.Stream" /> that reads
   characters from a byte stream in a particular encoding.</para>
    </summary>
    <remarks>
      <para>The <see cref="T:System.IO.StreamReader" /> class is designed for
   character input in a particular <see cref="T:System.Text.Encoding" />, whereas subclasses of <see cref="T:System.IO.Stream" /> are designed for byte input and output.</para>
      <block subset="none" type="note">
        <para>
          <see cref="T:System.IO.StreamReader" /> defaults to UTF-8 encoding unless specified
   otherwise, instead of defaulting to the ANSI code page for the current system.
   UTF-8 handles Unicode characters correctly and provides consistent results on localized
   versions of the operating system.</para>
        <para>When reading from a <see cref="T:System.IO.Stream" />, it is more efficient to use a buffer that is the
same size as the internal buffer of the stream.</para>
        <para>By default, a <see cref="T:System.IO.StreamReader" /> is not thread safe. For a
thread-safe wrapper, see <see cref="M:System.IO.TextReader.Synchronized(System.IO.TextReader)" qualify="true" />
.</para>
      </block>
    </remarks>
  </class>
  <class name="StreamWriter" fullname="System.IO.StreamWriter" assembly="mscorlib">
    <summary>
      <para>Implements a <see cref="T:System.IO.Stream" /> wrapper that writes
   characters to a stream in a particular encoding.</para>
    </summary>
    <remarks>
      <para>The <see cref="T:System.IO.StreamWriter" /> class is designed for character output in a particular
<see cref="T:System.Text.Encoding" />, 
   whereas subclasses of <see cref="T:System.IO.Stream" /> are designed for byte
   input and output.</para>
      <para>
        <see cref="T:System.IO.StreamWriter" /> defaults to using an instance of <see cref="T:System.Text.UTF8Encoding" /> unless specified 
otherwise. This instance of <see cref="T:System.Text.UTF8Encoding" /> is constructed such that the <see cref="M:System.Text.Encoding.GetPreamble" qualify="true" /> method returns
the Unicode byte order mark written in UTF-8. The preamble of the encoding is
added to a stream when you are not appending to an existing stream. This means
any text file you create with <see cref="T:System.IO.StreamWriter" /> has three byte order marks at
its beginning. UTF-8
handles all Unicode characters correctly and gives consistent results on
localized versions of the operating system. </para>
      <para>
        <block subset="none" type="note">By default, 
<see cref="T:System.IO.StreamWriter" /> is not thread safe. For a thread-safe wrapper, see <see cref="M:System.IO.TextWriter.Synchronized(System.IO.TextWriter)" qualify="true" />
.</block>
      </para>
    </remarks>
  </class>
  <class name="StringReader" fullname="System.IO.StringReader" assembly="mscorlib">
    <summary>
      <para> Implements a <see cref="T:System.IO.TextReader" />
that reads from a string.</para>
    </summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="StringWriter" fullname="System.IO.StringWriter" assembly="mscorlib">
    <summary>
   Implements a <see cref="T:System.IO.TextWriter" /> that writes information to a string.
</summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="TextReader" fullname="System.IO.TextReader" assembly="mscorlib">
    <summary>
      <para>Represents an object that can read a sequential series of
      characters.</para>
    </summary>
    <remarks>
      <para>
        <see cref="T:System.IO.TextReader" /> is designed for character
   input, whereas the <see cref="T:System.IO.StreamReader" /> is designed for byte input and the
<see cref="T:System.IO.StringReader" />
class is designed for reading from a
string.</para>
      <para>By default, a <see cref="T:System.IO.TextReader" /> is not thread safe. For information on creating a
thread-safe <see cref="T:System.IO.TextReader" />
, see <see cref="M:System.IO.TextReader.Synchronized(System.IO.TextReader)" qualify="true" /> .</para>
    </remarks>
  </class>
  <class name="TextWriter" fullname="System.IO.TextWriter" assembly="mscorlib">
    <summary>
      <para> 
      Represents a writer that can write a sequential series of characters.</para>
    </summary>
    <remarks>
      <para>
        <see cref="T:System.IO.TextWriter" /> is designed for character output, whereas the
<see cref="T:System.IO.Stream" /> 
class is designed for byte input and output.</para>
      <para>
        <block subset="none" type="note">By default, a <see cref="T:System.IO.TextWriter" /> is not thread safe. See <see cref="M:System.IO.TextWriter.Synchronized(System.IO.TextWriter)" qualify="true" /> for a
thread-safe wrapper. </block>
      </para>
    </remarks>
  </class>
  <class name="UnmanagedMemoryAccessor" fullname="System.IO.UnmanagedMemoryAccessor" assembly="mscorlib">
    <summary>To be added.</summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="UnmanagedMemoryStream" fullname="System.IO.UnmanagedMemoryStream" assembly="mscorlib">
    <summary>To be added.</summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="HandleInheritability" fullname="System.IO.HandleInheritability" assembly="System.Core">
    <summary>To be added.</summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="ErrorEventArgs" fullname="System.IO.ErrorEventArgs" assembly="System">
    <summary>To be added</summary>
    <remarks>To be added</remarks>
  </class>
  <class name="ErrorEventHandler" fullname="System.IO.ErrorEventHandler" assembly="System">
    <summary>To be added</summary>
    <remarks>To be added</remarks>
  </class>
  <class name="FileSystemEventArgs" fullname="System.IO.FileSystemEventArgs" assembly="System">
    <summary>To be added</summary>
    <remarks>To be added</remarks>
  </class>
  <class name="FileSystemEventHandler" fullname="System.IO.FileSystemEventHandler" assembly="System">
    <summary>To be added</summary>
    <remarks>To be added</remarks>
  </class>
  <class name="FileSystemWatcher" fullname="System.IO.FileSystemWatcher" assembly="System">
    <summary>Monitors File System's changes in directories, files and files inside directories.</summary>
    <remarks>
      <para>
Mono's implementation of the FileSystemWatcher has multiple backends.   This is necessary because not all operating systems supported by Mono have all the features necessary to provide the functionality expected by applications.
</para>
      <para>
If the operating system kernel supports watching directories (inotify on Linux, KEvents on BSD or OSX) that feature is used;   Otherwise it falls back to using the Gamin or FAM libraries (these libraries provide an API to monitor directories) and if none of those features are available, Mono will poll every 750 milliseconds the directories watched.  
</para>
      <para>
You can force the polling behavior (instead of using the kernel support) by setting the MONO_MANAGED_WATCHER environment variable before executing your application.   This might be useful for filesystems that do not support inotify and still require polling to detect changes.
</para>
    </remarks>
  </class>
  <class name="InternalBufferOverflowException" fullname="System.IO.InternalBufferOverflowException" assembly="System">
    <summary>To be added</summary>
    <remarks>To be added</remarks>
  </class>
  <class name="InvalidDataException" fullname="System.IO.InvalidDataException" assembly="System">
    <summary>To be added.</summary>
    <remarks>To be added.</remarks>
  </class>
  <class name="IODescriptionAttribute" fullname="System.IO.IODescriptionAttribute" assembly="System">
    <summary>To be added</summary>
    <remarks>To be added</remarks>
  </class>
  <class name="NotifyFilters" fullname="System.IO.NotifyFilters" assembly="System">
    <summary>To be added</summary>
    <remarks>To be added</remarks>
  </class>
  <class name="RenamedEventArgs" fullname="System.IO.RenamedEventArgs" assembly="System">
    <summary>To be added</summary>
    <remarks>To be added</remarks>
  </class>
  <class name="RenamedEventHandler" fullname="System.IO.RenamedEventHandler" assembly="System">
    <summary>To be added</summary>
    <remarks>To be added</remarks>
  </class>
  <class name="WaitForChangedResult" fullname="System.IO.WaitForChangedResult" assembly="System">
    <summary>To be added</summary>
    <remarks>To be added</remarks>
  </class>
  <class name="WatcherChangeTypes" fullname="System.IO.WatcherChangeTypes" assembly="System">
    <summary>To be added</summary>
    <remarks>To be added</remarks>
  </class>
</elements>