/*
 * Decompiled with CFR 0.152.
 */
package impl.krypt.asn1.pem;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.ext.krypt.Base64;

public class PemInputStream
extends FilterInputStream {
    private final Base64Buffer b64Buffer;
    private final byte[] singleByte = new byte[1];

    public PemInputStream(InputStream in) {
        super(in);
        this.b64Buffer = new Base64Buffer(in);
    }

    public void continueStream() {
        this.b64Buffer.continueStream();
    }

    public String getCurrentName() {
        return this.b64Buffer.getName();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len <= 0) {
            throw new IllegalArgumentException("Negative or zero length");
        }
        return this.b64Buffer.read(b, off, len);
    }

    @Override
    public int read() throws IOException {
        int r = this.read(this.singleByte);
        while (r == 0) {
            r = this.read(this.singleByte);
        }
        if (r == -1) {
            return r;
        }
        return this.singleByte[0] & 0xFF;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public static class MalformedPemException
    extends RuntimeException {
        public MalformedPemException(String message) {
            super(message);
        }
    }

    private static class Base64Buffer {
        private static final int THRESHOLD = 4096;
        private final BufferedReader in;
        private State state = State.HEADER;
        private byte[] buffer;
        private int bufpos = 0;
        private boolean eof = false;
        private String name;

        public Base64Buffer(InputStream in) {
            try {
                this.in = new BufferedReader(new InputStreamReader(in, "US-ASCII"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void continueStream() {
            this.buffer = null;
            this.name = null;
            this.bufpos = 0;
            this.state = State.HEADER;
            this.eof = false;
        }

        private int decodeLine(String line, OutputStream out) throws IOException {
            try {
                byte[] bytes = line.getBytes("US-ASCII");
                Base64.decodeTo(bytes, 0, bytes.length, out);
                return bytes.length;
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }

        private void fill() throws IOException {
            int total = 0;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            String line = this.in.readLine();
            block9: while (!this.state.equals((Object)State.DONE) && total < 4096 && line != null) {
                if (line.equals("")) {
                    line = this.in.readLine();
                    continue;
                }
                switch (this.state) {
                    case HEADER: {
                        PemLineMatcher matcher;
                        if (line.charAt(0) == '-' && (matcher = new PemHeaderMatcher(line)).match()) {
                            this.state = State.CONTENT;
                            this.name = matcher.getName();
                        }
                        line = this.in.readLine();
                        continue block9;
                    }
                    case CONTENT: {
                        if (line.charAt(0) == '-') {
                            this.state = State.FOOTER;
                            continue block9;
                        }
                        if ((total += this.decodeLine(line, baos)) >= 4096) continue block9;
                        line = this.in.readLine();
                        continue block9;
                    }
                    case FOOTER: {
                        PemLineMatcher matcher;
                        if (line.charAt(0) == '-') {
                            matcher = new PemFooterMatcher(line, this.name);
                            if (((PemFooterMatcher)matcher).match()) {
                                this.state = State.DONE;
                                continue block9;
                            }
                            line = this.in.readLine();
                            continue block9;
                        }
                        line = this.in.readLine();
                        continue block9;
                    }
                }
            }
            if (this.state.equals((Object)State.DONE) || line == null) {
                this.eof = true;
            }
            if (line == null && !this.state.equals((Object)State.DONE)) {
                switch (this.state) {
                    case HEADER: {
                        break;
                    }
                    case CONTENT: {
                        throw new MalformedPemException("PEM data ended prematurely");
                    }
                    default: {
                        throw new MalformedPemException("Could not find matching footer");
                    }
                }
            }
            this.buffer = baos.toByteArray();
            this.bufpos = 0;
        }

        private int consumeBytes(byte[] b, int off, int len) {
            if (this.bufpos == this.buffer.length) {
                return 0;
            }
            int available = this.buffer.length - this.bufpos;
            int toRead = len < available ? len : available;
            System.arraycopy(this.buffer, this.bufpos, b, off, toRead);
            this.bufpos += toRead;
            return toRead;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int total = 0;
            if (this.buffer == null) {
                this.fill();
            }
            while (!(total == len || this.bufpos == this.buffer.length && this.eof)) {
                if (this.bufpos == this.buffer.length) {
                    this.fill();
                }
                total += this.consumeBytes(b, off + total, len - total);
            }
            if (total == 0 && this.eof) {
                return -1;
            }
            return total;
        }

        public String getName() {
            return this.name;
        }
    }

    private static enum State {
        HEADER,
        CONTENT,
        FOOTER,
        DONE;

    }

    private static class PemFooterMatcher
    extends PemLineMatcher {
        private final String name;

        public PemFooterMatcher(String line, String name) {
            super(line, "END");
            this.name = name;
        }

        @Override
        public boolean match() throws IOException {
            boolean match = super.match();
            return match && this.name.equals(this.getName());
        }
    }

    private static class PemHeaderMatcher
    extends PemLineMatcher {
        public PemHeaderMatcher(String line) {
            super(line, "BEGIN");
        }
    }

    private static abstract class PemLineMatcher {
        private final Pattern pattern;
        private final String line;
        private String name;

        public PemLineMatcher(String line, String beginOrEnd) {
            this.pattern = Pattern.compile("^-----" + beginOrEnd + " (\\w(\\w|\\s)*)-----$");
            this.line = line;
        }

        public boolean match() throws IOException {
            Matcher m = this.pattern.matcher(this.line);
            if (m.matches()) {
                this.name = m.group(1);
                return this.name != null;
            }
            return false;
        }

        public String getName() {
            return this.name;
        }
    }
}

