/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcodings.Encoding;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyClassPathVariable;
import org.jruby.RubyException;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyUnboundMethod;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.java.addons.ArrayJavaAddons;
import org.jruby.java.addons.IOJavaAddons;
import org.jruby.java.addons.KernelJavaAddons;
import org.jruby.java.addons.StringJavaAddons;
import org.jruby.java.codegen.RealClassGenerator;
import org.jruby.java.dispatch.CallableSelector;
import org.jruby.java.invokers.InstanceMethodInvoker;
import org.jruby.java.invokers.MethodInvoker;
import org.jruby.java.invokers.StaticMethodInvoker;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.java.proxies.ArrayJavaProxyCreator;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.java.proxies.InterfaceJavaProxy;
import org.jruby.java.proxies.JavaInterfaceTemplate;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.java.proxies.MapJavaProxy;
import org.jruby.java.proxies.RubyObjectHolderProxy;
import org.jruby.java.util.BlankSlateWrapper;
import org.jruby.java.util.SystemPropertiesMap;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaArrayUtilities;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaField;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaProxyMethods;
import org.jruby.javasupport.JavaSupport;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.JavaUtilities;
import org.jruby.javasupport.ParameterTypes;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyClassFactory;
import org.jruby.javasupport.proxy.JavaProxyConstructor;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.ByteList;
import org.jruby.util.ClassCache;
import org.jruby.util.ClassProvider;
import org.jruby.util.CodegenUtils;
import org.jruby.util.IdUtil;
import org.jruby.util.cli.Options;

@JRubyModule(name={"Java"})
public class Java
implements Library {
    public static final boolean NEW_STYLE_EXTENSION;
    public static final boolean OBJECT_PROXY_CACHE;
    private static final ClassProvider JAVA_PACKAGE_CLASS_PROVIDER;
    private static final Map<String, Boolean> JAVA_PRIMITIVES;
    private static final Pattern CAMEL_CASE_PACKAGE_SPLITTER;

    @Override
    public void load(Ruby runtime, boolean wrap2) throws IOException {
        Java.createJavaModule(runtime);
        RubyModule jpmt = runtime.defineModule("JavaPackageModuleTemplate");
        jpmt.getSingletonClass().setSuperClass(new BlankSlateWrapper(runtime, jpmt.getMetaClass().getSuperClass(), runtime.getKernel()));
        runtime.getLoadService().require("jruby/java");
        RubyClass ajp = runtime.getClass("ArrayJavaProxy");
        ajp.setSuperClass(runtime.getJavaSupport().getObjectJavaClass().getProxyClass());
        ajp.includeModule(runtime.getEnumerable());
        RubyClassPathVariable.createClassPathVariable(runtime);
        runtime.setJavaProxyClassFactory(JavaProxyClassFactory.createFactory());
        SystemPropertiesMap systemProps = new SystemPropertiesMap();
        runtime.getObject().setConstantQuiet("ENV_JAVA", new MapJavaProxy(runtime, (RubyClass)Java.getProxyClass(runtime, SystemPropertiesMap.class), systemProps));
    }

    public static RubyModule createJavaModule(Ruby runtime) {
        ThreadContext context = runtime.getCurrentContext();
        RubyModule javaModule = runtime.defineModule("Java");
        javaModule.defineAnnotatedMethods(Java.class);
        JavaObject.createJavaObjectClass(runtime, javaModule);
        JavaArray.createJavaArrayClass(runtime, javaModule);
        JavaClass.createJavaClassClass(runtime, javaModule);
        JavaMethod.createJavaMethodClass(runtime, javaModule);
        JavaConstructor.createJavaConstructorClass(runtime, javaModule);
        JavaField.createJavaFieldClass(runtime, javaModule);
        JavaProxyMethods.createJavaProxyMethods(context);
        JavaProxy.createJavaProxy(context);
        ArrayJavaProxyCreator.createArrayJavaProxyCreator(context);
        ConcreteJavaProxy.createConcreteJavaProxy(context);
        InterfaceJavaProxy.createInterfaceJavaProxy(context);
        ArrayJavaProxy.createArrayJavaProxy(context);
        MapJavaProxy.createMapJavaProxy(context);
        JavaProxyClass.createJavaProxyModule(runtime);
        JavaInterfaceTemplate.createJavaInterfaceTemplateModule(context);
        RubyModule javaUtils = runtime.defineModule("JavaUtilities");
        javaUtils.defineAnnotatedMethods(JavaUtilities.class);
        JavaArrayUtilities.createJavaArrayUtilitiesModule(runtime);
        runtime.getArray().defineAnnotatedMethods(ArrayJavaAddons.class);
        runtime.getKernel().defineAnnotatedMethods(KernelJavaAddons.class);
        runtime.getString().defineAnnotatedMethods(StringJavaAddons.class);
        runtime.getIO().defineAnnotatedMethods(IOJavaAddons.class);
        if (runtime.getObject().isConstantDefined("StringIO")) {
            ((RubyClass)runtime.getObject().getConstant("StringIO")).defineAnnotatedMethods(IOJavaAddons.AnyIO.class);
        }
        Java.addNameClassMappings(runtime, runtime.getJavaSupport().getNameClassMap());
        runtime.getJavaSupport().setObjectJavaClass(JavaClass.get(runtime, Object.class));
        return javaModule;
    }

    private static void addNameClassMappings(Ruby runtime, Map<String, JavaClass> nameClassMap) {
        JavaClass booleanPrimClass = JavaClass.get(runtime, Boolean.TYPE);
        JavaClass booleanClass = JavaClass.get(runtime, Boolean.class);
        nameClassMap.put("boolean", booleanPrimClass);
        nameClassMap.put("Boolean", booleanClass);
        nameClassMap.put("java.lang.Boolean", booleanClass);
        JavaClass bytePrimClass = JavaClass.get(runtime, Byte.TYPE);
        JavaClass byteClass = JavaClass.get(runtime, Byte.class);
        nameClassMap.put("byte", bytePrimClass);
        nameClassMap.put("Byte", byteClass);
        nameClassMap.put("java.lang.Byte", byteClass);
        JavaClass shortPrimClass = JavaClass.get(runtime, Short.TYPE);
        JavaClass shortClass = JavaClass.get(runtime, Short.class);
        nameClassMap.put("short", shortPrimClass);
        nameClassMap.put("Short", shortClass);
        nameClassMap.put("java.lang.Short", shortClass);
        JavaClass charPrimClass = JavaClass.get(runtime, Character.TYPE);
        JavaClass charClass = JavaClass.get(runtime, Character.class);
        nameClassMap.put("char", charPrimClass);
        nameClassMap.put("Character", charClass);
        nameClassMap.put("Char", charClass);
        nameClassMap.put("java.lang.Character", charClass);
        JavaClass intPrimClass = JavaClass.get(runtime, Integer.TYPE);
        JavaClass intClass = JavaClass.get(runtime, Integer.class);
        nameClassMap.put("int", intPrimClass);
        nameClassMap.put("Integer", intClass);
        nameClassMap.put("Int", intClass);
        nameClassMap.put("java.lang.Integer", intClass);
        JavaClass longPrimClass = JavaClass.get(runtime, Long.TYPE);
        JavaClass longClass = JavaClass.get(runtime, Long.class);
        nameClassMap.put("long", longPrimClass);
        nameClassMap.put("Long", longClass);
        nameClassMap.put("java.lang.Long", longClass);
        JavaClass floatPrimClass = JavaClass.get(runtime, Float.TYPE);
        JavaClass floatClass = JavaClass.get(runtime, Float.class);
        nameClassMap.put("float", floatPrimClass);
        nameClassMap.put("Float", floatClass);
        nameClassMap.put("java.lang.Float", floatClass);
        JavaClass doublePrimClass = JavaClass.get(runtime, Double.TYPE);
        JavaClass doubleClass = JavaClass.get(runtime, Double.class);
        nameClassMap.put("double", doublePrimClass);
        nameClassMap.put("Double", doubleClass);
        nameClassMap.put("java.lang.Double", doubleClass);
        JavaClass bigintClass = JavaClass.get(runtime, BigInteger.class);
        nameClassMap.put("big_int", bigintClass);
        nameClassMap.put("big_integer", bigintClass);
        nameClassMap.put("BigInteger", bigintClass);
        nameClassMap.put("java.math.BigInteger", bigintClass);
        JavaClass bigdecimalClass = JavaClass.get(runtime, BigDecimal.class);
        nameClassMap.put("big_decimal", bigdecimalClass);
        nameClassMap.put("BigDecimal", bigdecimalClass);
        nameClassMap.put("java.math.BigDecimal", bigdecimalClass);
        JavaClass objectClass = JavaClass.get(runtime, Object.class);
        nameClassMap.put("object", objectClass);
        nameClassMap.put("Object", objectClass);
        nameClassMap.put("java.lang.Object", objectClass);
        JavaClass stringClass = JavaClass.get(runtime, String.class);
        nameClassMap.put("string", stringClass);
        nameClassMap.put("String", stringClass);
        nameClassMap.put("java.lang.String", stringClass);
    }

    public static IRubyObject create_proxy_class(IRubyObject recv2, IRubyObject constant, IRubyObject javaClass, IRubyObject module) {
        Ruby runtime = recv2.getRuntime();
        if (!(module instanceof RubyModule)) {
            throw runtime.newTypeError(module, runtime.getModule());
        }
        IRubyObject proxyClass = Java.get_proxy_class(recv2, javaClass);
        RubyModule m = (RubyModule)module;
        String constName = constant.asJavaString();
        IRubyObject existing = m.getConstantNoConstMissing(constName);
        if (existing != null && existing != RubyBasicObject.UNDEF && existing != proxyClass) {
            runtime.getWarnings().warn("replacing " + existing + " with " + proxyClass + " in constant '" + constName + " on class/module " + m);
        }
        return ((RubyModule)module).setConstantQuiet(constant.asJavaString(), Java.get_proxy_class(recv2, javaClass));
    }

    public static IRubyObject get_java_class(IRubyObject recv2, IRubyObject name2) {
        try {
            return JavaClass.for_name(recv2, name2);
        }
        catch (Exception e) {
            recv2.getRuntime().getJavaSupport().handleNativeException(e, null);
            return recv2.getRuntime().getNil();
        }
    }

    public static IRubyObject getInstance(Ruby runtime, Object rawJavaObject) {
        return Java.getInstance(runtime, rawJavaObject, false);
    }

    public static IRubyObject getInstance(Ruby runtime, Object rawJavaObject, boolean forceCache) {
        if (rawJavaObject != null) {
            RubyClass proxyClass = (RubyClass)Java.getProxyClass(runtime, rawJavaObject.getClass());
            if (OBJECT_PROXY_CACHE || forceCache || proxyClass.getCacheProxy()) {
                return runtime.getJavaSupport().getObjectProxyCache().getOrCreate(rawJavaObject, proxyClass);
            }
            return Java.allocateProxy(rawJavaObject, proxyClass);
        }
        return runtime.getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubyModule getInterfaceModule(Ruby runtime, JavaClass javaClass) {
        if (!javaClass.javaClass().isInterface()) {
            throw runtime.newArgumentError(javaClass.toString() + " is not an interface");
        }
        RubyModule interfaceModule = javaClass.getProxyModule();
        if (interfaceModule != null) {
            return interfaceModule;
        }
        javaClass.lockProxy();
        try {
            interfaceModule = javaClass.getProxyModule();
            if (interfaceModule == null) {
                interfaceModule = (RubyModule)runtime.getJavaSupport().getJavaInterfaceTemplate().dup();
                interfaceModule.setInstanceVariable("@java_class", javaClass);
                javaClass.setupInterfaceModule(interfaceModule);
                Class<?>[] extended2 = javaClass.javaClass().getInterfaces();
                int i2 = extended2.length;
                while (--i2 >= 0) {
                    JavaClass extendedClass = JavaClass.get(runtime, extended2[i2]);
                    RubyModule extModule = Java.getInterfaceModule(runtime, extendedClass);
                    interfaceModule.includeModule(extModule);
                }
                Java.addToJavaPackageModule(interfaceModule, javaClass);
            }
        }
        finally {
            javaClass.unlockProxy();
        }
        return interfaceModule;
    }

    public static IRubyObject get_interface_module(Ruby runtime, IRubyObject javaClassObject) {
        JavaClass javaClass;
        if (javaClassObject instanceof RubyString) {
            javaClass = JavaClass.forNameVerbose(runtime, javaClassObject.asJavaString());
        } else if (javaClassObject instanceof JavaClass) {
            javaClass = (JavaClass)javaClassObject;
        } else {
            throw runtime.newArgumentError("expected JavaClass, got " + javaClassObject);
        }
        return Java.getInterfaceModule(runtime, javaClass);
    }

    public static RubyClass getProxyClassForObject(Ruby runtime, Object object) {
        return (RubyClass)Java.getProxyClass(runtime, object.getClass());
    }

    public static RubyModule getProxyClass(Ruby runtime, JavaClass javaClass) {
        return Java.getProxyClass(runtime, javaClass.javaClass());
    }

    public static RubyModule getProxyClass(Ruby runtime, Class c) {
        return runtime.getJavaSupport().getProxyClassFromCache(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubyModule createProxyClassForClass(Ruby runtime, final Class c) {
        RubyClass proxyClass;
        JavaClass javaClass = runtime.getJavaSupport().getJavaClassFromCache(c);
        if (c.isInterface()) {
            return Java.getInterfaceModule(runtime, javaClass);
        }
        javaClass.lockProxy();
        try {
            proxyClass = javaClass.getProxyClass();
            if (proxyClass == null) {
                if (c.isArray()) {
                    proxyClass = Java.createProxyClass(runtime, runtime.getJavaSupport().getArrayProxyClass(), javaClass, true);
                    if (c.getComponentType() == Byte.TYPE) {
                        final Encoding ascii8bit = runtime.getEncodingService().getAscii8bitEncoding();
                        proxyClass.addMethod("to_s", new JavaMethod.JavaMethodZero((RubyModule)proxyClass, Visibility.PUBLIC){

                            @Override
                            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
                                ByteList bytes2 = new ByteList((byte[])((ArrayJavaProxy)self2).getObject(), ascii8bit);
                                return RubyString.newStringLight(context.runtime, bytes2);
                            }
                        });
                    }
                } else if (c.isPrimitive()) {
                    proxyClass = Java.createProxyClass(runtime, runtime.getJavaSupport().getConcreteProxyClass(), javaClass, true);
                } else if (c == Object.class) {
                    proxyClass = Java.createProxyClass(runtime, runtime.getJavaSupport().getConcreteProxyClass(), javaClass, true);
                    if (NEW_STYLE_EXTENSION) {
                        proxyClass.getMetaClass().defineAnnotatedMethods(NewStyleExtensionInherited.class);
                    } else {
                        proxyClass.getMetaClass().defineAnnotatedMethods(OldStyleExtensionInherited.class);
                    }
                    Java.addToJavaPackageModule(proxyClass, javaClass);
                } else {
                    proxyClass = Java.createProxyClass(runtime, (RubyClass)Java.getProxyClass(runtime, c.getSuperclass()), javaClass, false);
                    Class<?>[] interfaces2 = c.getInterfaces();
                    int i2 = interfaces2.length;
                    while (--i2 >= 0) {
                        JavaClass ifc = JavaClass.get(runtime, interfaces2[i2]);
                        proxyClass.includeModule(Java.getInterfaceModule(runtime, ifc));
                    }
                    if (Modifier.isPublic(c.getModifiers())) {
                        Java.addToJavaPackageModule(proxyClass, javaClass);
                    }
                }
                if (Modifier.isFinal(c.getModifiers())) {
                    proxyClass.getMetaClass().addMethod("inherited", new org.jruby.internal.runtime.methods.JavaMethod((RubyModule)proxyClass, Visibility.PUBLIC){

                        @Override
                        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                            throw context.runtime.newTypeError("can not extend final Java class: " + c.getCanonicalName());
                        }
                    });
                }
            }
        }
        finally {
            javaClass.unlockProxy();
        }
        return proxyClass;
    }

    public static IRubyObject get_proxy_class(IRubyObject recv2, IRubyObject java_class_object) {
        JavaClass javaClass;
        Ruby runtime = recv2.getRuntime();
        if (java_class_object instanceof RubyString) {
            javaClass = JavaClass.for_name(recv2, java_class_object);
        } else if (java_class_object instanceof JavaClass) {
            javaClass = (JavaClass)java_class_object;
        } else {
            throw runtime.newTypeError(java_class_object, runtime.getJavaSupport().getJavaClassClass());
        }
        return Java.getProxyClass(runtime, javaClass);
    }

    private static RubyClass createProxyClass(Ruby runtime, RubyClass baseType, JavaClass javaClass, boolean invokeInherited) {
        RubyClass proxyClass = javaClass.getProxyClass();
        if (proxyClass != null) {
            return proxyClass;
        }
        RubyClass.checkInheritable(baseType);
        RubyClass superClass = baseType;
        proxyClass = RubyClass.newClass(runtime, superClass);
        proxyClass.makeMetaClass(superClass.getMetaClass());
        try {
            javaClass.javaClass().asSubclass(Map.class);
            proxyClass.setAllocator(runtime.getJavaSupport().getMapJavaProxyClass().getAllocator());
            proxyClass.defineAnnotatedMethods(MapJavaProxy.class);
            proxyClass.includeModule(runtime.getEnumerable());
        }
        catch (ClassCastException e) {
            proxyClass.setAllocator(superClass.getAllocator());
        }
        if (invokeInherited) {
            proxyClass.inherit(superClass);
        }
        proxyClass.callMethod(runtime.getCurrentContext(), "java_class=", (IRubyObject)javaClass);
        javaClass.setupProxy(proxyClass);
        proxyClass.defineAnnotatedMethods(JavaProxyClassMethods.class);
        return proxyClass;
    }

    private static IRubyObject getRubyMethod(ThreadContext context, IRubyObject proxyClass, String name2, Class ... argTypesClasses) {
        Ruby runtime = context.runtime;
        if (!(proxyClass instanceof RubyClass)) {
            throw runtime.newTypeError(proxyClass, runtime.getModule());
        }
        RubyClass rubyClass = (RubyClass)proxyClass;
        Method jmethod = Java.getMethodFromClass(runtime, proxyClass, name2, argTypesClasses);
        String prettyName = name2 + CodegenUtils.prettyParams(argTypesClasses);
        if (Modifier.isStatic(jmethod.getModifiers())) {
            StaticMethodInvoker invoker = new StaticMethodInvoker(rubyClass, jmethod);
            return RubyMethod.newMethod(rubyClass, prettyName, rubyClass, name2, invoker, proxyClass);
        }
        InstanceMethodInvoker invoker = new InstanceMethodInvoker((RubyModule)rubyClass, jmethod);
        return RubyUnboundMethod.newUnboundMethod(rubyClass, prettyName, rubyClass, name2, invoker);
    }

    public static Method getMethodFromClass(Ruby runtime, IRubyObject proxyClass, String name2, Class ... argTypes) {
        Class jclass = (Class)((JavaClass)proxyClass.callMethod(runtime.getCurrentContext(), "java_class")).getValue();
        try {
            return jclass.getMethod(name2, argTypes);
        }
        catch (NoSuchMethodException nsme) {
            String prettyName = name2 + CodegenUtils.prettyParams(argTypes);
            String errorName = jclass.getName() + "." + prettyName;
            throw runtime.newNameError("Java method not found: " + errorName, name2);
        }
    }

    private static MethodInvoker getMethodInvokerForMethod(RubyClass metaClass, Method method2) {
        if (Modifier.isStatic(method2.getModifiers())) {
            return new StaticMethodInvoker(metaClass.getMetaClass(), method2);
        }
        return new InstanceMethodInvoker((RubyModule)metaClass, method2);
    }

    public static IRubyObject concrete_proxy_inherited(IRubyObject recv2, IRubyObject subclass) {
        Ruby runtime = recv2.getRuntime();
        ThreadContext tc = runtime.getCurrentContext();
        JavaSupport javaSupport = runtime.getJavaSupport();
        RubyClass javaProxyClass = javaSupport.getJavaProxyClass().getMetaClass();
        Helpers.invokeAs(tc, javaProxyClass, recv2, "inherited", subclass, Block.NULL_BLOCK);
        return Java.setupJavaSubclass(tc, subclass, recv2.callMethod(tc, "java_class"));
    }

    private static IRubyObject setupJavaSubclass(ThreadContext context, IRubyObject subclass, IRubyObject java_class2) {
        final Ruby runtime = context.runtime;
        if (!(subclass instanceof RubyClass)) {
            throw runtime.newTypeError(subclass, runtime.getClassClass());
        }
        RubyClass rubySubclass = (RubyClass)subclass;
        rubySubclass.getInstanceVariables().setInstanceVariable("@java_proxy_class", runtime.getNil());
        rubySubclass.setCacheProxy(true);
        RubyClass subclassSingleton = rubySubclass.getSingletonClass();
        subclassSingleton.addReadWriteAttribute(context, "java_proxy_class");
        subclassSingleton.addMethod("java_interfaces", new JavaMethod.JavaMethodZero(subclassSingleton, Visibility.PUBLIC){

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
                IRubyObject javaInterfaces = self2.getInstanceVariables().getInstanceVariable("@java_interfaces");
                if (javaInterfaces != null) {
                    return javaInterfaces.dup();
                }
                return context.runtime.getNil();
            }
        });
        rubySubclass.addMethod("__jcreate!", new JavaMethod.JavaMethodN((RubyModule)subclassSingleton, Visibility.PUBLIC){
            private final Map<Integer, ParameterTypes> methodCache;
            {
                super(x0, x1);
                this.methodCache = new HashMap<Integer, ParameterTypes>();
            }

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2) {
                IRubyObject proxyClass = self2.getMetaClass().getInstanceVariables().getInstanceVariable("@java_proxy_class");
                if (proxyClass == null || proxyClass.isNil()) {
                    proxyClass = JavaProxyClass.get_with_class(self2, self2.getMetaClass());
                    self2.getMetaClass().getInstanceVariables().setInstanceVariable("@java_proxy_class", proxyClass);
                }
                JavaProxyClass realProxyClass = (JavaProxyClass)proxyClass;
                RubyArray constructors2 = realProxyClass.constructors();
                ArrayList<JavaProxyConstructor> forArity = new ArrayList<JavaProxyConstructor>();
                for (int i2 = 0; i2 < constructors2.size(); ++i2) {
                    JavaProxyConstructor constructor2 = (JavaProxyConstructor)constructors2.eltInternal(i2);
                    if (constructor2.getParameterTypes().length != args2.length) continue;
                    forArity.add(constructor2);
                }
                if (forArity.size() == 0) {
                    throw runtime.newArgumentError("wrong number of arguments for constructor");
                }
                JavaProxyConstructor matching = (JavaProxyConstructor)CallableSelector.matchingCallableArityN(runtime, this.methodCache, forArity.toArray(new JavaProxyConstructor[forArity.size()]), args2, args2.length);
                if (matching == null) {
                    throw runtime.newArgumentError("wrong number of arguments for constructor");
                }
                Object[] newArgs = new Object[args2.length];
                Class<?>[] parameterTypes = matching.getParameterTypes();
                for (int i3 = 0; i3 < args2.length; ++i3) {
                    newArgs[i3] = args2[i3].toJava(parameterTypes[i3]);
                }
                JavaObject newObject2 = matching.newInstance(self2, newArgs);
                return JavaUtilities.set_java_object(self2, self2, newObject2);
            }
        });
        return runtime.getNil();
    }

    private static void addToJavaPackageModule(RubyModule proxyClass, JavaClass javaClass) {
        String className;
        RubyModule parentModule;
        Ruby runtime = proxyClass.getRuntime();
        Class clazz = javaClass.javaClass();
        String fullName = clazz.getName();
        if (fullName == null) {
            return;
        }
        int endPackage = fullName.lastIndexOf(46);
        if (fullName.indexOf(36) != -1) {
            IRubyObject declClass = javaClass.declaring_class();
            if (declClass.isNil()) {
                return;
            }
            parentModule = Java.getProxyClass(runtime, (JavaClass)declClass);
            className = clazz.getSimpleName();
        } else {
            String packageString = endPackage < 0 ? "" : fullName.substring(0, endPackage);
            parentModule = Java.getJavaPackageModule(runtime, packageString);
            String string2 = className = parentModule == null ? fullName : fullName.substring(endPackage + 1);
        }
        if (parentModule != null && IdUtil.isConstant(className) && parentModule.getConstantAt(className) == null) {
            parentModule.setConstant(className, proxyClass);
        }
    }

    public static RubyModule getJavaPackageModule(Ruby runtime, Package pkg) {
        return pkg == null ? Java.getJavaPackageModule(runtime, "") : Java.getJavaPackageModule(runtime, pkg.getName());
    }

    private static RubyModule getJavaPackageModule(Ruby runtime, String packageString) {
        String packageName;
        int length2 = packageString.length();
        if (length2 == 0) {
            packageName = "Default";
        } else {
            StringBuilder buf = new StringBuilder();
            int start2 = 0;
            int offset2 = 0;
            while (start2 < length2) {
                offset2 = packageString.indexOf(46, start2);
                if (offset2 == -1) {
                    offset2 = length2;
                }
                buf.append(Character.toUpperCase(packageString.charAt(start2))).append(packageString.substring(start2 + 1, offset2));
                start2 = offset2 + 1;
            }
            packageName = buf.toString();
        }
        RubyModule javaModule = runtime.getJavaSupport().getJavaModule();
        IRubyObject packageModule = javaModule.getConstantAt(packageName);
        if (packageModule == null) {
            return Java.createPackageModule(javaModule, packageName, packageString);
        }
        if (packageModule instanceof RubyModule) {
            return (RubyModule)packageModule;
        }
        return null;
    }

    private static RubyModule createPackageModule(RubyModule parent, String name2, String packageString) {
        Ruby runtime = parent.getRuntime();
        RubyModule packageModule = (RubyModule)runtime.getJavaSupport().getPackageModuleTemplate().dup();
        packageModule.setInstanceVariable("@package_name", runtime.newString(packageString.length() > 0 ? packageString + '.' : packageString));
        packageModule.addClassProvider(JAVA_PACKAGE_CLASS_PROVIDER);
        parent.const_set(runtime.newSymbol(name2), packageModule);
        MetaClass metaClass = (MetaClass)packageModule.getMetaClass();
        metaClass.setAttached(packageModule);
        return packageModule;
    }

    private static RubyModule getPackageModule(Ruby runtime, String name2) {
        String packageName;
        RubyModule javaModule = runtime.getJavaSupport().getJavaModule();
        IRubyObject value2 = javaModule.getConstantAt(name2);
        if (value2 instanceof RubyModule) {
            return (RubyModule)value2;
        }
        if ("Default".equals(name2)) {
            packageName = "";
        } else {
            Matcher m = CAMEL_CASE_PACKAGE_SPLITTER.matcher(name2);
            packageName = m.replaceAll("$1.$2").toLowerCase();
        }
        return Java.createPackageModule(javaModule, name2, packageName);
    }

    public static IRubyObject get_package_module(IRubyObject recv2, IRubyObject symObject) {
        return Java.getPackageModule(recv2.getRuntime(), symObject.asJavaString());
    }

    public static IRubyObject get_package_module_dot_format(IRubyObject recv2, IRubyObject dottedName) {
        Ruby runtime = recv2.getRuntime();
        RubyModule module = Java.getJavaPackageModule(runtime, dottedName.asJavaString());
        return module == null ? runtime.getNil() : module;
    }

    private static RubyModule getProxyOrPackageUnderPackage(ThreadContext context, Ruby runtime, RubyModule parentPackage, String sym) {
        IRubyObject packageNameObj = parentPackage.getInstanceVariable("@package_name");
        if (packageNameObj == null) {
            throw runtime.newArgumentError("invalid package module");
        }
        String packageName = packageNameObj.asJavaString();
        String name2 = sym.trim().intern();
        if (name2.length() == 0) {
            throw runtime.newArgumentError("empty class or package name");
        }
        String fullName = packageName + name2;
        if (!Character.isUpperCase(name2.charAt(0))) {
            if (JAVA_PRIMITIVES.containsKey(name2)) {
                throw runtime.newArgumentError("illegal package name component: " + name2);
            }
            IRubyObject previousErrorInfo = Helpers.getErrorInfo(runtime);
            try {
                return Java.getProxyClass(runtime, runtime.getJavaSupport().loadJavaClassQuiet(fullName));
            }
            catch (RaiseException re) {
                RubyException rubyEx = re.getException();
                if (rubyEx.kind_of_p(context, runtime.getStandardError()).isTrue()) {
                    Helpers.setErrorInfo(runtime, previousErrorInfo);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            RubyModule packageModule = Java.getJavaPackageModule(runtime, fullName);
            if (packageModule == null) {
                return null;
            }
            Java.memoizePackageOrClass(parentPackage, name2, packageModule);
            return packageModule;
        }
        try {
            RubyModule javaModule = Java.getProxyClass(runtime, JavaClass.forNameVerbose(runtime, fullName));
            Java.memoizePackageOrClass(parentPackage, name2, javaModule);
            return javaModule;
        }
        catch (Exception e) {
            if (runtime.getInstanceConfig().getAllowUppercasePackageNames()) {
                return Java.getJavaPackageModule(runtime, fullName);
            }
            throw runtime.newNameError("missing class or uppercase package name (`" + fullName + "'), caused by " + e.getMessage(), fullName);
        }
    }

    public static IRubyObject get_proxy_or_package_under_package(ThreadContext context, IRubyObject recv2, IRubyObject parentPackage, IRubyObject sym) {
        Ruby runtime = recv2.getRuntime();
        if (!(parentPackage instanceof RubyModule)) {
            throw runtime.newTypeError(parentPackage, runtime.getModule());
        }
        RubyModule result2 = Java.getProxyOrPackageUnderPackage(context, runtime, (RubyModule)parentPackage, sym.asJavaString());
        if (result2 != null) {
            return result2;
        }
        return runtime.getNil();
    }

    private static RubyModule getTopLevelProxyOrPackage(ThreadContext context, Ruby runtime, String sym) {
        String name2 = sym.trim().intern();
        if (name2.length() == 0) {
            throw runtime.newArgumentError("empty class or package name");
        }
        if (Character.isLowerCase(name2.charAt(0))) {
            try {
                return Java.getProxyClass(runtime, runtime.getJavaSupport().loadJavaClassQuiet(name2));
            }
            catch (RaiseException re) {
                RubyException rubyEx = re.getException();
                if (rubyEx.kind_of_p(context, runtime.getStandardError()).isTrue()) {
                    Helpers.setErrorInfo(runtime, runtime.getNil());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            RubyModule packageModule = Java.getJavaPackageModule(runtime, name2);
            if (packageModule == null) {
                return null;
            }
            RubyModule javaModule = runtime.getJavaSupport().getJavaModule();
            if (javaModule.getMetaClass().isMethodBound(name2, false)) {
                return packageModule;
            }
            Java.memoizePackageOrClass(javaModule, name2, packageModule);
            return packageModule;
        }
        RubyModule javaModule = null;
        try {
            Class cls = runtime.getJavaSupport().loadJavaClass(name2);
            javaModule = Java.getProxyClass(runtime, JavaClass.get(runtime, cls));
        }
        catch (ExceptionInInitializerError eiie) {
            throw runtime.newNameError("cannot initialize Java class " + name2, name2, eiie, false);
        }
        catch (LinkageError le) {
            throw runtime.newNameError("cannot link Java class " + name2, name2, le, false);
        }
        catch (SecurityException se) {
            throw runtime.newSecurityError(se.getLocalizedMessage());
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (javaModule == null) {
            javaModule = Java.getPackageModule(runtime, name2);
        }
        Java.memoizePackageOrClass(runtime.getJavaSupport().getJavaModule(), name2, javaModule);
        return javaModule;
    }

    private static void memoizePackageOrClass(final RubyModule parentPackage, String name2, final IRubyObject value2) {
        RubyClass singleton = parentPackage.getSingletonClass();
        singleton.addMethod(name2, new org.jruby.internal.runtime.methods.JavaMethod((RubyModule)singleton, Visibility.PUBLIC){

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                if (args2.length != 0) {
                    throw context.runtime.newArgumentError("Java package `" + parentPackage.callMethod("package_name") + "' does not have a method `" + name2 + "'");
                }
                return this.call(context, self2, clazz, name2);
            }

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
                return value2;
            }

            @Override
            public Arity getArity() {
                return Arity.noArguments();
            }
        });
    }

    public static IRubyObject get_top_level_proxy_or_package(ThreadContext context, IRubyObject recv2, IRubyObject sym) {
        Ruby runtime = context.runtime;
        RubyModule result2 = Java.getTopLevelProxyOrPackage(context, runtime, sym.asJavaString());
        return result2 != null ? result2 : runtime.getNil();
    }

    public static IRubyObject wrap(Ruby runtime, IRubyObject java_object2) {
        return Java.getInstance(runtime, ((JavaObject)java_object2).getValue());
    }

    @Deprecated
    @JRubyMethod(frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject java_to_ruby(IRubyObject recv2, IRubyObject object, Block unusedBlock) {
        try {
            return JavaUtil.java_to_ruby(recv2.getRuntime(), object);
        }
        catch (RuntimeException e) {
            recv2.getRuntime().getJavaSupport().handleNativeException(e, null);
            return recv2.getRuntime().getNil();
        }
    }

    @Deprecated
    @JRubyMethod(frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject ruby_to_java(IRubyObject recv2, IRubyObject object, Block unusedBlock) {
        return JavaUtil.ruby_to_java(recv2, object, unusedBlock);
    }

    @Deprecated
    @JRubyMethod(frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject java_to_primitive(IRubyObject recv2, IRubyObject object, Block unusedBlock) {
        return JavaUtil.java_to_primitive(recv2, object, unusedBlock);
    }

    @JRubyMethod(required=2, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_proxy_instance2(IRubyObject recv2, IRubyObject wrapper, IRubyObject ifcs, Block block) {
        IRubyObject[] javaClasses = ((RubyArray)ifcs).toJavaArray();
        Class[] interfaces2 = new Class[javaClasses.length];
        for (int i2 = 0; i2 < javaClasses.length; ++i2) {
            if (!(javaClasses[i2] instanceof JavaClass) || !((JavaClass)javaClasses[i2]).interface_p().isTrue()) {
                throw recv2.getRuntime().newArgumentError("Java interface expected. got: " + javaClasses[i2]);
            }
            interfaces2[i2] = ((JavaClass)javaClasses[i2]).javaClass();
        }
        return Java.newInterfaceImpl(wrapper, interfaces2);
    }

    public static IRubyObject newInterfaceImpl(final IRubyObject wrapper, Class[] interfaces2) {
        final Ruby runtime = wrapper.getRuntime();
        Class[] tmp_interfaces = interfaces2;
        interfaces2 = new Class[tmp_interfaces.length + 1];
        System.arraycopy(tmp_interfaces, 0, interfaces2, 0, tmp_interfaces.length);
        interfaces2[tmp_interfaces.length] = RubyObjectHolderProxy.class;
        if (!RubyInstanceConfig.INTERFACES_USE_PROXY) {
            Class proxyImplClass;
            ClassLoader classLoader;
            int interfacesHashCode = Java.interfacesHashCode(interfaces2);
            if (wrapper.getMetaClass().isSingleton() && wrapper.getMetaClass().getRealClass() == runtime.getProc()) {
                interfacesHashCode = 31 * interfacesHashCode + runtime.getProc().hashCode();
                classLoader = runtime.getJRubyClassLoader();
            } else {
                interfacesHashCode = 31 * interfacesHashCode + wrapper.getMetaClass().getRealClass().hashCode();
                classLoader = new ClassCache.OneShotClassLoader(runtime.getJRubyClassLoader());
            }
            String implClassName = "org.jruby.gen.InterfaceImpl" + Math.abs(interfacesHashCode);
            try {
                proxyImplClass = Class.forName(implClassName, true, runtime.getJRubyClassLoader());
            }
            catch (ClassNotFoundException cnfe) {
                proxyImplClass = RealClassGenerator.createOldStyleImplClass(interfaces2, wrapper.getMetaClass(), runtime, implClassName, classLoader);
            }
            try {
                Constructor proxyConstructor = proxyImplClass.getConstructor(IRubyObject.class);
                return JavaObject.wrap(runtime, proxyConstructor.newInstance(wrapper));
            }
            catch (NoSuchMethodException nsme) {
                throw runtime.newTypeError("Exception instantiating generated interface impl:\n" + nsme);
            }
            catch (InvocationTargetException ite) {
                throw runtime.newTypeError("Exception instantiating generated interface impl:\n" + ite);
            }
            catch (InstantiationException ie) {
                throw runtime.newTypeError("Exception instantiating generated interface impl:\n" + ie);
            }
            catch (IllegalAccessException iae) {
                throw runtime.newTypeError("Exception instantiating generated interface impl:\n" + iae);
            }
        }
        Object proxyObject = Proxy.newProxyInstance(runtime.getJRubyClassLoader(), interfaces2, new InvocationHandler(){
            private Map parameterTypeCache = new ConcurrentHashMap();

            @Override
            public Object invoke(Object proxy2, Method method2, Object[] nargs) throws Throwable {
                int length2;
                String methodName = method2.getName();
                int n = length2 = nargs == null ? 0 : nargs.length;
                if (methodName.equals("toString") && length2 == 0) {
                    return proxy2.getClass().getName();
                }
                if (methodName.equals("hashCode") && length2 == 0) {
                    return proxy2.getClass().hashCode();
                }
                if (methodName.equals("equals") && length2 == 1) {
                    Class[] parameterTypes = (Class[])this.parameterTypeCache.get(method2);
                    if (parameterTypes == null) {
                        parameterTypes = method2.getParameterTypes();
                        this.parameterTypeCache.put(method2, parameterTypes);
                    }
                    if (parameterTypes[0].equals(Object.class)) {
                        return proxy2 == nargs[0];
                    }
                } else if (methodName == "__ruby_object" && length2 == 0) {
                    return wrapper;
                }
                IRubyObject[] rubyArgs = JavaUtil.convertJavaArrayToRuby(runtime, nargs);
                try {
                    return Helpers.invoke(runtime.getCurrentContext(), wrapper, methodName, rubyArgs).toJava(method2.getReturnType());
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        });
        return JavaObject.wrap(runtime, proxyObject);
    }

    public static Class generateRealClass(RubyClass clazz) {
        Class proxyImplClass;
        block3: {
            Ruby runtime = clazz.getRuntime();
            Class[] interfaces2 = Java.getInterfacesFromRubyClass(clazz);
            int interfacesHashCode = Java.interfacesHashCode(interfaces2);
            interfacesHashCode = 31 * interfacesHashCode + clazz.hashCode();
            String implClassName = clazz.getBaseName() == null ? "anon_class" + Math.abs(System.identityHashCode(clazz)) + "_" + Math.abs(interfacesHashCode) : clazz.getName().replaceAll("::", "\\$\\$") + "_" + Math.abs(interfacesHashCode);
            try {
                proxyImplClass = Class.forName(implClassName, true, runtime.getJRubyClassLoader());
            }
            catch (ClassNotFoundException cnfe) {
                Class<RubyObject> superClass = clazz.getSuperClass().getRealClass().getReifiedClass();
                if (superClass == null) {
                    superClass = RubyObject.class;
                }
                proxyImplClass = RealClassGenerator.createRealImplClass(superClass, interfaces2, clazz, runtime, implClassName);
                if (!NEW_STYLE_EXTENSION || RubyBasicObject.class.isAssignableFrom(proxyImplClass) || clazz.getMethods().containsKey("initialize")) break block3;
                clazz.addMethod("initialize", new JavaMethod.JavaMethodZero(clazz, Visibility.PRIVATE){

                    @Override
                    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
                        return context.runtime.getNil();
                    }
                });
            }
        }
        clazz.setReifiedClass(proxyImplClass);
        clazz.setRubyClassAllocator(proxyImplClass);
        return proxyImplClass;
    }

    public static Constructor getRealClassConstructor(Ruby runtime, Class proxyImplClass) {
        try {
            return proxyImplClass.getConstructor(Ruby.class, RubyClass.class);
        }
        catch (NoSuchMethodException nsme) {
            throw runtime.newTypeError("Exception instantiating generated interface impl:\n" + nsme);
        }
    }

    public static IRubyObject constructProxy(Ruby runtime, Constructor proxyConstructor, RubyClass clazz) {
        try {
            return (IRubyObject)proxyConstructor.newInstance(runtime, clazz);
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
            throw runtime.newTypeError("Exception instantiating generated interface impl:\n" + ite);
        }
        catch (InstantiationException ie) {
            throw runtime.newTypeError("Exception instantiating generated interface impl:\n" + ie);
        }
        catch (IllegalAccessException iae) {
            throw runtime.newTypeError("Exception instantiating generated interface impl:\n" + iae);
        }
    }

    public static IRubyObject allocateProxy(Object javaObject, RubyClass clazz) {
        if (clazz.getSuperClass() == clazz.getRuntime().getJavaSupport().getArrayProxyClass()) {
            return new ArrayJavaProxy(clazz.getRuntime(), clazz, javaObject, JavaUtil.getJavaConverter(javaObject.getClass().getComponentType()));
        }
        IRubyObject proxy2 = clazz.allocate();
        if (proxy2 instanceof JavaProxy) {
            ((JavaProxy)proxy2).setObject(javaObject);
        } else {
            JavaObject wrappedObject = JavaObject.wrap(clazz.getRuntime(), javaObject);
            proxy2.dataWrapStruct(wrappedObject);
        }
        return proxy2;
    }

    public static IRubyObject wrapJavaObject(Ruby runtime, Object object) {
        return Java.allocateProxy(object, Java.getProxyClassForObject(runtime, object));
    }

    public static Class[] getInterfacesFromRubyClass(RubyClass klass) {
        HashSet interfaces2 = new HashSet();
        while (klass != null) {
            IRubyObject maybeInterfaces = klass.getInstanceVariables().getInstanceVariable("@java_interfaces");
            if (maybeInterfaces instanceof RubyArray) {
                RubyArray moreInterfaces = (RubyArray)maybeInterfaces;
                if (!moreInterfaces.isFrozen()) {
                    moreInterfaces.setFrozen(true);
                }
                interfaces2.addAll(moreInterfaces);
            }
            klass = klass.getSuperClass();
        }
        return interfaces2.toArray(new Class[interfaces2.size()]);
    }

    private static int interfacesHashCode(Class[] a) {
        if (a == null) {
            return 0;
        }
        int result2 = 1;
        for (Class element : a) {
            result2 = 31 * result2 + (element == null ? 0 : element.hashCode());
        }
        return result2;
    }

    static {
        String[] primitives;
        NEW_STYLE_EXTENSION = Options.JI_NEWSTYLEEXTENSION.load();
        OBJECT_PROXY_CACHE = Options.JI_OBJECTPROXYCACHE.load();
        JAVA_PACKAGE_CLASS_PROVIDER = new ClassProvider(){

            @Override
            public RubyClass defineClassUnder(RubyModule pkg, String name2, RubyClass superClazz) {
                if (superClazz != null) {
                    return null;
                }
                IRubyObject packageName = pkg.getInstanceVariables().getInstanceVariable("@package_name");
                if (packageName == null) {
                    return null;
                }
                Ruby runtime = pkg.getRuntime();
                return (RubyClass)Java.get_proxy_class(runtime.getJavaSupport().getJavaUtilitiesModule(), JavaClass.forNameVerbose(runtime, packageName.asJavaString() + name2));
            }

            @Override
            public RubyModule defineModuleUnder(RubyModule pkg, String name2) {
                IRubyObject packageName = pkg.getInstanceVariables().getInstanceVariable("@package_name");
                if (packageName == null) {
                    return null;
                }
                Ruby runtime = pkg.getRuntime();
                return (RubyModule)Java.get_interface_module(runtime, JavaClass.forNameVerbose(runtime, packageName.asJavaString() + name2));
            }
        };
        JAVA_PRIMITIVES = new HashMap<String, Boolean>();
        for (String primitive : primitives = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"}) {
            JAVA_PRIMITIVES.put(primitive, Boolean.TRUE);
        }
        CAMEL_CASE_PACKAGE_SPLITTER = Pattern.compile("([a-z][0-9]*)([A-Z])");
    }

    public static class JavaProxyClassMethods {
        @JRubyMethod(meta=true)
        public static IRubyObject java_method(ThreadContext context, IRubyObject proxyClass, IRubyObject rubyName) {
            String name2 = rubyName.asJavaString();
            return Java.getRubyMethod(context, proxyClass, name2, new Class[0]);
        }

        @JRubyMethod(meta=true)
        public static IRubyObject java_method(ThreadContext context, IRubyObject proxyClass, IRubyObject rubyName, IRubyObject argTypes) {
            String name2 = rubyName.asJavaString();
            RubyArray argTypesAry = argTypes.convertToArray();
            Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argTypesAry.size()]);
            return Java.getRubyMethod(context, proxyClass, name2, argTypesClasses);
        }

        @JRubyMethod(meta=true)
        public static IRubyObject java_send(ThreadContext context, IRubyObject recv2, IRubyObject rubyName) {
            String name2 = rubyName.asJavaString();
            Ruby runtime = context.runtime;
            JavaMethod method2 = new JavaMethod(runtime, Java.getMethodFromClass(runtime, recv2, name2, new Class[0]));
            return method2.invokeStaticDirect();
        }

        @JRubyMethod(meta=true)
        public static IRubyObject java_send(ThreadContext context, IRubyObject recv2, IRubyObject rubyName, IRubyObject argTypes) {
            String name2 = rubyName.asJavaString();
            RubyArray argTypesAry = argTypes.convertToArray();
            Ruby runtime = context.runtime;
            if (argTypesAry.size() != 0) {
                Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argTypesAry.size()]);
                throw JavaMethod.newArgSizeMismatchError(runtime, argTypesClasses);
            }
            JavaMethod method2 = new JavaMethod(runtime, Java.getMethodFromClass(runtime, recv2, name2, new Class[0]));
            return method2.invokeStaticDirect();
        }

        @JRubyMethod(meta=true)
        public static IRubyObject java_send(ThreadContext context, IRubyObject recv2, IRubyObject rubyName, IRubyObject argTypes, IRubyObject arg0) {
            String name2 = rubyName.asJavaString();
            RubyArray argTypesAry = argTypes.convertToArray();
            Ruby runtime = context.runtime;
            if (argTypesAry.size() != 1) {
                throw JavaMethod.newArgSizeMismatchError(runtime, (Class)argTypesAry.eltInternal(0).toJava(Class.class));
            }
            Class argTypeClass = (Class)argTypesAry.eltInternal(0).toJava(Class.class);
            JavaMethod method2 = new JavaMethod(runtime, Java.getMethodFromClass(runtime, recv2, name2, argTypeClass));
            return method2.invokeStaticDirect(arg0.toJava(argTypeClass));
        }

        @JRubyMethod(required=4, rest=true, meta=true)
        public static IRubyObject java_send(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
            Ruby runtime = context.runtime;
            String name2 = args2[0].asJavaString();
            RubyArray argTypesAry = args2[1].convertToArray();
            int argsLen = args2.length - 2;
            if (argTypesAry.size() != argsLen) {
                throw JavaMethod.newArgSizeMismatchError(runtime, (Class[])argTypesAry.toArray(new Class[argTypesAry.size()]));
            }
            Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argsLen]);
            Object[] argsAry = new Object[argsLen];
            for (int i2 = 0; i2 < argsLen; ++i2) {
                argsAry[i2] = args2[i2 + 2].toJava(argTypesClasses[i2]);
            }
            JavaMethod method2 = new JavaMethod(runtime, Java.getMethodFromClass(runtime, recv2, name2, argTypesClasses));
            return method2.invokeStaticDirect(argsAry);
        }

        @JRubyMethod(meta=true, visibility=Visibility.PRIVATE)
        public static IRubyObject java_alias(ThreadContext context, IRubyObject proxyClass, IRubyObject newName, IRubyObject rubyName) {
            return JavaProxyClassMethods.java_alias(context, proxyClass, newName, rubyName, context.runtime.newEmptyArray());
        }

        @JRubyMethod(meta=true, visibility=Visibility.PRIVATE)
        public static IRubyObject java_alias(ThreadContext context, IRubyObject proxyClass, IRubyObject newName, IRubyObject rubyName, IRubyObject argTypes) {
            String name2 = rubyName.asJavaString();
            String newNameStr = newName.asJavaString();
            RubyArray argTypesAry = argTypes.convertToArray();
            Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argTypesAry.size()]);
            Ruby runtime = context.runtime;
            if (!(proxyClass instanceof RubyClass)) {
                throw runtime.newTypeError(proxyClass, runtime.getModule());
            }
            RubyClass rubyClass = (RubyClass)proxyClass;
            Method method2 = Java.getMethodFromClass(runtime, proxyClass, name2, argTypesClasses);
            MethodInvoker invoker = Java.getMethodInvokerForMethod(rubyClass, method2);
            if (Modifier.isStatic(method2.getModifiers())) {
                rubyClass.getSingletonClass().addMethod(newNameStr, invoker);
            } else {
                rubyClass.addMethod(newNameStr, invoker);
            }
            return runtime.getNil();
        }
    }

    public static class NewStyleExtensionInherited {
        @JRubyMethod
        public static IRubyObject inherited(IRubyObject recv2, IRubyObject arg0) {
            if (!(arg0 instanceof RubyClass)) {
                throw recv2.getRuntime().newTypeError(arg0, recv2.getRuntime().getClassClass());
            }
            JavaInterfaceTemplate.addRealImplClassNew((RubyClass)arg0);
            return recv2.getRuntime().getNil();
        }
    }

    public static class OldStyleExtensionInherited {
        @JRubyMethod
        public static IRubyObject inherited(IRubyObject recv2, IRubyObject arg0) {
            return Java.concrete_proxy_inherited(recv2, arg0);
        }
    }
}

