/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import javax.crypto.Cipher;
import org.jruby.ext.openssl.impl.BIOFilter;

public class CipherSpec
extends BIOFilter {
    private final Cipher cipher;
    private final String osslName;
    private final int keyLenInBits;

    public CipherSpec(Cipher cipher, String osslName, int keyLenInBits) {
        this.cipher = cipher;
        this.osslName = osslName;
        this.keyLenInBits = keyLenInBits;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    public String getOsslName() {
        return this.osslName;
    }

    public int getKeyLenInBits() {
        return this.keyLenInBits;
    }

    public String getAlgorithm() {
        return this.getCipher().getAlgorithm();
    }

    public String getWrappingAlgorithm() {
        return CipherSpec.getWrappingAlgorithm(this.getAlgorithm());
    }

    public static String getWrappingAlgorithm(String algorithm) {
        if (algorithm == null) {
            return null;
        }
        if (algorithm.equalsIgnoreCase("RSA")) {
            return "RSA/ECB/PKCS1Padding";
        }
        return algorithm;
    }
}

