/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriter;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class GeoJSONWriter {
    private OsmDataLayer layer;
    private static final boolean skipEmptyNodes = true;

    public GeoJSONWriter(OsmDataLayer osmDataLayer) {
        this.layer = osmDataLayer;
    }

    public String write() {
        return this.write(true);
    }

    public String write(boolean bl) {
        StringWriter stringWriter = new StringWriter();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(1);
        hashMap.put("javax.json.stream.JsonGenerator.prettyPrinting", bl);
        JsonWriter jsonWriter = Json.createWriterFactory(hashMap).createWriter(stringWriter);
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder().add("type", "FeatureCollection").add("generator", "JOSM");
        GeoJSONWriter.appendLayerBounds(this.layer.data, jsonObjectBuilder);
        GeoJSONWriter.appendLayerFeatures(this.layer.data, jsonObjectBuilder);
        jsonWriter.writeObject(jsonObjectBuilder.build());
        String string = stringWriter.toString();
        jsonWriter.close();
        return string;
    }

    protected static void appendPrimitive(OsmPrimitive osmPrimitive, JsonArrayBuilder jsonArrayBuilder) {
        if (osmPrimitive.isIncomplete()) {
            return;
        }
        if (osmPrimitive instanceof Node && osmPrimitive.getKeys().isEmpty()) {
            return;
        }
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        for (Map.Entry<String, String> entry : osmPrimitive.getKeys().entrySet()) {
            jsonObjectBuilder.add(entry.getKey(), entry.getValue());
        }
        JsonObjectBuilder jsonObjectBuilder2 = Json.createObjectBuilder();
        osmPrimitive.accept(new GeometryPrimitiveVisitor(jsonObjectBuilder2));
        jsonArrayBuilder.add(Json.createObjectBuilder().add("type", "Feature").add("properties", jsonObjectBuilder).add("geometry", jsonObjectBuilder2));
    }

    protected static void appendLayerBounds(DataSet dataSet, JsonObjectBuilder jsonObjectBuilder) {
        Iterator<Bounds> iterator;
        if (dataSet != null && (iterator = dataSet.getDataSourceBounds().iterator()).hasNext()) {
            Bounds bounds = new Bounds(iterator.next());
            while (iterator.hasNext()) {
                bounds.extend(iterator.next());
            }
            GeoJSONWriter.appendBounds(bounds, jsonObjectBuilder);
        }
    }

    protected static void appendBounds(Bounds bounds, JsonObjectBuilder jsonObjectBuilder) {
        if (bounds != null) {
            jsonObjectBuilder.add("bbox", Json.createArrayBuilder().add(bounds.getMinLon()).add(bounds.getMinLat()).add(bounds.getMaxLon()).add(bounds.getMaxLat()));
        }
    }

    protected static void appendLayerFeatures(DataSet dataSet, JsonObjectBuilder jsonObjectBuilder) {
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        if (dataSet != null) {
            for (Node osmPrimitive : dataSet.getNodes()) {
                GeoJSONWriter.appendPrimitive(osmPrimitive, jsonArrayBuilder);
            }
            for (Way way : dataSet.getWays()) {
                GeoJSONWriter.appendPrimitive(way, jsonArrayBuilder);
            }
        }
        jsonObjectBuilder.add("features", jsonArrayBuilder);
    }

    private static class GeometryPrimitiveVisitor
    implements PrimitiveVisitor {
        private final JsonObjectBuilder geomObj;

        public GeometryPrimitiveVisitor(JsonObjectBuilder jsonObjectBuilder) {
            this.geomObj = jsonObjectBuilder;
        }

        @Override
        public void visit(INode iNode) {
            this.geomObj.add("type", "Point");
            LatLon latLon = iNode.getCoor();
            if (latLon != null) {
                this.geomObj.add("coordinates", this.getCoorArray(iNode.getCoor()));
            }
        }

        @Override
        public void visit(IWay iWay) {
            this.geomObj.add("type", "LineString");
            if (iWay instanceof Way) {
                JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
                for (Node node : ((Way)iWay).getNodes()) {
                    LatLon latLon = node.getCoor();
                    if (latLon == null) continue;
                    jsonArrayBuilder.add(this.getCoorArray(latLon));
                }
                this.geomObj.add("coordinates", jsonArrayBuilder);
            }
        }

        @Override
        public void visit(IRelation iRelation) {
        }

        private JsonArrayBuilder getCoorArray(LatLon latLon) {
            return Json.createArrayBuilder().add(latLon.lon()).add(latLon.lat());
        }
    }
}

