/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;
import org.apache.tools.bzip2.CBZip2OutputStream;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.tools.Utils;

public enum Compression {
    NONE,
    BZIP2,
    GZIP,
    ZIP;


    public static Compression byExtension(String string) {
        return string != null && string.endsWith(".gz") ? GZIP : (string != null && (string.endsWith(".bz2") || string.endsWith(".bz")) ? BZIP2 : (string != null && string.endsWith(".zip") ? ZIP : NONE));
    }

    public InputStream getUncompressedInputStream(InputStream inputStream) throws IOException {
        switch (this) {
            case BZIP2: {
                return FileImporter.getBZip2InputStream(inputStream);
            }
            case GZIP: {
                return FileImporter.getGZipInputStream(inputStream);
            }
            case ZIP: {
                return FileImporter.getZipInputStream(inputStream);
            }
        }
        return inputStream;
    }

    public static InputStream getUncompressedFileInputStream(File file) throws IOException {
        return Compression.byExtension(file.getName()).getUncompressedInputStream(new FileInputStream(file));
    }

    public static InputStream getUncompressedURLInputStream(URL uRL) throws IOException {
        return Utils.openURLAndDecompress(uRL, true);
    }

    public OutputStream getCompressedOutputStream(OutputStream outputStream) throws IOException {
        switch (this) {
            case BZIP2: {
                outputStream.write(66);
                outputStream.write(90);
                return new CBZip2OutputStream(outputStream);
            }
            case GZIP: {
                return new GZIPOutputStream(outputStream);
            }
            case ZIP: {
                return new ZipOutputStream(outputStream);
            }
        }
        return outputStream;
    }

    public static OutputStream getCompressedFileOutputStream(File file) throws IOException {
        return Compression.byExtension(file.getName()).getCompressedOutputStream(new FileOutputStream(file));
    }
}

