/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TextContextualPopupMenu
extends JPopupMenu {
    protected JTextComponent component = null;
    protected UndoAction undoAction = null;
    protected final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("editable")) {
                TextContextualPopupMenu.this.removeAll();
                TextContextualPopupMenu.this.addMenuEntries();
            }
        }
    };

    protected TextContextualPopupMenu() {
    }

    protected TextContextualPopupMenu attach(JTextComponent jTextComponent) {
        if (jTextComponent != null && !this.isAttached()) {
            this.component = jTextComponent;
            if (jTextComponent.isEditable()) {
                this.undoAction = new UndoAction();
                jTextComponent.getDocument().addUndoableEditListener(this.undoAction);
            }
            this.addMenuEntries();
            jTextComponent.addPropertyChangeListener("editable", this.propertyChangeListener);
        }
        return this;
    }

    private void addMenuEntries() {
        if (this.component.isEditable()) {
            this.add(new JMenuItem(this.undoAction));
            this.addSeparator();
            this.addMenuEntry(this.component, I18n.tr("Cut", new Object[0]), "cut-to-clipboard", null);
        }
        this.addMenuEntry(this.component, I18n.tr("Copy", new Object[0]), "copy-to-clipboard", "copy");
        if (this.component.isEditable()) {
            this.addMenuEntry(this.component, I18n.tr("Paste", new Object[0]), "paste-from-clipboard", "paste");
            this.addMenuEntry(this.component, I18n.tr("Delete", new Object[0]), "delete-next", null);
        }
        this.addSeparator();
        this.addMenuEntry(this.component, I18n.tr("Select All", new Object[0]), "select-all", null);
    }

    protected TextContextualPopupMenu detach() {
        if (this.isAttached()) {
            this.component.removePropertyChangeListener("editable", this.propertyChangeListener);
            this.removeAll();
            if (this.undoAction != null) {
                this.component.getDocument().removeUndoableEditListener(this.undoAction);
                this.undoAction = null;
            }
            this.component = null;
        }
        return this;
    }

    public static PopupMenuLauncher enableMenuFor(JTextComponent jTextComponent) {
        PopupMenuLauncher popupMenuLauncher = new PopupMenuLauncher(new TextContextualPopupMenu().attach(jTextComponent), true);
        jTextComponent.addMouseListener(popupMenuLauncher);
        return popupMenuLauncher;
    }

    public static void disableMenuFor(JTextComponent jTextComponent, PopupMenuLauncher popupMenuLauncher) {
        if (popupMenuLauncher.getMenu() instanceof TextContextualPopupMenu) {
            ((TextContextualPopupMenu)popupMenuLauncher.getMenu()).detach();
            jTextComponent.removeMouseListener(popupMenuLauncher);
        }
    }

    public final boolean isAttached() {
        return this.component != null;
    }

    protected void addMenuEntry(JTextComponent jTextComponent, String string, String string2, String string3) {
        Action action = jTextComponent.getActionMap().get(string2);
        if (action != null) {
            ImageIcon imageIcon;
            JMenuItem jMenuItem = new JMenuItem(action);
            jMenuItem.setText(string);
            if (string3 != null && Main.pref.getBoolean("text.popupmenu.useicons", true) && (imageIcon = new ImageProvider(string3).setWidth(16).get()) != null) {
                jMenuItem.setIcon(imageIcon);
            }
            this.add(jMenuItem);
        }
    }

    protected static class UndoAction
    extends AbstractAction
    implements UndoableEditListener {
        private final UndoManager undoManager = new UndoManager();

        public UndoAction() {
            super(I18n.tr("Undo", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            this.undoManager.addEdit(undoableEditEvent.getEdit());
            this.setEnabled(this.undoManager.canUndo());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.undoManager.undo();
            }
            catch (CannotUndoException cannotUndoException) {
            }
            finally {
                this.setEnabled(this.undoManager.canUndo());
            }
        }
    }
}

