/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OsmUrlToBounds;

public class BoundingBoxSelectionPanel
extends JPanel {
    private JosmTextField[] tfLatLon = null;
    private final JosmTextField tfOsmUrl = new JosmTextField();

    protected void buildInputFields() {
        this.tfLatLon = new JosmTextField[4];
        for (int i = 0; i < 4; ++i) {
            this.tfLatLon[i] = new JosmTextField(11);
            this.tfLatLon[i].setMinimumSize(new Dimension(100, new JosmTextField().getMinimumSize().height));
            SelectAllOnFocusGainedDecorator.decorate(this.tfLatLon[i]);
        }
        LatitudeValidator.decorate(this.tfLatLon[0]);
        LatitudeValidator.decorate(this.tfLatLon[2]);
        LongitudeValidator.decorate(this.tfLatLon[1]);
        LongitudeValidator.decorate(this.tfLatLon[3]);
    }

    protected final void build() {
        this.buildInputFields();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        this.tfOsmUrl.getDocument().addDocumentListener(new OsmUrlRefresher());
        this.tfOsmUrl.addFocusListener(new SelectAllOnFocusGainedDecorator());
        this.add((Component)new JLabel(I18n.tr("Min. latitude", new Object[0])), GBC.std().insets(0, 0, 3, 5));
        this.add((Component)this.tfLatLon[0], GBC.std().insets(0, 0, 3, 5));
        this.add((Component)new JLabel(I18n.tr("Min. longitude", new Object[0])), GBC.std().insets(0, 0, 3, 5));
        this.add((Component)this.tfLatLon[1], GBC.eol());
        this.add((Component)new JLabel(I18n.tr("Max. latitude", new Object[0])), GBC.std().insets(0, 0, 3, 5));
        this.add((Component)this.tfLatLon[2], GBC.std().insets(0, 0, 3, 5));
        this.add((Component)new JLabel(I18n.tr("Max. longitude", new Object[0])), GBC.std().insets(0, 0, 3, 5));
        this.add((Component)this.tfLatLon[3], GBC.eol());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 3);
        this.add((Component)new JMultilineLabel(I18n.tr("URL from www.openstreetmap.org (you can paste a download URL here to specify a bounding box)", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(3, 0, 0, 3);
        this.add((Component)this.tfOsmUrl, gridBagConstraints);
    }

    public BoundingBoxSelectionPanel() {
        this.build();
    }

    public void setBoundingBox(Bounds bounds) {
        this.updateBboxFields(bounds);
    }

    public Bounds getBoundingBox() {
        double d;
        double d2;
        double d3;
        double d4;
        try {
            d4 = Double.parseDouble(this.tfLatLon[0].getText().trim());
            d3 = Double.parseDouble(this.tfLatLon[1].getText().trim());
            d2 = Double.parseDouble(this.tfLatLon[2].getText().trim());
            d = Double.parseDouble(this.tfLatLon[3].getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (!(LatLon.isValidLon(d3) && LatLon.isValidLon(d) && LatLon.isValidLat(d4) && LatLon.isValidLat(d2))) {
            return null;
        }
        if (d3 > d) {
            return null;
        }
        if (d4 > d2) {
            return null;
        }
        return new Bounds(d3, d4, d, d2);
    }

    private boolean parseURL() {
        Bounds bounds = OsmUrlToBounds.parse(this.tfOsmUrl.getText());
        if (bounds == null) {
            return false;
        }
        this.updateBboxFields(bounds);
        return true;
    }

    private void updateBboxFields(Bounds bounds) {
        if (bounds == null) {
            return;
        }
        this.tfLatLon[0].setText(bounds.getMin().latToString(CoordinateFormat.DECIMAL_DEGREES));
        this.tfLatLon[1].setText(bounds.getMin().lonToString(CoordinateFormat.DECIMAL_DEGREES));
        this.tfLatLon[2].setText(bounds.getMax().latToString(CoordinateFormat.DECIMAL_DEGREES));
        this.tfLatLon[3].setText(bounds.getMax().lonToString(CoordinateFormat.DECIMAL_DEGREES));
    }

    class OsmUrlRefresher
    implements DocumentListener {
        OsmUrlRefresher() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            BoundingBoxSelectionPanel.this.parseURL();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            BoundingBoxSelectionPanel.this.parseURL();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            BoundingBoxSelectionPanel.this.parseURL();
        }
    }

    private static class LongitudeValidator
    extends AbstractTextComponentValidator {
        public static void decorate(JTextComponent jTextComponent) {
            new LongitudeValidator(jTextComponent);
        }

        public LongitudeValidator(JTextComponent jTextComponent) {
            super(jTextComponent);
        }

        @Override
        public void validate() {
            double d = 0.0;
            try {
                d = Double.parseDouble(this.getComponent().getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.feedbackInvalid(I18n.tr("The string ''{0}'' is not a valid double value.", this.getComponent().getText()));
                return;
            }
            if (!LatLon.isValidLon(d)) {
                this.feedbackInvalid(I18n.tr("Value for longitude in range [-180,180] required.", this.getComponent().getText()));
                return;
            }
            this.feedbackValid("");
        }

        @Override
        public boolean isValid() {
            double d = 0.0;
            try {
                d = Double.parseDouble(this.getComponent().getText());
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            return LatLon.isValidLon(d);
        }
    }

    private static class LatitudeValidator
    extends AbstractTextComponentValidator {
        public static void decorate(JTextComponent jTextComponent) {
            new LatitudeValidator(jTextComponent);
        }

        public LatitudeValidator(JTextComponent jTextComponent) {
            super(jTextComponent);
        }

        @Override
        public void validate() {
            double d = 0.0;
            try {
                d = Double.parseDouble(this.getComponent().getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.feedbackInvalid(I18n.tr("The string ''{0}'' is not a valid double value.", this.getComponent().getText()));
                return;
            }
            if (!LatLon.isValidLat(d)) {
                this.feedbackInvalid(I18n.tr("Value for latitude in range [-90,90] required.", this.getComponent().getText()));
                return;
            }
            this.feedbackValid("");
        }

        @Override
        public boolean isValid() {
            double d = 0.0;
            try {
                d = Double.parseDouble(this.getComponent().getText());
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            return LatLon.isValidLat(d);
        }
    }
}

