/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.dialogs.properties.PresetListPanel;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.TaggingPresetReader;
import org.openstreetmap.josm.gui.tagging.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionItemPriority;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.QuadStateCheckBox;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public final class TaggingPresetItems {
    private static int auto_increment_selected = 0;
    public static final String DIFFERENT = I18n.tr("<different>", new Object[0]);
    private static final BooleanProperty PROP_FILL_DEFAULT = new BooleanProperty("taggingpreset.fill-default-for-tagged-primitives", false);
    private static final Map<String, EnumSet<TaggingPresetType>> typeCache = new LinkedHashMap<String, EnumSet<TaggingPresetType>>(16, 1.1f, true);
    private static final Map<String, String> lastValue = new HashMap<String, String>();

    private TaggingPresetItems() {
    }

    public static EnumSet<TaggingPresetType> getType(String string) throws SAXException {
        if (typeCache.containsKey(string)) {
            return typeCache.get(string);
        }
        EnumSet<TaggingPresetType> enumSet = EnumSet.noneOf(TaggingPresetType.class);
        for (String string2 : Arrays.asList(string.split(","))) {
            try {
                TaggingPresetType taggingPresetType = TaggingPresetType.fromString(string2);
                enumSet.add(taggingPresetType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SAXException(I18n.tr("Unknown type: {0}", string2), illegalArgumentException);
            }
        }
        typeCache.put(string, enumSet);
        return enumSet;
    }

    static String fixPresetString(String string) {
        return string == null ? string : string.replaceAll("'", "''");
    }

    private static String[] splitEscaped(char c, String string) {
        if (string == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (bl) {
                stringBuilder.append(c2);
                bl = false;
                continue;
            }
            if (c2 == '\\') {
                bl = true;
                continue;
            }
            if (c2 == c) {
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                continue;
            }
            stringBuilder.append(c2);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static Usage determineTextUsage(Collection<OsmPrimitive> collection, String string) {
        Usage usage = new Usage();
        usage.values = new TreeSet();
        for (OsmPrimitive osmPrimitive : collection) {
            String string2 = osmPrimitive.get(string);
            if (string2 != null) {
                usage.values.add(string2);
            } else {
                usage.hadEmpty = true;
            }
            if (!osmPrimitive.hasKeys()) continue;
            usage.hadKeys = true;
        }
        return usage;
    }

    static Usage determineBooleanUsage(Collection<OsmPrimitive> collection, String string) {
        Usage usage = new Usage();
        usage.values = new TreeSet();
        for (OsmPrimitive osmPrimitive : collection) {
            String string2 = OsmUtils.getNamedOsmBoolean(osmPrimitive.get(string));
            if (string2 == null) continue;
            usage.values.add(string2);
        }
        return usage;
    }

    protected static ImageIcon loadImageIcon(String string, File file, Integer n) {
        Collection<String> collection = Main.pref.getCollection("taggingpreset.icon.sources", null);
        ImageProvider imageProvider = new ImageProvider(string).setDirs(collection).setId("presets").setArchive(file).setOptional(true);
        if (n != null) {
            imageProvider.setMaxSize(n);
        }
        return imageProvider.get();
    }

    private static class ConcatenatingJList
    extends JList {
        private String delimiter;

        public ConcatenatingJList(String string, Object[] objectArray) {
            super(objectArray);
            this.delimiter = string;
        }

        public void setSelectedItem(Object object) {
            if (object == null) {
                this.clearSelection();
            } else {
                String string = object.toString();
                TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(string.split(this.delimiter)));
                ListModel listModel = this.getModel();
                int[] nArray = new int[listModel.getSize()];
                int n = 0;
                for (int i = 0; i < listModel.getSize(); ++i) {
                    if (!treeSet.contains(((PresetListEntry)listModel.getElementAt((int)i)).value)) continue;
                    nArray[n++] = i;
                }
                this.setSelectedIndices(Arrays.copyOf(nArray, n));
                this.setEnabled(Utils.join(this.delimiter, treeSet).equals(this.getSelectedItem()));
            }
        }

        public String getSelectedItem() {
            ListModel listModel = this.getModel();
            int[] nArray = this.getSelectedIndices();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < nArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(this.delimiter);
                }
                stringBuilder.append(((PresetListEntry)listModel.getElementAt((int)nArray[i])).value);
            }
            return stringBuilder.toString();
        }
    }

    public static class MultiSelect
    extends ComboMultiSelect {
        public long rows = -1L;
        protected ConcatenatingJList list;

        @Override
        protected void addToPanelAnchor(JPanel jPanel, String string, boolean bl) {
            this.list = new ConcatenatingJList(this.delimiter, this.lhm.values().toArray());
            this.component = this.list;
            ListCellRenderer listCellRenderer = this.getListCellRenderer();
            this.list.setCellRenderer(listCellRenderer);
            if (this.usage.hasUniqueValue() && !this.usage.unused()) {
                this.originalValue = this.usage.getFirst();
                this.list.setSelectedItem(this.originalValue);
            } else if (string != null && !this.usage.hadKeys() || PROP_FILL_DEFAULT.get().booleanValue() || "force".equals(this.use_last_as_default)) {
                this.originalValue = DIFFERENT;
                this.list.setSelectedItem(string);
            } else if (this.usage.unused()) {
                this.originalValue = null;
                this.list.setSelectedItem(this.originalValue);
            } else {
                this.originalValue = DIFFERENT;
                this.list.setSelectedItem(this.originalValue);
            }
            JScrollPane jScrollPane = new JScrollPane(this.list);
            if (this.rows != -1L) {
                double d = listCellRenderer.getListCellRendererComponent(this.list, new PresetListEntry("x"), 0, false, false).getPreferredSize().getHeight() * (double)this.rows;
                jScrollPane.setPreferredSize(new Dimension((int)jScrollPane.getPreferredSize().getWidth(), (int)d));
            }
            jPanel.add((Component)jScrollPane, GBC.eol().fill(2));
        }

        @Override
        protected Object getSelectedItem() {
            return this.list.getSelectedItem();
        }

        @Override
        public void addCommands(List<Tag> list) {
            if (this.list.isEnabled()) {
                super.addCommands(list);
            }
        }
    }

    public static class Combo
    extends ComboMultiSelect {
        public boolean editable = true;
        protected JosmComboBox combo;
        public String length;

        public Combo() {
            this.delimiter = ",";
        }

        @Override
        protected void addToPanelAnchor(JPanel jPanel, String string, boolean bl) {
            AutoCompletionList autoCompletionList;
            if (!this.usage.unused()) {
                for (String object2 : this.usage.values) {
                    if (this.lhm.containsKey(object2)) continue;
                    this.lhm.put(object2, new PresetListEntry(object2));
                }
            }
            if (string != null && !this.lhm.containsKey(string)) {
                this.lhm.put(string, new PresetListEntry(string));
            }
            this.lhm.put("", new PresetListEntry(""));
            this.combo = new JosmComboBox(this.lhm.values().toArray());
            this.component = this.combo;
            this.combo.setRenderer(this.getListCellRenderer());
            this.combo.setEditable(this.editable);
            this.combo.reinitialize(this.lhm.values());
            AutoCompletingTextField autoCompletingTextField = new AutoCompletingTextField();
            this.initAutoCompletionField(autoCompletingTextField, this.key);
            if (this.length != null && !this.length.isEmpty()) {
                autoCompletingTextField.setMaxChars(Integer.valueOf(this.length));
            }
            if ((autoCompletionList = autoCompletingTextField.getAutoCompletionList()) != null) {
                autoCompletionList.add(this.getDisplayValues(), AutoCompletionItemPriority.IS_IN_STANDARD);
            }
            this.combo.setEditor(autoCompletingTextField);
            if (this.usage.hasUniqueValue()) {
                this.originalValue = this.lhm.get(this.usage.getFirst());
                this.combo.setSelectedItem(this.originalValue);
            } else if (string != null && this.usage.unused()) {
                if (!this.usage.hadKeys() || PROP_FILL_DEFAULT.get().booleanValue() || "force".equals(this.use_last_as_default)) {
                    this.combo.setSelectedItem(((PresetListEntry)this.lhm.get(string)).getDisplayValue(true));
                } else {
                    this.combo.setSelectedItem("");
                }
                this.originalValue = this.lhm.get(DIFFERENT);
            } else if (this.usage.unused()) {
                this.originalValue = this.lhm.get("");
                if ("force".equals(this.use_last_as_default) && lastValue.containsKey(this.key) && !bl) {
                    this.combo.setSelectedItem(this.lhm.get(lastValue.get(this.key)));
                } else {
                    this.combo.setSelectedItem(this.originalValue);
                }
            } else {
                this.originalValue = this.lhm.get(DIFFERENT);
                this.combo.setSelectedItem(this.originalValue);
            }
            jPanel.add((Component)this.combo, GBC.eol().fill(2));
        }

        @Override
        protected Object getSelectedItem() {
            return this.combo.getSelectedItem();
        }

        @Override
        protected String getDisplayIfNull() {
            if (this.combo.isEditable()) {
                return this.combo.getEditor().getItem().toString();
            }
            return null;
        }
    }

    public static abstract class ComboMultiSelect
    extends KeyedItem {
        public String locale_text;
        public String values;
        public String values_from;
        public String values_context;
        public String display_values;
        public String locale_display_values;
        public String short_descriptions;
        public String locale_short_descriptions;
        public String default_;
        public String delimiter = ";";
        public String use_last_as_default = "false";
        public String values_searchable = "false";
        protected JComponent component;
        protected final Map<String, PresetListEntry> lhm = new LinkedHashMap<String, PresetListEntry>();
        private boolean initialized = false;
        protected Usage usage;
        protected Object originalValue;
        private static final ListCellRenderer RENDERER = new ListCellRenderer(){
            JLabel lbl = new JLabel();

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                PresetListEntry presetListEntry = (PresetListEntry)object;
                if (!jList.isShowing() && presetListEntry.prefferedWidth != -1 && presetListEntry.prefferedHeight != -1) {
                    if (n == -1) {
                        this.lbl.setPreferredSize(new Dimension(presetListEntry.prefferedWidth, 10));
                    } else {
                        this.lbl.setPreferredSize(new Dimension(presetListEntry.prefferedWidth, presetListEntry.prefferedHeight));
                    }
                    return this.lbl;
                }
                this.lbl.setPreferredSize(null);
                if (bl) {
                    this.lbl.setBackground(jList.getSelectionBackground());
                    this.lbl.setForeground(jList.getSelectionForeground());
                } else {
                    this.lbl.setBackground(jList.getBackground());
                    this.lbl.setForeground(jList.getForeground());
                }
                this.lbl.setOpaque(true);
                this.lbl.setFont(this.lbl.getFont().deriveFont(0));
                this.lbl.setText("<html>" + presetListEntry.getListDisplay() + "</html>");
                this.lbl.setIcon(presetListEntry.getIcon());
                this.lbl.setEnabled(jList.isEnabled());
                presetListEntry.prefferedWidth = this.lbl.getPreferredSize().width;
                presetListEntry.prefferedHeight = this.lbl.getPreferredSize().height;
                if (n == -1) {
                    this.lbl.setPreferredSize(new Dimension(this.lbl.getPreferredSize().width, 10));
                }
                return this.lbl;
            }
        };

        protected abstract Object getSelectedItem();

        protected abstract void addToPanelAnchor(JPanel var1, String var2, boolean var3);

        protected char getDelChar() {
            return this.delimiter.isEmpty() ? (char)';' : this.delimiter.charAt(0);
        }

        @Override
        public Collection<String> getValues() {
            this.initListEntries();
            return this.lhm.keySet();
        }

        public Collection<String> getDisplayValues() {
            this.initListEntries();
            return Utils.transform(this.lhm.values(), new Utils.Function<PresetListEntry, String>(){

                @Override
                public String apply(PresetListEntry presetListEntry) {
                    return presetListEntry.getDisplayValue(true);
                }
            });
        }

        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection, boolean bl) {
            this.initListEntries();
            this.usage = TaggingPresetItems.determineTextUsage(collection, this.key);
            if (!this.usage.hasUniqueValue() && !this.usage.unused()) {
                this.lhm.put(DIFFERENT, new PresetListEntry(DIFFERENT));
            }
            jPanel.add((Component)new JLabel(I18n.tr("{0}:", this.locale_text)), GBC.std().insets(0, 0, 10, 0));
            this.addToPanelAnchor(jPanel, this.default_, bl);
            return true;
        }

        private void initListEntries() {
            if (this.initialized) {
                this.lhm.remove(DIFFERENT);
                return;
            }
            if (this.lhm.isEmpty()) {
                this.initListEntriesFromAttributes();
            } else {
                if (this.values != null) {
                    Main.warn(I18n.tr("Warning in tagging preset \"{0}-{1}\": Ignoring ''{2}'' attribute as ''{3}'' elements are given.", this.key, this.text, "values", "list_entry"));
                }
                if (this.display_values != null || this.locale_display_values != null) {
                    Main.warn(I18n.tr("Warning in tagging preset \"{0}-{1}\": Ignoring ''{2}'' attribute as ''{3}'' elements are given.", this.key, this.text, "display_values", "list_entry"));
                }
                if (this.short_descriptions != null || this.locale_short_descriptions != null) {
                    Main.warn(I18n.tr("Warning in tagging preset \"{0}-{1}\": Ignoring ''{2}'' attribute as ''{3}'' elements are given.", this.key, this.text, "short_descriptions", "list_entry"));
                }
                for (PresetListEntry presetListEntry : this.lhm.values()) {
                    if (presetListEntry.value_context != null) continue;
                    presetListEntry.value_context = this.values_context;
                }
            }
            if (this.locale_text == null) {
                this.locale_text = I18n.trc(this.text_context, TaggingPresetItems.fixPresetString(this.text));
            }
            this.initialized = true;
        }

        private String[] initListEntriesFromAttributes() {
            String[] stringArray;
            Object object;
            Object object2;
            char c = this.getDelChar();
            String[] stringArray2 = null;
            if (this.values_from != null && (object2 = this.values_from.split("#")) != null && ((String[])object2).length == 2) {
                try {
                    object = Class.forName(object2[0]).getMethod(object2[1], new Class[0]);
                    int n = ((Method)object).getModifiers();
                    if (Modifier.isPublic(n) && Modifier.isStatic(n) && ((Method)object).getReturnType().equals(String[].class) && ((Method)object).getParameterTypes().length == 0) {
                        stringArray2 = (String[])((Method)object).invoke(null, new Object[0]);
                    } else {
                        Main.error(I18n.tr("Broken tagging preset \"{0}-{1}\" - Java method given in ''values_from'' is not \"{2}\"", this.key, this.text, "public static String[] methodName()"));
                    }
                }
                catch (Exception exception) {
                    Main.error(I18n.tr("Broken tagging preset \"{0}-{1}\" - Java method given in ''values_from'' threw {2} ({3})", this.key, this.text, exception.getClass().getName(), exception.getMessage()));
                }
            }
            if (stringArray2 == null) {
                stringArray2 = TaggingPresetItems.splitEscaped(c, this.values);
            }
            object = (object2 = Utils.firstNonNull(this.locale_display_values, this.display_values)) == null ? stringArray2 : TaggingPresetItems.splitEscaped(c, (String)object2);
            String string = Utils.firstNonNull(this.locale_short_descriptions, this.short_descriptions);
            String[] stringArray3 = stringArray = string == null ? null : TaggingPresetItems.splitEscaped(c, string);
            if (((Object)object).length != stringArray2.length) {
                Main.error(I18n.tr("Broken tagging preset \"{0}-{1}\" - number of items in ''display_values'' must be the same as in ''values''", this.key, this.text));
                object = stringArray2;
            }
            if (stringArray != null && stringArray.length != stringArray2.length) {
                Main.error(I18n.tr("Broken tagging preset \"{0}-{1}\" - number of items in ''short_descriptions'' must be the same as in ''values''", this.key, this.text));
                stringArray = null;
            }
            for (int i = 0; i < stringArray2.length; ++i) {
                PresetListEntry presetListEntry = new PresetListEntry(stringArray2[i]);
                Object object3 = presetListEntry.locale_display_value = this.locale_display_values != null ? object[i] : I18n.trc(this.values_context, TaggingPresetItems.fixPresetString((String)object[i]));
                if (stringArray != null) {
                    presetListEntry.locale_short_description = this.locale_short_descriptions != null ? stringArray[i] : I18n.tr(TaggingPresetItems.fixPresetString(stringArray[i]), new Object[0]);
                }
                this.lhm.put(stringArray2[i], presetListEntry);
                object[i] = presetListEntry.getDisplayValue(true);
            }
            return object;
        }

        protected String getDisplayIfNull() {
            return null;
        }

        @Override
        public void addCommands(List<Tag> list) {
            Object object = this.getSelectedItem();
            String string = object == null ? null : object.toString();
            String string2 = null;
            if (string == null) {
                string = this.getDisplayIfNull();
            }
            if (string != null) {
                for (String string3 : this.lhm.keySet()) {
                    String string4 = this.lhm.get(string3).toString();
                    if (string4 == null || !string4.equals(string)) continue;
                    string2 = string3;
                    break;
                }
                if (string2 == null) {
                    string2 = string;
                }
            } else {
                string2 = "";
            }
            string2 = Tag.removeWhiteSpaces(string2);
            if (this.originalValue == null ? string2.length() == 0 : string2.equals(this.originalValue.toString())) {
                return;
            }
            if (!"false".equals(this.use_last_as_default)) {
                lastValue.put(this.key, string2);
            }
            list.add(new Tag(this.key, string2));
        }

        public void addListEntry(PresetListEntry presetListEntry) {
            this.lhm.put(presetListEntry.value, presetListEntry);
        }

        public void addListEntries(Collection<PresetListEntry> collection) {
            for (PresetListEntry presetListEntry : collection) {
                this.addListEntry(presetListEntry);
            }
        }

        @Override
        boolean requestFocusInWindow() {
            return this.component.requestFocusInWindow();
        }

        protected ListCellRenderer getListCellRenderer() {
            return RENDERER;
        }

        @Override
        public MatchType getDefaultMatch() {
            return MatchType.NONE;
        }
    }

    public static class Check
    extends KeyedItem {
        public String locale_text;
        public String value_on = "yes";
        public String value_off = "no";
        public boolean default_ = false;
        private QuadStateCheckBox check;
        private QuadStateCheckBox.State initialState;
        private boolean def;

        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection, boolean bl) {
            Usage usage = TaggingPresetItems.determineBooleanUsage(collection, this.key);
            this.def = this.default_;
            if (this.locale_text == null) {
                this.locale_text = this.text_context != null ? I18n.trc(this.text_context, TaggingPresetItems.fixPresetString(this.text)) : I18n.tr(TaggingPresetItems.fixPresetString(this.text), new Object[0]);
            }
            String string = null;
            Iterator<Object> iterator = usage.values.iterator();
            while (iterator.hasNext()) {
                String object;
                string = object = iterator.next();
            }
            if (usage.values.size() < 2 && (string == null || this.value_on.equals(string) || this.value_off.equals(string))) {
                if (this.def && !PROP_FILL_DEFAULT.get().booleanValue()) {
                    for (OsmPrimitive osmPrimitive : collection) {
                        if (!osmPrimitive.hasKeys()) continue;
                        this.def = false;
                    }
                }
                this.initialState = this.value_on.equals(string) ? QuadStateCheckBox.State.SELECTED : (this.value_off.equals(string) ? QuadStateCheckBox.State.NOT_SELECTED : (this.def ? QuadStateCheckBox.State.SELECTED : QuadStateCheckBox.State.UNSET));
                this.check = new QuadStateCheckBox(this.locale_text, this.initialState, new QuadStateCheckBox.State[]{QuadStateCheckBox.State.SELECTED, QuadStateCheckBox.State.NOT_SELECTED, QuadStateCheckBox.State.UNSET});
            } else {
                this.def = false;
                this.initialState = QuadStateCheckBox.State.PARTIAL;
                this.check = new QuadStateCheckBox(this.locale_text, QuadStateCheckBox.State.PARTIAL, new QuadStateCheckBox.State[]{QuadStateCheckBox.State.PARTIAL, QuadStateCheckBox.State.SELECTED, QuadStateCheckBox.State.NOT_SELECTED, QuadStateCheckBox.State.UNSET});
            }
            jPanel.add((Component)this.check, GBC.eol().fill(2));
            return true;
        }

        @Override
        public void addCommands(List<Tag> list) {
            if (this.check.getState() == this.initialState && !this.def) {
                return;
            }
            list.add(new Tag(this.key, this.check.getState() == QuadStateCheckBox.State.SELECTED ? this.value_on : (this.check.getState() == QuadStateCheckBox.State.NOT_SELECTED ? this.value_off : null)));
        }

        @Override
        boolean requestFocusInWindow() {
            return this.check.requestFocusInWindow();
        }

        @Override
        public MatchType getDefaultMatch() {
            return MatchType.NONE;
        }

        @Override
        public Collection<String> getValues() {
            return Arrays.asList(this.value_on, this.value_off);
        }

        @Override
        public String toString() {
            return "Check [" + (this.locale_text != null ? "locale_text=" + this.locale_text + ", " : "") + (this.value_on != null ? "value_on=" + this.value_on + ", " : "") + (this.value_off != null ? "value_off=" + this.value_off + ", " : "") + "default_=" + this.default_ + ", " + (this.check != null ? "check=" + this.check + ", " : "") + (this.initialState != null ? "initialState=" + (Object)((Object)this.initialState) + ", " : "") + "def=" + this.def + "]";
        }
    }

    public static class CheckGroup
    extends TaggingPresetItem {
        public String columns;
        public final List<Check> checks = new LinkedList<Check>();

        @Override
        boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection, boolean bl) {
            Integer n = Integer.valueOf(this.columns);
            int n2 = (int)Math.ceil((double)this.checks.size() / n.doubleValue());
            JPanel jPanel2 = new JPanel(new GridLayout(n2, n));
            for (Check check : this.checks) {
                check.addToPanel(jPanel2, collection, bl);
            }
            jPanel.add((Component)jPanel2, GBC.eol());
            return false;
        }

        @Override
        void addCommands(List<Tag> list) {
            for (Check check : this.checks) {
                check.addCommands(list);
            }
        }

        public String toString() {
            return "CheckGroup [columns=" + this.columns + "]";
        }
    }

    public static class Text
    extends KeyedItem {
        public String locale_text;
        public String default_;
        public String originalValue;
        public String use_last_as_default = "false";
        public String auto_increment;
        public String length;
        private JComponent value;

        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection, boolean bl) {
            Serializable serializable;
            Usage usage = TaggingPresetItems.determineTextUsage(collection, this.key);
            AutoCompletingTextField autoCompletingTextField = new AutoCompletingTextField();
            this.initAutoCompletionField(autoCompletingTextField, this.key);
            if (this.length != null && !this.length.isEmpty()) {
                autoCompletingTextField.setMaxChars(Integer.valueOf(this.length));
            }
            if (usage.unused()) {
                if (auto_increment_selected != 0 && this.auto_increment != null) {
                    try {
                        autoCompletingTextField.setText(Integer.toString(Integer.parseInt((String)lastValue.get(this.key)) + auto_increment_selected));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (!usage.hadKeys() || PROP_FILL_DEFAULT.get().booleanValue() || "force".equals(this.use_last_as_default)) {
                    if (!"false".equals(this.use_last_as_default) && lastValue.containsKey(this.key) && !bl) {
                        autoCompletingTextField.setText((String)lastValue.get(this.key));
                    } else {
                        autoCompletingTextField.setText(this.default_);
                    }
                } else {
                    autoCompletingTextField.setText("");
                }
                this.value = autoCompletingTextField;
                this.originalValue = null;
            } else if (usage.hasUniqueValue()) {
                autoCompletingTextField.setText(usage.getFirst());
                this.value = autoCompletingTextField;
                this.originalValue = usage.getFirst();
            } else {
                serializable = new JosmComboBox(usage.values.toArray());
                ((JComboBox)serializable).setEditable(true);
                ((JComboBox)serializable).setEditor(autoCompletingTextField);
                ((JComboBox)serializable).getEditor().setItem(DIFFERENT);
                this.value = serializable;
                this.originalValue = DIFFERENT;
            }
            if (this.locale_text == null && this.text != null) {
                this.locale_text = this.text_context != null ? I18n.trc(this.text_context, TaggingPresetItems.fixPresetString(this.text)) : I18n.tr(TaggingPresetItems.fixPresetString(this.text), new Object[0]);
            }
            if (this.auto_increment != null) {
                serializable = new ButtonGroup();
                JPanel jPanel2 = new JPanel(new GridBagLayout());
                jPanel2.add((Component)this.value, GBC.std().fill(2));
                for (String string : this.auto_increment.split(",")) {
                    JToggleButton jToggleButton = new JToggleButton(string);
                    jToggleButton.setToolTipText(I18n.tr("Select auto-increment of {0} for this field", string));
                    jToggleButton.setMargin(new Insets(0, 0, 0, 0));
                    jToggleButton.setFocusable(false);
                    ((ButtonGroup)serializable).add(jToggleButton);
                    try {
                        final int n = NumberFormat.getIntegerInstance().parse(string.replace("+", "")).intValue();
                        if (auto_increment_selected == n) {
                            jToggleButton.setSelected(true);
                        }
                        jToggleButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                auto_increment_selected = n;
                            }
                        });
                        jPanel2.add((Component)jToggleButton, GBC.std());
                    }
                    catch (ParseException parseException) {
                        Main.error("Cannot parse auto-increment value of '" + string + "' into an integer");
                    }
                }
                final JToggleButton jToggleButton = new JToggleButton("X");
                jToggleButton.setVisible(false);
                jToggleButton.setFocusable(false);
                ((ButtonGroup)serializable).add(jToggleButton);
                JButton jButton = new JButton("X");
                jButton.setToolTipText(I18n.tr("Cancel auto-increment for this field", new Object[0]));
                jButton.setMargin(new Insets(0, 0, 0, 0));
                jButton.setFocusable(false);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        auto_increment_selected = 0;
                        jToggleButton.setSelected(true);
                    }
                });
                jPanel2.add((Component)jButton, GBC.eol());
                this.value = jPanel2;
            }
            jPanel.add((Component)new JLabel(this.locale_text + ":"), GBC.std().insets(0, 0, 10, 0));
            jPanel.add((Component)this.value, GBC.eol().fill(2));
            return true;
        }

        private static String getValue(Component component) {
            if (component instanceof JosmComboBox) {
                return ((JosmComboBox)component).getEditor().getItem().toString();
            }
            if (component instanceof JosmTextField) {
                return ((JosmTextField)component).getText();
            }
            if (component instanceof JPanel) {
                return Text.getValue(((JPanel)component).getComponent(0));
            }
            return null;
        }

        @Override
        public void addCommands(List<Tag> list) {
            String string = Text.getValue(this.value);
            if (string == null) {
                Main.error("No 'last value' support for component " + this.value);
                return;
            }
            string = Tag.removeWhiteSpaces(string);
            if (!"false".equals(this.use_last_as_default) || this.auto_increment != null) {
                lastValue.put(this.key, string);
            }
            if (string.equals(this.originalValue) || this.originalValue == null && string.length() == 0) {
                return;
            }
            list.add(new Tag(this.key, string));
        }

        @Override
        boolean requestFocusInWindow() {
            return this.value.requestFocusInWindow();
        }

        @Override
        public MatchType getDefaultMatch() {
            return MatchType.NONE;
        }

        @Override
        public Collection<String> getValues() {
            if (this.default_ == null || this.default_.isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.singleton(this.default_);
        }
    }

    public static class Key
    extends KeyedItem {
        public String value;

        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection, boolean bl) {
            return false;
        }

        @Override
        public void addCommands(List<Tag> list) {
            list.add(new Tag(this.key, this.value));
        }

        @Override
        public MatchType getDefaultMatch() {
            return MatchType.KEY_VALUE;
        }

        @Override
        public Collection<String> getValues() {
            return Collections.singleton(this.value);
        }

        @Override
        public String toString() {
            return "Key [key=" + this.key + ", value=" + this.value + ", text=" + this.text + ", text_context=" + this.text_context + ", match=" + this.match + "]";
        }
    }

    public static abstract class KeyedItem
    extends TaggingPresetItem {
        public String key;
        public String text;
        public String text_context;
        public String match = this.getDefaultMatch().getValue();

        public abstract MatchType getDefaultMatch();

        public abstract Collection<String> getValues();

        @Override
        Boolean matches(Map<String, String> map) {
            switch (MatchType.ofString(this.match)) {
                case NONE: {
                    return null;
                }
                case KEY: {
                    return map.containsKey(this.key) ? Boolean.valueOf(true) : null;
                }
                case KEY_REQUIRED: {
                    return map.containsKey(this.key);
                }
                case KEY_VALUE: {
                    return map.containsKey(this.key) && this.getValues().contains(map.get(this.key));
                }
            }
            throw new IllegalStateException();
        }

        public String toString() {
            return "KeyedItem [key=" + this.key + ", text=" + this.text + ", text_context=" + this.text_context + ", match=" + this.match + "]";
        }
    }

    public static class ItemSeparator
    extends TaggingPresetItem {
        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection, boolean bl) {
            jPanel.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
            return false;
        }

        @Override
        public void addCommands(List<Tag> list) {
        }

        public String toString() {
            return "ItemSeparator";
        }
    }

    public static class Space
    extends TaggingPresetItem {
        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection, boolean bl) {
            jPanel.add((Component)new JLabel(" "), GBC.eol());
            return false;
        }

        @Override
        public void addCommands(List<Tag> list) {
        }

        public String toString() {
            return "Space";
        }
    }

    public static class Optional
    extends TaggingPresetTextItem {
        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection, boolean bl) {
            this.initializeLocaleText(I18n.tr("Optional Attributes:", new Object[0]));
            jPanel.add((Component)new JLabel(" "), GBC.eol());
            jPanel.add((Component)new JLabel(this.locale_text), GBC.eol());
            jPanel.add((Component)new JLabel(" "), GBC.eol());
            return false;
        }
    }

    public static class Roles
    extends TaggingPresetItem {
        public final List<Role> roles = new LinkedList<Role>();

        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection, boolean bl) {
            jPanel.add((Component)new JLabel(" "), GBC.eol());
            if (!this.roles.isEmpty()) {
                JPanel jPanel2 = new JPanel(new GridBagLayout());
                jPanel2.add((Component)new JLabel(I18n.tr("Available roles", new Object[0])), GBC.std().insets(0, 0, 10, 0));
                jPanel2.add((Component)new JLabel(I18n.tr("role", new Object[0])), GBC.std().insets(0, 0, 10, 0));
                jPanel2.add((Component)new JLabel(I18n.tr("count", new Object[0])), GBC.std().insets(0, 0, 10, 0));
                jPanel2.add((Component)new JLabel(I18n.tr("elements", new Object[0])), GBC.eol());
                for (Role role : this.roles) {
                    role.addToPanel(jPanel2, collection);
                }
                jPanel.add((Component)jPanel2, GBC.eol());
            }
            return false;
        }

        @Override
        public void addCommands(List<Tag> list) {
        }
    }

    public static class PresetLink
    extends TaggingPresetItem {
        public String preset_name = "";

        @Override
        boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection, boolean bl) {
            final String string = this.preset_name;
            final TaggingPreset taggingPreset = Utils.filter(TaggingPresetPreference.taggingPresets, new Predicate<TaggingPreset>(){

                @Override
                public boolean evaluate(TaggingPreset taggingPreset) {
                    return string.equals(taggingPreset.name);
                }
            }).iterator().next();
            if (taggingPreset == null) {
                return false;
            }
            JLabel jLabel = PresetListPanel.createLabelForPreset(taggingPreset);
            jLabel.addMouseListener(new PresetListPanel.PresetLabelML(jLabel, taggingPreset, null){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    taggingPreset.actionPerformed(null);
                }
            });
            jPanel.add((Component)jLabel, GBC.eol().fill(2));
            return false;
        }

        @Override
        void addCommands(List<Tag> list) {
        }
    }

    public static class Link
    extends TaggingPresetTextItem {
        public String href;
        public String locale_href;

        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection, boolean bl) {
            this.initializeLocaleText(I18n.tr("More information about this feature", new Object[0]));
            String string = this.locale_href;
            if (string == null) {
                string = this.href;
            }
            if (string != null) {
                jPanel.add((Component)new UrlLabel(string, this.locale_text, 2), GBC.eol().insets(0, 10, 0, 0));
            }
            return false;
        }

        @Override
        protected String fieldsToString() {
            return super.fieldsToString() + (this.href != null ? "href=" + this.href + ", " : "") + (this.locale_href != null ? "locale_href=" + this.locale_href + ", " : "");
        }
    }

    public static class Label
    extends TaggingPresetTextItem {
        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection, boolean bl) {
            this.initializeLocaleText(null);
            Label.addLabel(jPanel, this.locale_text);
            return false;
        }

        public static void addLabel(JPanel jPanel, String string) {
            jPanel.add((Component)new JLabel(string), GBC.eol());
        }
    }

    public static abstract class TaggingPresetTextItem
    extends TaggingPresetItem {
        public String text;
        public String text_context;
        public String locale_text;

        protected final void initializeLocaleText(String string) {
            if (this.locale_text == null) {
                this.locale_text = this.text == null ? string : (this.text_context != null ? I18n.trc(this.text_context, TaggingPresetItems.fixPresetString(this.text)) : I18n.tr(TaggingPresetItems.fixPresetString(this.text), new Object[0]));
            }
        }

        @Override
        void addCommands(List<Tag> list) {
        }

        protected String fieldsToString() {
            return (this.text != null ? "text=" + this.text + ", " : "") + (this.text_context != null ? "text_context=" + this.text_context + ", " : "") + (this.locale_text != null ? "locale_text=" + this.locale_text : "");
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [" + this.fieldsToString() + "]";
        }
    }

    public static class Usage {
        TreeSet<String> values;
        boolean hadKeys = false;
        boolean hadEmpty = false;

        public boolean hasUniqueValue() {
            return this.values.size() == 1 && !this.hadEmpty;
        }

        public boolean unused() {
            return this.values.isEmpty();
        }

        public String getFirst() {
            return this.values.first();
        }

        public boolean hadKeys() {
            return this.hadKeys;
        }
    }

    public static enum MatchType {
        NONE("none"),
        KEY("key"),
        KEY_REQUIRED("key!"),
        KEY_VALUE("keyvalue");

        private final String value;

        private MatchType(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public static MatchType ofString(String string) {
            for (MatchType matchType : EnumSet.allOf(MatchType.class)) {
                if (!matchType.getValue().equals(string)) continue;
                return matchType;
            }
            throw new IllegalArgumentException(string + " is not allowed");
        }
    }

    public static class Role {
        public EnumSet<TaggingPresetType> types;
        public String key;
        public String text;
        public String text_context;
        public String locale_text;
        public SearchCompiler.Match memberExpression;
        public boolean required = false;
        public long count = 0L;

        public void setType(String string) throws SAXException {
            this.types = TaggingPresetItems.getType(string);
        }

        public void setRequisite(String string) throws SAXException {
            if ("required".equals(string)) {
                this.required = true;
            } else if (!"optional".equals(string)) {
                throw new SAXException(I18n.tr("Unknown requisite: {0}", string));
            }
        }

        public void setMember_expression(String string) throws SAXException {
            try {
                this.memberExpression = SearchCompiler.compile(string, true, true);
            }
            catch (SearchCompiler.ParseError parseError) {
                throw new SAXException(I18n.tr("Illegal member expression: {0}", parseError.getMessage()), parseError);
            }
        }

        public long getValidCount(long l) {
            if (this.count > 0L && !this.required) {
                return l != 0L ? this.count : 0L;
            }
            if (this.count > 0L) {
                return this.count;
            }
            if (!this.required) {
                return l != 0L ? l : 0L;
            }
            return l != 0L ? l : 1L;
        }

        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            String string = this.count > 0L && !this.required ? "0," + this.count : (this.count > 0L ? String.valueOf(this.count) : (!this.required ? "0-..." : "1-..."));
            if (this.locale_text == null && this.text != null) {
                this.locale_text = this.text_context != null ? I18n.trc(this.text_context, TaggingPresetItems.fixPresetString(this.text)) : I18n.tr(TaggingPresetItems.fixPresetString(this.text), new Object[0]);
            }
            jPanel.add((Component)new JLabel(this.locale_text + ":"), GBC.std().insets(0, 0, 10, 0));
            jPanel.add((Component)new JLabel(this.key), GBC.std().insets(0, 0, 10, 0));
            jPanel.add((Component)new JLabel(string), this.types == null ? GBC.eol() : GBC.std().insets(0, 0, 10, 0));
            if (this.types != null) {
                JPanel jPanel2 = new JPanel();
                for (TaggingPresetType taggingPresetType : this.types) {
                    jPanel2.add(new JLabel(ImageProvider.get(taggingPresetType.getIconName())));
                }
                jPanel.add((Component)jPanel2, GBC.eol());
            }
            return true;
        }
    }

    public static class PresetListEntry {
        public String value;
        public String value_context;
        public String display_value;
        public String short_description;
        public String icon;
        public String icon_size;
        public String locale_display_value;
        public String locale_short_description;
        private final File zipIcons = TaggingPresetReader.getZipIcons();
        private int prefferedWidth = -1;
        private int prefferedHeight = -1;

        public String getListDisplay() {
            if (this.value.equals(DIFFERENT)) {
                return "<b>" + DIFFERENT.replaceAll("<", "&lt;").replaceAll(">", "&gt;") + "</b>";
            }
            if (this.value.isEmpty()) {
                return "&nbsp;";
            }
            StringBuilder stringBuilder = new StringBuilder("<b>");
            stringBuilder.append(this.getDisplayValue(true));
            stringBuilder.append("</b>");
            if (this.getShortDescription(true) != null) {
                stringBuilder.append("<div style=\"width:300px; padding:0 0 5px 5px\">");
                stringBuilder.append(this.getShortDescription(true));
                stringBuilder.append("</div>");
            }
            return stringBuilder.toString();
        }

        public ImageIcon getIcon() {
            return this.icon == null ? null : TaggingPresetItems.loadImageIcon(this.icon, this.zipIcons, this.parseInteger(this.icon_size));
        }

        private Integer parseInteger(String string) {
            if (string == null || string.isEmpty()) {
                return null;
            }
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public PresetListEntry() {
        }

        public PresetListEntry(String string) {
            this.value = string;
        }

        public String getDisplayValue(boolean bl) {
            return bl ? Utils.firstNonNull(this.locale_display_value, I18n.tr(this.display_value, new Object[0]), I18n.trc(this.value_context, this.value)) : Utils.firstNonNull(this.display_value, this.value);
        }

        public String getShortDescription(boolean bl) {
            return bl ? Utils.firstNonNull(this.locale_short_description, I18n.tr(this.short_description, new Object[0])) : this.short_description;
        }

        public String toString() {
            if (this.value.equals(DIFFERENT)) {
                return DIFFERENT;
            }
            return this.getDisplayValue(true).replaceAll("<.*>", "");
        }
    }
}

