/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;

public class TagCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    protected AutoCompletingTextField editor = new AutoCompletingTextField();
    protected TagModel currentTag = null;
    protected AutoCompletionManager autocomplete = null;
    protected AutoCompletionList autoCompletionList = null;

    public TagCellEditor() {
        this.editor.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
    }

    protected void initAutoCompletionListForKeys(TagEditorModel tagEditorModel, TagModel tagModel) {
        if (this.autoCompletionList == null) {
            return;
        }
        this.autoCompletionList.clear();
        this.autocomplete.populateWithKeys(this.autoCompletionList);
        for (String string : tagEditorModel.getKeys()) {
            if (string.equals(tagModel.getName())) continue;
            this.autoCompletionList.remove(string);
        }
        this.autoCompletionList.fireTableDataChanged();
    }

    protected void initAutoCompletionListForValues(String string) {
        if (this.autoCompletionList == null) {
            return;
        }
        this.autoCompletionList.clear();
        this.autocomplete.populateWithTagValues(this.autoCompletionList, string);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.currentTag = (TagModel)object;
        if (this.autoCompletionList != null) {
            this.autoCompletionList.clear();
        }
        if (n2 == 0) {
            this.editor.setText(this.currentTag.getName());
            TagEditorModel tagEditorModel = (TagEditorModel)jTable.getModel();
            this.initAutoCompletionListForKeys(tagEditorModel, this.currentTag);
            return this.editor;
        }
        if (n2 == 1) {
            if (this.currentTag.getValueCount() == 0) {
                this.editor.setText("");
            } else if (this.currentTag.getValueCount() == 1) {
                this.editor.setText(this.currentTag.getValues().get(0));
            } else {
                this.editor.setText("");
            }
            this.initAutoCompletionListForValues(this.currentTag.getName());
            return this.editor;
        }
        return null;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getText();
    }

    public AutoCompletionList getAutoCompletionList() {
        return this.autoCompletionList;
    }

    public void setAutoCompletionList(AutoCompletionList autoCompletionList) {
        this.autoCompletionList = autoCompletionList;
        this.editor.setAutoCompletionList(autoCompletionList);
    }

    public void setAutoCompletionManager(AutoCompletionManager autoCompletionManager) {
        this.autocomplete = autoCompletionManager;
    }

    public void autoCompletionItemSelected(String string) {
        this.editor.setText(string);
        this.editor.selectAll();
        this.editor.requestFocus();
    }

    public AutoCompletingTextField getEditor() {
        return this.editor;
    }
}

