/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.progress;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.openstreetmap.josm.gui.progress.CancelHandler;
import org.openstreetmap.josm.gui.progress.ChildProgress;
import org.openstreetmap.josm.gui.progress.ProgressException;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;

public abstract class AbstractProgressMonitor
implements ProgressMonitor {
    private final CancelHandler cancelHandler;
    protected State state = State.INIT;
    int ticksCount;
    int ticks;
    private int childTicks;
    private String taskTitle;
    private String customText;
    private String extraText;
    private String shownTitle;
    private String shownCustomText;
    private boolean intermediateTask;
    private Queue<Request> requests = new LinkedList<Request>();
    private AbstractProgressMonitor currentChild;
    private Request requestedState = new Request();

    protected abstract void doBeginTask();

    protected abstract void doFinishTask();

    protected abstract void doSetIntermediate(boolean var1);

    protected abstract void doSetTitle(String var1);

    protected abstract void doSetCustomText(String var1);

    protected AbstractProgressMonitor(CancelHandler cancelHandler) {
        this.cancelHandler = cancelHandler;
    }

    protected void checkState(State ... stateArray) {
        for (State state : stateArray) {
            if (state != this.state) continue;
            return;
        }
        throw new ProgressException("Expected states are %s but current state is %s", new Object[]{Arrays.asList(stateArray).toString(), this.state});
    }

    @Override
    public void beginTask(String string) {
        this.beginTask(string, 10000);
    }

    @Override
    public synchronized void beginTask(String string, int n) {
        this.taskTitle = string;
        this.checkState(State.INIT);
        this.state = State.IN_TASK;
        this.doBeginTask();
        this.setTicksCount(n);
        this.resetState();
    }

    @Override
    public synchronized void finishTask() {
        if (this.state != State.FINISHED) {
            if (this.state == State.IN_SUBTASK) {
                this.requestedState.finishRequested = true;
            } else {
                this.checkState(State.IN_TASK);
                this.state = State.FINISHED;
                this.doFinishTask();
            }
        }
    }

    @Override
    public synchronized void invalidate() {
        if (this.state == State.INIT) {
            this.state = State.FINISHED;
            this.doFinishTask();
        }
    }

    @Override
    public synchronized void subTask(String string) {
        if (this.state == State.IN_SUBTASK) {
            if (string != null) {
                this.requestedState.title = string;
            }
            this.requestedState.intermediate = false;
        } else {
            this.checkState(State.IN_TASK);
            if (string != null) {
                this.taskTitle = string;
                this.resetState();
            }
            this.intermediateTask = false;
            this.doSetIntermediate(false);
        }
    }

    @Override
    public synchronized void indeterminateSubTask(String string) {
        if (this.state == State.IN_SUBTASK) {
            if (string != null) {
                this.requestedState.title = string;
            }
            this.requestedState.intermediate = true;
        } else {
            this.checkState(State.IN_TASK);
            if (string != null) {
                this.taskTitle = string;
                this.resetState();
            }
            this.intermediateTask = true;
            this.doSetIntermediate(true);
        }
    }

    @Override
    public synchronized void setCustomText(String string) {
        if (this.state == State.IN_SUBTASK) {
            this.requestedState.customText = string;
        } else {
            this.customText = string;
            this.resetState();
        }
    }

    @Override
    public synchronized void setExtraText(String string) {
        if (this.state == State.IN_SUBTASK) {
            this.requestedState.extraText = string;
        } else {
            this.extraText = string;
            this.resetState();
        }
    }

    @Override
    public void appendLogMessage(String string) {
    }

    private void resetState() {
        String string = this.extraText != null ? this.taskTitle + " " + this.extraText : this.taskTitle;
        if (string == null ? this.shownTitle != null : !string.equals(this.shownTitle)) {
            this.shownTitle = string;
            this.doSetTitle(this.shownTitle);
        }
        if (this.customText == null ? this.shownCustomText != null : !this.customText.equals(this.shownCustomText)) {
            this.shownCustomText = this.customText;
            this.doSetCustomText(this.shownCustomText);
        }
        this.doSetIntermediate(this.intermediateTask);
    }

    @Override
    public void cancel() {
        this.cancelHandler.cancel();
    }

    @Override
    public boolean isCanceled() {
        return this.cancelHandler.isCanceled();
    }

    @Override
    public void addCancelListener(ProgressMonitor.CancelListener cancelListener) {
        this.cancelHandler.addCancelListener(cancelListener);
    }

    @Override
    public void removeCancelListener(ProgressMonitor.CancelListener cancelListener) {
        this.cancelHandler.removeCancelListener(cancelListener);
    }

    abstract void updateProgress(double var1);

    @Override
    public synchronized void setTicks(int n) {
        if (n >= this.ticksCount) {
            n = this.ticksCount - 1;
        }
        this.ticks = n;
        this.internalUpdateProgress(0.0);
    }

    @Override
    public synchronized void setTicksCount(int n) {
        this.ticksCount = n;
        this.internalUpdateProgress(0.0);
    }

    @Override
    public void worked(int n) {
        if (n == -1) {
            this.setTicks(this.ticksCount - 1);
        } else {
            this.setTicks(this.ticks + n);
        }
    }

    private void internalUpdateProgress(double d) {
        if (d > 1.0) {
            d = 1.0;
        }
        this.checkState(State.IN_TASK, State.IN_SUBTASK);
        this.updateProgress(this.ticksCount == 0 ? 0.0 : ((double)this.ticks + d * (double)this.childTicks) / (double)this.ticksCount);
    }

    @Override
    public synchronized int getTicks() {
        return this.ticks;
    }

    @Override
    public synchronized int getTicksCount() {
        return this.ticksCount;
    }

    @Override
    public synchronized ProgressMonitor createSubTaskMonitor(int n, boolean bl) {
        if (n == -1) {
            n = this.ticksCount - this.ticks;
        }
        if (this.state == State.IN_SUBTASK) {
            Request request = new Request();
            request.originator = new ChildProgress(this, this.cancelHandler, bl);
            request.childTicks = n;
            this.requests.add(request);
            return request.originator;
        }
        this.checkState(State.IN_TASK);
        this.state = State.IN_SUBTASK;
        this.childTicks = n;
        this.currentChild = new ChildProgress(this, this.cancelHandler, bl);
        return this.currentChild;
    }

    private void applyChildRequest(Request request) {
        if (request.customText != null) {
            this.doSetCustomText(request.customText);
        }
        if (request.title != null) {
            this.doSetTitle(request.title);
        }
        if (request.intermediate != null) {
            this.doSetIntermediate(request.intermediate);
        }
        this.internalUpdateProgress(request.currentValue);
    }

    private void applyThisRequest(Request request) {
        if (request.finishRequested) {
            this.finishTask();
        } else {
            if (request.customText != null) {
                this.customText = request.customText;
            }
            if (request.title != null) {
                this.taskTitle = request.title;
            }
            if (request.intermediate != null) {
                this.intermediateTask = request.intermediate;
            }
            if (request.extraText != null) {
                this.extraText = request.extraText;
            }
            this.resetState();
        }
    }

    protected synchronized void childFinished(AbstractProgressMonitor abstractProgressMonitor) {
        this.checkState(State.IN_SUBTASK);
        if (this.currentChild == abstractProgressMonitor) {
            this.setTicks(this.ticks + this.childTicks);
            if (this.requests.isEmpty()) {
                this.state = State.IN_TASK;
                this.applyThisRequest(this.requestedState);
                this.requestedState = new Request();
            } else {
                Request request = this.requests.poll();
                this.currentChild = request.originator;
                this.childTicks = request.childTicks;
                this.applyChildRequest(request);
            }
        } else {
            Iterator iterator = this.requests.iterator();
            while (iterator.hasNext()) {
                if (((Request)iterator.next()).originator != abstractProgressMonitor) continue;
                iterator.remove();
                return;
            }
            throw new ProgressException("Subtask %s not found", abstractProgressMonitor);
        }
    }

    private Request getRequest(AbstractProgressMonitor abstractProgressMonitor) {
        for (Request request : this.requests) {
            if (request.originator != abstractProgressMonitor) continue;
            return request;
        }
        throw new ProgressException("Subtask %s not found", abstractProgressMonitor);
    }

    protected synchronized void childSetProgress(AbstractProgressMonitor abstractProgressMonitor, double d) {
        this.checkState(State.IN_SUBTASK);
        if (this.currentChild == abstractProgressMonitor) {
            this.internalUpdateProgress(d);
        } else {
            this.getRequest((AbstractProgressMonitor)abstractProgressMonitor).currentValue = d;
        }
    }

    protected synchronized void childSetTitle(AbstractProgressMonitor abstractProgressMonitor, String string) {
        this.checkState(State.IN_SUBTASK);
        if (this.currentChild == abstractProgressMonitor) {
            this.doSetTitle(string);
        } else {
            this.getRequest((AbstractProgressMonitor)abstractProgressMonitor).title = string;
        }
    }

    protected synchronized void childSetCustomText(AbstractProgressMonitor abstractProgressMonitor, String string) {
        this.checkState(State.IN_SUBTASK);
        if (this.currentChild == abstractProgressMonitor) {
            this.doSetCustomText(string);
        } else {
            this.getRequest((AbstractProgressMonitor)abstractProgressMonitor).customText = string;
        }
    }

    protected synchronized void childSetIntermediate(AbstractProgressMonitor abstractProgressMonitor, boolean bl) {
        this.checkState(State.IN_SUBTASK);
        if (this.currentChild == abstractProgressMonitor) {
            this.doSetIntermediate(bl);
        } else {
            this.getRequest((AbstractProgressMonitor)abstractProgressMonitor).intermediate = bl;
        }
    }

    protected static enum State {
        INIT,
        IN_TASK,
        IN_SUBTASK,
        FINISHED;

    }

    private static class Request {
        AbstractProgressMonitor originator;
        int childTicks;
        double currentValue;
        String title;
        String customText;
        String extraText;
        Boolean intermediate;
        boolean finishRequested;

        private Request() {
        }
    }
}

