/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.server.OsmApiUrlInputPanel;
import org.openstreetmap.josm.tools.I18n;

public final class ServerAccessPreference
extends DefaultTabPreferenceSetting {
    private OsmApiUrlInputPanel pnlApiUrlPreferences;

    private ServerAccessPreference() {
        super("connection", I18n.tr("Connection Settings", new Object[0]), I18n.tr("Connection Settings for the OSM server.", new Object[0]), false, new JTabbedPane());
    }

    protected JPanel buildTabbedServerPreferences() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.getTabPane(), "Center");
        return jPanel;
    }

    protected JPanel buildContentPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.pnlApiUrlPreferences = new OsmApiUrlInputPanel();
        jPanel.add((Component)this.pnlApiUrlPreferences, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 3, 3);
        jPanel.add((Component)this.buildTabbedServerPreferences(), gridBagConstraints);
        HelpUtil.setHelpContext(jPanel, HelpUtil.ht("/Preferences/Connection"));
        return jPanel;
    }

    public final void addApiUrlChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pnlApiUrlPreferences.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        preferenceTabbedPane.createPreferenceTab(this).add((Component)this.buildContentPanel(), gridBagConstraints);
        this.pnlApiUrlPreferences.initFromPreferences();
    }

    @Override
    public boolean ok() {
        this.pnlApiUrlPreferences.saveToPreferences();
        return false;
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new ServerAccessPreference();
        }
    }
}

