/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.remotecontrol;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.RemoteControl;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public final class RemoteControlPreference
extends DefaultTabPreferenceSetting {
    private final Map<PermissionPrefWithDefault, JCheckBox> prefs = new LinkedHashMap<PermissionPrefWithDefault, JCheckBox>();
    private JCheckBox enableRemoteControl;
    private JCheckBox loadInNewLayer = new JCheckBox(I18n.tr("Download objects to new layer", new Object[0]));
    private JCheckBox alwaysAskUserConfirm = new JCheckBox(I18n.tr("Confirm all Remote Control actions manually", new Object[0]));

    private RemoteControlPreference() {
        super("remotecontrol", I18n.tr("Remote Control", new Object[0]), I18n.tr("Settings for the remote control feature.", new Object[0]));
        for (PermissionPrefWithDefault permissionPrefWithDefault : PermissionPrefWithDefault.getPermissionPrefs()) {
            JCheckBox jCheckBox = new JCheckBox(permissionPrefWithDefault.preferenceText);
            jCheckBox.setSelected(permissionPrefWithDefault.isAllowed());
            this.prefs.put(permissionPrefWithDefault, jCheckBox);
        }
    }

    @Override
    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel("<html>" + I18n.tr("Allows JOSM to be controlled from other applications, e.g. from a web browser.", new Object[0]) + "</html>");
        jLabel.setFont(jLabel.getFont().deriveFont(0));
        jPanel.add((Component)jLabel, GBC.eol().insets(5, 5, 0, 10).fill(2));
        JLabel jLabel2 = new JLabel("<html>" + I18n.tr("JOSM will always listen at <b>port {0}</b> (http) and <b>port {1}</b> (https) on localhost.<br>These ports are not configurable because they are referenced by external applications talking to JOSM.", Main.pref.get("remote.control.port", "8111"), Main.pref.get("remote.control.https.port", "8112")) + "</html>");
        jLabel2.setFont(jLabel2.getFont().deriveFont(0));
        jPanel.add((Component)jLabel2, GBC.eol().insets(5, 5, 0, 10).fill(2));
        this.enableRemoteControl = new JCheckBox(I18n.tr("Enable remote control", new Object[0]), (boolean)RemoteControl.PROP_REMOTECONTROL_ENABLED.get());
        jPanel.add((Component)this.enableRemoteControl, GBC.eol());
        final JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray)));
        jPanel.add((Component)jPanel2, GBC.eol().fill(2).insets(5, 5, 5, 5));
        jPanel2.add((Component)new JLabel(I18n.tr("Permitted actions:", new Object[0])), GBC.eol());
        for (JCheckBox jCheckBox : this.prefs.values()) {
            jPanel2.add((Component)jCheckBox, GBC.eol().insets(15, 5, 0, 0).fill(2));
        }
        jPanel2.add((Component)new JSeparator(), GBC.eop().fill(2).insets(15, 5, 15, 5));
        jPanel2.add((Component)this.loadInNewLayer, GBC.eol().fill(2));
        jPanel2.add((Component)this.alwaysAskUserConfirm, GBC.eol().fill(2));
        jPanel.add(Box.createVerticalGlue(), GBC.eol().fill(3));
        this.loadInNewLayer.setSelected(Main.pref.getBoolean("remotecontrol.new-layer", false));
        this.alwaysAskUserConfirm.setSelected(Main.pref.getBoolean("remotecontrol.always-confirm", false));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GuiHelper.setEnabledRec(jPanel2, RemoteControlPreference.this.enableRemoteControl.isSelected());
            }
        };
        this.enableRemoteControl.addActionListener(actionListener);
        actionListener.actionPerformed(null);
        this.createPreferenceTabWithScrollPane(preferenceTabbedPane, jPanel);
    }

    @Override
    public boolean ok() {
        boolean bl = this.enableRemoteControl.isSelected();
        boolean bl2 = RemoteControl.PROP_REMOTECONTROL_ENABLED.put(bl);
        if (bl) {
            for (Map.Entry<PermissionPrefWithDefault, JCheckBox> entry : this.prefs.entrySet()) {
                Main.pref.put(entry.getKey().pref, entry.getValue().isSelected());
            }
            Main.pref.put("remotecontrol.new-layer", this.loadInNewLayer.isSelected());
            Main.pref.put("remotecontrol.always-confirm", this.alwaysAskUserConfirm.isSelected());
        }
        if (bl2) {
            if (bl) {
                RemoteControl.start();
            } else {
                RemoteControl.stop();
            }
        }
        return false;
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new RemoteControlPreference();
        }
    }
}

