/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.audio;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public final class AudioPreference
extends DefaultTabPreferenceSetting {
    private JCheckBox audioMenuVisible = new JCheckBox(I18n.tr("Display the Audio menu.", new Object[0]));
    private JCheckBox markerButtonLabels = new JCheckBox(I18n.tr("Label audio (and image and web) markers.", new Object[0]));
    private JCheckBox markerAudioTraceVisible = new JCheckBox(I18n.tr("Display live audio trace.", new Object[0]));
    private JCheckBox audioMarkersFromExplicitWaypoints = new JCheckBox(I18n.tr("Explicit waypoints with valid timestamps.", new Object[0]));
    private JCheckBox audioMarkersFromUntimedWaypoints = new JCheckBox(I18n.tr("Explicit waypoints with time estimated from track position.", new Object[0]));
    private JCheckBox audioMarkersFromNamedTrackpoints = new JCheckBox(I18n.tr("Named trackpoints.", new Object[0]));
    private JCheckBox audioMarkersFromWavTimestamps = new JCheckBox(I18n.tr("Modified times (time stamps) of audio files.", new Object[0]));
    private JCheckBox audioMarkersFromStart = new JCheckBox(I18n.tr("Start of track (will always do this if no other markers available).", new Object[0]));
    private JosmTextField audioLeadIn = new JosmTextField(8);
    private JosmTextField audioForwardBackAmount = new JosmTextField(8);
    private JosmTextField audioFastForwardMultiplier = new JosmTextField(8);
    private JosmTextField audioCalibration = new JosmTextField(8);

    private AudioPreference() {
        super("audio", I18n.tr("Audio Settings", new Object[0]), I18n.tr("Settings for the audio player and audio markers.", new Object[0]));
    }

    @Override
    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.audioMenuVisible.setSelected(!Main.pref.getBoolean("audio.menuinvisible"));
        this.audioMenuVisible.setToolTipText(I18n.tr("Show or hide the audio menu entry on the main menu bar.", new Object[0]));
        jPanel.add((Component)this.audioMenuVisible, GBC.eol().insets(0, 0, 0, 0));
        this.markerAudioTraceVisible.setSelected(Main.pref.getBoolean("marker.traceaudio", true));
        this.markerAudioTraceVisible.setToolTipText(I18n.tr("Display a moving icon representing the point on the synchronized track where the audio currently playing was recorded.", new Object[0]));
        jPanel.add((Component)this.markerAudioTraceVisible, GBC.eol().insets(0, 0, 0, 0));
        this.markerButtonLabels.setSelected(Main.pref.getBoolean("marker.buttonlabels", true));
        this.markerButtonLabels.setToolTipText(I18n.tr("Put text labels against audio (and image and web) markers as well as their button icons.", new Object[0]));
        jPanel.add((Component)this.markerButtonLabels, GBC.eol().insets(0, 0, 0, 0));
        jPanel.add((Component)new JLabel(I18n.tr("When importing audio, make markers from...", new Object[0])), GBC.eol());
        this.audioMarkersFromExplicitWaypoints.setSelected(Main.pref.getBoolean("marker.audiofromexplicitwaypoints", true));
        this.audioMarkersFromExplicitWaypoints.setToolTipText(I18n.tr("When importing audio, apply it to any waypoints in the GPX layer.", new Object[0]));
        jPanel.add((Component)this.audioMarkersFromExplicitWaypoints, GBC.eol().insets(10, 0, 0, 0));
        this.audioMarkersFromUntimedWaypoints.setSelected(Main.pref.getBoolean("marker.audiofromuntimedwaypoints", true));
        this.audioMarkersFromUntimedWaypoints.setToolTipText(I18n.tr("When importing audio, apply it to any waypoints in the GPX layer.", new Object[0]));
        jPanel.add((Component)this.audioMarkersFromUntimedWaypoints, GBC.eol().insets(10, 0, 0, 0));
        this.audioMarkersFromNamedTrackpoints.setSelected(Main.pref.getBoolean("marker.audiofromnamedtrackpoints", false));
        this.audioMarkersFromNamedTrackpoints.setToolTipText(I18n.tr("Automatically create audio markers from trackpoints (rather than explicit waypoints) with names or descriptions.", new Object[0]));
        jPanel.add((Component)this.audioMarkersFromNamedTrackpoints, GBC.eol().insets(10, 0, 0, 0));
        this.audioMarkersFromWavTimestamps.setSelected(Main.pref.getBoolean("marker.audiofromwavtimestamps", false));
        this.audioMarkersFromWavTimestamps.setToolTipText(I18n.tr("Create audio markers at the position on the track corresponding to the modified time of each audio WAV file imported.", new Object[0]));
        jPanel.add((Component)this.audioMarkersFromWavTimestamps, GBC.eol().insets(10, 0, 0, 0));
        this.audioMarkersFromStart.setSelected(Main.pref.getBoolean("marker.audiofromstart"));
        this.audioMarkersFromStart.setToolTipText(I18n.tr("Automatically create audio markers from trackpoints (rather than explicit waypoints) with names or descriptions.", new Object[0]));
        jPanel.add((Component)this.audioMarkersFromStart, GBC.eol().insets(10, 0, 0, 0));
        this.audioForwardBackAmount.setText(Main.pref.get("audio.forwardbackamount", "10.0"));
        this.audioForwardBackAmount.setToolTipText(I18n.tr("The number of seconds to jump forward or back when the relevant button is pressed", new Object[0]));
        jPanel.add((Component)new JLabel(I18n.tr("Forward/back time (seconds)", new Object[0])), GBC.std());
        jPanel.add((Component)this.audioForwardBackAmount, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.audioFastForwardMultiplier.setText(Main.pref.get("audio.fastfwdmultiplier", "1.3"));
        this.audioFastForwardMultiplier.setToolTipText(I18n.tr("The amount by which the speed is multiplied for fast forwarding", new Object[0]));
        jPanel.add((Component)new JLabel(I18n.tr("Fast forward multiplier", new Object[0])), GBC.std());
        jPanel.add((Component)this.audioFastForwardMultiplier, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.audioLeadIn.setText(Main.pref.get("audio.leadin", "1.0"));
        this.audioLeadIn.setToolTipText(I18n.tr("Playback starts this number of seconds before (or after, if negative) the audio track position requested", new Object[0]));
        jPanel.add((Component)new JLabel(I18n.tr("Lead-in time (seconds)", new Object[0])), GBC.std());
        jPanel.add((Component)this.audioLeadIn, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.audioCalibration.setText(Main.pref.get("audio.calibration", "1.0"));
        this.audioCalibration.setToolTipText(I18n.tr("The ratio of voice recorder elapsed time to true elapsed time", new Object[0]));
        jPanel.add((Component)new JLabel(I18n.tr("Voice recorder calibration", new Object[0])), GBC.std());
        jPanel.add((Component)this.audioCalibration, GBC.eol().fill(2).insets(5, 0, 0, 5));
        jPanel.add(Box.createVerticalGlue(), GBC.eol().fill(3));
        this.createPreferenceTabWithScrollPane(preferenceTabbedPane, jPanel);
    }

    @Override
    public boolean ok() {
        Main.pref.put("audio.menuinvisible", !this.audioMenuVisible.isSelected());
        Main.pref.put("marker.traceaudio", this.markerAudioTraceVisible.isSelected());
        Main.pref.put("marker.buttonlabels", this.markerButtonLabels.isSelected());
        Main.pref.put("marker.audiofromexplicitwaypoints", this.audioMarkersFromExplicitWaypoints.isSelected());
        Main.pref.put("marker.audiofromuntimedwaypoints", this.audioMarkersFromUntimedWaypoints.isSelected());
        Main.pref.put("marker.audiofromnamedtrackpoints", this.audioMarkersFromNamedTrackpoints.isSelected());
        Main.pref.put("marker.audiofromwavtimestamps", this.audioMarkersFromWavTimestamps.isSelected());
        Main.pref.put("marker.audiofromstart", this.audioMarkersFromStart.isSelected());
        Main.pref.put("audio.forwardbackamount", this.audioForwardBackAmount.getText());
        Main.pref.put("audio.fastfwdmultiplier", this.audioFastForwardMultiplier.getText());
        Main.pref.put("audio.leadin", this.audioLeadIn.getText());
        Main.pref.put("audio.calibration", this.audioCalibration.getText());
        return false;
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new AudioPreference();
        }
    }
}

