/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public interface Selector {
    public boolean matches(Environment var1);

    public String getSubpart();

    public Range getRange();

    public static class GeneralSelector
    extends AbstractSelector {
        public final String base;
        public final Range range;
        public final String subpart;
        static final double R = 6378135.0;

        public GeneralSelector(String string, Pair<Integer, Integer> pair, List<Condition> list, String string2) {
            super(list);
            this.base = string;
            if (pair != null) {
                int n;
                int n2 = pair.a == null ? 0 : (Integer)pair.a;
                int n3 = n = pair.b == null ? Integer.MAX_VALUE : (Integer)pair.b;
                this.range = n2 <= n ? GeneralSelector.fromLevel(n2, n) : Range.ZERO_TO_INFINITY;
            } else {
                this.range = Range.ZERO_TO_INFINITY;
            }
            this.subpart = string2;
        }

        @Override
        public String getSubpart() {
            return this.subpart;
        }

        @Override
        public Range getRange() {
            return this.range;
        }

        public boolean matchesBase(OsmPrimitiveType osmPrimitiveType) {
            if (this.base.equals("*")) {
                return true;
            }
            if (OsmPrimitiveType.NODE.equals((Object)osmPrimitiveType)) {
                return this.base.equals("node");
            }
            if (OsmPrimitiveType.WAY.equals((Object)osmPrimitiveType)) {
                return this.base.equals("way") || this.base.equals("area");
            }
            if (OsmPrimitiveType.RELATION.equals((Object)osmPrimitiveType)) {
                return this.base.equals("area") || this.base.equals("relation") || this.base.equals("canvas");
            }
            return false;
        }

        public boolean matchesBase(OsmPrimitive osmPrimitive) {
            if (!this.matchesBase(osmPrimitive.getType())) {
                return false;
            }
            if (osmPrimitive instanceof Relation) {
                if (this.base.equals("area")) {
                    return ((Relation)osmPrimitive).isMultipolygon();
                }
                if (this.base.equals("canvas")) {
                    return osmPrimitive.get("#canvas") != null;
                }
            }
            return true;
        }

        public boolean matchesBase(Environment environment) {
            return this.matchesBase(environment.osm);
        }

        @Override
        public boolean matches(Environment environment) {
            return this.matchesBase(environment) && this.matchesConditions(environment);
        }

        public String getBase() {
            return this.base;
        }

        public static Range fromLevel(int n, int n2) {
            if (n > n2) {
                throw new AssertionError();
            }
            double d = 0.0;
            double d2 = Double.POSITIVE_INFINITY;
            if (n2 != Integer.MAX_VALUE) {
                d = GeneralSelector.level2scale(n2 + 1);
            }
            if (n != 0) {
                d2 = GeneralSelector.level2scale(n);
            }
            return new Range(d, d2);
        }

        public static double level2scale(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            return 4.0075004119207874E7 / Math.pow(2.0, n) / 2.56;
        }

        public String toString() {
            return this.base + (Range.ZERO_TO_INFINITY.equals(this.range) ? "" : this.range) + Utils.join("", this.conds) + (this.subpart != null ? "::" + this.subpart : "");
        }
    }

    public static class LinkSelector
    extends AbstractSelector {
        public LinkSelector(List<Condition> list) {
            super(list);
        }

        @Override
        public boolean matches(Environment environment) {
            Utils.ensure(environment.isLinkContext(), "Requires LINK context in environment, got ''{0}''", new Object[]{environment.getContext()});
            return this.matchesConditions(environment);
        }

        @Override
        public String getSubpart() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Range getRange() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String toString() {
            return "LinkSelector{conditions=" + this.conds + '}';
        }
    }

    public static abstract class AbstractSelector
    implements Selector {
        protected final List<Condition> conds;

        protected AbstractSelector(List<Condition> list) {
            this.conds = list == null || list.isEmpty() ? null : list;
        }

        public final boolean matchesConditions(Environment environment) {
            if (this.conds == null) {
                return true;
            }
            for (Condition condition : this.conds) {
                try {
                    if (condition.applies(environment)) continue;
                    return false;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    Main.error("PatternSyntaxException while applying condition" + condition + ": " + patternSyntaxException.getMessage());
                    return false;
                }
            }
            return true;
        }

        public List<Condition> getConditions() {
            if (this.conds == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.conds);
        }
    }

    public static class ChildOrParentSelector
    implements Selector {
        public final Selector left;
        public final LinkSelector link;
        public final Selector right;
        public final ChildOrParentSelectorType type;

        public ChildOrParentSelector(Selector selector, LinkSelector linkSelector, Selector selector2, ChildOrParentSelectorType childOrParentSelectorType) {
            this.left = selector;
            this.link = linkSelector;
            this.right = selector2;
            this.type = childOrParentSelectorType;
        }

        @Override
        public boolean matches(Environment environment) {
            block20: {
                block19: {
                    if (!this.right.matches(environment)) {
                        return false;
                    }
                    if (ChildOrParentSelectorType.ELEMENT_OF.equals((Object)this.type)) {
                        if (environment.osm instanceof Node || environment.osm.getDataSet() == null) {
                            return false;
                        }
                        environment.parent = environment.osm;
                        ContainsFinder containsFinder = new ContainsFinder(environment);
                        if (this.right instanceof GeneralSelector) {
                            if (((GeneralSelector)this.right).matchesBase(OsmPrimitiveType.NODE)) {
                                containsFinder.visit(environment.osm.getDataSet().searchNodes(environment.osm.getBBox()));
                            }
                            if (((GeneralSelector)this.right).matchesBase(OsmPrimitiveType.WAY)) {
                                containsFinder.visit(environment.osm.getDataSet().searchWays(environment.osm.getBBox()));
                            }
                        } else {
                            containsFinder.visit(environment.osm.getDataSet().allPrimitives());
                        }
                        return environment.child != null;
                    }
                    if (ChildOrParentSelectorType.CROSSING.equals((Object)this.type) && environment.osm instanceof Way) {
                        environment.parent = environment.osm;
                        CrossingFinder crossingFinder = new CrossingFinder(environment);
                        if (((GeneralSelector)this.right).matchesBase(OsmPrimitiveType.WAY)) {
                            crossingFinder.visit(environment.osm.getDataSet().searchWays(environment.osm.getBBox()));
                        }
                        return environment.child != null;
                    }
                    if (!ChildOrParentSelectorType.SIBLING.equals((Object)this.type)) break block19;
                    if (!(environment.osm instanceof Node)) break block20;
                    for (Way way : Utils.filteredCollection(environment.osm.getReferrers(true), Way.class)) {
                        Node node;
                        Environment environment2;
                        int n = way.getNodes().indexOf(environment.osm);
                        if (n - 1 < 0 || !this.left.matches(environment2 = environment.withPrimitive(node = way.getNode(n - 1)).withParent(way).withChild(environment.osm)) || !this.link.matches(environment2.withLinkContext())) continue;
                        environment.child = node;
                        environment.index = n;
                        environment.parent = way;
                        return true;
                    }
                    break block20;
                }
                if (ChildOrParentSelectorType.CHILD.equals((Object)this.type)) {
                    MatchingReferrerFinder matchingReferrerFinder = new MatchingReferrerFinder(environment);
                    environment.osm.visitReferrers(matchingReferrerFinder);
                    if (environment.parent != null) {
                        return true;
                    }
                } else if (ChildOrParentSelectorType.PARENT.equals((Object)this.type)) {
                    if (environment.osm instanceof Way) {
                        List<Node> list = ((Way)environment.osm).getNodes();
                        for (int i = 0; i < list.size(); ++i) {
                            Node node = list.get(i);
                            if (!this.left.matches(environment.withPrimitive(node)) || !this.link.matches(environment.withChildAndIndexAndLinkContext(node, i))) continue;
                            environment.child = node;
                            environment.index = i;
                            return true;
                        }
                    } else if (environment.osm instanceof Relation) {
                        List<RelationMember> list = ((Relation)environment.osm).getMembers();
                        for (int i = 0; i < list.size(); ++i) {
                            OsmPrimitive osmPrimitive = list.get(i).getMember();
                            if (!this.left.matches(environment.withPrimitive(osmPrimitive)) || !this.link.matches(environment.withChildAndIndexAndLinkContext(osmPrimitive, i))) continue;
                            environment.child = osmPrimitive;
                            environment.index = i;
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        @Override
        public String getSubpart() {
            return this.right.getSubpart();
        }

        @Override
        public Range getRange() {
            return this.right.getRange();
        }

        public String toString() {
            return this.left + " " + (ChildOrParentSelectorType.PARENT.equals((Object)this.type) ? "<" : ">") + this.link + " " + this.right;
        }

        private final class ContainsFinder
        extends AbstractFinder {
            private ContainsFinder(Environment environment) {
                super(environment);
                CheckParameterUtil.ensureThat(!(environment.osm instanceof Node), "Nodes not supported");
            }

            @Override
            public void visit(Node node) {
                if (this.e.child == null && ChildOrParentSelector.this.left.matches(this.e.withPrimitive(node)) && (this.e.osm instanceof Way && Geometry.nodeInsidePolygon(node, ((Way)this.e.osm).getNodes()) || this.e.osm instanceof Relation && ((Relation)this.e.osm).isMultipolygon() && Geometry.isNodeInsideMultiPolygon(node, (Relation)this.e.osm, null))) {
                    this.e.child = node;
                }
            }

            @Override
            public void visit(Way way) {
                if (this.e.child == null && ChildOrParentSelector.this.left.matches(this.e.withPrimitive(way)) && (this.e.osm instanceof Way && Geometry.PolygonIntersection.FIRST_INSIDE_SECOND.equals((Object)Geometry.polygonIntersection(way.getNodes(), ((Way)this.e.osm).getNodes())) || this.e.osm instanceof Relation && ((Relation)this.e.osm).isMultipolygon() && Geometry.isPolygonInsideMultiPolygon(way.getNodes(), (Relation)this.e.osm, null))) {
                    this.e.child = way;
                }
            }
        }

        private final class CrossingFinder
        extends AbstractFinder {
            private CrossingFinder(Environment environment) {
                super(environment);
                CheckParameterUtil.ensureThat(environment.osm instanceof Way, "Only ways are supported");
            }

            @Override
            public void visit(Way way) {
                if (this.e.child == null && ChildOrParentSelector.this.left.matches(this.e.withPrimitive(way)) && this.e.osm instanceof Way && Geometry.PolygonIntersection.CROSSING.equals((Object)Geometry.polygonIntersection(way.getNodes(), ((Way)this.e.osm).getNodes()))) {
                    this.e.child = way;
                }
            }
        }

        private abstract class AbstractFinder
        extends AbstractVisitor {
            protected final Environment e;

            protected AbstractFinder(Environment environment) {
                this.e = environment;
            }

            @Override
            public void visit(Node node) {
            }

            @Override
            public void visit(Way way) {
            }

            @Override
            public void visit(Relation relation) {
            }

            public void visit(Collection<? extends OsmPrimitive> collection) {
                for (OsmPrimitive osmPrimitive : collection) {
                    if (this.e.child != null) break;
                    if (this.e.osm.equals(osmPrimitive) || !osmPrimitive.isUsable()) continue;
                    osmPrimitive.accept(this);
                }
            }
        }

        private class MatchingReferrerFinder
        extends AbstractVisitor {
            private Environment e;

            public MatchingReferrerFinder(Environment environment) {
                this.e = environment;
            }

            @Override
            public void visit(Node node) {
                throw new AssertionError();
            }

            @Override
            public void visit(Way way) {
                if (this.e.parent != null) {
                    return;
                }
                if (!ChildOrParentSelector.this.left.matches(this.e.withPrimitive(way))) {
                    return;
                }
                for (int i = 0; i < way.getNodesCount(); ++i) {
                    Node node = way.getNode(i);
                    if (!node.equals(this.e.osm) || !ChildOrParentSelector.this.link.matches(this.e.withParentAndIndexAndLinkContext(way, i))) continue;
                    this.e.parent = way;
                    this.e.index = i;
                    return;
                }
            }

            @Override
            public void visit(Relation relation) {
                if (this.e.parent != null) {
                    return;
                }
                if (!ChildOrParentSelector.this.left.matches(this.e.withPrimitive(relation))) {
                    return;
                }
                for (int i = 0; i < relation.getMembersCount(); ++i) {
                    RelationMember relationMember = relation.getMember(i);
                    if (!relationMember.getMember().equals(this.e.osm) || !ChildOrParentSelector.this.link.matches(this.e.withParentAndIndexAndLinkContext(relation, i))) continue;
                    this.e.parent = relation;
                    this.e.index = i;
                    return;
                }
            }
        }
    }

    public static enum ChildOrParentSelectorType {
        CHILD,
        PARENT,
        ELEMENT_OF,
        CROSSING,
        SIBLING;

    }
}

