/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.awt.Color;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public final class ExpressionFactory {
    private static final List<Method> arrayFunctions;
    private static final List<Method> parameterFunctions;
    private static final Functions FUNCTIONS_INSTANCE;

    private ExpressionFactory() {
    }

    public static Expression createFunctionExpression(String string, List<Expression> list) {
        if (Utils.equal(string, "cond") && list.size() == 3) {
            return new CondOperator(list.get(0), list.get(1), list.get(2));
        }
        if (Utils.equal(string, "and")) {
            return new AndOperator(list);
        }
        if (Utils.equal(string, "or")) {
            return new OrOperator(list);
        }
        if (Utils.equal(string, "length") && list.size() == 1) {
            return new LengthFunction(list.get(0));
        }
        for (Method method : arrayFunctions) {
            if (!method.getName().equals(string)) continue;
            return new ArrayFunction(method, list);
        }
        for (Method method : parameterFunctions) {
            if (!method.getName().equals(string) || list.size() != method.getParameterTypes().length) continue;
            return new ParameterFunction(method, list);
        }
        return NullExpression.INSTANCE;
    }

    static {
        FUNCTIONS_INSTANCE = new Functions();
        arrayFunctions = new ArrayList<Method>();
        parameterFunctions = new ArrayList<Method>();
        for (Method method : Functions.class.getDeclaredMethods()) {
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length == 1 && classArray[0].isArray()) {
                arrayFunctions.add(method);
                continue;
            }
            parameterFunctions.add(method);
        }
        try {
            parameterFunctions.add(Math.class.getMethod("abs", Float.TYPE));
            parameterFunctions.add(Math.class.getMethod("acos", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("asin", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("atan", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("atan2", Double.TYPE, Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("ceil", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("cos", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("cosh", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("exp", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("floor", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("log", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("max", Float.TYPE, Float.TYPE));
            parameterFunctions.add(Math.class.getMethod("min", Float.TYPE, Float.TYPE));
            parameterFunctions.add(Math.class.getMethod("random", new Class[0]));
            parameterFunctions.add(Math.class.getMethod("round", Float.TYPE));
            parameterFunctions.add(Math.class.getMethod("signum", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("sin", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("sinh", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("sqrt", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("tan", Double.TYPE));
            parameterFunctions.add(Math.class.getMethod("tanh", Double.TYPE));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
    }

    public static class ArrayFunction
    implements Expression {
        private final Method m;
        private final List<Expression> args;
        private final Class<?> arrayComponentType;
        private final Object[] convertedArgs;

        public ArrayFunction(Method method, List<Expression> list) {
            this.m = method;
            this.args = list;
            Class<?>[] classArray = method.getParameterTypes();
            this.convertedArgs = new Object[classArray.length];
            this.arrayComponentType = classArray[0].getComponentType();
        }

        @Override
        public Object evaluate(Environment environment) {
            Object object = Array.newInstance(this.arrayComponentType, this.args.size());
            for (int i = 0; i < this.args.size(); ++i) {
                Object obj = Cascade.convertTo(this.args.get(i).evaluate(environment), this.arrayComponentType);
                if (obj == null && this.m.getAnnotation(NullableArguments.class) == null) {
                    return null;
                }
                Array.set(object, i, obj);
            }
            this.convertedArgs[0] = object;
            Object object2 = null;
            try {
                object2 = this.m.invoke(null, this.convertedArgs);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Main.error(invocationTargetException);
                return null;
            }
            return object2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("ArrayFunction~");
            stringBuilder.append(this.m.getName()).append("(");
            for (int i = 0; i < this.args.size(); ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.arrayComponentType);
                stringBuilder.append(" ").append(this.args.get(i));
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }
    }

    public static class ParameterFunction
    implements Expression {
        private final Method m;
        private final List<Expression> args;
        private final Class<?>[] expectedParameterTypes;

        public ParameterFunction(Method method, List<Expression> list) {
            this.m = method;
            this.args = list;
            this.expectedParameterTypes = method.getParameterTypes();
        }

        @Override
        public Object evaluate(Environment environment) {
            FUNCTIONS_INSTANCE.env = environment;
            Object[] objectArray = new Object[this.expectedParameterTypes.length];
            for (int i = 0; i < this.args.size(); ++i) {
                objectArray[i] = Cascade.convertTo(this.args.get(i).evaluate(environment), this.expectedParameterTypes[i]);
                if (objectArray[i] != null || this.m.getAnnotation(NullableArguments.class) != null) continue;
                return null;
            }
            Object object = null;
            try {
                object = this.m.invoke((Object)FUNCTIONS_INSTANCE, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Main.error(invocationTargetException);
                return null;
            }
            return object;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("ParameterFunction~");
            stringBuilder.append(this.m.getName()).append("(");
            for (int i = 0; i < this.args.size(); ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.expectedParameterTypes[i]);
                stringBuilder.append(" ").append(this.args.get(i));
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }
    }

    public static class LengthFunction
    implements Expression {
        private Expression arg;

        public LengthFunction(Expression expression) {
            this.arg = expression;
        }

        @Override
        public Object evaluate(Environment environment) {
            List list = Cascade.convertTo(this.arg.evaluate(environment), List.class);
            if (list != null) {
                return list.size();
            }
            String string = Cascade.convertTo(this.arg.evaluate(environment), String.class);
            if (string != null) {
                return string.length();
            }
            return null;
        }
    }

    public static class OrOperator
    implements Expression {
        private List<Expression> args;

        public OrOperator(List<Expression> list) {
            this.args = list;
        }

        @Override
        public Object evaluate(Environment environment) {
            for (Expression expression : this.args) {
                Boolean bl = Cascade.convertTo(expression.evaluate(environment), Boolean.TYPE);
                if (bl == null || !bl.booleanValue()) continue;
                return true;
            }
            return false;
        }
    }

    public static class AndOperator
    implements Expression {
        private List<Expression> args;

        public AndOperator(List<Expression> list) {
            this.args = list;
        }

        @Override
        public Object evaluate(Environment environment) {
            for (Expression expression : this.args) {
                Boolean bl = Cascade.convertTo(expression.evaluate(environment), Boolean.TYPE);
                if (bl != null && bl.booleanValue()) continue;
                return false;
            }
            return true;
        }
    }

    public static class CondOperator
    implements Expression {
        private Expression condition;
        private Expression firstOption;
        private Expression secondOption;

        public CondOperator(Expression expression, Expression expression2, Expression expression3) {
            this.condition = expression;
            this.firstOption = expression2;
            this.secondOption = expression3;
        }

        @Override
        public Object evaluate(Environment environment) {
            Boolean bl = Cascade.convertTo(this.condition.evaluate(environment), Boolean.TYPE);
            if (bl != null && bl.booleanValue()) {
                return this.firstOption.evaluate(environment);
            }
            return this.secondOption.evaluate(environment);
        }
    }

    public static class NullExpression
    implements Expression {
        public static final NullExpression INSTANCE = new NullExpression();

        @Override
        public Object evaluate(Environment environment) {
            return null;
        }
    }

    public static class Functions {
        Environment env;

        public static Object eval(Object object) {
            return object;
        }

        public static float plus(float ... fArray) {
            float f = 0.0f;
            for (float f2 : fArray) {
                f += f2;
            }
            return f;
        }

        public static Float minus(float ... fArray) {
            if (fArray.length == 0) {
                return Float.valueOf(0.0f);
            }
            if (fArray.length == 1) {
                return Float.valueOf(-fArray[0]);
            }
            float f = fArray[0];
            for (int i = 1; i < fArray.length; ++i) {
                f -= fArray[i];
            }
            return Float.valueOf(f);
        }

        public static float times(float ... fArray) {
            float f = 1.0f;
            for (float f2 : fArray) {
                f *= f2;
            }
            return f;
        }

        public static Float divided_by(float ... fArray) {
            if (fArray.length == 0) {
                return Float.valueOf(1.0f);
            }
            float f = fArray[0];
            for (int i = 1; i < fArray.length; ++i) {
                if (fArray[i] == 0.0f) {
                    return null;
                }
                f /= fArray[i];
            }
            return Float.valueOf(f);
        }

        public static List list(Object ... objectArray) {
            return Arrays.asList(objectArray);
        }

        @NullableArguments
        public static Object coalesce(Object ... objectArray) {
            return Utils.firstNonNull(objectArray);
        }

        public static Object get(List<?> list, float f) {
            int n = Math.round(f);
            if (n >= 0 && n < list.size()) {
                return list.get(n);
            }
            return null;
        }

        public static List<String> split(String string, String string2) {
            return Arrays.asList(string2.split(Pattern.quote(string), -1));
        }

        public static Color rgb(float f, float f2, float f3) {
            Color color;
            try {
                color = new Color(f, f2, f3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            return color;
        }

        public static Color hsb_color(float f, float f2, float f3) {
            try {
                return Color.getHSBColor(f, f2, f3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }

        public static Color html2color(String string) {
            return ColorHelper.html2color(string);
        }

        public static String color2html(Color color) {
            return ColorHelper.color2html(color);
        }

        public static float red(Color color) {
            return Utils.color_int2float(color.getRed()).floatValue();
        }

        public static float green(Color color) {
            return Utils.color_int2float(color.getGreen()).floatValue();
        }

        public static float blue(Color color) {
            return Utils.color_int2float(color.getBlue()).floatValue();
        }

        public static float alpha(Color color) {
            return Utils.color_int2float(color.getAlpha()).floatValue();
        }

        @NullableArguments
        public static String concat(Object ... objectArray) {
            return Utils.join("", Arrays.asList(objectArray));
        }

        @NullableArguments
        public static String join(String ... stringArray) {
            return Utils.join(stringArray[0], Arrays.asList(stringArray).subList(1, stringArray.length));
        }

        public Object prop(String string) {
            return this.prop(string, null);
        }

        public Object prop(String string, String string2) {
            return this.env.getCascade(string2).get(string);
        }

        public Boolean is_prop_set(String string) {
            return this.is_prop_set(string, null);
        }

        public Boolean is_prop_set(String string, String string2) {
            return this.env.getCascade(string2).containsKey(string);
        }

        public String tag(String string) {
            return this.env.osm == null ? null : this.env.osm.get(string);
        }

        public String parent_tag(String string) {
            if (this.env.parent == null) {
                if (this.env.osm != null) {
                    for (OsmPrimitive osmPrimitive : this.env.osm.getReferrers()) {
                        String string2 = osmPrimitive.get(string);
                        if (string2 == null) continue;
                        return string2;
                    }
                }
                return null;
            }
            return this.env.parent.get(string);
        }

        public String child_tag(String string) {
            return this.env.child == null ? null : this.env.child.get(string);
        }

        public boolean has_tag_key(String string) {
            return this.env.osm.hasKey(string);
        }

        public Float index() {
            if (this.env.index == null) {
                return null;
            }
            return new Float(this.env.index + 1);
        }

        public String role() {
            return this.env.getRole();
        }

        public static boolean not(boolean bl) {
            return !bl;
        }

        public static boolean greater_equal(float f, float f2) {
            return f >= f2;
        }

        public static boolean less_equal(float f, float f2) {
            return f <= f2;
        }

        public static boolean greater(float f, float f2) {
            return f > f2;
        }

        public static boolean less(float f, float f2) {
            return f < f2;
        }

        public static boolean equal(Object object, Object object2) {
            for (Class clazz : new Class[]{Float.class, Boolean.class, Color.class, float[].class, String.class}) {
                Object t = Cascade.convertTo(object, clazz);
                Object t2 = Cascade.convertTo(object2, clazz);
                if (t == null || t2 == null || !t.equals(t2)) continue;
                return true;
            }
            return false;
        }

        public Boolean JOSM_search(String string) {
            SearchCompiler.Match match;
            try {
                match = SearchCompiler.compile(string, false, false);
            }
            catch (SearchCompiler.ParseError parseError) {
                return null;
            }
            return match.match(this.env.osm);
        }

        public static String JOSM_pref(String string, String string2) {
            String string3 = Main.pref.get(string, null);
            return string3 != null ? string3 : string2;
        }

        public static Color JOSM_pref_color(String string, Color color) {
            Color color2 = Main.pref.getColor(string, null);
            return color2 != null ? color2 : color;
        }

        public static boolean regexp_test(String string, String string2) {
            return Pattern.matches(string, string2);
        }

        public static boolean regexp_test(String string, String string2, String string3) {
            int n = 0;
            if (string3.contains("i")) {
                n |= 2;
            }
            if (string3.contains("s")) {
                n |= 0x20;
            }
            if (string3.contains("m")) {
                n |= 8;
            }
            return Pattern.compile(string, n).matcher(string2).matches();
        }

        public static List<String> regexp_match(String string, String string2, String string3) {
            int n = 0;
            if (string3.contains("i")) {
                n |= 2;
            }
            if (string3.contains("s")) {
                n |= 0x20;
            }
            if (string3.contains("m")) {
                n |= 8;
            }
            Matcher matcher = Pattern.compile(string, n).matcher(string2);
            return Utils.getMatches(matcher);
        }

        public static List<String> regexp_match(String string, String string2) {
            Matcher matcher = Pattern.compile(string).matcher(string2);
            return Utils.getMatches(matcher);
        }

        public long osm_id() {
            return this.env.osm.getUniqueId();
        }

        @NullableArguments
        public static String tr(String ... stringArray) {
            String string = stringArray[0];
            System.arraycopy(stringArray, 1, stringArray, 0, stringArray.length - 1);
            return I18n.tr(string, stringArray);
        }

        public static String substring(String string, float f) {
            return string == null ? null : string.substring((int)f);
        }

        public static String substring(String string, float f, float f2) {
            return string == null ? null : string.substring((int)f, (int)f2);
        }

        public static String replace(String string, String string2, String string3) {
            return string == null ? null : string.replace(string2, string3);
        }

        public static String URL_encode(String string) {
            try {
                return string == null ? null : URLEncoder.encode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }

        public static String XML_encode(String string) {
            return string == null ? null : XmlWriter.encode(string);
        }

        public static long CRC32_checksum(String string) {
            CRC32 cRC32 = new CRC32();
            cRC32.update(string.getBytes(Utils.UTF_8));
            return cRC32.getValue();
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface NullableArguments {
    }
}

