/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.LanguageInfo;

public abstract class LabelCompositionStrategy {
    public abstract String compose(OsmPrimitive var1);

    public static class DeriveLabelFromNameTagsCompositionStrategy
    extends LabelCompositionStrategy {
        private static final String[] DEFAULT_NAME_TAGS = new String[]{"name:" + LanguageInfo.getJOSMLocaleCode(), "name", "int_name", "ref", "operator", "brand", "addr:housenumber"};
        private static final String[] DEFAULT_NAME_COMPLEMENT_TAGS = new String[]{"capacity"};
        private List<String> nameTags = new ArrayList<String>();
        private List<String> nameComplementTags = new ArrayList<String>();

        public DeriveLabelFromNameTagsCompositionStrategy() {
            this.initNameTagsFromPreferences();
        }

        private static List<String> buildNameTags(List<String> list) {
            if (list == null) {
                list = Collections.emptyList();
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : list) {
                if (string == null || (string = string.trim()).isEmpty()) continue;
                arrayList.add(string);
            }
            return arrayList;
        }

        public void setNameTags(List<String> list) {
            this.nameTags = DeriveLabelFromNameTagsCompositionStrategy.buildNameTags(list);
        }

        public void setNameComplementTags(List<String> list) {
            this.nameComplementTags = DeriveLabelFromNameTagsCompositionStrategy.buildNameTags(list);
        }

        public List<String> getNameTags() {
            return Collections.unmodifiableList(this.nameTags);
        }

        public List<String> getNameComplementTags() {
            return Collections.unmodifiableList(this.nameComplementTags);
        }

        public final void initNameTagsFromPreferences() {
            if (Main.pref == null) {
                this.nameTags = new ArrayList<String>(Arrays.asList(DEFAULT_NAME_TAGS));
                this.nameComplementTags = new ArrayList<String>(Arrays.asList(DEFAULT_NAME_COMPLEMENT_TAGS));
            } else {
                this.nameTags = new ArrayList<String>(Main.pref.getCollection("mappaint.nameOrder", Arrays.asList(DEFAULT_NAME_TAGS)));
                this.nameComplementTags = new ArrayList<String>(Main.pref.getCollection("mappaint.nameComplementOrder", Arrays.asList(DEFAULT_NAME_COMPLEMENT_TAGS)));
            }
        }

        private String getPrimitiveName(OsmPrimitive osmPrimitive) {
            String string3;
            String string2 = null;
            if (!osmPrimitive.hasKeys()) {
                return null;
            }
            Iterator<String> iterator = this.nameTags.iterator();
            while (iterator.hasNext() && (string2 = osmPrimitive.get(string3 = iterator.next())) == null) {
            }
            for (String string3 : this.nameComplementTags) {
                String string4 = osmPrimitive.get(string3);
                if (string4 == null) continue;
                if (string2 == null) {
                    string2 = string4;
                    break;
                }
                string2 = string2 + " (" + string4 + ")";
                break;
            }
            return string2;
        }

        @Override
        public String compose(OsmPrimitive osmPrimitive) {
            if (osmPrimitive == null) {
                return null;
            }
            return this.getPrimitiveName(osmPrimitive);
        }

        public String toString() {
            return "{" + this.getClass().getSimpleName() + "}";
        }
    }

    public static class TagLookupCompositionStrategy
    extends LabelCompositionStrategy {
        private String defaultLabelTag;

        public TagLookupCompositionStrategy(String string) {
            if (string != null && (string = string.trim()).isEmpty()) {
                string = null;
            }
            this.defaultLabelTag = string;
        }

        @Override
        public String compose(OsmPrimitive osmPrimitive) {
            if (this.defaultLabelTag == null) {
                return null;
            }
            if (osmPrimitive == null) {
                return null;
            }
            return osmPrimitive.get(this.defaultLabelTag);
        }

        public String getDefaultLabelTag() {
            return this.defaultLabelTag;
        }

        public String toString() {
            return "{" + this.getClass().getSimpleName() + " defaultLabelTag=" + this.defaultLabelTag + "}";
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.defaultLabelTag == null ? 0 : this.defaultLabelTag.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TagLookupCompositionStrategy tagLookupCompositionStrategy = (TagLookupCompositionStrategy)object;
            return !(this.defaultLabelTag == null ? tagLookupCompositionStrategy.defaultLabelTag != null : !this.defaultLabelTag.equals(tagLookupCompositionStrategy.defaultLabelTag));
        }
    }

    public static class StaticLabelCompositionStrategy
    extends LabelCompositionStrategy {
        private String defaultLabel;

        public StaticLabelCompositionStrategy(String string) {
            this.defaultLabel = string;
        }

        @Override
        public String compose(OsmPrimitive osmPrimitive) {
            return this.defaultLabel;
        }

        public String getDefaultLabel() {
            return this.defaultLabel;
        }

        public String toString() {
            return "{" + this.getClass().getSimpleName() + " defaultLabel=" + this.defaultLabel + "}";
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.defaultLabel == null ? 0 : this.defaultLabel.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            StaticLabelCompositionStrategy staticLabelCompositionStrategy = (StaticLabelCompositionStrategy)object;
            return !(this.defaultLabel == null ? staticLabelCompositionStrategy.defaultLabel != null : !this.defaultLabel.equals(staticLabelCompositionStrategy.defaultLabel));
        }
    }
}

