/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MarkersFromNamedPointsAction
extends AbstractAction {
    private final GpxLayer layer;

    public MarkersFromNamedPointsAction(GpxLayer gpxLayer) {
        super(I18n.tr("Markers From Named Points", new Object[0]), ImageProvider.get("addmarkers"));
        this.layer = gpxLayer;
        this.putValue("help", HelpUtil.ht("/Action/MarkersFromNamedPoints"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        GpxData gpxData = new GpxData();
        for (GpxTrack gpxTrack : this.layer.data.tracks) {
            for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                for (WayPoint wayPoint : gpxTrackSegment.getWayPoints()) {
                    if (!wayPoint.attr.containsKey("name") && !wayPoint.attr.containsKey("desc")) continue;
                    gpxData.waypoints.add(wayPoint);
                }
            }
        }
        MarkerLayer markerLayer = new MarkerLayer(gpxData, I18n.tr("Named Trackpoints from {0}", this.layer.getName()), this.layer.getAssociatedFile(), this.layer);
        if (!markerLayer.data.isEmpty()) {
            Main.main.addLayer(markerLayer);
        }
    }
}

