/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractMergeAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;
import org.openstreetmap.josm.gui.progress.ProgressTaskIds;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.xml.sax.SAXException;

public class DownloadWmsAlongTrackAction
extends AbstractAction {
    private final GpxData data;

    public DownloadWmsAlongTrackAction(GpxData gpxData) {
        super(I18n.tr("Precache imagery tiles along this track", new Object[0]), ImageProvider.get("downloadalongtrack"));
        this.data = gpxData;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        final ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        for (GpxTrack object : this.data.tracks) {
            for (GpxTrackSegment gpxTrackSegment : object.getSegments()) {
                for (WayPoint wayPoint : gpxTrackSegment.getWayPoints()) {
                    arrayList.add(wayPoint.getCoor());
                }
            }
        }
        for (WayPoint wayPoint : this.data.waypoints) {
            arrayList.add(wayPoint.getCoor());
        }
        final WMSLayer wMSLayer = this.askWMSLayer();
        if (wMSLayer != null) {
            PleaseWaitRunnable pleaseWaitRunnable = new PleaseWaitRunnable(I18n.tr("Precaching WMS", new Object[0])){
                private WMSLayer.PrecacheTask precacheTask;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void realRun() throws SAXException, IOException, OsmTransferException {
                    this.precacheTask = new WMSLayer.PrecacheTask(this.progressMonitor);
                    wMSLayer.downloadAreaToCache(this.precacheTask, arrayList, 0.0, 0.0);
                    while (!this.precacheTask.isFinished() && !this.progressMonitor.isCanceled()) {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            try {
                                this.wait(200L);
                            }
                            catch (InterruptedException interruptedException) {
                                Main.warn("InterruptedException in " + this.getClass().getSimpleName() + " while precaching WMS");
                            }
                        }
                    }
                }

                @Override
                protected void finish() {
                }

                @Override
                protected void cancel() {
                    this.precacheTask.cancel();
                }

                @Override
                public ProgressTaskId canRunInBackground() {
                    return ProgressTaskIds.PRECACHE_WMS;
                }
            };
            Main.worker.execute(pleaseWaitRunnable);
        }
    }

    protected WMSLayer askWMSLayer() {
        List<WMSLayer> list = Main.map.mapView.getLayersOfType(WMSLayer.class);
        if (list.isEmpty()) {
            this.warnNoImageryLayers();
            return null;
        }
        JosmComboBox josmComboBox = new JosmComboBox(list.toArray());
        josmComboBox.setRenderer(new AbstractMergeAction.LayerListCellRenderer());
        josmComboBox.setSelectedIndex(0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Please select the imagery layer.", new Object[0])), GBC.eol());
        jPanel.add((Component)josmComboBox, GBC.eol());
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Select imagery layer", new Object[0]), new String[]{I18n.tr("Download", new Object[0]), I18n.tr("Cancel", new Object[0])});
        extendedDialog.setButtonIcons(new String[]{"dialogs/down", "cancel"});
        extendedDialog.setContent(jPanel);
        extendedDialog.showDialog();
        if (extendedDialog.getValue() != 1) {
            return null;
        }
        return (WMSLayer)josmComboBox.getSelectedItem();
    }

    protected void warnNoImageryLayers() {
        JOptionPane.showMessageDialog(Main.parent, I18n.tr("There are no imagery layers.", new Object[0]), I18n.tr("No imagery layers", new Object[0]), 2);
    }
}

