/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class DownloadAlongPanel
extends JPanel {
    private final String prefOsm;
    private final String prefGps;
    private final String prefDist;
    private final String prefArea;
    private final String prefNear;
    private final JCheckBox cbDownloadOsmData;
    private final JCheckBox cbDownloadGpxData;
    private static final Integer[] dist = new Integer[]{5000, 500, 50};
    private static final Integer[] area = new Integer[]{20, 10, 5, 1};
    private final JList buffer;
    private final JList maxRect;
    private final JList downloadNear;

    public DownloadAlongPanel(String string, String string2, String string3, String string4, String string5) {
        super(new GridBagLayout());
        int n;
        this.prefOsm = string;
        this.prefGps = string2;
        this.prefDist = string3;
        this.prefArea = string4;
        this.prefNear = string5;
        this.cbDownloadOsmData = new JCheckBox(I18n.tr("OpenStreetMap data", new Object[0]), Main.pref.getBoolean(string, true));
        this.cbDownloadOsmData.setToolTipText(I18n.tr("Select to download OSM data.", new Object[0]));
        this.add((Component)this.cbDownloadOsmData, GBC.std().insets(1, 5, 1, 5));
        this.cbDownloadGpxData = new JCheckBox(I18n.tr("Raw GPS data", new Object[0]), Main.pref.getBoolean(string2, false));
        this.cbDownloadGpxData.setToolTipText(I18n.tr("Select to download GPS traces.", new Object[0]));
        this.add((Component)this.cbDownloadGpxData, GBC.eol().insets(5, 5, 1, 5));
        this.add((Component)new JLabel(I18n.tr("Download everything within:", new Object[0])), GBC.eol());
        String[] stringArray = new String[dist.length];
        for (int i = 0; i < dist.length; ++i) {
            stringArray[i] = I18n.tr("{0} meters", dist[i]);
        }
        this.buffer = new JList<String>(stringArray);
        double d = Main.pref.getDouble(string3, dist[0].intValue());
        int n2 = 0;
        for (n = 0; n < dist.length; ++n) {
            if (dist[n] != (int)d) continue;
            n2 = n;
            break;
        }
        this.buffer.setSelectedIndex(n2);
        this.add((Component)this.buffer, GBC.eol());
        this.add((Component)new JLabel(I18n.tr("Maximum area per request:", new Object[0])), GBC.eol());
        stringArray = new String[area.length];
        for (n = 0; n < area.length; ++n) {
            stringArray[n] = I18n.tr("{0} sq km", area[n]);
        }
        this.maxRect = new JList<String>(stringArray);
        double d2 = Main.pref.getDouble(string4, area[0].intValue());
        int n3 = 0;
        for (int i = 0; i < area.length; ++i) {
            if (area[i] != (int)d2) continue;
            n3 = i;
            break;
        }
        this.maxRect.setSelectedIndex(n3);
        this.add((Component)this.maxRect, GBC.eol());
        if (string5 != null) {
            this.add((Component)new JLabel(I18n.tr("Download near:", new Object[0])), GBC.eol());
            this.downloadNear = new JList<String>(new String[]{I18n.tr("track only", new Object[0]), I18n.tr("waypoints only", new Object[0]), I18n.tr("track and waypoints", new Object[0])});
            this.downloadNear.setSelectedIndex(Main.pref.getInteger(string5, 0));
            this.add((Component)this.downloadNear, GBC.eol());
        } else {
            this.downloadNear = null;
        }
    }

    public final double getDistance() {
        return dist[this.buffer.getSelectedIndex()].intValue();
    }

    public final double getArea() {
        return area[this.maxRect.getSelectedIndex()].intValue();
    }

    public final int getNear() {
        return this.downloadNear.getSelectedIndex();
    }

    public boolean isDownloadOsmData() {
        return this.cbDownloadOsmData.isSelected();
    }

    public boolean isDownloadGpxData() {
        return this.cbDownloadGpxData.isSelected();
    }

    protected final void rememberSettings() {
        Main.pref.put(this.prefOsm, this.isDownloadOsmData());
        Main.pref.put(this.prefGps, this.isDownloadGpxData());
        Main.pref.putDouble(this.prefDist, this.getDistance());
        Main.pref.putDouble(this.prefArea, this.getArea());
        if (this.prefNear != null) {
            Main.pref.putInteger(this.prefNear, this.getNear());
        }
    }

    protected final void addChangeListener(ChangeListener changeListener) {
        this.cbDownloadGpxData.addChangeListener(changeListener);
        this.cbDownloadOsmData.addChangeListener(changeListener);
    }

    public int showInDownloadDialog(String string, String string2) {
        final HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Download", new Object[0]), ImageProvider.get("download"), I18n.tr("Click to download", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to cancel", new Object[0]), null)};
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                buttonSpecArray[0].setEnabled(DownloadAlongPanel.this.isDownloadOsmData() || DownloadAlongPanel.this.isDownloadGpxData());
            }
        });
        int n = HelpAwareOptionPane.showOptionDialog(Main.parent, this, string, 3, null, buttonSpecArray, buttonSpecArray[0], string2);
        if (0 == n) {
            this.rememberSettings();
        }
        return n;
    }
}

