/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.gpx.DateFilterPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.WindowGeometry;

public class ChooseTrackVisibilityAction
extends AbstractAction {
    private final GpxLayer layer;
    DateFilterPanel dateFilter;
    JTable table;
    boolean noUpdates = false;

    public ChooseTrackVisibilityAction(GpxLayer gpxLayer) {
        super(I18n.tr("Choose visible tracks", new Object[0]), ImageProvider.get("dialogs/filter"));
        this.layer = gpxLayer;
        this.putValue("help", HelpUtil.ht("/Action/ChooseTrackVisibility"));
    }

    private Object[][] buildTableContents() {
        Object[][] objectArray = new Object[this.layer.data.tracks.size()][5];
        int n = 0;
        for (GpxTrack gpxTrack : this.layer.data.tracks) {
            Map<String, Object> map = gpxTrack.getAttributes();
            String string = map.containsKey("name") ? map.get("name") : "";
            String string2 = map.containsKey("desc") ? map.get("desc") : "";
            String string3 = GpxLayer.getTimespanForTrack(gpxTrack);
            String string4 = NavigatableComponent.getSystemOfMeasurement().getDistText(gpxTrack.length());
            String string5 = map.containsKey("url") ? map.get("url") : "";
            objectArray[n] = new String[]{string, string2, string3, string4, string5};
            ++n;
        }
        return objectArray;
    }

    private JTable buildTable(Object[][] objectArray) {
        Object[] objectArray2 = new String[]{I18n.tr("Name", new Object[0]), I18n.tr("Description", new Object[0]), I18n.tr("Timespan", new Object[0]), I18n.tr("Length", new Object[0]), I18n.tr("URL", new Object[0])};
        JTable jTable = new JTable(objectArray, objectArray2){

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    jComponent.setToolTipText((String)this.getValueAt(n, n2));
                }
                return component;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        jTable.getColumnModel().getColumn(0).setPreferredWidth(220);
        jTable.getColumnModel().getColumn(1).setPreferredWidth(300);
        jTable.getColumnModel().getColumn(2).setPreferredWidth(200);
        jTable.getColumnModel().getColumn(3).setPreferredWidth(50);
        jTable.getColumnModel().getColumn(4).setPreferredWidth(100);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() != 2) {
                    return;
                }
                JTable jTable = (JTable)mouseEvent.getSource();
                int n = jTable.convertColumnIndexToModel(jTable.columnAtPoint(mouseEvent.getPoint()));
                if (n != 4) {
                    return;
                }
                int n2 = jTable.rowAtPoint(mouseEvent.getPoint());
                String string = (String)jTable.getValueAt(n2, n);
                if (string == null || string.isEmpty()) {
                    return;
                }
                OpenBrowser.displayUrl(string);
            }
        };
        jTable.setAutoCreateRowSorter(true);
        jTable.addMouseListener(mouseAdapter);
        jTable.setFillsViewportHeight(true);
        return jTable;
    }

    private void selectVisibleTracksInTable() {
        if (!this.layer.isVisible()) {
            return;
        }
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.clearSelection();
        for (int i = 0; i < this.layer.trackVisibility.length; ++i) {
            if (!this.layer.trackVisibility[i]) continue;
            listSelectionModel.addSelectionInterval(i, i);
        }
    }

    private void listenToSelectionChanges() {
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ChooseTrackVisibilityAction.this.noUpdates || !(listSelectionEvent.getSource() instanceof ListSelectionModel)) {
                    return;
                }
                ChooseTrackVisibilityAction.this.updateVisibilityFromTable();
            }
        });
    }

    private void updateVisibilityFromTable() {
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        for (int i = 0; i < this.layer.trackVisibility.length; ++i) {
            this.layer.trackVisibility[this.table.convertRowIndexToModel((int)i)] = listSelectionModel.isSelectedIndex(i);
        }
        Main.map.mapView.preferenceChanged(null);
        Main.map.repaint(100L);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.dateFilter = new DateFilterPanel(this.layer, "gpx.traces", false);
        this.dateFilter.setFilterAppliedListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChooseTrackVisibilityAction.this.noUpdates = true;
                ChooseTrackVisibilityAction.this.selectVisibleTracksInTable();
                ChooseTrackVisibilityAction.this.noUpdates = false;
                Main.map.mapView.preferenceChanged(null);
                Main.map.repaint(100L);
            }
        });
        this.dateFilter.loadFromPrefs();
        JToggleButton jToggleButton = new JToggleButton(new AbstractAction(I18n.tr("Select by date", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((JToggleButton)actionEvent.getSource()).isSelected()) {
                    ChooseTrackVisibilityAction.this.dateFilter.setEnabled(true);
                    ChooseTrackVisibilityAction.this.dateFilter.applyFilter();
                } else {
                    ChooseTrackVisibilityAction.this.dateFilter.setEnabled(false);
                }
            }
        });
        this.dateFilter.setEnabled(false);
        jPanel.add((Component)jToggleButton, GBC.std().insets(0, 0, 5, 0));
        jPanel.add((Component)this.dateFilter, GBC.eol().insets(0, 0, 10, 0).fill(2));
        jPanel.add((Component)new JLabel(I18n.tr("<html>Select all tracks that you want to be displayed. You can drag select a range of tracks or use CTRL+Click to select specific ones. The map is updated live in the background. Open the URLs by double clicking them.</html>", new Object[0])), GBC.eop().fill(2));
        boolean[] blArray = (boolean[])this.layer.trackVisibility.clone();
        this.table = this.buildTable(this.buildTableContents());
        this.selectVisibleTracksInTable();
        this.listenToSelectionChanges();
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jPanel.add((Component)jScrollPane, GBC.eol().fill(1));
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Set track visibility for {0}", this.layer.getName()), new String[]{I18n.tr("Show all", new Object[0]), I18n.tr("Show selected only", new Object[0]), I18n.tr("Cancel", new Object[0])});
        extendedDialog.setButtonIcons(new String[]{"dialogs/layerlist/eye", "dialogs/filter", "cancel"});
        extendedDialog.setContent(jPanel, false);
        extendedDialog.setDefaultButton(2);
        extendedDialog.setCancelButton(3);
        extendedDialog.configureContextsensitiveHelp("/Action/ChooseTrackVisibility", true);
        extendedDialog.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(1000, 500)));
        extendedDialog.showDialog();
        this.dateFilter.saveInPrefs();
        int n = extendedDialog.getValue();
        if (n != 1 && n != 2) {
            this.layer.trackVisibility = Arrays.copyOf(blArray, this.layer.trackVisibility.length);
            Main.map.repaint();
            return;
        }
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        boolean bl = n == 1 || listSelectionModel.isSelectionEmpty();
        for (int i = 0; i < this.layer.trackVisibility.length; ++i) {
            this.layer.trackVisibility[this.table.convertRowIndexToModel((int)i)] = bl || listSelectionModel.isSelectedIndex(i);
        }
        this.layer.setVisible(n == 1 || !listSelectionModel.isSelectionEmpty());
        Main.map.mapView.preferenceChanged(null);
        Main.map.repaint();
    }
}

