/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.ChangesetCacheEvent;
import org.openstreetmap.josm.data.osm.ChangesetCacheListener;

public class OpenChangesetComboBoxModel
extends DefaultComboBoxModel
implements ChangesetCacheListener {
    private List<Changeset> changesets = new ArrayList<Changeset>();
    private Changeset selectedChangeset = null;

    protected Changeset getChangesetById(long l) {
        for (Changeset changeset : this.changesets) {
            if ((long)changeset.getId() != l) continue;
            return changeset;
        }
        return null;
    }

    public void refresh() {
        this.changesets.clear();
        this.changesets.addAll(ChangesetCache.getInstance().getOpenChangesets());
        this.fireContentsChanged(this, 0, this.getSize());
        int n = this.changesets.indexOf(this.selectedChangeset);
        if (n < 0) {
            this.selectFirstChangeset();
        } else {
            this.setSelectedItem(this.changesets.get(n));
        }
    }

    public void selectFirstChangeset() {
        if (this.changesets == null || this.changesets.isEmpty()) {
            this.setSelectedItem(null);
        } else {
            this.setSelectedItem(this.changesets.get(0));
        }
    }

    @Override
    public void changesetCacheUpdated(ChangesetCacheEvent changesetCacheEvent) {
        this.refresh();
    }

    @Override
    public Object getElementAt(int n) {
        return this.changesets.get(n);
    }

    @Override
    public int getIndexOf(Object object) {
        return this.changesets.indexOf(object);
    }

    @Override
    public int getSize() {
        return this.changesets.size();
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedChangeset;
    }

    @Override
    public void setSelectedItem(Object object) {
        if (object == null) {
            this.selectedChangeset = null;
            super.setSelectedItem(null);
            return;
        }
        if (!(object instanceof Changeset)) {
            return;
        }
        Changeset changeset = (Changeset)object;
        if (changeset.getId() == 0 || !changeset.isOpen()) {
            return;
        }
        Changeset changeset2 = this.getChangesetById(changeset.getId());
        if (changeset2 == null) {
            return;
        }
        this.selectedChangeset = changeset2;
        super.setSelectedItem(this.selectedChangeset);
    }
}

