/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;
import org.openstreetmap.josm.gui.util.CellEditorSupport;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

class ActionFlagsTableCell
extends JPanel
implements TableCellRenderer,
TableCellEditor {
    private final JCheckBox[] checkBoxes = new JCheckBox[2];
    private final CellEditorSupport cellEditorSupport = new CellEditorSupport(this);
    private ActionListener al = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ActionFlagsTableCell.this.cellEditorSupport.fireEditingStopped();
        }
    };

    public ActionFlagsTableCell() {
        this.checkBoxes[0] = new JCheckBox(I18n.tr("Upload", new Object[0]));
        this.checkBoxes[1] = new JCheckBox(I18n.tr("Save", new Object[0]));
        this.setLayout(new GridBagLayout());
        ActionMap actionMap = this.getActionMap();
        for (final JCheckBox jCheckBox : this.checkBoxes) {
            this.add((Component)jCheckBox, GBC.eol().fill(2));
            jCheckBox.setPreferredSize(new Dimension(jCheckBox.getPreferredSize().width, 19));
            jCheckBox.addActionListener(this.al);
            actionMap.put(jCheckBox.getText(), new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jCheckBox.setSelected(!jCheckBox.isSelected());
                    ActionFlagsTableCell.this.cellEditorSupport.fireEditingStopped();
                }
            });
        }
        this.setToolTipText(I18n.tr("<html>Select which actions to perform for this layer, if you click the leftmost button.<br/>Check \"upload\" to upload the changes to the OSM server.<br/>Check \"Save\" to save the layer to the file specified on the left.</html>", new Object[0]));
    }

    protected void updateCheckboxes(Object object) {
        if (this.checkBoxes[0] != null && this.checkBoxes[1] != null) {
            boolean[] blArray = object instanceof SaveLayerInfo ? new boolean[]{((SaveLayerInfo)object).isDoUploadToServer(), ((SaveLayerInfo)object).isDoSaveToFile()} : (boolean[])object;
            this.checkBoxes[0].setSelected(blArray[0]);
            this.checkBoxes[1].setSelected(blArray[1]);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.updateCheckboxes(object);
        return this;
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.cellEditorSupport.addCellEditorListener(cellEditorListener);
    }

    @Override
    public void cancelCellEditing() {
        this.cellEditorSupport.fireEditingCanceled();
    }

    @Override
    public Object getCellEditorValue() {
        boolean[] blArray = new boolean[]{this.checkBoxes[0].isSelected(), this.checkBoxes[1].isSelected()};
        return blArray;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.cellEditorSupport.removeCellEditorListener(cellEditorListener);
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.cellEditorSupport.fireEditingStopped();
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.updateCheckboxes(object);
        return this;
    }
}

