/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.gui.history.DiffTableModel;
import org.openstreetmap.josm.gui.history.TwoColumnDiff;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RelationMemberListTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color BGCOLOR_EMPTY_ROW = new Color(234, 234, 234);
    public static final Color BGCOLOR_NOT_IN_OPPOSITE = new Color(255, 197, 197);
    public static final Color BGCOLOR_IN_OPPOSITE = new Color(255, 234, 213);
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);
    private Map<OsmPrimitiveType, ImageIcon> icons;

    public RelationMemberListTableCellRenderer() {
        this.setOpaque(true);
        this.icons = new HashMap<OsmPrimitiveType, ImageIcon>();
        this.icons.put(OsmPrimitiveType.NODE, ImageProvider.get("data", "node"));
        this.icons.put(OsmPrimitiveType.WAY, ImageProvider.get("data", "way"));
        this.icons.put(OsmPrimitiveType.RELATION, ImageProvider.get("data", "relation"));
    }

    protected void renderIcon(RelationMemberData relationMemberData) {
        if (relationMemberData == null) {
            this.setIcon(null);
        } else {
            this.setIcon(this.icons.get((Object)relationMemberData.getMemberType()));
        }
    }

    protected void renderRole(TwoColumnDiff.Item item, int n, boolean bl) {
        String string = "";
        Color color = item.state.getColor();
        RelationMemberData relationMemberData = (RelationMemberData)item.value;
        string = relationMemberData == null ? "" : relationMemberData.getRole();
        this.setText(string);
        this.setToolTipText(string);
        this.setBackground(color);
    }

    protected void renderPrimitive(TwoColumnDiff.Item item, int n, boolean bl) {
        String string = "";
        Color color = item.state.getColor();
        RelationMemberData relationMemberData = (RelationMemberData)item.value;
        string = "";
        if (relationMemberData != null) {
            switch (relationMemberData.getMemberType()) {
                case NODE: {
                    string = I18n.tr("Node {0}", relationMemberData.getMemberId());
                    break;
                }
                case WAY: {
                    string = I18n.tr("Way {0}", relationMemberData.getMemberId());
                    break;
                }
                case RELATION: {
                    string = I18n.tr("Relation {0}", relationMemberData.getMemberId());
                }
            }
        }
        this.setText(string);
        this.setToolTipText(string);
        this.setBackground(color);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        TwoColumnDiff.Item item = (TwoColumnDiff.Item)object;
        this.renderIcon((RelationMemberData)item.value);
        switch (n2) {
            case 0: {
                this.renderRole(item, n, bl);
                break;
            }
            case 1: {
                this.renderPrimitive(item, n, bl);
            }
        }
        return this;
    }

    protected DiffTableModel getRelationMemberTableModel(JTable jTable) {
        return (DiffTableModel)jTable.getModel();
    }
}

