/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class BookmarkList
extends JList {
    public BookmarkList() {
        this.setModel(new DefaultListModel());
        this.load();
        this.setVisibleRowCount(7);
        this.setCellRenderer(new BookmarkCellRenderer());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void load() {
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        defaultListModel.removeAllElements();
        Collection<Collection<String>> collection = Main.pref.getArray("bookmarks", null);
        if (collection != null) {
            LinkedList<Bookmark> linkedList = new LinkedList<Bookmark>();
            for (Collection<String> collection2 : collection) {
                try {
                    linkedList.add(new Bookmark(collection2));
                }
                catch (Exception exception) {
                    Main.error(I18n.tr("Error reading bookmark entry: %s", exception.getMessage()));
                }
            }
            Collections.sort(linkedList);
            for (Bookmark bookmark : linkedList) {
                defaultListModel.addElement(bookmark);
            }
            return;
        } else {
            if (Main.applet) return;
            File file = new File(Main.pref.getPreferencesDir(), "bookmarks");
            try {
                LinkedList<Bookmark> linkedList = new LinkedList<Bookmark>();
                if (!file.exists()) return;
                Main.info("Try loading obsolete bookmarks file");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Utils.UTF_8));
                Object object = bufferedReader.readLine();
                while (object != null) {
                    Matcher matcher = Pattern.compile("^(.+)[,\u001e](-?\\d+.\\d+)[,\u001e](-?\\d+.\\d+)[,\u001e](-?\\d+.\\d+)[,\u001e](-?\\d+.\\d+)$").matcher((CharSequence)object);
                    if (!matcher.matches() || matcher.groupCount() != 5) {
                        Main.error(I18n.tr("Unexpected line ''{0}'' in bookmark file ''{1}''", object, file.toString()));
                    } else {
                        Bookmark bookmark = new Bookmark();
                        bookmark.setName(matcher.group(1));
                        double[] dArray = new double[4];
                        for (int i = 0; i < 4; ++i) {
                            try {
                                dArray[i] = Double.parseDouble(matcher.group(i + 2));
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                Main.error(I18n.tr("Illegal double value ''{0}'' on line ''{1}'' in bookmark file ''{2}''", matcher.group(i + 2), object, file.toString()));
                            }
                        }
                        bookmark.setArea(new Bounds(dArray));
                        linkedList.add(bookmark);
                    }
                    object = bufferedReader.readLine();
                }
                Utils.close(bufferedReader);
                Collections.sort(linkedList);
                for (Bookmark bookmark : linkedList) {
                    defaultListModel.addElement(bookmark);
                }
                this.save();
                Main.info("Removing obsolete bookmarks file");
                if (file.delete()) return;
                file.deleteOnExit();
                return;
            }
            catch (IOException iOException) {
                Main.error(iOException);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Could not read bookmarks from<br>''{0}''<br>Error was: {1}</html>", file.toString(), iOException.getMessage()), I18n.tr("Error", new Object[0]), 0);
            }
        }
    }

    public final void save() {
        LinkedList<Collection<String>> linkedList = new LinkedList<Collection<String>>();
        for (Object object : ((DefaultListModel)this.getModel()).toArray()) {
            String[] stringArray = new String[5];
            Bookmark bookmark = (Bookmark)object;
            stringArray[0] = bookmark.getName();
            Bounds bounds = bookmark.getArea();
            stringArray[1] = String.valueOf(bounds.getMinLat());
            stringArray[2] = String.valueOf(bounds.getMinLon());
            stringArray[3] = String.valueOf(bounds.getMaxLat());
            stringArray[4] = String.valueOf(bounds.getMaxLon());
            linkedList.add(Arrays.asList(stringArray));
        }
        Main.pref.putArray("bookmarks", linkedList);
    }

    static class BookmarkCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private ImageIcon icon;

        public BookmarkCellRenderer() {
            this.setOpaque(true);
            this.icon = ImageProvider.get("dialogs", "bookmark");
            this.setIcon(this.icon);
        }

        protected void renderColor(boolean bl) {
            if (bl) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(UIManager.getColor("List.background"));
                this.setForeground(UIManager.getColor("List.foreground"));
            }
        }

        protected String buildToolTipText(Bookmark bookmark) {
            Bounds bounds = bookmark.getArea();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>min[latitude,longitude]=<strong>[").append(bounds.getMinLat()).append(",").append(bounds.getMinLon()).append("]</strong>").append("<br>").append("max[latitude,longitude]=<strong>[").append(bounds.getMaxLat()).append(",").append(bounds.getMaxLon()).append("]</strong>").append("</html>");
            return stringBuilder.toString();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Bookmark bookmark = (Bookmark)object;
            this.renderColor(bl);
            this.setText(bookmark.getName());
            this.setToolTipText(this.buildToolTipText(bookmark));
            return this;
        }
    }

    public static class Bookmark
    implements Comparable<Bookmark> {
        private String name;
        private Bounds area;

        public Bookmark(Collection<String> collection) throws NumberFormatException, IllegalArgumentException {
            ArrayList<String> arrayList = new ArrayList<String>(collection);
            if (arrayList.size() < 5) {
                throw new IllegalArgumentException(I18n.tr("Wrong number of arguments for bookmark", new Object[0]));
            }
            this.name = (String)arrayList.get(0);
            this.area = new Bounds(Double.parseDouble((String)arrayList.get(1)), Double.parseDouble((String)arrayList.get(2)), Double.parseDouble((String)arrayList.get(3)), Double.parseDouble((String)arrayList.get(4)));
        }

        public Bookmark() {
            this.area = null;
            this.name = null;
        }

        public Bookmark(Bounds bounds) {
            this.area = bounds;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(Bookmark bookmark) {
            return this.name.toLowerCase().compareTo(bookmark.name.toLowerCase());
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.area == null ? 0 : this.area.hashCode());
            n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Bookmark bookmark = (Bookmark)object;
            if (this.area == null ? bookmark.area != null : !this.area.equals(bookmark.area)) {
                return false;
            }
            return !(this.name == null ? bookmark.name != null : !this.name.equals(bookmark.name));
        }

        public Bounds getArea() {
            return this.area;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setArea(Bounds bounds) {
            this.area = bounds;
        }
    }
}

