/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.sort;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationSortUtils;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;

public class RelationNodeMap {
    private final NodesWays map = new NodesWays(false);
    private final NodesWays onewayMap = new NodesWays(true);
    private final NodesWays onewayReverseMap = new NodesWays(true);
    private final Set<Integer> remaining = new TreeSet<Integer>();
    private final Map<Integer, Set<Node>> remainingOneway = new TreeMap<Integer, Set<Node>>();
    private final List<Integer> notSortable = new ArrayList<Integer>();
    Integer firstOneway = null;
    Node lastOnewayNode = null;
    Node firstCircular = null;

    public static Node firstOnewayNode(RelationMember relationMember) {
        if (!relationMember.isWay()) {
            return null;
        }
        if (relationMember.getRole().equals("backward")) {
            return relationMember.getWay().lastNode();
        }
        return relationMember.getWay().firstNode();
    }

    public static Node lastOnewayNode(RelationMember relationMember) {
        if (!relationMember.isWay()) {
            return null;
        }
        if (relationMember.getRole().equals("backward")) {
            return relationMember.getWay().firstNode();
        }
        return relationMember.getWay().lastNode();
    }

    RelationNodeMap(List<RelationMember> list) {
        for (int i = 0; i < list.size(); ++i) {
            RelationMember relationMember = list.get(i);
            if (relationMember.getMember().isIncomplete() || !relationMember.isWay()) {
                this.notSortable.add(i);
                continue;
            }
            Way way = relationMember.getWay();
            if (RelationSortUtils.roundaboutType(way) != WayConnectionType.Direction.NONE) {
                for (Node node : way.getNodes()) {
                    this.addPair(node, i);
                }
                continue;
            }
            if (RelationSortUtils.isOneway(relationMember)) {
                this.addNodeWayMap(RelationNodeMap.firstOnewayNode(relationMember), i);
                this.addWayNodeMap(RelationNodeMap.lastOnewayNode(relationMember), i);
                this.addNodeWayMapReverse(RelationNodeMap.lastOnewayNode(relationMember), i);
                this.addWayNodeMapReverse(RelationNodeMap.firstOnewayNode(relationMember), i);
                this.addRemainingForward(RelationNodeMap.firstOnewayNode(relationMember), i);
                this.addRemainingForward(RelationNodeMap.lastOnewayNode(relationMember), i);
                continue;
            }
            this.addPair(way.firstNode(), i);
            this.addPair(way.lastNode(), i);
        }
        this.remaining.addAll(this.map.ways.keySet());
    }

    private void addPair(Node node, int n) {
        Set<Integer> set = this.map.nodes.get(node);
        if (set == null) {
            set = new TreeSet<Integer>();
            this.map.nodes.put(node, set);
        }
        set.add(n);
        Set<Node> set2 = this.map.ways.get(n);
        if (set2 == null) {
            set2 = new TreeSet<Node>();
            this.map.ways.put(n, set2);
        }
        set2.add(node);
    }

    private void addNodeWayMap(Node node, int n) {
        Set<Integer> set = this.onewayMap.nodes.get(node);
        if (set == null) {
            set = new TreeSet<Integer>();
            this.onewayMap.nodes.put(node, set);
        }
        set.add(n);
    }

    private void addWayNodeMap(Node node, int n) {
        Set<Node> set = this.onewayMap.ways.get(n);
        if (set == null) {
            set = new TreeSet<Node>();
            this.onewayMap.ways.put(n, set);
        }
        set.add(node);
    }

    private void addNodeWayMapReverse(Node node, int n) {
        Set<Integer> set = this.onewayReverseMap.nodes.get(node);
        if (set == null) {
            set = new TreeSet<Integer>();
            this.onewayReverseMap.nodes.put(node, set);
        }
        set.add(n);
    }

    private void addWayNodeMapReverse(Node node, int n) {
        Set<Node> set = this.onewayReverseMap.ways.get(n);
        if (set == null) {
            set = new TreeSet<Node>();
            this.onewayReverseMap.ways.put(n, set);
        }
        set.add(node);
    }

    private void addRemainingForward(Node node, int n) {
        Set<Node> set = this.remainingOneway.get(n);
        if (set == null) {
            set = new TreeSet<Node>();
            this.remainingOneway.put(n, set);
        }
        set.add(node);
    }

    public Integer popAdjacent(Integer n) {
        if (this.lastOnewayNode != null) {
            return this.popBackwardOnewayPart(n);
        }
        if (this.firstOneway != null) {
            return this.popForwardOnewayPart(n);
        }
        if (this.map.ways.containsKey(n)) {
            for (Node node : this.map.ways.get(n)) {
                Integer n2 = this.deleteAndGetAdjacentNode(this.map, node);
                if (n2 != null) {
                    return n2;
                }
                Integer n3 = this.deleteAndGetAdjacentNode(this.onewayMap, node);
                if (n3 == null) continue;
                this.firstOneway = n3;
                return n3;
            }
        }
        this.firstOneway = n;
        return this.popForwardOnewayPart(n);
    }

    private Integer popForwardOnewayPart(Integer n) {
        if (this.onewayMap.ways.containsKey(n)) {
            for (Node node : this.onewayMap.ways.get(n)) {
                Integer n2 = this.findAdjacentWay(this.onewayMap, node);
                if (n2 == null) continue;
                this.lastOnewayNode = this.processBackwardIfEndOfLoopReached(n2);
                if (this.lastOnewayNode != null) {
                    return this.popBackwardOnewayPart(this.firstOneway);
                }
                this.deleteWayNode(this.onewayMap, n2, node);
                return n2;
            }
        }
        this.firstOneway = null;
        return null;
    }

    private Node processBackwardIfEndOfLoopReached(Integer n) {
        if (this.onewayReverseMap.ways.containsKey(n)) {
            for (Node node : this.onewayReverseMap.ways.get(n)) {
                if (this.map.nodes.containsKey(node) || this.onewayMap.nodes.containsKey(node) && this.onewayMap.nodes.get(node).size() > 1) {
                    return node;
                }
                if (this.firstCircular == null || this.firstCircular != node) continue;
                return this.firstCircular;
            }
        }
        return null;
    }

    private Integer popBackwardOnewayPart(int n) {
        if (this.lastOnewayNode != null) {
            TreeSet treeSet = new TreeSet();
            if (this.onewayReverseMap.ways.containsKey(n)) {
                treeSet.addAll(this.onewayReverseMap.ways.get(n));
            }
            if (this.map.ways.containsKey(n)) {
                treeSet.addAll(this.map.ways.get(n));
            }
            for (Node node : treeSet) {
                Integer n2;
                if (node == this.lastOnewayNode) {
                    this.firstOneway = null;
                    this.lastOnewayNode = null;
                    n2 = this.deleteAndGetAdjacentNode(this.map, node);
                    if (n2 != null) {
                        return n2;
                    }
                    Integer n3 = this.deleteAndGetAdjacentNode(this.onewayMap, node);
                    if (n3 != null) {
                        this.firstOneway = n3;
                        return n3;
                    }
                }
                if ((n2 = this.deleteAndGetAdjacentNode(this.onewayReverseMap, node)) == null) continue;
                return n2;
            }
        }
        this.firstOneway = null;
        this.lastOnewayNode = null;
        return null;
    }

    private Integer deleteAndGetAdjacentNode(NodesWays nodesWays, Node node) {
        Integer n = this.findAdjacentWay(nodesWays, node);
        if (n == null) {
            return null;
        }
        this.deleteWayNode(nodesWays, n, node);
        return n;
    }

    private Integer findAdjacentWay(NodesWays nodesWays, Node node) {
        Set<Integer> set = nodesWays.nodes.get(node);
        if (set == null || set.isEmpty()) {
            return null;
        }
        return set.iterator().next();
    }

    private void deleteWayNode(NodesWays nodesWays, Integer n, Node node) {
        if (nodesWays.oneWay) {
            this.doneOneway(n);
        } else {
            this.done(n);
        }
        nodesWays.ways.get(n).remove(node);
    }

    public Integer pop() {
        if (!this.remaining.isEmpty()) {
            Integer n = this.remaining.iterator().next();
            this.done(n);
            return n;
        }
        if (this.remainingOneway.isEmpty()) {
            return null;
        }
        for (Integer n : this.remainingOneway.keySet()) {
            for (Node node : this.onewayReverseMap.ways.get(n)) {
                if (!this.onewayReverseMap.nodes.containsKey(node) || this.onewayReverseMap.nodes.get(node).size() <= 1) continue;
                this.doneOneway(n);
                this.firstCircular = node;
                return n;
            }
        }
        Integer n = this.remainingOneway.keySet().iterator().next();
        this.doneOneway(n);
        return n;
    }

    private void doneOneway(Integer n) {
        Set<Node> set = this.remainingOneway.get(n);
        for (Node node : set) {
            if (this.onewayMap.nodes.containsKey(node)) {
                this.onewayMap.nodes.get(node).remove(n);
            }
            if (!this.onewayReverseMap.nodes.containsKey(node)) continue;
            this.onewayReverseMap.nodes.get(node).remove(n);
        }
        this.remainingOneway.remove(n);
    }

    private void done(Integer n) {
        this.remaining.remove(n);
        Set<Node> set = this.map.ways.get(n);
        for (Node node : set) {
            boolean bl = this.map.nodes.get(node).remove(n);
            if (!bl) {
                throw new AssertionError();
            }
        }
    }

    public List<Integer> getNotSortableMembers() {
        return this.notSortable;
    }

    private static class NodesWays {
        public final Map<Node, Set<Integer>> nodes = new TreeMap<Node, Set<Integer>>();
        public final Map<Integer, Set<Node>> ways = new TreeMap<Integer, Set<Node>>();
        public final boolean oneWay;

        public NodesWays(boolean bl) {
            this.oneWay = bl;
        }
    }
}

