/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.tools.I18n;

public class BasicChangesetQueryPanel
extends JPanel {
    private Map<BasicQuery, JRadioButton> rbQueries;
    private Map<BasicQuery, JMultilineLabel> lblQueries;
    private JCheckBox cbMyChangesetsOnly;

    protected JPanel buildQueriesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        this.rbQueries = new HashMap<BasicQuery, JRadioButton>();
        this.lblQueries = new HashMap<BasicQuery, JMultilineLabel>();
        SelectQueryHandler selectQueryHandler = new SelectQueryHandler();
        for (BasicQuery basicQuery : BasicQuery.values()) {
            JRadioButton jRadioButton = new JRadioButton();
            jRadioButton.addItemListener(selectQueryHandler);
            this.rbQueries.put(basicQuery, jRadioButton);
            buttonGroup.add(jRadioButton);
            this.lblQueries.put(basicQuery, new JMultilineLabel(""));
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 3);
        jPanel.add((Component)this.rbQueries.get((Object)BasicQuery.MOST_RECENT_CHANGESETS), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.lblQueries.get((Object)BasicQuery.MOST_RECENT_CHANGESETS), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.rbQueries.get((Object)BasicQuery.MY_OPEN_CHANGESETS), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.lblQueries.get((Object)BasicQuery.MY_OPEN_CHANGESETS), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.rbQueries.get((Object)BasicQuery.CHANGESETS_IN_MAP_VIEW), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.lblQueries.get((Object)BasicQuery.CHANGESETS_IN_MAP_VIEW), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 0, 3, 3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.cbMyChangesetsOnly = new JCheckBox(I18n.tr("Download my changesets only", new Object[0]));
        jPanel.add((Component)this.cbMyChangesetsOnly, gridBagConstraints);
        this.cbMyChangesetsOnly.setToolTipText(I18n.tr("<html>Select to restrict the query to your changesets only.<br>Unselect to include all changesets in the query.</html>", new Object[0]));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 0, 3, 3);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        return jPanel;
    }

    protected JPanel buildInfoPanel() {
        HtmlPanel htmlPanel = new HtmlPanel();
        htmlPanel.setText(I18n.tr("<html>Please select one the following <strong>standard queries</strong>.Select <strong>Download my changesets only</strong> if you only want to download changesets created by yourself.<br>Note that JOSM will download max. 100 changesets.</html>", new Object[0]));
        return htmlPanel;
    }

    protected final void build() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.buildInfoPanel(), "North");
        this.add((Component)this.buildQueriesPanel(), "Center");
    }

    public BasicChangesetQueryPanel() {
        this.build();
    }

    public void init() {
        JMultilineLabel jMultilineLabel = this.lblQueries.get((Object)BasicQuery.MOST_RECENT_CHANGESETS);
        jMultilineLabel.setText(I18n.tr("<html>Download the latest changesets</html>", new Object[0]));
        jMultilineLabel = this.lblQueries.get((Object)BasicQuery.MY_OPEN_CHANGESETS);
        if (JosmUserIdentityManager.getInstance().isAnonymous()) {
            this.rbQueries.get((Object)BasicQuery.MY_OPEN_CHANGESETS).setEnabled(false);
            jMultilineLabel.setText(I18n.tr("<html>Download my open changesets<br><em>Disabled. Please enter your OSM user name in the preferences first.</em></html>", new Object[0]));
        } else {
            this.rbQueries.get((Object)BasicQuery.MY_OPEN_CHANGESETS).setEnabled(true);
            jMultilineLabel.setText(I18n.tr("<html>Download my open changesets</html>", new Object[0]));
        }
        jMultilineLabel = this.lblQueries.get((Object)BasicQuery.CHANGESETS_IN_MAP_VIEW);
        if (!Main.isDisplayingMapView()) {
            this.rbQueries.get((Object)BasicQuery.CHANGESETS_IN_MAP_VIEW).setEnabled(false);
            jMultilineLabel.setText(I18n.tr("<html>Download changesets in the current map view.<br><em>Disabled. There is currently no map view active.</em></html>", new Object[0]));
        } else {
            this.rbQueries.get((Object)BasicQuery.CHANGESETS_IN_MAP_VIEW).setEnabled(true);
            jMultilineLabel.setText(I18n.tr("<html>Download changesets in the current map view</html>", new Object[0]));
        }
        this.restoreFromPreferences();
    }

    public void rememberInPreferences() {
        BasicQuery basicQuery = this.getSelectedQuery();
        if (basicQuery == null) {
            Main.pref.put("changeset-query.basic.query", null);
        } else {
            Main.pref.put("changeset-query.basic.query", basicQuery.toString());
        }
        Main.pref.put("changeset-query.basic.my-changesets-only", this.cbMyChangesetsOnly.isSelected());
    }

    public void restoreFromPreferences() {
        BasicQuery basicQuery;
        String string = Main.pref.get("changeset-query.basic.query", null);
        if (string == null) {
            basicQuery = BasicQuery.MOST_RECENT_CHANGESETS;
        } else {
            try {
                basicQuery = BasicQuery.valueOf(BasicQuery.class, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Main.warn(I18n.tr("Unexpected value for preference ''{0}'', got ''{1}''. Resetting to default query.", "changeset-query.basic.query", string));
                basicQuery = BasicQuery.MOST_RECENT_CHANGESETS;
            }
        }
        this.rbQueries.get((Object)basicQuery).setSelected(true);
        boolean bl = Main.pref.getBoolean("changeset-query.basic.my-changesets-only", false);
        bl = bl || basicQuery.equals((Object)BasicQuery.MY_OPEN_CHANGESETS);
        this.cbMyChangesetsOnly.setSelected(bl);
    }

    protected BasicQuery getSelectedQuery() {
        for (BasicQuery basicQuery : BasicQuery.values()) {
            if (!this.rbQueries.get((Object)basicQuery).isSelected()) continue;
            return basicQuery;
        }
        return null;
    }

    public ChangesetQuery buildChangesetQuery() {
        BasicQuery basicQuery = this.getSelectedQuery();
        ChangesetQuery changesetQuery = new ChangesetQuery();
        JosmUserIdentityManager josmUserIdentityManager = JosmUserIdentityManager.getInstance();
        if (basicQuery == null) {
            return changesetQuery;
        }
        switch (basicQuery) {
            case MOST_RECENT_CHANGESETS: {
                break;
            }
            case MY_OPEN_CHANGESETS: {
                changesetQuery = changesetQuery.beingOpen(true);
                break;
            }
            case CHANGESETS_IN_MAP_VIEW: {
                Bounds bounds = Main.map.mapView.getLatLonBounds(Main.map.mapView.getBounds());
                changesetQuery = changesetQuery.inBbox(bounds);
            }
        }
        if (this.cbMyChangesetsOnly.isSelected()) {
            if (josmUserIdentityManager.isPartiallyIdentified()) {
                changesetQuery = changesetQuery.forUser(josmUserIdentityManager.getUserName());
            } else if (josmUserIdentityManager.isFullyIdentified()) {
                changesetQuery = changesetQuery.forUser(josmUserIdentityManager.getUserId()).beingOpen(true);
            } else {
                throw new IllegalStateException(I18n.tr("Cannot create changeset query for open changesets of anonymous user", new Object[0]));
            }
        }
        return changesetQuery;
    }

    class SelectQueryHandler
    implements ItemListener {
        SelectQueryHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            BasicQuery basicQuery = BasicChangesetQueryPanel.this.getSelectedQuery();
            if (basicQuery == null) {
                return;
            }
            if (basicQuery.equals((Object)BasicQuery.MY_OPEN_CHANGESETS)) {
                BasicChangesetQueryPanel.this.cbMyChangesetsOnly.setSelected(true);
                BasicChangesetQueryPanel.this.cbMyChangesetsOnly.setEnabled(false);
            } else if (!BasicChangesetQueryPanel.this.cbMyChangesetsOnly.isEnabled()) {
                BasicChangesetQueryPanel.this.cbMyChangesetsOnly.setEnabled(true);
            }
        }
    }

    private static enum BasicQuery {
        MOST_RECENT_CHANGESETS,
        MY_OPEN_CHANGESETS,
        CHANGESETS_IN_MAP_VIEW;

    }
}

