/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.FilterTableModel;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.MultikeyActionsHandler;
import org.openstreetmap.josm.tools.MultikeyShortcutAction;
import org.openstreetmap.josm.tools.Shortcut;

public class FilterDialog
extends ToggleDialog
implements DataSetListener {
    private JTable userTable;
    private FilterTableModel filterModel = new FilterTableModel();
    private EnableFilterAction enableFilterAction;
    private HidingFilterAction hidingFilterAction;
    private static final Shortcut ENABLE_FILTER_SHORTCUT = Shortcut.registerShortcut("core_multikey:enableFilter", I18n.tr("Multikey: {0}", I18n.tr("Enable filter", new Object[0])), 69, 5008);
    private static final Shortcut HIDING_FILTER_SHORTCUT = Shortcut.registerShortcut("core_multikey:hidingFilter", I18n.tr("Multikey: {0}", I18n.tr("Hide filter", new Object[0])), 72, 5008);
    protected final String[] columnToolTips = new String[]{Main.platform.makeTooltip(I18n.tr("Enable filter", new Object[0]), ENABLE_FILTER_SHORTCUT), Main.platform.makeTooltip(I18n.tr("Hiding filter", new Object[0]), HIDING_FILTER_SHORTCUT), null, I18n.tr("Inverse filter", new Object[0]), I18n.tr("Filter mode", new Object[0])};

    public FilterDialog() {
        super(I18n.tr("Filter", new Object[0]), "filter", I18n.tr("Filter objects and hide/disable them.", new Object[0]), Shortcut.registerShortcut("subwindow:filter", I18n.tr("Toggle: {0}", I18n.tr("Filter", new Object[0])), 70, 5007), 162);
        this.build();
        this.enableFilterAction = new EnableFilterAction();
        this.hidingFilterAction = new HidingFilterAction();
        MultikeyActionsHandler.getInstance().addAction(this.enableFilterAction);
        MultikeyActionsHandler.getInstance().addAction(this.hidingFilterAction);
    }

    @Override
    public void showNotify() {
        DatasetEventManager.getInstance().addDatasetListener(this, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        this.filterModel.executeFilters();
    }

    @Override
    public void hideNotify() {
        DatasetEventManager.getInstance().removeDatasetListener(this);
        this.filterModel.clearFilterFlags();
        Main.map.mapView.repaint();
    }

    protected void build() {
        this.userTable = new JTable(this.filterModel){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent mouseEvent) {
                        Point point = mouseEvent.getPoint();
                        int n = this.columnModel.getColumnIndexAtX(point.x);
                        int n2 = this.columnModel.getColumn(n).getModelIndex();
                        return FilterDialog.this.columnToolTips[n2];
                    }
                };
            }
        };
        this.userTable.setSelectionMode(0);
        this.userTable.getColumnModel().getColumn(0).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(1).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(3).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(4).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(0).setResizable(false);
        this.userTable.getColumnModel().getColumn(1).setResizable(false);
        this.userTable.getColumnModel().getColumn(3).setResizable(false);
        this.userTable.getColumnModel().getColumn(4).setResizable(false);
        this.userTable.setDefaultRenderer(Boolean.class, new BooleanRenderer());
        this.userTable.setDefaultRenderer(String.class, new StringRenderer());
        SideButton sideButton = new SideButton(new AbstractAction(){
            {
                this.putValue("Name", I18n.tr("Add", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Add filter.", new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Filter filter = (Filter)SearchAction.showSearchDialog(new Filter());
                if (filter != null) {
                    FilterDialog.this.filterModel.addFilter(filter);
                }
            }
        });
        SideButton sideButton2 = new SideButton(new AbstractAction(){
            {
                this.putValue("Name", I18n.tr("Edit", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Edit filter.", new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = FilterDialog.this.userTable.getSelectionModel().getMinSelectionIndex();
                if (n < 0) {
                    return;
                }
                Filter filter = FilterDialog.this.filterModel.getFilter(n);
                Filter filter2 = (Filter)SearchAction.showSearchDialog(filter);
                if (filter2 != null) {
                    FilterDialog.this.filterModel.setFilter(n, filter2);
                }
            }
        });
        SideButton sideButton3 = new SideButton(new AbstractAction(){
            {
                this.putValue("Name", I18n.tr("Delete", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Delete filter.", new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = FilterDialog.this.userTable.getSelectionModel().getMinSelectionIndex();
                if (n < 0) {
                    return;
                }
                FilterDialog.this.filterModel.removeFilter(n);
            }
        });
        SideButton sideButton4 = new SideButton(new AbstractAction(){
            {
                this.putValue("Name", I18n.tr("Up", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Move filter up.", new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get("dialogs", "up"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = FilterDialog.this.userTable.getSelectionModel().getMinSelectionIndex();
                if (n < 0) {
                    return;
                }
                FilterDialog.this.filterModel.moveUpFilter(n);
                FilterDialog.this.userTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
            }
        });
        SideButton sideButton5 = new SideButton(new AbstractAction(){
            {
                this.putValue("Name", I18n.tr("Down", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Move filter down.", new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get("dialogs", "down"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = FilterDialog.this.userTable.getSelectionModel().getMinSelectionIndex();
                if (n < 0) {
                    return;
                }
                FilterDialog.this.filterModel.moveDownFilter(n);
                FilterDialog.this.userTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
            }
        });
        InputMapUtils.addEnterAction(this.userTable, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = FilterDialog.this.userTable.getSelectedRow();
                if (n < 0) {
                    return;
                }
                Filter filter = FilterDialog.this.filterModel.getFilter(n);
                FilterDialog.this.filterModel.setValueAt(!filter.enable, n, 0);
            }
        });
        InputMapUtils.addSpacebarAction(this.userTable, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = FilterDialog.this.userTable.getSelectedRow();
                if (n < 0) {
                    return;
                }
                Filter filter = FilterDialog.this.filterModel.getFilter(n);
                FilterDialog.this.filterModel.setValueAt(!filter.hiding, n, 1);
            }
        });
        this.createLayout(this.userTable, true, Arrays.asList(sideButton, sideButton2, sideButton3, sideButton4, sideButton5));
    }

    @Override
    public void destroy() {
        MultikeyActionsHandler.getInstance().removeAction(this.enableFilterAction);
        MultikeyActionsHandler.getInstance().removeAction(this.hidingFilterAction);
        super.destroy();
    }

    public void updateDialogHeader() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FilterDialog.this.setTitle(I18n.tr("Filter Hidden:{0} Disabled:{1}", ((FilterDialog)FilterDialog.this).filterModel.disabledAndHiddenCount, ((FilterDialog)FilterDialog.this).filterModel.disabledCount));
            }
        });
    }

    public void drawOSDText(Graphics2D graphics2D) {
        this.filterModel.drawOSDText(graphics2D);
    }

    private Collection<OsmPrimitive> getAffectedPrimitives(Collection<? extends OsmPrimitive> collection) {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        Stack<? extends OsmPrimitive> stack = new Stack<OsmPrimitive>();
        stack.addAll(collection);
        while (!stack.isEmpty()) {
            OsmPrimitive osmPrimitive = (OsmPrimitive)stack.pop();
            if (hashSet.contains(osmPrimitive)) continue;
            hashSet.add(osmPrimitive);
            if (osmPrimitive instanceof Way) {
                for (Node node : ((Way)osmPrimitive).getNodes()) {
                    stack.push(node);
                }
            } else if (osmPrimitive instanceof Relation) {
                for (RelationMember relationMember : ((Relation)osmPrimitive).getMembers()) {
                    stack.push(relationMember.getMember());
                }
            }
            for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                stack.push(osmPrimitive2);
            }
        }
        return hashSet;
    }

    @Override
    public void dataChanged(DataChangedEvent dataChangedEvent) {
        this.filterModel.executeFilters();
    }

    @Override
    public void nodeMoved(NodeMovedEvent nodeMovedEvent) {
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        this.filterModel.executeFilters();
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent primitivesAddedEvent) {
        this.filterModel.executeFilters(primitivesAddedEvent.getPrimitives());
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent primitivesRemovedEvent) {
        this.filterModel.executeFilters();
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent relationMembersChangedEvent) {
        this.filterModel.executeFilters(this.getAffectedPrimitives(relationMembersChangedEvent.getPrimitives()));
    }

    @Override
    public void tagsChanged(TagsChangedEvent tagsChangedEvent) {
        this.filterModel.executeFilters(this.getAffectedPrimitives(tagsChangedEvent.getPrimitives()));
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent wayNodesChangedEvent) {
        this.filterModel.executeFilters(this.getAffectedPrimitives(wayNodesChangedEvent.getPrimitives()));
    }

    private class HidingFilterAction
    extends AbstractFilterAction {
        public HidingFilterAction() {
            this.putValue("ShortDescription", I18n.tr("Hiding filter", new Object[0]));
            HIDING_FILTER_SHORTCUT.setAccelerator(this);
        }

        @Override
        public Shortcut getMultikeyShortcut() {
            return HIDING_FILTER_SHORTCUT;
        }

        @Override
        public void executeMultikeyAction(int n, boolean bl) {
            if (n >= 0 && n < FilterDialog.this.filterModel.getRowCount()) {
                Filter filter = FilterDialog.this.filterModel.getFilter(n);
                FilterDialog.this.filterModel.setValueAt(!filter.hiding, n, 1);
                this.lastFilter = filter;
            } else if (bl && this.isLastFilterValid()) {
                FilterDialog.this.filterModel.setValueAt(!this.lastFilter.hiding, FilterDialog.this.filterModel.getFilters().indexOf(this.lastFilter), 1);
            }
        }
    }

    private class EnableFilterAction
    extends AbstractFilterAction {
        EnableFilterAction() {
            this.putValue("ShortDescription", I18n.tr("Enable filter", new Object[0]));
            ENABLE_FILTER_SHORTCUT.setAccelerator(this);
        }

        @Override
        public Shortcut getMultikeyShortcut() {
            return ENABLE_FILTER_SHORTCUT;
        }

        @Override
        public void executeMultikeyAction(int n, boolean bl) {
            if (n >= 0 && n < FilterDialog.this.filterModel.getRowCount()) {
                Filter filter = FilterDialog.this.filterModel.getFilter(n);
                FilterDialog.this.filterModel.setValueAt(!filter.enable, n, 0);
                this.lastFilter = filter;
            } else if (bl && this.isLastFilterValid()) {
                FilterDialog.this.filterModel.setValueAt(!this.lastFilter.enable, FilterDialog.this.filterModel.getFilters().indexOf(this.lastFilter), 0);
            }
        }
    }

    abstract class AbstractFilterAction
    extends AbstractAction
    implements MultikeyShortcutAction {
        protected Filter lastFilter;

        AbstractFilterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<MultikeyShortcutAction.MultikeyInfo> getMultikeyCombinations() {
            ArrayList<MultikeyShortcutAction.MultikeyInfo> arrayList = new ArrayList<MultikeyShortcutAction.MultikeyInfo>();
            for (int i = 0; i < FilterDialog.this.filterModel.getRowCount(); ++i) {
                Filter filter = FilterDialog.this.filterModel.getFilter(i);
                MultikeyShortcutAction.MultikeyInfo multikeyInfo = new MultikeyShortcutAction.MultikeyInfo(i, filter.text);
                arrayList.add(multikeyInfo);
            }
            return arrayList;
        }

        protected boolean isLastFilterValid() {
            return this.lastFilter != null && FilterDialog.this.filterModel.getFilters().contains(this.lastFilter);
        }

        @Override
        public MultikeyShortcutAction.MultikeyInfo getLastMultikeyAction() {
            if (this.isLastFilterValid()) {
                return new MultikeyShortcutAction.MultikeyInfo(-1, this.lastFilter.text);
            }
            return null;
        }
    }

    static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        BooleanRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            FilterTableModel filterTableModel = (FilterTableModel)jTable.getModel();
            this.setSelected(object != null && (Boolean)object != false);
            this.setEnabled(filterTableModel.isCellEnabled(n, n2));
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    static class StringRenderer
    extends DefaultTableCellRenderer {
        StringRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            FilterTableModel filterTableModel = (FilterTableModel)jTable.getModel();
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            component.setEnabled(filterTableModel.isCellEnabled(n, n2));
            return component;
        }
    }
}

