/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolver;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolverModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class PasteTagsConflictResolverDialog
extends JDialog
implements PropertyChangeListener {
    private static final Map<OsmPrimitiveType, String> PANE_TITLES = new HashMap<OsmPrimitiveType, String>();
    private TagConflictResolver allPrimitivesResolver;
    private Map<OsmPrimitiveType, TagConflictResolver> resolvers;
    private JTabbedPane tpResolvers;
    private Mode mode;
    private boolean canceled = false;
    private ImageIcon iconResolved;
    private ImageIcon iconUnresolved;
    private StatisticsTableModel statisticsModel;
    private JPanel pnlTagResolver;

    public PasteTagsConflictResolverDialog(Component component) {
        super((Window)JOptionPane.getFrameForComponent(component), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
        this.iconResolved = ImageProvider.get("dialogs/conflict", "tagconflictresolved");
        this.iconUnresolved = ImageProvider.get("dialogs/conflict", "tagconflictunresolved");
    }

    protected final void build() {
        this.setTitle(I18n.tr("Conflicts in pasted tags", new Object[0]));
        this.allPrimitivesResolver = new TagConflictResolver();
        this.resolvers = new HashMap<OsmPrimitiveType, TagConflictResolver>();
        for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.dataValues()) {
            this.resolvers.put(osmPrimitiveType, new TagConflictResolver());
            this.resolvers.get((Object)osmPrimitiveType).getModel().addPropertyChangeListener(this);
        }
        this.tpResolvers = new JTabbedPane();
        this.getContentPane().setLayout(new GridBagLayout());
        this.mode = null;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().add((Component)this.buildSourceAndTargetInfoPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlTagResolver = new JPanel();
        this.getContentPane().add((Component)this.pnlTagResolver, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().add((Component)this.buildButtonPanel(), gridBagConstraints);
    }

    protected JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        ApplyAction applyAction = new ApplyAction();
        this.allPrimitivesResolver.getModel().addPropertyChangeListener(applyAction);
        for (OsmPrimitiveType osmPrimitiveType : this.resolvers.keySet()) {
            this.resolvers.get((Object)osmPrimitiveType).getModel().addPropertyChangeListener(applyAction);
        }
        jPanel.add(new SideButton(applyAction));
        CancelAction cancelAction = new CancelAction();
        jPanel.add(new SideButton(cancelAction));
        return jPanel;
    }

    protected JPanel buildSourceAndTargetInfoPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.statisticsModel = new StatisticsTableModel();
        jPanel.add((Component)new StatisticsInfoTable(this.statisticsModel), "Center");
        return jPanel;
    }

    protected void initResolver(OsmPrimitiveType osmPrimitiveType, TagCollection tagCollection, Map<OsmPrimitiveType, Integer> map) {
        this.resolvers.get((Object)osmPrimitiveType).getModel().populate(tagCollection, tagCollection.getKeysWithMultipleValues());
        this.resolvers.get((Object)osmPrimitiveType).getModel().prepareDefaultTagDecisions();
        if (!tagCollection.isEmpty() && map.get((Object)osmPrimitiveType) != null && map.get((Object)osmPrimitiveType) > 0) {
            this.tpResolvers.add(PANE_TITLES.get((Object)osmPrimitiveType), this.resolvers.get((Object)osmPrimitiveType));
        }
    }

    public void populate(TagCollection tagCollection, Map<OsmPrimitiveType, Integer> hashMap, Map<OsmPrimitiveType, Integer> hashMap2) {
        this.mode = Mode.RESOLVING_ONE_TAGCOLLECTION_ONLY;
        tagCollection = tagCollection == null ? new TagCollection() : tagCollection;
        hashMap = hashMap == null ? new HashMap() : hashMap;
        hashMap2 = hashMap2 == null ? new HashMap() : hashMap2;
        this.allPrimitivesResolver.getModel().populate(tagCollection, tagCollection.getKeysWithMultipleValues());
        this.allPrimitivesResolver.getModel().prepareDefaultTagDecisions();
        this.pnlTagResolver.setLayout(new BorderLayout());
        this.pnlTagResolver.removeAll();
        this.pnlTagResolver.add((Component)this.allPrimitivesResolver, "Center");
        this.statisticsModel.reset();
        StatisticsInfo statisticsInfo = new StatisticsInfo();
        statisticsInfo.numTags = tagCollection.getKeys().size();
        statisticsInfo.sourceInfo.putAll(hashMap);
        statisticsInfo.targetInfo.putAll(hashMap2);
        this.statisticsModel.append(statisticsInfo);
        this.validate();
    }

    protected int getNumResolverTabs() {
        return this.tpResolvers.getTabCount();
    }

    protected TagConflictResolver getResolver(int n) {
        return (TagConflictResolver)this.tpResolvers.getComponentAt(n);
    }

    public void populate(TagCollection tagCollection, TagCollection tagCollection2, TagCollection tagCollection3, Map<OsmPrimitiveType, Integer> map, Map<OsmPrimitiveType, Integer> map2) {
        int n;
        StatisticsInfo statisticsInfo;
        tagCollection = tagCollection == null ? new TagCollection() : tagCollection;
        tagCollection2 = tagCollection2 == null ? new TagCollection() : tagCollection2;
        TagCollection tagCollection4 = tagCollection3 = tagCollection3 == null ? new TagCollection() : tagCollection3;
        if (tagCollection.isEmpty() && tagCollection2.isEmpty() && tagCollection3.isEmpty()) {
            this.populate(null, null, null);
            return;
        }
        this.tpResolvers.removeAll();
        this.initResolver(OsmPrimitiveType.NODE, tagCollection, map2);
        this.initResolver(OsmPrimitiveType.WAY, tagCollection2, map2);
        this.initResolver(OsmPrimitiveType.RELATION, tagCollection3, map2);
        this.pnlTagResolver.setLayout(new BorderLayout());
        this.pnlTagResolver.removeAll();
        this.pnlTagResolver.add((Component)this.tpResolvers, "Center");
        this.mode = Mode.RESOLVING_TYPED_TAGCOLLECTIONS;
        this.validate();
        this.statisticsModel.reset();
        if (!tagCollection.isEmpty()) {
            statisticsInfo = new StatisticsInfo();
            statisticsInfo.numTags = tagCollection.getKeys().size();
            int n2 = n = map2.get((Object)OsmPrimitiveType.NODE) == null ? 0 : map2.get((Object)OsmPrimitiveType.NODE);
            if (n > 0) {
                statisticsInfo.sourceInfo.put(OsmPrimitiveType.NODE, map.get((Object)OsmPrimitiveType.NODE));
                statisticsInfo.targetInfo.put(OsmPrimitiveType.NODE, n);
                this.statisticsModel.append(statisticsInfo);
            }
        }
        if (!tagCollection2.isEmpty()) {
            statisticsInfo = new StatisticsInfo();
            statisticsInfo.numTags = tagCollection2.getKeys().size();
            int n3 = n = map2.get((Object)OsmPrimitiveType.WAY) == null ? 0 : map2.get((Object)OsmPrimitiveType.WAY);
            if (n > 0) {
                statisticsInfo.sourceInfo.put(OsmPrimitiveType.WAY, map.get((Object)OsmPrimitiveType.WAY));
                statisticsInfo.targetInfo.put(OsmPrimitiveType.WAY, n);
                this.statisticsModel.append(statisticsInfo);
            }
        }
        if (!tagCollection3.isEmpty()) {
            statisticsInfo = new StatisticsInfo();
            statisticsInfo.numTags = tagCollection3.getKeys().size();
            int n4 = n = map2.get((Object)OsmPrimitiveType.RELATION) == null ? 0 : map2.get((Object)OsmPrimitiveType.RELATION);
            if (n > 0) {
                statisticsInfo.sourceInfo.put(OsmPrimitiveType.RELATION, map.get((Object)OsmPrimitiveType.RELATION));
                statisticsInfo.targetInfo.put(OsmPrimitiveType.RELATION, n);
                this.statisticsModel.append(statisticsInfo);
            }
        }
        for (int i = 0; i < this.getNumResolverTabs(); ++i) {
            if (this.getResolver(i).getModel().isResolvedCompletely()) continue;
            this.tpResolvers.setSelectedIndex(i);
            break;
        }
    }

    protected void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerOnScreen(new Dimension(400, 300))).applySafe(this);
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(bl);
    }

    public TagCollection getResolution() {
        return this.allPrimitivesResolver.getModel().getResolution();
    }

    public TagCollection getResolution(OsmPrimitiveType osmPrimitiveType) {
        if (osmPrimitiveType == null) {
            return null;
        }
        return this.resolvers.get((Object)osmPrimitiveType).getModel().getResolution();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(TagConflictResolverModel.NUM_CONFLICTS_PROP)) {
            TagConflictResolverModel tagConflictResolverModel = (TagConflictResolverModel)propertyChangeEvent.getSource();
            for (int i = 0; i < this.tpResolvers.getTabCount(); ++i) {
                TagConflictResolver tagConflictResolver = (TagConflictResolver)this.tpResolvers.getComponentAt(i);
                if (tagConflictResolverModel != tagConflictResolver.getModel()) continue;
                this.tpResolvers.setIconAt(i, (Boolean)propertyChangeEvent.getNewValue() != false ? this.iconResolved : this.iconUnresolved);
            }
        }
    }

    static {
        PANE_TITLES.put(OsmPrimitiveType.NODE, I18n.tr("Tags from nodes", new Object[0]));
        PANE_TITLES.put(OsmPrimitiveType.WAY, I18n.tr("Tags from ways", new Object[0]));
        PANE_TITLES.put(OsmPrimitiveType.RELATION, I18n.tr("Tags from relations", new Object[0]));
    }

    private static class StatisticsInfoTable
    extends JPanel {
        private JTable infoTable;

        protected void build(StatisticsTableModel statisticsTableModel) {
            this.infoTable = new JTable(statisticsTableModel, new StatisticsTableColumnModel());
            this.infoTable.setShowHorizontalLines(true);
            this.infoTable.setShowVerticalLines(false);
            this.infoTable.setEnabled(false);
            this.setLayout(new BorderLayout());
            this.add((Component)this.infoTable, "Center");
        }

        public StatisticsInfoTable(StatisticsTableModel statisticsTableModel) {
            this.build(statisticsTableModel);
        }

        @Override
        public Insets getInsets() {
            Insets insets = super.getInsets();
            insets.bottom = 20;
            return insets;
        }
    }

    private static class StatisticsInfoRenderer
    extends JLabel
    implements TableCellRenderer {
        private StatisticsInfoRenderer() {
        }

        protected void reset() {
            this.setIcon(null);
            this.setText("");
            this.setFont(UIManager.getFont("Table.font"));
        }

        protected void renderNumTags(StatisticsInfo statisticsInfo) {
            if (statisticsInfo == null) {
                return;
            }
            this.setText(I18n.trn("{0} tag", "{0} tags", statisticsInfo.numTags, statisticsInfo.numTags));
        }

        protected void renderStatistics(Map<OsmPrimitiveType, Integer> map) {
            if (map == null) {
                return;
            }
            if (map.isEmpty()) {
                return;
            }
            if (map.size() == 1) {
                this.setIcon(ImageProvider.get(map.keySet().iterator().next()));
            } else {
                this.setIcon(ImageProvider.get("data", "object"));
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<OsmPrimitiveType, Integer> entry : map.entrySet()) {
                int n;
                OsmPrimitiveType osmPrimitiveType = entry.getKey();
                int n2 = n = entry.getValue() == null ? 0 : entry.getValue();
                if (n == 0) continue;
                String string = "";
                switch (osmPrimitiveType) {
                    case NODE: {
                        string = I18n.trn("{0} node", "{0} nodes", n, n);
                        break;
                    }
                    case WAY: {
                        string = I18n.trn("{0} way", "{0} ways", n, n);
                        break;
                    }
                    case RELATION: {
                        string = I18n.trn("{0} relation", "{0} relations", n, n);
                    }
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string);
            }
            this.setText(stringBuilder.toString());
        }

        protected void renderFrom(StatisticsInfo statisticsInfo) {
            this.renderStatistics(statisticsInfo.sourceInfo);
        }

        protected void renderTo(StatisticsInfo statisticsInfo) {
            this.renderStatistics(statisticsInfo.targetInfo);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.reset();
            if (object == null) {
                return this;
            }
            if (n == 0) {
                this.setFont(this.getFont().deriveFont(1));
                this.setText((String)object);
            } else {
                StatisticsInfo statisticsInfo = (StatisticsInfo)object;
                switch (n2) {
                    case 0: {
                        this.renderNumTags(statisticsInfo);
                        break;
                    }
                    case 1: {
                        this.renderFrom(statisticsInfo);
                        break;
                    }
                    case 2: {
                        this.renderTo(statisticsInfo);
                    }
                }
            }
            return this;
        }
    }

    private static class StatisticsTableModel
    extends DefaultTableModel {
        private static final String[] HEADERS = new String[]{I18n.tr("Paste ...", new Object[0]), I18n.tr("From ...", new Object[0]), I18n.tr("To ...", new Object[0])};
        private List<StatisticsInfo> data = new ArrayList<StatisticsInfo>();

        @Override
        public Object getValueAt(int n, int n2) {
            if (n == 0) {
                return HEADERS[n2];
            }
            if (n - 1 < this.data.size()) {
                return this.data.get(n - 1);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 1;
            }
            return this.data.size() + 1;
        }

        public void reset() {
            this.data.clear();
        }

        public void append(StatisticsInfo statisticsInfo) {
            this.data.add(statisticsInfo);
            this.fireTableDataChanged();
        }
    }

    private static class StatisticsTableColumnModel
    extends DefaultTableColumnModel {
        public StatisticsTableColumnModel() {
            StatisticsInfoRenderer statisticsInfoRenderer = new StatisticsInfoRenderer();
            TableColumn tableColumn = null;
            tableColumn = new TableColumn(0);
            tableColumn.setHeaderValue(I18n.tr("Paste ...", new Object[0]));
            tableColumn.setResizable(true);
            tableColumn.setCellRenderer(statisticsInfoRenderer);
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(1);
            tableColumn.setHeaderValue(I18n.tr("From ...", new Object[0]));
            tableColumn.setResizable(true);
            tableColumn.setCellRenderer(statisticsInfoRenderer);
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(2);
            tableColumn.setHeaderValue(I18n.tr("To ...", new Object[0]));
            tableColumn.setResizable(true);
            tableColumn.setCellRenderer(statisticsInfoRenderer);
            this.addColumn(tableColumn);
        }
    }

    public static class StatisticsInfo {
        public int numTags;
        public Map<OsmPrimitiveType, Integer> sourceInfo = new HashMap<OsmPrimitiveType, Integer>();
        public Map<OsmPrimitiveType, Integer> targetInfo = new HashMap<OsmPrimitiveType, Integer>();
    }

    class ApplyAction
    extends AbstractAction
    implements PropertyChangeListener {
        public ApplyAction() {
            this.putValue("ShortDescription", I18n.tr("Apply resolved conflicts", new Object[0]));
            this.putValue("Name", I18n.tr("Apply", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PasteTagsConflictResolverDialog.this.setVisible(false);
        }

        protected void updateEnabledState() {
            if (PasteTagsConflictResolverDialog.this.mode == null) {
                this.setEnabled(false);
            } else if (PasteTagsConflictResolverDialog.this.mode.equals((Object)Mode.RESOLVING_ONE_TAGCOLLECTION_ONLY)) {
                this.setEnabled(PasteTagsConflictResolverDialog.this.allPrimitivesResolver.getModel().isResolvedCompletely());
            } else {
                boolean bl = true;
                for (OsmPrimitiveType osmPrimitiveType : PasteTagsConflictResolverDialog.this.resolvers.keySet()) {
                    bl &= ((TagConflictResolver)PasteTagsConflictResolverDialog.this.resolvers.get((Object)osmPrimitiveType)).getModel().isResolvedCompletely();
                }
                this.setEnabled(bl);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(TagConflictResolverModel.NUM_CONFLICTS_PROP)) {
                this.updateEnabledState();
            }
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("ShortDescription", I18n.tr("Cancel conflict resolution", new Object[0]));
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("", "cancel"));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PasteTagsConflictResolverDialog.this.setVisible(false);
            PasteTagsConflictResolverDialog.this.setCanceled(true);
        }
    }

    private static enum Mode {
        RESOLVING_ONE_TAGCOLLECTION_ONLY,
        RESOLVING_TYPED_TAGCOLLECTIONS;

    }
}

