/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.Authenticator;
import java.net.ProxySelector;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.jdesktop.swinghelper.debug.CheckThreadViolationRepaintManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.PreferencesAction;
import org.openstreetmap.josm.data.AutosaveTask;
import org.openstreetmap.josm.data.CustomConfigurator;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.SplashScreen;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreference;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.DefaultProxySelector;
import org.openstreetmap.josm.io.MessageNotifier;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.io.auth.DefaultAuthenticator;
import org.openstreetmap.josm.io.remotecontrol.RemoteControl;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.Utils;

public class MainApplication
extends Main {
    public MainApplication() {
    }

    public MainApplication(JFrame jFrame) {
        MainApplication.addListener();
        jFrame.setContentPane(contentPanePrivate);
        jFrame.setJMenuBar(this.menu);
        geometry.applySafe(jFrame);
        LinkedList<Image> linkedList = new LinkedList<Image>();
        linkedList.add(ImageProvider.get("logo_16x16x32").getImage());
        linkedList.add(ImageProvider.get("logo_16x16x8").getImage());
        linkedList.add(ImageProvider.get("logo_32x32x32").getImage());
        linkedList.add(ImageProvider.get("logo_32x32x8").getImage());
        linkedList.add(ImageProvider.get("logo_48x48x32").getImage());
        linkedList.add(ImageProvider.get("logo_48x48x8").getImage());
        linkedList.add(ImageProvider.get("logo").getImage());
        jFrame.setIconImages(linkedList);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Main.exitJosm(true, 0);
            }
        });
        jFrame.setDefaultCloseOperation(0);
    }

    public static void showHelp() {
        System.out.println(I18n.tr("Java OpenStreetMap Editor", new Object[0]) + " [" + Version.getInstance().getAgentString() + "]\n\n" + I18n.tr("usage", new Object[0]) + ":\n" + "\tjava -jar josm.jar <options>...\n\n" + I18n.tr("options", new Object[0]) + ":\n" + "\t--help|-h                                 " + I18n.tr("Show this help", new Object[0]) + "\n" + "\t--geometry=widthxheight(+|-)x(+|-)y       " + I18n.tr("Standard unix geometry argument", new Object[0]) + "\n" + "\t[--download=]minlat,minlon,maxlat,maxlon  " + I18n.tr("Download the bounding box", new Object[0]) + "\n" + "\t[--download=]<URL>                        " + I18n.tr("Download the location at the URL (with lat=x&lon=y&zoom=z)", new Object[0]) + "\n" + "\t[--download=]<filename>                   " + I18n.tr("Open a file (any file type that can be opened with File/Open)", new Object[0]) + "\n" + "\t--downloadgps=minlat,minlon,maxlat,maxlon " + I18n.tr("Download the bounding box as raw GPS", new Object[0]) + "\n" + "\t--downloadgps=<URL>                       " + I18n.tr("Download the location at the URL (with lat=x&lon=y&zoom=z) as raw GPS", new Object[0]) + "\n" + "\t--selection=<searchstring>                " + I18n.tr("Select with the given search", new Object[0]) + "\n" + "\t--[no-]maximize                           " + I18n.tr("Launch in maximized mode", new Object[0]) + "\n" + "\t--reset-preferences                       " + I18n.tr("Reset the preferences to default", new Object[0]) + "\n\n" + "\t--load-preferences=<url-to-xml>           " + I18n.tr("Changes preferences according to the XML file", new Object[0]) + "\n\n" + "\t--set=<key>=<value>                       " + I18n.tr("Set preference key to value", new Object[0]) + "\n\n" + "\t--language=<language>                     " + I18n.tr("Set the language", new Object[0]) + "\n\n" + "\t--version                                 " + I18n.tr("Displays the JOSM version and exits", new Object[0]) + "\n\n" + "\t--debug                                   " + I18n.tr("Print debugging messages to console", new Object[0]) + "\n\n" + I18n.tr("options provided as Java system properties", new Object[0]) + ":\n" + "\t-Djosm.home=" + I18n.tr("/PATH/TO/JOSM/FOLDER/         ", new Object[0]) + I18n.tr("Change the folder for all user settings", new Object[0]) + "\n\n" + I18n.tr("note: For some tasks, JOSM needs a lot of memory. It can be necessary to add the following\n      Java option to specify the maximum size of allocated memory in megabytes", new Object[0]) + ":\n" + "\t-Xmx...m\n\n" + I18n.tr("examples", new Object[0]) + ":\n" + "\tjava -jar josm.jar track1.gpx track2.gpx london.osm\n" + "\tjava -jar josm.jar " + OsmUrlToBounds.getURL(43.2, 11.1, 13) + "\n" + "\tjava -jar josm.jar london.osm --selection=http://www.ostertag.name/osm/OSM_errors_node-duplicate.xml\n" + "\tjava -jar josm.jar 43.2,11.1,43.4,11.4\n" + "\tjava -Djosm.home=/home/user/.josm_dev -jar josm.jar\n" + "\tjava -Xmx1024m -jar josm.jar\n\n" + I18n.tr("Parameters --download, --downloadgps, and --selection are processed in this order.", new Object[0]) + "\n" + I18n.tr("Make sure you load some data if you use --selection.", new Object[0]) + "\n");
    }

    private static Map<Option, Collection<String>> buildCommandLineArgumentMap(String[] stringArray) {
        Collection<String> collection;
        int n;
        ArrayList<LongOpt> arrayList = new ArrayList<LongOpt>();
        for (Option option : Option.values()) {
            arrayList.add(new LongOpt(option.getName(), option.requiresArgument() ? 1 : 0, null, 0));
        }
        Getopt getopt = new Getopt("JOSM", stringArray, "hv", arrayList.toArray(new LongOpt[arrayList.size()]));
        HashMap<Option, Collection<String>> hashMap = new HashMap<Option, Collection<String>>();
        while ((n = getopt.getopt()) != -1) {
            Option option;
            option = null;
            switch (n) {
                case 104: {
                    option = Option.HELP;
                    break;
                }
                case 118: {
                    option = Option.VERSION;
                    break;
                }
                case 0: {
                    option = Option.values()[getopt.getLongind()];
                }
            }
            if (option != null) {
                collection = (ArrayList<String>)hashMap.get((Object)option);
                if (collection == null) {
                    collection = new ArrayList<String>();
                    hashMap.put(option, collection);
                }
                collection.add(getopt.getOptarg());
                continue;
            }
            throw new IllegalArgumentException();
        }
        for (int i = getopt.getOptind(); i < stringArray.length; ++i) {
            collection = (Collection)hashMap.get((Object)Option.DOWNLOAD);
            if (collection == null) {
                collection = new ArrayList();
                hashMap.put(Option.DOWNLOAD, collection);
            }
            collection.add(stringArray[i]);
        }
        return hashMap;
    }

    public static void main(String[] stringArray) {
        Object object3;
        I18n.init();
        Main.checkJava6();
        Map<Option, Collection<String>> map = null;
        try {
            map = MainApplication.buildCommandLineArgumentMap(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.exit(1);
        }
        boolean bl = map.containsKey((Object)Option.LANGUAGE);
        if (bl) {
            I18n.set(map.get((Object)Option.LANGUAGE).iterator().next());
        }
        MainApplication.initApplicationPreferences();
        Policy.setPolicy(new Policy(){
            private PermissionCollection pc = new Permissions();
            {
                this.pc.add(new AllPermission());
            }

            @Override
            public void refresh() {
            }

            @Override
            public PermissionCollection getPermissions(CodeSource codeSource) {
                return this.pc;
            }
        });
        Thread.setDefaultUncaughtExceptionHandler(new BugReportExceptionHandler());
        Preferences.updateSystemProperty("sun.awt.exception.handler", BugReportExceptionHandler.class.getName());
        Main.determinePlatformHook();
        Main.platform.preStartupHook();
        Main.commandLineArgs = Utils.copyArray(stringArray);
        if (map.containsKey((Object)Option.VERSION)) {
            System.out.println(Version.getInstance().getAgentString());
            System.exit(0);
        }
        if (map.containsKey((Object)Option.DEBUG)) {
            logLevel = 4;
            Preferences.updateSystemProperty("debug", "true");
            Main.debug(I18n.tr("Print debugging messages to console", new Object[0]));
        }
        Main.pref.init(map.containsKey((Object)Option.RESET_PREFERENCES));
        if (!bl) {
            I18n.set(Main.pref.get("language", null));
        }
        Main.pref.updateSystemProperties();
        final JFrame jFrame = new JFrame(I18n.tr("Java OpenStreetMap Editor", new Object[0]));
        Main.parent = jFrame;
        if (map.containsKey((Object)Option.LOAD_PREFERENCES)) {
            object3 = new CustomConfigurator.XMLCommandProcessor(Main.pref);
            for (String string : map.get((Object)Option.LOAD_PREFERENCES)) {
                MainApplication.info("Reading preferences from " + string);
                try {
                    ((CustomConfigurator.XMLCommandProcessor)object3).openAndReadXML(Utils.openURL(new URL(string)));
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
        if (map.containsKey((Object)Option.SET)) {
            for (String string : map.get((Object)Option.SET)) {
                String[] stringArray2 = string.split("=", 2);
                Main.pref.put(stringArray2[0], "null".equals(stringArray2[1]) ? null : stringArray2[1]);
            }
        }
        DefaultAuthenticator.createInstance();
        Authenticator.setDefault(DefaultAuthenticator.getInstance());
        object3 = new DefaultProxySelector(ProxySelector.getDefault());
        ProxySelector.setDefault((ProxySelector)object3);
        OAuthAccessTokenHolder.getInstance().init(Main.pref, CredentialsManager.getInstance());
        if (map.containsKey((Object)Option.HELP)) {
            MainApplication.showHelp();
            System.exit(0);
        }
        final SplashScreen splashScreen = new SplashScreen();
        final ProgressMonitor progressMonitor = splashScreen.getProgressMonitor();
        progressMonitor.beginTask(I18n.tr("Initializing", new Object[0]));
        splashScreen.setVisible(Main.pref.getBoolean("draw.splashscreen", true));
        Main.setInitStatusListener(new Main.InitStatusListener(){

            @Override
            public void updateStatus(String string) {
                progressMonitor.indeterminateSubTask(string);
            }
        });
        Collection<PluginInformation> collection = PluginHandler.buildListOfPluginsToLoad(splashScreen, progressMonitor.createSubTaskMonitor(1, false));
        if (!collection.isEmpty() && PluginHandler.checkAndConfirmPluginUpdate(splashScreen)) {
            progressMonitor.subTask(I18n.tr("Updating plugins", new Object[0]));
            collection = PluginHandler.updatePlugins(splashScreen, null, progressMonitor.createSubTaskMonitor(1, false), false);
        }
        progressMonitor.indeterminateSubTask(I18n.tr("Installing updated plugins", new Object[0]));
        PluginHandler.installDownloadedPlugins(true);
        progressMonitor.indeterminateSubTask(I18n.tr("Loading early plugins", new Object[0]));
        PluginHandler.loadEarlyPlugins(splashScreen, collection, progressMonitor.createSubTaskMonitor(1, false));
        progressMonitor.indeterminateSubTask(I18n.tr("Setting defaults", new Object[0]));
        MainApplication.preConstructorInit(map);
        progressMonitor.indeterminateSubTask(I18n.tr("Creating main GUI", new Object[0]));
        MainApplication mainApplication = new MainApplication(jFrame);
        progressMonitor.indeterminateSubTask(I18n.tr("Loading plugins", new Object[0]));
        PluginHandler.loadLatePlugins(splashScreen, collection, progressMonitor.createSubTaskMonitor(1, false));
        toolbar.refreshToolbarControl();
        GuiHelper.runInEDTAndWait(new Runnable(){

            @Override
            public void run() {
                splashScreen.setVisible(false);
                splashScreen.dispose();
                jFrame.setVisible(true);
            }
        });
        Main.MasterWindowListener.setup();
        boolean bl2 = Main.pref.getBoolean("gui.maximized", false);
        if (!map.containsKey((Object)Option.NO_MAXIMIZE) && bl2 || map.containsKey((Object)Option.MAXIMIZE)) {
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                Main.windowState = 6;
                jFrame.setExtendedState(Main.windowState);
            } else {
                Main.debug("Main window: maximizing not supported");
            }
        }
        if (mainApplication.menu.fullscreenToggleAction != null) {
            mainApplication.menu.fullscreenToggleAction.initial();
        }
        SwingUtilities.invokeLater(new GuiFinalizationWorker(map, (DefaultProxySelector)object3));
        if (RemoteControl.PROP_REMOTECONTROL_ENABLED.get().booleanValue()) {
            RemoteControl.start();
        }
        if (MessageNotifier.PROP_NOTIFIER_ENABLED.get().booleanValue()) {
            MessageNotifier.start();
        }
        if (Main.pref.getBoolean("debug.edt-checker.enable", Version.getInstance().isLocalBuild())) {
            MainApplication.info("Enabled EDT checker, wrongful access to gui from non EDT thread will be printed to console");
            RepaintManager.setCurrentManager(new CheckThreadViolationRepaintManager());
        }
    }

    private static class GuiFinalizationWorker
    implements Runnable {
        private final Map<Option, Collection<String>> args;
        private final DefaultProxySelector proxySelector;

        public GuiFinalizationWorker(Map<Option, Collection<String>> map, DefaultProxySelector defaultProxySelector) {
            this.args = map;
            this.proxySelector = defaultProxySelector;
        }

        @Override
        public void run() {
            if (!this.handleProxyErrors()) {
                this.handleNetworkErrors();
            }
            this.handleAutosave();
            MainApplication.postConstructorProcessCmdLine(this.args);
            DownloadDialog.autostartIfNeeded();
        }

        private void handleAutosave() {
            if (AutosaveTask.PROP_AUTOSAVE_ENABLED.get().booleanValue()) {
                AutosaveTask autosaveTask = new AutosaveTask();
                List<File> list = autosaveTask.getUnsavedLayersFiles();
                if (!list.isEmpty()) {
                    ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Unsaved osm data", new Object[0]), new String[]{I18n.tr("Restore", new Object[0]), I18n.tr("Cancel", new Object[0]), I18n.tr("Discard", new Object[0])});
                    extendedDialog.setContent(I18n.trn("JOSM found {0} unsaved osm data layer. ", "JOSM found {0} unsaved osm data layers. ", list.size(), list.size()) + I18n.tr("It looks like JOSM crashed last time. Would you like to restore the data?", new Object[0]));
                    extendedDialog.setButtonIcons(new String[]{"ok", "cancel", "dialogs/delete"});
                    int n = extendedDialog.showDialog().getValue();
                    if (n == 1) {
                        autosaveTask.recoverUnsavedLayers();
                    } else if (n == 3) {
                        autosaveTask.dicardUnsavedLayers();
                    }
                }
                autosaveTask.schedule();
            }
        }

        private boolean handleNetworkOrProxyErrors(boolean bl, String string, String string2) {
            if (bl) {
                ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, string, new String[]{I18n.tr("Change proxy settings", new Object[0]), I18n.tr("Cancel", new Object[0])});
                extendedDialog.setButtonIcons(new String[]{"dialogs/settings.png", "cancel.png"}).setCancelButton(2);
                extendedDialog.setMinimumSize(new Dimension(460, 260));
                extendedDialog.setIcon(2);
                extendedDialog.setContent(string2);
                if (extendedDialog.showDialog().getValue() == 1) {
                    PreferencesAction.forPreferenceSubTab(null, null, ProxyPreference.class).run();
                }
            }
            return bl;
        }

        private boolean handleProxyErrors() {
            return this.handleNetworkOrProxyErrors(this.proxySelector.hasErrors(), I18n.tr("Proxy errors occurred", new Object[0]), I18n.tr("JOSM tried to access the following resources:<br>{0}but <b>failed</b> to do so, because of the following proxy errors:<br>{1}Would you like to change your proxy settings now?", Utils.joinAsHtmlUnorderedList(this.proxySelector.getErrorResources()), Utils.joinAsHtmlUnorderedList(this.proxySelector.getErrorMessages())));
        }

        private boolean handleNetworkErrors() {
            boolean bl;
            boolean bl2 = bl = !NETWORK_ERRORS.isEmpty();
            if (bl) {
                TreeSet<String> treeSet = new TreeSet<String>();
                for (Throwable throwable : NETWORK_ERRORS.values()) {
                    treeSet.add(throwable.toString());
                }
                return this.handleNetworkOrProxyErrors(bl, I18n.tr("Network errors occurred", new Object[0]), I18n.tr("JOSM tried to access the following resources:<br>{0}but <b>failed</b> to do so, because of the following network errors:<br>{1}It may result of a missing proxy configuration.<br>Would you like to change your proxy settings now?", Utils.joinAsHtmlUnorderedList(NETWORK_ERRORS.keySet()), Utils.joinAsHtmlUnorderedList(treeSet)));
            }
            return false;
        }
    }

    public static enum Option {
        HELP(false),
        VERSION(false),
        DEBUG(false),
        LANGUAGE(true),
        RESET_PREFERENCES(false),
        LOAD_PREFERENCES(true),
        SET(true),
        GEOMETRY(true),
        NO_MAXIMIZE(false),
        MAXIMIZE(false),
        DOWNLOAD(true),
        DOWNLOADGPS(true),
        SELECTION(true);

        private String name = this.name().toLowerCase().replace("_", "-");
        private boolean requiresArgument;

        private Option(boolean bl) {
            this.requiresArgument = bl;
        }

        public String getName() {
            return this.name;
        }

        public boolean requiresArgument() {
            return this.requiresArgument;
        }

        public static Map<Option, Collection<String>> fromStringMap(Map<String, Collection<String>> map) {
            HashMap<Option, Collection<String>> hashMap = new HashMap<Option, Collection<String>>();
            for (Map.Entry<String, Collection<String>> entry : map.entrySet()) {
                Option option = Option.valueOf(entry.getKey().toUpperCase().replace("-", "_"));
                if (option == null) continue;
                hashMap.put(option, entry.getValue());
            }
            return hashMap;
        }
    }
}

