/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmEditorPane;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.WindowGeometry;

public final class HelpAwareOptionPane {
    private HelpAwareOptionPane() {
    }

    private static List<JButton> createOptionButtons(ButtonSpec[] buttonSpecArray, String string) {
        ArrayList<JButton> arrayList = new ArrayList<JButton>();
        if (buttonSpecArray == null) {
            JButton jButton = new JButton(I18n.tr("OK", new Object[0]));
            jButton.setIcon(ImageProvider.get("ok"));
            jButton.setToolTipText(I18n.tr("Click to close the dialog", new Object[0]));
            jButton.setFocusable(true);
            arrayList.add(jButton);
        } else {
            for (final ButtonSpec buttonSpec : buttonSpecArray) {
                final JButton jButton = new JButton(buttonSpec.text);
                jButton.setIcon(buttonSpec.icon);
                jButton.setToolTipText(buttonSpec.tooltipText == null ? "" : buttonSpec.tooltipText);
                if (string != null) {
                    HelpUtil.setHelpContext(jButton, string);
                }
                jButton.setFocusable(true);
                jButton.setEnabled(buttonSpec.isEnabled());
                buttonSpec.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        jButton.setEnabled(buttonSpec.isEnabled());
                    }
                });
                arrayList.add(jButton);
            }
        }
        return arrayList;
    }

    private static JButton createHelpButton(final String string) {
        JButton jButton = new JButton(I18n.tr("Help", new Object[0]));
        jButton.setIcon(ImageProvider.get("help"));
        jButton.setToolTipText(I18n.tr("Show help information", new Object[0]));
        HelpUtil.setHelpContext(jButton, string);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpBrowser.setUrlForHelpTopic(string);
            }
        };
        jButton.addActionListener(abstractAction);
        InputMapUtils.enableEnter(jButton);
        return jButton;
    }

    public static int showOptionDialog(Component component, Object object, String string, int n, Icon icon, final ButtonSpec[] buttonSpecArray, final ButtonSpec buttonSpec, String string2) {
        final List<JButton> list = HelpAwareOptionPane.createOptionButtons(buttonSpecArray, string2);
        if (string2 != null) {
            list.add(HelpAwareOptionPane.createHelpButton(string2));
        }
        JButton jButton = null;
        if (buttonSpecArray != null && buttonSpec != null) {
            for (int i = 0; i < buttonSpecArray.length; ++i) {
                if (buttonSpecArray[i] != buttonSpec) continue;
                jButton = list.get(i);
                break;
            }
        }
        if (object instanceof String) {
            JosmEditorPane josmEditorPane = new JosmEditorPane("text/html", (String)object);
            josmEditorPane.setEditable(false);
            josmEditorPane.setOpaque(false);
            object = josmEditorPane;
        }
        final JOptionPane jOptionPane = new JOptionPane(object, n, -1, icon, list.toArray(), jButton);
        jOptionPane.getValue();
        final JDialog jDialog = new JDialog((Window)JOptionPane.getFrameForComponent(component), string, Dialog.ModalityType.DOCUMENT_MODAL);
        jDialog.setContentPane(jOptionPane);
        jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                jOptionPane.setValue(-1);
                super.windowClosed(windowEvent);
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                if (buttonSpec != null && buttonSpecArray != null && buttonSpecArray.length > 0) {
                    int n;
                    for (n = 0; n < buttonSpecArray.length && buttonSpecArray[n] != buttonSpec; ++n) {
                    }
                    if (n >= buttonSpecArray.length) {
                        ((JButton)list.get(0)).requestFocusInWindow();
                    }
                    ((JButton)list.get(n)).requestFocusInWindow();
                } else {
                    ((JButton)list.get(0)).requestFocusInWindow();
                }
            }
        });
        jDialog.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "close");
        jDialog.getRootPane().getActionMap().put("close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jOptionPane.setValue(-1);
                jDialog.setVisible(false);
            }
        });
        if (buttonSpecArray != null) {
            for (int i = 0; i < buttonSpecArray.length; ++i) {
                DefaultAction defaultAction = new DefaultAction(jDialog, jOptionPane, i);
                list.get(i).addActionListener(defaultAction);
                list.get(i).getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "enter");
                list.get(i).getActionMap().put("enter", defaultAction);
            }
        } else {
            DefaultAction defaultAction = new DefaultAction(jDialog, jOptionPane, 0);
            list.get(0).addActionListener(defaultAction);
            list.get(0).getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "enter");
            list.get(0).getActionMap().put("enter", defaultAction);
        }
        jDialog.pack();
        WindowGeometry.centerOnScreen(jDialog.getSize()).applySafe(jDialog);
        if (string2 != null) {
            HelpUtil.setHelpContext(jDialog.getRootPane(), string2);
        }
        jDialog.setVisible(true);
        return (Integer)jOptionPane.getValue();
    }

    public static int showOptionDialog(Component component, Object object, String string, int n, String string2) {
        return HelpAwareOptionPane.showOptionDialog(component, object, string, n, null, null, null, string2);
    }

    public static void showMessageDialogInEDT(final Component component, final Object object, final String string, final int n, final String string2) {
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                HelpAwareOptionPane.showOptionDialog(component, object, string, n, null, null, null, string2);
            }
        });
    }

    private static class DefaultAction
    extends AbstractAction {
        private JDialog dialog;
        private JOptionPane pane;
        private int value;

        public DefaultAction(JDialog jDialog, JOptionPane jOptionPane, int n) {
            this.dialog = jDialog;
            this.pane = jOptionPane;
            this.value = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.pane.setValue(this.value);
            this.dialog.setVisible(false);
        }
    }

    public static class ButtonSpec {
        public final String text;
        public final Icon icon;
        public final String tooltipText;
        public final String helpTopic;
        private boolean enabled;
        private final Collection<ChangeListener> listeners = new HashSet<ChangeListener>();

        public ButtonSpec(String string, Icon icon, String string2, String string3) {
            this(string, icon, string2, string3, true);
        }

        public ButtonSpec(String string, Icon icon, String string2, String string3, boolean bl) {
            this.text = string;
            this.icon = icon;
            this.tooltipText = string2;
            this.helpTopic = string3;
            this.setEnabled(bl);
        }

        public final boolean isEnabled() {
            return this.enabled;
        }

        public final void setEnabled(boolean bl) {
            if (this.enabled != bl) {
                this.enabled = bl;
                ChangeEvent changeEvent = new ChangeEvent(this);
                for (ChangeListener changeListener : this.listeners) {
                    changeListener.stateChanged(changeEvent);
                }
            }
        }

        private final boolean addChangeListener(ChangeListener changeListener) {
            return changeListener != null ? this.listeners.add(changeListener) : false;
        }
    }
}

