/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WindowGeometry;

public class ExtendedDialog
extends JDialog {
    private final boolean disposeOnClose;
    private int result = 0;
    public static final int DialogClosedOtherwise = 0;
    private boolean toggleable = false;
    private String rememberSizePref = "";
    private WindowGeometry defaultWindowGeometry = null;
    private String togglePref = "";
    private int toggleValue = -1;
    private ConditionalOptionPaneUtil.MessagePanel togglePanel;
    private Component parent;
    private Component content;
    private final String[] bTexts;
    private String[] bToolTipTexts;
    private Icon[] bIcons;
    private List<Integer> cancelButtonIdx = Collections.emptyList();
    private int defaultButtonIdx = 1;
    protected JButton defaultButton = null;
    private Icon icon;
    private boolean modal;
    private boolean showHelpButton;
    private String helpTopic;
    private boolean placeContentInScrollPane;
    protected Insets contentInsets = new Insets(10, 5, 0, 5);
    protected List<JButton> buttons = new ArrayList<JButton>();
    private boolean setupDone = false;

    public ExtendedDialog(Component component, String string, String[] stringArray) {
        this(component, string, stringArray, true, true);
    }

    public ExtendedDialog(Component component, String string, String[] stringArray, boolean bl) {
        this(component, string, stringArray, bl, true);
    }

    public ExtendedDialog(Component component, String string, String[] stringArray, boolean bl, boolean bl2) {
        super((Window)JOptionPane.getFrameForComponent(component), string, bl ? Dialog.ModalityType.DOCUMENT_MODAL : Dialog.ModalityType.MODELESS);
        this.parent = component;
        this.modal = bl;
        this.bTexts = Utils.copyArray(stringArray);
        if (bl2) {
            this.setDefaultCloseOperation(2);
        }
        this.disposeOnClose = bl2;
    }

    public ExtendedDialog setButtonIcons(Icon[] iconArray) {
        this.bIcons = Utils.copyArray(iconArray);
        return this;
    }

    public ExtendedDialog setButtonIcons(String[] stringArray) {
        this.bIcons = new Icon[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.bIcons[i] = ImageProvider.get(stringArray[i]);
        }
        return this;
    }

    public ExtendedDialog setToolTipTexts(String[] stringArray) {
        this.bToolTipTexts = Utils.copyArray(stringArray);
        return this;
    }

    public ExtendedDialog setContent(Component component) {
        return this.setContent(component, true);
    }

    public ExtendedDialog setContent(Component component, boolean bl) {
        this.content = component;
        this.placeContentInScrollPane = bl;
        return this;
    }

    public ExtendedDialog setContent(String string) {
        return this.setContent(ExtendedDialog.string2label(string), false);
    }

    public ExtendedDialog setIcon(Icon icon) {
        this.icon = icon;
        return this;
    }

    public ExtendedDialog setIcon(int n) {
        switch (n) {
            case 0: {
                return this.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
            }
            case 1: {
                return this.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
            }
            case 2: {
                return this.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
            }
            case 3: {
                return this.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
            }
            case -1: {
                return this.setIcon(null);
            }
        }
        throw new IllegalArgumentException("Unknown message type!");
    }

    public ExtendedDialog showDialog() {
        if (this.toggleCheckState()) {
            this.result = this.toggleValue;
            return this;
        }
        this.setupDialog();
        if (this.defaultButton != null) {
            this.getRootPane().setDefaultButton(this.defaultButton);
        }
        this.fixFocus();
        this.setVisible(true);
        this.toggleSaveState();
        return this;
    }

    public int getValue() {
        return this.result;
    }

    public void setupDialog() {
        boolean bl;
        Serializable serializable;
        if (this.setupDone) {
            return;
        }
        this.setupDone = true;
        this.setupEscListener();
        JPanel jPanel = new JPanel(new GridBagLayout());
        for (int i = 0; i < this.bTexts.length; ++i) {
            final int n = i;
            AbstractAction abstractAction = new AbstractAction(this.bTexts[i]){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExtendedDialog.this.buttonAction(n, actionEvent);
                }
            };
            JButton jButton = new JButton(abstractAction);
            if (i == this.defaultButtonIdx - 1) {
                this.defaultButton = jButton;
            }
            if (this.bIcons != null && this.bIcons[i] != null) {
                jButton.setIcon(this.bIcons[i]);
            }
            if (this.bToolTipTexts != null && i < this.bToolTipTexts.length && this.bToolTipTexts[i] != null) {
                jButton.setToolTipText(this.bToolTipTexts[i]);
            }
            jPanel.add((Component)jButton, GBC.std().insets(2, 2, 2, 2));
            this.buttons.add(jButton);
        }
        if (this.showHelpButton) {
            jPanel.add((Component)new JButton(new HelpAction()), GBC.std().insets(2, 2, 2, 2));
            HelpUtil.setHelpContext(this.getRootPane(), this.helpTopic);
        }
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        if (this.icon != null) {
            serializable = new JLabel(this.icon);
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weighty = 1.0;
            jPanel2.add((Component)serializable, gridBagConstraints);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.gridx = 1;
        }
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = this.contentInsets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add(this.content, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        if (this.toggleable) {
            this.togglePanel = new ConditionalOptionPaneUtil.MessagePanel((Object)null, ConditionalOptionPaneUtil.isInBulkOperation(this.togglePref));
            gridBagConstraints.gridx = this.icon != null ? 1 : 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(5, this.contentInsets.left, 5, this.contentInsets.right);
            jPanel2.add((Component)this.togglePanel, gridBagConstraints);
        }
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel2.add((Component)jPanel, gridBagConstraints);
        if (this.placeContentInScrollPane) {
            serializable = new JScrollPane(jPanel2);
            serializable.setBorder(null);
            this.setContentPane((Container)serializable);
        } else {
            this.setContentPane(jPanel2);
        }
        this.pack();
        serializable = this.getSize();
        Dimension dimension = this.findMaxDialogSize();
        boolean bl2 = ((Dimension)serializable).width > dimension.width;
        boolean bl3 = bl = ((Dimension)serializable).height > dimension.height;
        if (dimension.width > 0 && ((Dimension)serializable).width > dimension.width) {
            ((Dimension)serializable).width = dimension.width;
        }
        if (dimension.height > 0 && ((Dimension)serializable).height > dimension.height) {
            ((Dimension)serializable).height = dimension.height;
        }
        if (!bl2 && bl) {
            ((Dimension)serializable).width += new JScrollBar().getPreferredSize().width;
        }
        this.setSize((Dimension)serializable);
        this.setLocationRelativeTo(this.parent);
    }

    protected void buttonAction(int n, ActionEvent actionEvent) {
        this.result = n + 1;
        this.setVisible(false);
    }

    protected Dimension findMaxDialogSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = new Dimension(dimension.width * 2 / 3, dimension.height * 2 / 3);
        if (this.parent != null) {
            dimension2 = JOptionPane.getFrameForComponent(this.parent).getSize();
        }
        return dimension2;
    }

    private void setupEscListener() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtendedDialog.this.result = 0;
                ExtendedDialog.this.setVisible(false);
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
    }

    protected final void rememberWindowGeometry(WindowGeometry windowGeometry) {
        if (windowGeometry != null) {
            windowGeometry.remember(this.rememberSizePref);
        }
    }

    protected final WindowGeometry initWindowGeometry() {
        return new WindowGeometry(this.rememberSizePref, this.defaultWindowGeometry);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.repaint();
        }
        if (this.rememberSizePref.length() != 0 && this.defaultWindowGeometry != null) {
            if (bl) {
                this.initWindowGeometry().applySafe(this);
            } else if (this.isShowing()) {
                this.rememberWindowGeometry(new WindowGeometry(this));
            }
        }
        super.setVisible(bl);
        if (!bl && this.disposeOnClose) {
            this.dispose();
        }
    }

    public ExtendedDialog setRememberWindowGeometry(String string, WindowGeometry windowGeometry) {
        this.rememberSizePref = string == null ? "" : string;
        this.defaultWindowGeometry = windowGeometry;
        return this;
    }

    public ExtendedDialog toggleEnable(String string) {
        if (!this.modal) {
            throw new IllegalArgumentException();
        }
        this.toggleable = true;
        this.togglePref = string;
        return this;
    }

    public ExtendedDialog toggleDisable() {
        this.toggleable = false;
        return this;
    }

    public ExtendedDialog setDefaultButton(int n) {
        this.defaultButtonIdx = n;
        return this;
    }

    public ExtendedDialog setCancelButton(Integer ... integerArray) {
        this.cancelButtonIdx = Arrays.asList(integerArray);
        return this;
    }

    protected void fixFocus() {
        if (this.toggleable && this.defaultButton != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtendedDialog.this.defaultButton.requestFocusInWindow();
                }
            });
        }
    }

    public final boolean toggleCheckState() {
        this.toggleable = this.togglePref != null && !this.togglePref.isEmpty();
        this.toggleValue = ConditionalOptionPaneUtil.getDialogReturnValue(this.togglePref);
        return this.toggleable && this.toggleValue != -1;
    }

    private void toggleSaveState() {
        if (!this.toggleable || this.togglePanel == null || this.cancelButtonIdx.contains(this.result) || this.result == 0) {
            return;
        }
        this.togglePanel.getNotShowAgain().store(this.togglePref, this.result);
    }

    private static JMultilineLabel string2label(String string) {
        JMultilineLabel jMultilineLabel = new JMultilineLabel(string);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        jMultilineLabel.setMaxWidth(dimension.width / 2);
        return jMultilineLabel;
    }

    public ExtendedDialog configureContextsensitiveHelp(String string, boolean bl) {
        this.helpTopic = string;
        this.showHelpButton = bl;
        return this;
    }

    class HelpAction
    extends AbstractAction {
        public HelpAction() {
            this.putValue("ShortDescription", I18n.tr("Show help information", new Object[0]));
            this.putValue("Name", I18n.tr("Help", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("help"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HelpBrowser.setUrlForHelpTopic(ExtendedDialog.this.helpTopic);
        }
    }
}

