/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.ChangePropertyKeyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.Entities;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItems;
import org.openstreetmap.josm.gui.widgets.EditableList;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;

public class TagChecker
extends Test.TagTest {
    public static final String DATA_FILE = "resource://data/validator/tagchecker.cfg";
    public static final String IGNORE_FILE = "resource://data/validator/ignoretags.cfg";
    public static final String SPELL_FILE = "resource://data/validator/words.cfg";
    protected static Map<String, String> spellCheckKeyData;
    protected static MultiMap<String, String> presetsValueData;
    protected static final List<CheckerData> checkerData;
    protected static final List<String> ignoreDataStartsWith;
    protected static final List<String> ignoreDataEquals;
    protected static final List<String> ignoreDataEndsWith;
    protected static final List<IgnoreKeyPair> ignoreDataKeyPair;
    protected static final String PREFIX;
    public static final String PREF_CHECK_VALUES;
    public static final String PREF_CHECK_KEYS;
    public static final String PREF_CHECK_COMPLEX;
    public static final String PREF_CHECK_FIXMES;
    public static final String PREF_SOURCES;
    public static final String PREF_CHECK_KEYS_BEFORE_UPLOAD;
    public static final String PREF_CHECK_VALUES_BEFORE_UPLOAD;
    public static final String PREF_CHECK_COMPLEX_BEFORE_UPLOAD;
    public static final String PREF_CHECK_FIXMES_BEFORE_UPLOAD;
    protected boolean checkKeys = false;
    protected boolean checkValues = false;
    protected boolean checkComplex = false;
    protected boolean checkFixmes = false;
    protected JCheckBox prefCheckKeys;
    protected JCheckBox prefCheckValues;
    protected JCheckBox prefCheckComplex;
    protected JCheckBox prefCheckFixmes;
    protected JCheckBox prefCheckPaint;
    protected JCheckBox prefCheckKeysBeforeUpload;
    protected JCheckBox prefCheckValuesBeforeUpload;
    protected JCheckBox prefCheckComplexBeforeUpload;
    protected JCheckBox prefCheckFixmesBeforeUpload;
    protected JCheckBox prefCheckPaintBeforeUpload;
    protected static final int EMPTY_VALUES = 1200;
    protected static final int INVALID_KEY = 1201;
    protected static final int INVALID_VALUE = 1202;
    protected static final int FIXME = 1203;
    protected static final int INVALID_SPACE = 1204;
    protected static final int INVALID_KEY_SPACE = 1205;
    protected static final int INVALID_HTML = 1206;
    protected static final int LONG_VALUE = 1208;
    protected static final int LONG_KEY = 1209;
    protected static final int LOW_CHAR_VALUE = 1210;
    protected static final int LOW_CHAR_KEY = 1211;
    protected EditableList sourcesList;
    protected static final Entities entities;
    static final List<String> DEFAULT_SOURCES;

    public TagChecker() {
        super(I18n.tr("Tag checker", new Object[0]), I18n.tr("This test checks for errors in tag keys and values.", new Object[0]));
    }

    @Override
    public void initialize() throws IOException {
        TagChecker.initializeData();
        TagChecker.initializePresets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeData() throws IOException {
        checkerData.clear();
        ignoreDataStartsWith.clear();
        ignoreDataEquals.clear();
        ignoreDataEndsWith.clear();
        ignoreDataKeyPair.clear();
        spellCheckKeyData = new HashMap<String, String>();
        String string = "";
        for (String string2 : Main.pref.getCollection(PREF_SOURCES, DEFAULT_SOURCES)) {
            BufferedReader bufferedReader = null;
            try {
                String string3;
                MirroredInputStream mirroredInputStream = new MirroredInputStream(string2);
                bufferedReader = new BufferedReader(UTFInputStreamReader.create(mirroredInputStream));
                String string4 = null;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = true;
                while ((string3 = bufferedReader.readLine()) != null && (bl || string3.length() != 0)) {
                    Object object;
                    Object object2;
                    if (string3.startsWith("#")) {
                        if (string3.startsWith("# JOSM TagChecker")) {
                            bl = true;
                            if (!DEFAULT_SOURCES.contains(string2)) {
                                Main.info(I18n.tr("Adding {0} to tag checker", string2));
                            }
                        } else if (string3.startsWith("# JOSM IgnoreTags")) {
                            bl2 = true;
                            if (!DEFAULT_SOURCES.contains(string2)) {
                                Main.info(I18n.tr("Adding {0} to ignore tags", string2));
                            }
                        }
                    } else if (bl2) {
                        if ((string3 = string3.trim()).length() < 4) continue;
                        object2 = string3.substring(0, 2);
                        string3 = string3.substring(2);
                        if (((String)object2).equals("S:")) {
                            ignoreDataStartsWith.add(string3);
                        } else if (((String)object2).equals("E:")) {
                            ignoreDataEquals.add(string3);
                        } else if (((String)object2).equals("F:")) {
                            ignoreDataEndsWith.add(string3);
                        } else if (((String)object2).equals("K:")) {
                            object = new IgnoreKeyPair();
                            int n = string3.indexOf(61);
                            ((IgnoreKeyPair)object).key = string3.substring(0, n);
                            ((IgnoreKeyPair)object).value = string3.substring(n + 1);
                            ignoreDataKeyPair.add((IgnoreKeyPair)object);
                        }
                    } else if (bl) {
                        if (string3.length() > 0) {
                            object2 = new CheckerData();
                            object = ((CheckerData)object2).getData(string3);
                            if (object == null) {
                                checkerData.add((CheckerData)object2);
                            } else {
                                Main.error(I18n.tr("Invalid tagchecker line - {0}: {1}", object, string3));
                            }
                        }
                    } else if (string3.charAt(0) == '+') {
                        string4 = string3.substring(1);
                    } else if (string3.charAt(0) == '-' && string4 != null) {
                        spellCheckKeyData.put(string3.substring(1), string4);
                    } else {
                        Main.error(I18n.tr("Invalid spellcheck line: {0}", string3));
                    }
                    if (!bl3) continue;
                    bl3 = false;
                    if (bl || bl2 || DEFAULT_SOURCES.contains(string2)) continue;
                    Main.info(I18n.tr("Adding {0} to spellchecker", string2));
                }
            }
            catch (IOException iOException) {
                try {
                    string = string + string2 + "\n";
                }
                catch (Throwable throwable) {
                    Utils.close(bufferedReader);
                    throw throwable;
                }
                Utils.close(bufferedReader);
                continue;
            }
            Utils.close(bufferedReader);
        }
        if (string.length() > 0) {
            throw new IOException(I18n.tr("Could not access data file(s):\n{0}", string));
        }
    }

    public static void initializePresets() {
        if (!Main.pref.getBoolean(PREF_CHECK_VALUES, true)) {
            return;
        }
        Collection<TaggingPreset> collection = TaggingPresetPreference.taggingPresets;
        if (collection != null) {
            presetsValueData = new MultiMap();
            for (String object : OsmPrimitive.getUninterestingKeys()) {
                presetsValueData.putVoid(object);
            }
            for (String string : Main.pref.getCollection("validator.knownkeys", Arrays.asList("is_in", "int_ref", "fixme", "population"))) {
                presetsValueData.putVoid(string);
            }
            for (TaggingPreset taggingPreset : collection) {
                for (TaggingPresetItem taggingPresetItem : taggingPreset.data) {
                    if (taggingPresetItem instanceof TaggingPresetItems.KeyedItem) {
                        TagChecker.addPresetValue(taggingPreset, (TaggingPresetItems.KeyedItem)taggingPresetItem);
                        continue;
                    }
                    if (!(taggingPresetItem instanceof TaggingPresetItems.CheckGroup)) continue;
                    for (TaggingPresetItems.Check check : ((TaggingPresetItems.CheckGroup)taggingPresetItem).checks) {
                        TagChecker.addPresetValue(taggingPreset, check);
                    }
                }
            }
        }
    }

    private static void addPresetValue(TaggingPreset taggingPreset, TaggingPresetItems.KeyedItem keyedItem) {
        Collection<String> collection = keyedItem.getValues();
        if (keyedItem.key != null && collection != null) {
            try {
                presetsValueData.putAll(keyedItem.key, collection);
            }
            catch (NullPointerException nullPointerException) {
                Main.error(taggingPreset + ": Unable to initialize " + keyedItem);
            }
        }
    }

    private boolean containsLow(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) >= ' ') continue;
            return true;
        }
        return false;
    }

    @Override
    public void check(OsmPrimitive osmPrimitive) {
        MultiMap<OsmPrimitive, String> multiMap = new MultiMap<OsmPrimitive, String>();
        if (this.checkComplex) {
            Map<String, String> map = osmPrimitive.getKeys();
            for (CheckerData checkerData : TagChecker.checkerData) {
                if (!checkerData.match(osmPrimitive, map)) continue;
                this.errors.add(new TestError((Test)this, checkerData.getSeverity(), I18n.tr("Suspicious tag/value combinations", new Object[0]), checkerData.getDescription(), checkerData.getDescriptionOrig(), checkerData.getCode(), osmPrimitive));
                multiMap.put(osmPrimitive, "TC");
            }
        }
        for (Map.Entry entry : osmPrimitive.getKeys().entrySet()) {
            String string = I18n.marktr("Key ''{0}'' invalid.");
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            if (this.checkValues && this.containsLow(string3) && !multiMap.contains(osmPrimitive, "ICV")) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Tag value contains character with code less than 0x20", new Object[0]), I18n.tr(string, string2), MessageFormat.format(string, string2), 1210, osmPrimitive));
                multiMap.put(osmPrimitive, "ICV");
            }
            if (this.checkKeys && this.containsLow(string2) && !multiMap.contains(osmPrimitive, "ICK")) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Tag key contains character with code less than 0x20", new Object[0]), I18n.tr(string, string2), MessageFormat.format(string, string2), 1211, osmPrimitive));
                multiMap.put(osmPrimitive, "ICK");
            }
            if (this.checkValues && string3 != null && string3.length() > 255 && !multiMap.contains(osmPrimitive, "LV")) {
                this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("Tag value longer than allowed", new Object[0]), I18n.tr(string, string2), MessageFormat.format(string, string2), 1208, osmPrimitive));
                multiMap.put(osmPrimitive, "LV");
            }
            if (this.checkKeys && string2 != null && string2.length() > 255 && !multiMap.contains(osmPrimitive, "LK")) {
                this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("Tag key longer than allowed", new Object[0]), I18n.tr(string, string2), MessageFormat.format(string, string2), 1209, osmPrimitive));
                multiMap.put(osmPrimitive, "LK");
            }
            if (this.checkValues && (string3 == null || string3.trim().length() == 0) && !multiMap.contains(osmPrimitive, "EV")) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Tags with empty values", new Object[0]), I18n.tr(string, string2), MessageFormat.format(string, string2), 1200, osmPrimitive));
                multiMap.put(osmPrimitive, "EV");
            }
            if (this.checkKeys && spellCheckKeyData.containsKey(string2) && !multiMap.contains(osmPrimitive, "IPK")) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Invalid property key", new Object[0]), I18n.tr(string, string2), MessageFormat.format(string, string2), 1201, osmPrimitive));
                multiMap.put(osmPrimitive, "IPK");
            }
            if (this.checkKeys && string2.indexOf(32) >= 0 && !multiMap.contains(osmPrimitive, "IPK")) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Invalid white space in property key", new Object[0]), I18n.tr(string, string2), MessageFormat.format(string, string2), 1205, osmPrimitive));
                multiMap.put(osmPrimitive, "IPK");
            }
            if (this.checkValues && string3 != null && (string3.startsWith(" ") || string3.endsWith(" ")) && !multiMap.contains(osmPrimitive, "SPACE")) {
                this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("Property values start or end with white space", new Object[0]), I18n.tr(string, string2), MessageFormat.format(string, string2), 1204, osmPrimitive));
                multiMap.put(osmPrimitive, "SPACE");
            }
            if (this.checkValues && string3 != null && !string3.equals(entities.unescape(string3)) && !multiMap.contains(osmPrimitive, "HTML")) {
                this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("Property values contain HTML entity", new Object[0]), I18n.tr(string, string2), MessageFormat.format(string, string2), 1206, osmPrimitive));
                multiMap.put(osmPrimitive, "HTML");
            }
            if (this.checkValues && string3 != null && string3.length() > 0 && presetsValueData != null) {
                Set<String> set = presetsValueData.get(string2);
                boolean bl = set != null;
                boolean bl2 = set != null && (set.isEmpty() || set.contains(entry.getValue()));
                boolean bl3 = false;
                for (String string4 : ignoreDataStartsWith) {
                    if (!string2.startsWith(string4)) continue;
                    bl3 = true;
                }
                for (String string5 : ignoreDataEquals) {
                    if (!string2.equals(string5)) continue;
                    bl3 = true;
                }
                for (String string6 : ignoreDataEndsWith) {
                    if (!string2.endsWith(string6)) continue;
                    bl3 = true;
                }
                if (!bl2) {
                    for (IgnoreKeyPair ignoreKeyPair : ignoreDataKeyPair) {
                        if (!string2.equals(ignoreKeyPair.key) || !string3.equals(ignoreKeyPair.value)) continue;
                        bl3 = true;
                    }
                }
                if (!bl3) {
                    Object object;
                    if (!bl) {
                        object = I18n.marktr("Key ''{0}'' not in presets.");
                        this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("Presets do not contain property key", new Object[0]), I18n.tr((String)object, string2), MessageFormat.format((String)object, string2), 1202, osmPrimitive));
                        multiMap.put(osmPrimitive, "UPK");
                    } else if (!bl2) {
                        object = I18n.marktr("Value ''{0}'' for key ''{1}'' not in presets.");
                        this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("Presets do not contain property value", new Object[0]), I18n.tr((String)object, entry.getValue(), string2), MessageFormat.format((String)object, entry.getValue(), string2), 1202, osmPrimitive));
                        multiMap.put(osmPrimitive, "UPV");
                    }
                }
            }
            if (!this.checkFixmes || string3 == null || string3.length() <= 0 || !string3.toLowerCase().contains("fixme") && !string3.contains("check and delete") && !string2.contains("todo") && !string2.toLowerCase().contains("fixme") || multiMap.contains(osmPrimitive, "FIXME")) continue;
            this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("FIXMES", new Object[0]), 1203, osmPrimitive));
            multiMap.put(osmPrimitive, "FIXME");
        }
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.checkKeys = Main.pref.getBoolean(PREF_CHECK_KEYS, true);
        if (this.isBeforeUpload) {
            this.checkKeys = this.checkKeys && Main.pref.getBoolean(PREF_CHECK_KEYS_BEFORE_UPLOAD, true);
        }
        this.checkValues = Main.pref.getBoolean(PREF_CHECK_VALUES, true);
        if (this.isBeforeUpload) {
            this.checkValues = this.checkValues && Main.pref.getBoolean(PREF_CHECK_VALUES_BEFORE_UPLOAD, true);
        }
        this.checkComplex = Main.pref.getBoolean(PREF_CHECK_COMPLEX, true);
        if (this.isBeforeUpload) {
            this.checkComplex = this.checkValues && Main.pref.getBoolean(PREF_CHECK_COMPLEX_BEFORE_UPLOAD, true);
        }
        this.checkFixmes = Main.pref.getBoolean(PREF_CHECK_FIXMES, true);
        if (this.isBeforeUpload) {
            this.checkFixmes = this.checkFixmes && Main.pref.getBoolean(PREF_CHECK_FIXMES_BEFORE_UPLOAD, true);
        }
    }

    @Override
    public void visit(Collection<OsmPrimitive> collection) {
        if (this.checkKeys || this.checkValues || this.checkComplex || this.checkFixmes) {
            super.visit(collection);
        }
    }

    @Override
    public void addGui(JPanel jPanel) {
        GBC gBC = GBC.eol();
        gBC.anchor = 13;
        jPanel.add((Component)new JLabel(this.name + " :"), GBC.eol().insets(3, 0, 0, 0));
        this.prefCheckKeys = new JCheckBox(I18n.tr("Check property keys.", new Object[0]), Main.pref.getBoolean(PREF_CHECK_KEYS, true));
        this.prefCheckKeys.setToolTipText(I18n.tr("Validate that property keys are valid checking against list of words.", new Object[0]));
        jPanel.add((Component)this.prefCheckKeys, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckKeysBeforeUpload = new JCheckBox();
        this.prefCheckKeysBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_KEYS_BEFORE_UPLOAD, true));
        jPanel.add((Component)this.prefCheckKeysBeforeUpload, gBC);
        this.prefCheckComplex = new JCheckBox(I18n.tr("Use complex property checker.", new Object[0]), Main.pref.getBoolean(PREF_CHECK_COMPLEX, true));
        this.prefCheckComplex.setToolTipText(I18n.tr("Validate property values and tags using complex rules.", new Object[0]));
        jPanel.add((Component)this.prefCheckComplex, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckComplexBeforeUpload = new JCheckBox();
        this.prefCheckComplexBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_COMPLEX_BEFORE_UPLOAD, true));
        jPanel.add((Component)this.prefCheckComplexBeforeUpload, gBC);
        Collection<String> collection = Main.pref.getCollection(PREF_SOURCES, Arrays.asList(DATA_FILE, IGNORE_FILE, SPELL_FILE));
        this.sourcesList = new EditableList(I18n.tr("TagChecker source", new Object[0]));
        this.sourcesList.setItems(collection);
        jPanel.add((Component)new JLabel(I18n.tr("Data sources ({0})", "*.cfg")), GBC.eol().insets(23, 0, 0, 0));
        jPanel.add((Component)this.sourcesList, GBC.eol().fill(2).insets(23, 0, 0, 0));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TagChecker.this.handlePrefEnable();
            }
        };
        this.prefCheckKeys.addActionListener(actionListener);
        this.prefCheckKeysBeforeUpload.addActionListener(actionListener);
        this.prefCheckComplex.addActionListener(actionListener);
        this.prefCheckComplexBeforeUpload.addActionListener(actionListener);
        this.handlePrefEnable();
        this.prefCheckValues = new JCheckBox(I18n.tr("Check property values.", new Object[0]), Main.pref.getBoolean(PREF_CHECK_VALUES, true));
        this.prefCheckValues.setToolTipText(I18n.tr("Validate that property values are valid checking against presets.", new Object[0]));
        jPanel.add((Component)this.prefCheckValues, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckValuesBeforeUpload = new JCheckBox();
        this.prefCheckValuesBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_VALUES_BEFORE_UPLOAD, true));
        jPanel.add((Component)this.prefCheckValuesBeforeUpload, gBC);
        this.prefCheckFixmes = new JCheckBox(I18n.tr("Check for FIXMES.", new Object[0]), Main.pref.getBoolean(PREF_CHECK_FIXMES, true));
        this.prefCheckFixmes.setToolTipText(I18n.tr("Looks for nodes or ways with FIXME in any property value.", new Object[0]));
        jPanel.add((Component)this.prefCheckFixmes, GBC.std().insets(20, 0, 0, 0));
        this.prefCheckFixmesBeforeUpload = new JCheckBox();
        this.prefCheckFixmesBeforeUpload.setSelected(Main.pref.getBoolean(PREF_CHECK_FIXMES_BEFORE_UPLOAD, true));
        jPanel.add((Component)this.prefCheckFixmesBeforeUpload, gBC);
    }

    public void handlePrefEnable() {
        boolean bl = this.prefCheckKeys.isSelected() || this.prefCheckKeysBeforeUpload.isSelected() || this.prefCheckComplex.isSelected() || this.prefCheckComplexBeforeUpload.isSelected();
        this.sourcesList.setEnabled(bl);
    }

    @Override
    public boolean ok() {
        this.enabled = this.prefCheckKeys.isSelected() || this.prefCheckValues.isSelected() || this.prefCheckComplex.isSelected() || this.prefCheckFixmes.isSelected();
        this.testBeforeUpload = this.prefCheckKeysBeforeUpload.isSelected() || this.prefCheckValuesBeforeUpload.isSelected() || this.prefCheckFixmesBeforeUpload.isSelected() || this.prefCheckComplexBeforeUpload.isSelected();
        Main.pref.put(PREF_CHECK_VALUES, this.prefCheckValues.isSelected());
        Main.pref.put(PREF_CHECK_COMPLEX, this.prefCheckComplex.isSelected());
        Main.pref.put(PREF_CHECK_KEYS, this.prefCheckKeys.isSelected());
        Main.pref.put(PREF_CHECK_FIXMES, this.prefCheckFixmes.isSelected());
        Main.pref.put(PREF_CHECK_VALUES_BEFORE_UPLOAD, this.prefCheckValuesBeforeUpload.isSelected());
        Main.pref.put(PREF_CHECK_COMPLEX_BEFORE_UPLOAD, this.prefCheckComplexBeforeUpload.isSelected());
        Main.pref.put(PREF_CHECK_KEYS_BEFORE_UPLOAD, this.prefCheckKeysBeforeUpload.isSelected());
        Main.pref.put(PREF_CHECK_FIXMES_BEFORE_UPLOAD, this.prefCheckFixmesBeforeUpload.isSelected());
        return Main.pref.putCollection(PREF_SOURCES, this.sourcesList.getItems());
    }

    @Override
    public Command fixError(TestError testError) {
        ArrayList<Command> arrayList = new ArrayList<Command>(50);
        Collection<? extends OsmPrimitive> collection = testError.getPrimitives();
        for (OsmPrimitive osmPrimitive : collection) {
            Map<String, String> map = osmPrimitive.getKeys();
            if (map == null || map.isEmpty()) continue;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                if (string2 == null || string2.trim().length() == 0) {
                    arrayList.add(new ChangePropertyCommand(osmPrimitive, string, null));
                    continue;
                }
                if (string2.startsWith(" ") || string2.endsWith(" ")) {
                    arrayList.add(new ChangePropertyCommand(osmPrimitive, string, Tag.removeWhiteSpaces(string2)));
                    continue;
                }
                if (string.startsWith(" ") || string.endsWith(" ")) {
                    arrayList.add(new ChangePropertyKeyCommand(osmPrimitive, string, Tag.removeWhiteSpaces(string)));
                    continue;
                }
                String string3 = entities.unescape(string2);
                if (!string3.equals(string2)) {
                    arrayList.add(new ChangePropertyCommand(osmPrimitive, string, string3));
                    continue;
                }
                String string4 = spellCheckKeyData.get(string);
                if (string4 == null) continue;
                arrayList.add(new ChangePropertyKeyCommand(osmPrimitive, string, string4));
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (Command)arrayList.get(0);
        }
        return new SequenceCommand(I18n.tr("Fix tags", new Object[0]), arrayList);
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof TagChecker) {
            int n = testError.getCode();
            return n == 1201 || n == 1200 || n == 1204 || n == 1205 || n == 1206;
        }
        return false;
    }

    static {
        checkerData = new ArrayList<CheckerData>();
        ignoreDataStartsWith = new ArrayList<String>();
        ignoreDataEquals = new ArrayList<String>();
        ignoreDataEndsWith = new ArrayList<String>();
        ignoreDataKeyPair = new ArrayList<IgnoreKeyPair>();
        PREFIX = "validator." + TagChecker.class.getSimpleName();
        PREF_CHECK_VALUES = PREFIX + ".checkValues";
        PREF_CHECK_KEYS = PREFIX + ".checkKeys";
        PREF_CHECK_COMPLEX = PREFIX + ".checkComplex";
        PREF_CHECK_FIXMES = PREFIX + ".checkFixmes";
        PREF_SOURCES = PREFIX + ".source";
        PREF_CHECK_KEYS_BEFORE_UPLOAD = PREF_CHECK_KEYS + "BeforeUpload";
        PREF_CHECK_VALUES_BEFORE_UPLOAD = PREF_CHECK_VALUES + "BeforeUpload";
        PREF_CHECK_COMPLEX_BEFORE_UPLOAD = PREF_CHECK_COMPLEX + "BeforeUpload";
        PREF_CHECK_FIXMES_BEFORE_UPLOAD = PREF_CHECK_FIXMES + "BeforeUpload";
        entities = new Entities();
        DEFAULT_SOURCES = Arrays.asList(DATA_FILE, IGNORE_FILE, SPELL_FILE);
    }

    protected static class CheckerData {
        private String description;
        protected List<CheckerElement> data = new ArrayList<CheckerElement>();
        private OsmPrimitiveType type;
        private int code;
        protected Severity severity;
        protected static final int TAG_CHECK_ERROR = 1250;
        protected static final int TAG_CHECK_WARN = 1260;
        protected static final int TAG_CHECK_INFO = 1270;
        private static final Pattern CLEAN_STR_PATTERN = Pattern.compile(" *# *([^#]+) *$");
        private static final Pattern SPLIT_TRIMMED_PATTERN = Pattern.compile(" *: *");
        private static final Pattern SPLIT_ELEMENTS_PATTERN = Pattern.compile(" *&& *");

        protected CheckerData() {
        }

        public String getData(String string) {
            Matcher matcher = CLEAN_STR_PATTERN.matcher(string);
            String string2 = matcher.replaceFirst("").trim();
            try {
                this.description = matcher.group(1);
                if (this.description != null && this.description.length() == 0) {
                    this.description = null;
                }
            }
            catch (IllegalStateException illegalStateException) {
                this.description = null;
            }
            String[] stringArray = SPLIT_TRIMMED_PATTERN.split(string2, 3);
            if (stringArray[0].equals("way")) {
                this.type = OsmPrimitiveType.WAY;
            } else if (stringArray[0].equals("node")) {
                this.type = OsmPrimitiveType.NODE;
            } else if (stringArray[0].equals("relation")) {
                this.type = OsmPrimitiveType.RELATION;
            } else if (stringArray[0].equals("*")) {
                this.type = null;
            } else {
                return I18n.tr("Could not find element type", new Object[0]);
            }
            if (stringArray.length != 3) {
                return I18n.tr("Incorrect number of parameters", new Object[0]);
            }
            if (stringArray[1].equals("W")) {
                this.severity = Severity.WARNING;
                this.code = 1260;
            } else if (stringArray[1].equals("E")) {
                this.severity = Severity.ERROR;
                this.code = 1250;
            } else if (stringArray[1].equals("I")) {
                this.severity = Severity.OTHER;
                this.code = 1270;
            } else {
                return I18n.tr("Could not find warning level", new Object[0]);
            }
            for (String string3 : SPLIT_ELEMENTS_PATTERN.split(stringArray[2])) {
                try {
                    this.data.add(new CheckerElement(string3));
                }
                catch (IllegalStateException illegalStateException) {
                    return I18n.tr("Illegal expression ''{0}''", string3);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return I18n.tr("Illegal regular expression ''{0}''", string3);
                }
            }
            return null;
        }

        public boolean match(OsmPrimitive osmPrimitive, Map<String, String> map) {
            if (this.type != null && OsmPrimitiveType.from(osmPrimitive) != this.type) {
                return false;
            }
            for (CheckerElement checkerElement : this.data) {
                if (checkerElement.match(osmPrimitive, map)) continue;
                return false;
            }
            return true;
        }

        public String getDescription() {
            return I18n.tr(this.description, new Object[0]);
        }

        public String getDescriptionOrig() {
            return this.description;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public int getCode() {
            if (this.type == null) {
                return this.code;
            }
            return this.code + this.type.ordinal() + 1;
        }

        protected static class CheckerElement {
            public Object tag;
            public Object value;
            public boolean noMatch;
            public boolean tagAll = false;
            public boolean valueAll = false;
            public boolean valueBool = false;

            private Pattern getPattern(String string) throws IllegalStateException, PatternSyntaxException {
                if (string.endsWith("/i")) {
                    return Pattern.compile(string.substring(1, string.length() - 2), 2);
                }
                if (string.endsWith("/")) {
                    return Pattern.compile(string.substring(1, string.length() - 1));
                }
                throw new IllegalStateException();
            }

            public CheckerElement(String string) throws IllegalStateException, PatternSyntaxException {
                Matcher matcher = Pattern.compile("(.+)([!=]=)(.+)").matcher(string);
                matcher.matches();
                String string2 = matcher.group(1).trim();
                if (string2.equals("*")) {
                    this.tagAll = true;
                } else {
                    this.tag = string2.startsWith("/") ? this.getPattern(string2) : string2;
                    this.noMatch = matcher.group(2).equals("!=");
                    string2 = matcher.group(3).trim();
                    if (string2.equals("*")) {
                        this.valueAll = true;
                    } else if (string2.equals("BOOLEAN_TRUE")) {
                        this.valueBool = true;
                        this.value = "yes";
                    } else if (string2.equals("BOOLEAN_FALSE")) {
                        this.valueBool = true;
                        this.value = "no";
                    } else {
                        this.value = string2.startsWith("/") ? this.getPattern(string2) : string2;
                    }
                }
            }

            public boolean match(OsmPrimitive osmPrimitive, Map<String, String> map) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String string;
                    String string2 = entry.getKey();
                    String string3 = string = this.valueBool ? OsmUtils.getNamedOsmBoolean(entry.getValue()) : entry.getValue();
                    if (!this.tagAll && !(this.tag instanceof Pattern ? ((Pattern)this.tag).matcher(string2).matches() : string2.equals(this.tag)) || !this.valueAll && !(this.value instanceof Pattern ? ((Pattern)this.value).matcher(string).matches() : string.equals(this.value))) continue;
                    return !this.noMatch;
                }
                return this.noMatch;
            }
        }
    }

    protected static class IgnoreKeyPair {
        public String key;
        public String value;

        protected IgnoreKeyPair() {
        }
    }
}

