/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;

public class PowerLines
extends Test {
    protected static final int POWER_LINES = 2501;
    public static final Collection<String> POWER_LINE_TAGS = Arrays.asList("line", "minor_line");
    public static final Collection<String> POWER_TOWER_TAGS = Arrays.asList("tower", "pole");
    public static final Collection<String> POWER_STATION_TAGS = Arrays.asList("station", "sub_station", "substation", "plant", "generator");
    public static final Collection<String> POWER_ALLOWED_TAGS = Arrays.asList("switch", "transformer", "busbar", "generator");
    private final Map<Way, String> towerPoleTagMap = new HashMap<Way, String>();
    private final List<PowerLineError> potentialErrors = new ArrayList<PowerLineError>();
    private final List<OsmPrimitive> powerStations = new ArrayList<OsmPrimitive>();

    public PowerLines() {
        super(I18n.tr("Power lines", new Object[0]), I18n.tr("Checks for nodes in power lines that do not have a power=tower/pole tag.", new Object[0]));
    }

    @Override
    public void visit(Way way) {
        if (way.isUsable()) {
            if (PowerLines.isPowerLine(way) && !way.hasTag("location", "underground")) {
                String string = null;
                boolean bl = false;
                boolean bl2 = false;
                for (Node node : way.getNodes()) {
                    if (!PowerLines.isPowerTower(node)) {
                        if (PowerLines.isPowerAllowed(node)) continue;
                        this.potentialErrors.add(new PowerLineError(node, way));
                        bl = true;
                        continue;
                    }
                    if (string == null) {
                        string = node.get("power");
                        bl2 = true;
                        continue;
                    }
                    if (string.equals(node.get("power"))) continue;
                    bl2 = false;
                }
                if (bl && bl2) {
                    this.towerPoleTagMap.put(way, string);
                }
            } else if (way.isClosed() && PowerLines.isPowerStation(way)) {
                this.powerStations.add(way);
            }
        }
    }

    @Override
    public void visit(Relation relation) {
        if (relation.isMultipolygon() && PowerLines.isPowerStation(relation)) {
            this.powerStations.add(relation);
        }
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.towerPoleTagMap.clear();
        this.powerStations.clear();
        this.potentialErrors.clear();
    }

    @Override
    public void endTest() {
        for (PowerLineError powerLineError : this.potentialErrors) {
            Node node = powerLineError.getNode();
            if (node == null || this.isInPowerStation(node)) continue;
            this.errors.add(powerLineError);
        }
        this.potentialErrors.clear();
        super.endTest();
    }

    protected final boolean isInPowerStation(Node node) {
        for (OsmPrimitive osmPrimitive : this.powerStations) {
            Object object;
            ArrayList<List<Node>> arrayList = new ArrayList<List<Node>>();
            if (osmPrimitive instanceof Way) {
                arrayList.add(((Way)osmPrimitive).getNodes());
            } else if (osmPrimitive instanceof Relation && (object = MultipolygonCache.getInstance().get(Main.map.mapView, (Relation)osmPrimitive)) != null) {
                for (Multipolygon.JoinedWay joinedWay : Multipolygon.joinWays(((Multipolygon)object).getOuterWays())) {
                    arrayList.add(joinedWay.getNodes());
                }
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                List list = (List)object.next();
                if (!Geometry.nodeInsidePolygon(node, list)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Command fixError(TestError testError) {
        Iterator<? extends OsmPrimitive> iterator;
        if (testError instanceof PowerLineError && this.isFixable(testError) && (iterator = testError.getPrimitives().iterator()).hasNext()) {
            return new ChangePropertyCommand(iterator.next(), "power", this.towerPoleTagMap.get(((PowerLineError)testError).line));
        }
        return null;
    }

    @Override
    public boolean isFixable(TestError testError) {
        return testError instanceof PowerLineError && this.towerPoleTagMap.containsKey(((PowerLineError)testError).line);
    }

    protected static final boolean isPowerLine(Way way) {
        return PowerLines.isPowerIn(way, POWER_LINE_TAGS);
    }

    protected static final boolean isPowerStation(OsmPrimitive osmPrimitive) {
        return PowerLines.isPowerIn(osmPrimitive, POWER_STATION_TAGS);
    }

    protected static final boolean isPowerTower(Node node) {
        return PowerLines.isPowerIn(node, POWER_TOWER_TAGS);
    }

    protected static final boolean isPowerAllowed(Node node) {
        return PowerLines.isPowerIn(node, POWER_ALLOWED_TAGS);
    }

    private static final boolean isPowerIn(OsmPrimitive osmPrimitive, Collection<String> collection) {
        String string = osmPrimitive.get("power");
        return string != null && collection != null && collection.contains(string);
    }

    protected class PowerLineError
    extends TestError {
        private final Way line;

        public PowerLineError(Node node, Way way) {
            super((Test)PowerLines.this, Severity.WARNING, I18n.tr("Missing power tower/pole within power line", new Object[0]), 2501, node);
            this.line = way;
        }

        public final Node getNode() {
            Iterator<? extends OsmPrimitive> iterator = this.getPrimitives().iterator();
            return iterator.hasNext() ? (Node)iterator.next() : null;
        }
    }
}

