/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.QuadTiling;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;

public class QuadBuckets<T extends OsmPrimitive>
implements Collection<T> {
    private static final boolean consistency_testing = false;
    private static final int NW_INDEX = 1;
    private static final int NE_INDEX = 3;
    private static final int SE_INDEX = 2;
    private static final int SW_INDEX = 0;
    public static final int MAX_OBJECTS_PER_LEVEL = 16;
    private QBLevel<T> root;
    private QBLevel<T> search_cache;
    private int size;

    static void abort(String string) {
        throw new AssertionError((Object)string);
    }

    public QuadBuckets() {
        this.clear();
    }

    @Override
    public final void clear() {
        this.root = new QBLevel(this);
        this.search_cache = null;
        this.size = 0;
    }

    @Override
    public boolean add(T t) {
        this.root.add(t);
        ++this.size;
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        for (OsmPrimitive osmPrimitive : this) {
            if (collection.contains(osmPrimitive) || this.remove(osmPrimitive)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            bl |= this.remove(obj);
        }
        return bl;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean bl = false;
        for (OsmPrimitive osmPrimitive : collection) {
            bl |= this.add((T)osmPrimitive);
        }
        return bl;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object object) {
        OsmPrimitive osmPrimitive = (OsmPrimitive)object;
        this.search_cache = null;
        QBLevel<OsmPrimitive> qBLevel = this.root.findBucket(osmPrimitive.getBBox());
        if (qBLevel.remove_content(osmPrimitive)) {
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object object) {
        OsmPrimitive osmPrimitive = (OsmPrimitive)object;
        QBLevel<T> qBLevel = this.root.findBucket(osmPrimitive.getBBox());
        return qBLevel != null && ((QBLevel)qBLevel).content != null && ((QBLevel)qBLevel).content.contains(osmPrimitive);
    }

    public ArrayList<T> toArrayList() {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : this) {
            arrayList.add(osmPrimitive);
        }
        return arrayList;
    }

    @Override
    public Object[] toArray() {
        return this.toArrayList().toArray();
    }

    @Override
    public <A> A[] toArray(A[] AArray) {
        return this.toArrayList().toArray(AArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new QuadBucketIterator(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public List<T> search(BBox bBox) {
        ArrayList arrayList = new ArrayList();
        boolean bl = true;
        if (bl) {
            if (this.search_cache == null) {
                this.search_cache = this.root;
            }
            while (this.search_cache != null && !this.search_cache.bbox().bounds(bBox)) {
                this.search_cache = ((QBLevel)this.search_cache).parent;
            }
            if (this.search_cache == null) {
                this.search_cache = this.root;
                Main.info("bbox: " + bBox + " is out of the world");
            }
        } else {
            this.search_cache = this.root;
        }
        QBLevel qBLevel = ((QBLevel)this.search_cache).parent;
        ((QBLevel)this.search_cache).search(bBox, arrayList);
        while (qBLevel != null) {
            qBLevel.search_contents(bBox, arrayList);
            qBLevel = qBLevel.parent;
        }
        return arrayList;
    }

    public void printTree() {
        this.printTreeRecursive(this.root, 0);
    }

    private void printTreeRecursive(QBLevel<T> qBLevel, int n) {
        if (qBLevel == null) {
            this.printIndented(n, "<empty child>");
            return;
        }
        this.printIndented(n, qBLevel);
        if (qBLevel.hasContent()) {
            for (OsmPrimitive osmPrimitive : ((QBLevel)qBLevel).content) {
                this.printIndented(n, osmPrimitive);
            }
        }
        for (QBLevel qBLevel2 : ((QBLevel)qBLevel).getChildren()) {
            this.printTreeRecursive(qBLevel2, n + 2);
        }
    }

    private void printIndented(int n, Object object) {
        for (int i = 0; i < n; ++i) {
            System.out.print(' ');
        }
        System.out.println(object);
    }

    class QuadBucketIterator
    implements Iterator<T> {
        QBLevel<T> current_node;
        int content_index;
        int iterated_over;

        final QBLevel<T> next_content_node(QBLevel<T> qBLevel) {
            if (qBLevel == null) {
                return null;
            }
            QBLevel qBLevel2 = qBLevel;
            QBLevel qBLevel3 = qBLevel.nextContentNode();
            if (qBLevel2 == qBLevel3) {
                QuadBuckets.abort("got same leaf back leaf: " + qBLevel.isLeaf());
            }
            return qBLevel3;
        }

        public QuadBucketIterator(QuadBuckets<T> quadBuckets2) {
            this.current_node = !quadBuckets2.root.hasChildren() || quadBuckets2.root.hasContent() ? quadBuckets2.root : this.next_content_node(quadBuckets2.root);
            this.iterated_over = 0;
        }

        @Override
        public boolean hasNext() {
            return this.peek() != null;
        }

        T peek() {
            if (this.current_node == null) {
                return null;
            }
            while (this.current_node.content == null || this.content_index >= this.current_node.content.size()) {
                this.content_index = 0;
                this.current_node = this.next_content_node(this.current_node);
                if (this.current_node != null) continue;
            }
            if (this.current_node == null || this.current_node.content == null) {
                return null;
            }
            return (OsmPrimitive)this.current_node.content.get(this.content_index);
        }

        @Override
        public T next() {
            Object t = this.peek();
            ++this.content_index;
            ++this.iterated_over;
            return t;
        }

        @Override
        public void remove() {
            --this.content_index;
            Object t = this.peek();
            this.current_node.remove_content(t);
        }
    }

    static class QBLevel<T extends OsmPrimitive> {
        private final int level;
        private final int index;
        private final BBox bbox;
        private final long quad;
        private final QBLevel<T> parent;
        private boolean isLeaf = true;
        private List<T> content;
        private QBLevel<T> nw;
        private QBLevel<T> ne;
        private QBLevel<T> sw;
        private QBLevel<T> se;
        private final QuadBuckets<T> buckets;

        private QBLevel<T> getChild(int n) {
            switch (n) {
                case 3: {
                    if (this.ne == null) {
                        this.ne = new QBLevel<T>(this, n, this.buckets);
                    }
                    return this.ne;
                }
                case 1: {
                    if (this.nw == null) {
                        this.nw = new QBLevel<T>(this, n, this.buckets);
                    }
                    return this.nw;
                }
                case 2: {
                    if (this.se == null) {
                        this.se = new QBLevel<T>(this, n, this.buckets);
                    }
                    return this.se;
                }
                case 0: {
                    if (this.sw == null) {
                        this.sw = new QBLevel<T>(this, n, this.buckets);
                    }
                    return this.sw;
                }
            }
            return null;
        }

        private QBLevel<T>[] getChildren() {
            return new QBLevel[]{this.sw, this.nw, this.se, this.ne};
        }

        public String toString() {
            return super.toString() + "[" + this.level + "]: " + this.bbox();
        }

        public QBLevel(QuadBuckets<T> quadBuckets) {
            this.level = 0;
            this.index = 0;
            this.quad = 0L;
            this.parent = null;
            this.bbox = new BBox(-180.0, 90.0, 180.0, -90.0);
            this.buckets = quadBuckets;
        }

        public QBLevel(QBLevel<T> qBLevel, int n, QuadBuckets<T> quadBuckets) {
            this.parent = qBLevel;
            this.level = qBLevel.level + 1;
            this.index = n;
            this.buckets = quadBuckets;
            int n2 = (24 - this.level) * 2;
            long l = 1L;
            if (n2 >= 30) {
                n2 -= 30;
                l = 0x40000000L;
            }
            long l2 = l * (long)(n << n2);
            this.quad = qBLevel.quad | l2;
            this.bbox = this.calculateBBox();
        }

        private BBox calculateBBox() {
            LatLon latLon = this.coor();
            double d = latLon.lat() + this.parent.height() / 2.0;
            double d2 = latLon.lon() + this.parent.width() / 2.0;
            return new BBox(latLon.lon(), latLon.lat(), d2, d);
        }

        QBLevel<T> findBucket(BBox bBox) {
            if (!this.hasChildren()) {
                return this;
            }
            int n = bBox.getIndex(this.level);
            if (n == -1) {
                return this;
            }
            return this.getChild(n).findBucket(bBox);
        }

        boolean remove_content(T t) {
            if (this.content == null) {
                return false;
            }
            boolean bl = this.content.remove(t);
            if (this.content.isEmpty()) {
                this.content = null;
            }
            if (this.canRemove()) {
                this.remove_from_parent();
            }
            return bl;
        }

        void __split() {
            List<T> list = this.content;
            this.content = null;
            for (OsmPrimitive osmPrimitive : list) {
                int n = osmPrimitive.getBBox().getIndex(this.level);
                if (n == -1) {
                    this.__add_content(osmPrimitive);
                    continue;
                }
                this.getChild(n).doAdd(osmPrimitive);
            }
            this.isLeaf = false;
        }

        boolean __add_content(T t) {
            boolean bl = false;
            if (this.content == null) {
                this.content = new ArrayList<T>();
            }
            bl = this.content.add(t);
            return bl;
        }

        boolean matches(T t, BBox bBox) {
            if (t instanceof Node) {
                LatLon latLon = ((Node)t).getCoor();
                return bBox.bounds(latLon != null ? latLon : LatLon.ZERO);
            }
            return ((OsmPrimitive)t).getBBox().intersects(bBox);
        }

        private void search_contents(BBox bBox, List<T> list) {
            if (this.content == null) {
                return;
            }
            for (OsmPrimitive osmPrimitive : this.content) {
                if (!this.matches(osmPrimitive, bBox)) continue;
                list.add(osmPrimitive);
            }
        }

        boolean isLeaf() {
            return this.isLeaf;
        }

        boolean hasChildren() {
            return this.nw != null || this.ne != null || this.sw != null || this.se != null;
        }

        QBLevel<T> next_sibling() {
            return this.parent == null ? null : this.parent.firstSiblingOf(this);
        }

        boolean hasContent() {
            return this.content != null;
        }

        QBLevel<T> nextSibling() {
            QBLevel<T> qBLevel = this;
            QBLevel<T> qBLevel2 = qBLevel.next_sibling();
            while (qBLevel2 == null && (qBLevel = qBLevel.parent) != null) {
                qBLevel2 = qBLevel.next_sibling();
            }
            qBLevel = qBLevel2;
            return qBLevel;
        }

        QBLevel<T> firstChild() {
            if (this.sw != null) {
                return this.sw;
            }
            if (this.nw != null) {
                return this.nw;
            }
            if (this.se != null) {
                return this.se;
            }
            return this.ne;
        }

        QBLevel<T> firstSiblingOf(QBLevel<T> qBLevel) {
            switch (qBLevel.index) {
                case 0: {
                    if (this.nw != null) {
                        return this.nw;
                    }
                }
                case 1: {
                    if (this.se != null) {
                        return this.se;
                    }
                }
                case 2: {
                    return this.ne;
                }
            }
            return null;
        }

        QBLevel<T> nextNode() {
            if (!this.hasChildren()) {
                return this.nextSibling();
            }
            return this.firstChild();
        }

        QBLevel<T> nextContentNode() {
            QBLevel<T> qBLevel = this.nextNode();
            if (qBLevel == null) {
                return qBLevel;
            }
            if (qBLevel.hasContent()) {
                return qBLevel;
            }
            return qBLevel.nextContentNode();
        }

        void doAdd(T t) {
            this.__add_content(t);
            if (this.isLeaf() && this.content.size() > 16 && this.level < 24) {
                this.__split();
            }
        }

        void add(T t) {
            this.findBucket(((OsmPrimitive)t).getBBox()).doAdd(t);
        }

        private void search(BBox bBox, List<T> list) {
            if (!this.bbox().intersects(bBox)) {
                return;
            }
            if (this.bbox().bounds(bBox)) {
                ((QuadBuckets)this.buckets).search_cache = this;
            }
            if (this.hasContent()) {
                this.search_contents(bBox, list);
            }
            if (this.nw != null) {
                super.search(bBox, list);
            }
            if (this.ne != null) {
                super.search(bBox, list);
            }
            if (this.se != null) {
                super.search(bBox, list);
            }
            if (this.sw != null) {
                super.search(bBox, list);
            }
        }

        public String quads() {
            return Long.toHexString(this.quad);
        }

        int index_of(QBLevel<T> qBLevel) {
            QBLevel<T>[] qBLevelArray = this.getChildren();
            for (int i = 0; i < 4; ++i) {
                if (qBLevelArray[i] != qBLevel) continue;
                return i;
            }
            return -1;
        }

        double width() {
            return this.bbox.width();
        }

        double height() {
            return this.bbox.height();
        }

        public BBox bbox() {
            return this.bbox;
        }

        final LatLon coor() {
            return QuadTiling.tile2LatLon(this.quad);
        }

        void remove_from_parent() {
            if (this.parent == null) {
                return;
            }
            if (!this.canRemove()) {
                QuadBuckets.abort("attempt to remove non-empty child: " + this.content + " " + Arrays.toString(this.getChildren()));
            }
            if (this.parent.nw == this) {
                this.parent.nw = null;
            } else if (this.parent.ne == this) {
                this.parent.ne = null;
            } else if (this.parent.sw == this) {
                this.parent.sw = null;
            } else if (this.parent.se == this) {
                this.parent.se = null;
            }
            if (this.parent.canRemove()) {
                this.parent.remove_from_parent();
            }
        }

        boolean canRemove() {
            if (this.content != null && !this.content.isEmpty()) {
                return false;
            }
            return !this.hasChildren();
        }
    }
}

