/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.io.imagery.ImageryReader;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class ImageryLayerInfo {
    public static final ImageryLayerInfo instance = new ImageryLayerInfo();
    List<ImageryInfo> layers = new ArrayList<ImageryInfo>();
    static List<ImageryInfo> defaultLayers = new ArrayList<ImageryInfo>();
    private static final String[] DEFAULT_LAYER_SITES = new String[]{Main.getJOSMWebsite() + "/maps"};

    private ImageryLayerInfo() {
    }

    public ImageryLayerInfo(ImageryLayerInfo imageryLayerInfo) {
        this.layers.addAll(imageryLayerInfo.layers);
    }

    public void clear() {
        this.layers.clear();
    }

    public void load() {
        boolean bl = !this.layers.isEmpty();
        List<ImageryInfo.ImageryPreferenceEntry> list = Main.pref.getListOfStructs("imagery.entries", null, ImageryInfo.ImageryPreferenceEntry.class);
        if (list != null) {
            for (ImageryInfo.ImageryPreferenceEntry imageryPreferenceEntry : list) {
                try {
                    ImageryInfo imageryInfo = new ImageryInfo(imageryPreferenceEntry);
                    this.add(imageryInfo);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Main.warn("Unable to load imagery preference entry:" + illegalArgumentException);
                }
            }
            Collections.sort(this.layers);
        }
        if (bl) {
            this.save();
        }
    }

    public void loadDefaults(boolean bl) {
        defaultLayers.clear();
        for (String object2 : Main.pref.getCollection("imagery.layers.sites", Arrays.asList(DEFAULT_LAYER_SITES))) {
            if (bl) {
                MirroredInputStream.cleanup(object2);
            }
            Iterator<ImageryInfo> iterator = null;
            try {
                ImageryReader sAXException = new ImageryReader(object2);
                List<ImageryInfo> list = sAXException.parse();
                defaultLayers.addAll(list);
            }
            catch (IOException iOException) {
                Utils.close(iterator);
                Main.error(iOException, false);
            }
            catch (SAXException sAXException) {
                Utils.close(iterator);
                Main.error(sAXException);
            }
        }
        while (defaultLayers.remove(null)) {
        }
        ArrayList<String> collection = Main.pref.getCollection("imagery.layers.default");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ImageryInfo imageryInfo : defaultLayers) {
            if (!imageryInfo.isDefaultEntry()) continue;
            arrayList.add(imageryInfo.getUrl());
            boolean bl2 = false;
            for (Object object : collection) {
                if (!this.isSimilar((String)object, imageryInfo.getUrl())) continue;
                bl2 = true;
                break;
            }
            boolean bl3 = false;
            if (!bl2) {
                Object object;
                object = this.layers.iterator();
                while (object.hasNext()) {
                    ImageryInfo imageryInfo2 = (ImageryInfo)object.next();
                    if (!this.isSimilar(imageryInfo.getUrl(), imageryInfo2.getUrl())) continue;
                    bl3 = true;
                    break;
                }
            }
            if (bl2 || bl3) continue;
            this.add(new ImageryInfo(imageryInfo));
        }
        Collections.sort(defaultLayers);
        Main.pref.putCollection("imagery.layers.default", arrayList.isEmpty() ? collection : arrayList);
    }

    private boolean isSimilar(String string, String string2) {
        return Utils.equal(string, string2) || string != null && string2 != null && !string.isEmpty() && !string2.isEmpty() && (string.contains(string2) || string2.contains(string));
    }

    public void add(ImageryInfo imageryInfo) {
        this.layers.add(imageryInfo);
    }

    public void remove(ImageryInfo imageryInfo) {
        this.layers.remove(imageryInfo);
    }

    public void save() {
        ArrayList<ImageryInfo.ImageryPreferenceEntry> arrayList = new ArrayList<ImageryInfo.ImageryPreferenceEntry>();
        for (ImageryInfo imageryInfo : this.layers) {
            arrayList.add(new ImageryInfo.ImageryPreferenceEntry(imageryInfo));
        }
        Main.pref.putListOfStructs("imagery.entries", arrayList, ImageryInfo.ImageryPreferenceEntry.class);
    }

    public List<ImageryInfo> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public List<ImageryInfo> getDefaultLayers() {
        return Collections.unmodifiableList(defaultLayers);
    }

    public static void addLayer(ImageryInfo imageryInfo) {
        instance.add(imageryInfo);
        instance.save();
    }

    public static void addLayers(Collection<ImageryInfo> collection) {
        for (ImageryInfo imageryInfo : collection) {
            instance.add(imageryInfo);
        }
        instance.save();
        Collections.sort(ImageryLayerInfo.instance.layers);
    }
}

