/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.Attributed;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.imagery.Shape;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ImageProvider;

public class ImageryInfo
implements Comparable<ImageryInfo>,
Attributed {
    private String name;
    private String url = null;
    private boolean defaultEntry = false;
    private String cookies = null;
    private String eulaAcceptanceRequired = null;
    private ImageryType imageryType = ImageryType.WMS;
    private double pixelPerDegree = 0.0;
    private int defaultMaxZoom = 0;
    private int defaultMinZoom = 0;
    private ImageryBounds bounds = null;
    private List<String> serverProjections;
    private String attributionText;
    private String attributionLinkURL;
    private String attributionImage;
    private String attributionImageURL;
    private String termsOfUseText;
    private String termsOfUseURL;
    private String countryCode = "";
    private String icon;

    public ImageryInfo() {
    }

    public ImageryInfo(String string) {
        this.name = string;
    }

    public ImageryInfo(String string, String string2) {
        this.name = string;
        this.setExtendedUrl(string2);
    }

    public ImageryInfo(String string, String string2, String string3) {
        this.name = string;
        this.setExtendedUrl(string2);
        this.eulaAcceptanceRequired = string3;
    }

    public ImageryInfo(String string, String string2, String string3, String string4, String string5) {
        this.name = string;
        this.setExtendedUrl(string2);
        ImageryType imageryType = ImageryType.fromString(string3);
        this.cookies = string5;
        this.eulaAcceptanceRequired = string4;
        if (imageryType != null) {
            this.imageryType = imageryType;
        }
    }

    public ImageryInfo(ImageryPreferenceEntry imageryPreferenceEntry) {
        CheckParameterUtil.ensureParameterNotNull(imageryPreferenceEntry.name, "name");
        CheckParameterUtil.ensureParameterNotNull(imageryPreferenceEntry.url, "url");
        this.name = imageryPreferenceEntry.name;
        this.url = imageryPreferenceEntry.url;
        this.cookies = imageryPreferenceEntry.cookies;
        this.eulaAcceptanceRequired = imageryPreferenceEntry.eula;
        this.imageryType = ImageryType.fromString(imageryPreferenceEntry.type);
        if (this.imageryType == null) {
            throw new IllegalArgumentException("unknown type");
        }
        this.pixelPerDegree = imageryPreferenceEntry.pixel_per_eastnorth;
        this.defaultMaxZoom = imageryPreferenceEntry.max_zoom;
        this.defaultMinZoom = imageryPreferenceEntry.min_zoom;
        if (imageryPreferenceEntry.bounds != null) {
            this.bounds = new ImageryBounds(imageryPreferenceEntry.bounds, ",");
            if (imageryPreferenceEntry.shapes != null) {
                try {
                    for (String string : imageryPreferenceEntry.shapes.split(";")) {
                        this.bounds.addShape(new Shape(string, ","));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Main.warn(illegalArgumentException);
                }
            }
        }
        if (imageryPreferenceEntry.projections != null) {
            this.serverProjections = Arrays.asList(imageryPreferenceEntry.projections.split(","));
        }
        this.attributionText = imageryPreferenceEntry.attribution_text;
        this.attributionLinkURL = imageryPreferenceEntry.attribution_url;
        this.attributionImage = imageryPreferenceEntry.logo_image;
        this.attributionImageURL = imageryPreferenceEntry.logo_url;
        this.termsOfUseText = imageryPreferenceEntry.terms_of_use_text;
        this.termsOfUseURL = imageryPreferenceEntry.terms_of_use_url;
        this.countryCode = imageryPreferenceEntry.country_code;
        this.icon = imageryPreferenceEntry.icon;
    }

    public ImageryInfo(ImageryInfo imageryInfo) {
        this.name = imageryInfo.name;
        this.url = imageryInfo.url;
        this.defaultEntry = imageryInfo.defaultEntry;
        this.cookies = imageryInfo.cookies;
        this.eulaAcceptanceRequired = null;
        this.imageryType = imageryInfo.imageryType;
        this.pixelPerDegree = imageryInfo.pixelPerDegree;
        this.defaultMaxZoom = imageryInfo.defaultMaxZoom;
        this.defaultMinZoom = imageryInfo.defaultMinZoom;
        this.bounds = imageryInfo.bounds;
        this.serverProjections = imageryInfo.serverProjections;
        this.attributionText = imageryInfo.attributionText;
        this.attributionLinkURL = imageryInfo.attributionLinkURL;
        this.attributionImage = imageryInfo.attributionImage;
        this.attributionImageURL = imageryInfo.attributionImageURL;
        this.termsOfUseText = imageryInfo.termsOfUseText;
        this.termsOfUseURL = imageryInfo.termsOfUseURL;
        this.countryCode = imageryInfo.countryCode;
        this.icon = imageryInfo.icon;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ImageryInfo imageryInfo = (ImageryInfo)object;
        if (this.imageryType != imageryInfo.imageryType) {
            return false;
        }
        if (this.url != null ? !this.url.equals(imageryInfo.url) : imageryInfo.url != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(imageryInfo.name) : imageryInfo.name != null);
    }

    public int hashCode() {
        int n = this.url != null ? this.url.hashCode() : 0;
        n = 31 * n + (this.imageryType != null ? this.imageryType.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "ImageryInfo{name='" + this.name + '\'' + ", countryCode='" + this.countryCode + '\'' + ", url='" + this.url + '\'' + ", imageryType=" + (Object)((Object)this.imageryType) + '}';
    }

    @Override
    public int compareTo(ImageryInfo imageryInfo) {
        int n = this.countryCode.compareTo(imageryInfo.countryCode);
        if (n == 0) {
            n = this.name.compareTo(imageryInfo.name);
        }
        if (n == 0) {
            n = this.url.compareTo(imageryInfo.url);
        }
        if (n == 0) {
            n = Double.compare(this.pixelPerDegree, imageryInfo.pixelPerDegree);
        }
        return n;
    }

    public boolean equalsBaseValues(ImageryInfo imageryInfo) {
        return this.url.equals(imageryInfo.url);
    }

    public void setPixelPerDegree(double d) {
        this.pixelPerDegree = d;
    }

    public void setDefaultMaxZoom(int n) {
        this.defaultMaxZoom = n;
    }

    public void setDefaultMinZoom(int n) {
        this.defaultMinZoom = n;
    }

    public void setBounds(ImageryBounds imageryBounds) {
        this.bounds = imageryBounds;
    }

    public ImageryBounds getBounds() {
        return this.bounds;
    }

    @Override
    public boolean requiresAttribution() {
        return this.attributionText != null || this.attributionImage != null || this.termsOfUseText != null || this.termsOfUseURL != null;
    }

    @Override
    public String getAttributionText(int n, Coordinate coordinate, Coordinate coordinate2) {
        return this.attributionText;
    }

    @Override
    public String getAttributionLinkURL() {
        return this.attributionLinkURL;
    }

    @Override
    public Image getAttributionImage() {
        ImageIcon imageIcon = ImageProvider.getIfAvailable(this.attributionImage);
        if (imageIcon != null) {
            return imageIcon.getImage();
        }
        return null;
    }

    @Override
    public String getAttributionImageURL() {
        return this.attributionImageURL;
    }

    @Override
    public String getTermsOfUseText() {
        return this.termsOfUseText;
    }

    @Override
    public String getTermsOfUseURL() {
        return this.termsOfUseURL;
    }

    public void setAttributionText(String string) {
        this.attributionText = string;
    }

    public void setAttributionImageURL(String string) {
        this.attributionImageURL = string;
    }

    public void setAttributionImage(String string) {
        this.attributionImage = string;
    }

    public void setAttributionLinkURL(String string) {
        this.attributionLinkURL = string;
    }

    public void setTermsOfUseText(String string) {
        this.termsOfUseText = string;
    }

    public void setTermsOfUseURL(String string) {
        this.termsOfUseURL = string;
    }

    public void setExtendedUrl(String string) {
        CheckParameterUtil.ensureParameterNotNull(string);
        this.url = string;
        this.imageryType = ImageryType.WMS;
        this.defaultMaxZoom = 0;
        this.defaultMinZoom = 0;
        for (ImageryType imageryType : ImageryType.values()) {
            Matcher object = Pattern.compile(imageryType.getTypeString() + "(?:\\[(?:(\\d+),)?(\\d+)\\])?:(.*)").matcher(string);
            if (!object.matches()) continue;
            this.url = object.group(3);
            this.imageryType = imageryType;
            if (object.group(2) != null) {
                this.defaultMaxZoom = Integer.valueOf(object.group(2));
            }
            if (object.group(1) == null) break;
            this.defaultMinZoom = Integer.valueOf(object.group(1));
            break;
        }
        if (this.serverProjections == null || this.serverProjections.isEmpty()) {
            try {
                this.serverProjections = new ArrayList<String>();
                Matcher matcher = Pattern.compile(".*\\{PROJ\\(([^)}]+)\\)\\}.*").matcher(string.toUpperCase());
                if (matcher.matches()) {
                    for (String string2 : matcher.group(1).split(",")) {
                        this.serverProjections.add(string2);
                    }
                }
            }
            catch (Exception exception) {
                Main.warn(exception);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public boolean isDefaultEntry() {
        return this.defaultEntry;
    }

    public void setDefaultEntry(boolean bl) {
        this.defaultEntry = bl;
    }

    public String getCookies() {
        return this.cookies;
    }

    public double getPixelPerDegree() {
        return this.pixelPerDegree;
    }

    public int getMaxZoom() {
        return this.defaultMaxZoom;
    }

    public int getMinZoom() {
        return this.defaultMinZoom;
    }

    public String getEulaAcceptanceRequired() {
        return this.eulaAcceptanceRequired;
    }

    public void setEulaAcceptanceRequired(String string) {
        this.eulaAcceptanceRequired = string;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String string) {
        this.countryCode = string;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String string) {
        this.icon = string;
    }

    public List<String> getServerProjections() {
        if (this.serverProjections == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.serverProjections);
    }

    public void setServerProjections(Collection<String> collection) {
        this.serverProjections = new ArrayList<String>(collection);
    }

    public String getExtendedUrl() {
        return this.imageryType.getTypeString() + (this.defaultMaxZoom != 0 ? "[" + (this.defaultMinZoom != 0 ? this.defaultMinZoom + "," : "") + this.defaultMaxZoom + "]" : "") + ":" + this.url;
    }

    public String getToolbarName() {
        String string = this.name;
        if (this.pixelPerDegree != 0.0) {
            string = string + "#PPD=" + this.pixelPerDegree;
        }
        return string;
    }

    public String getMenuName() {
        String string = this.name;
        if (this.pixelPerDegree != 0.0) {
            string = string + " (" + this.pixelPerDegree + ")";
        }
        return string;
    }

    public boolean hasAttribution() {
        return this.attributionText != null;
    }

    public void copyAttribution(ImageryInfo imageryInfo) {
        this.attributionImage = imageryInfo.attributionImage;
        this.attributionImageURL = imageryInfo.attributionImageURL;
        this.attributionText = imageryInfo.attributionText;
        this.attributionLinkURL = imageryInfo.attributionLinkURL;
        this.termsOfUseText = imageryInfo.termsOfUseText;
        this.termsOfUseURL = imageryInfo.termsOfUseURL;
    }

    public void setAttribution(AbstractTileSource abstractTileSource) {
        ImageIcon imageIcon;
        if (this.attributionText != null) {
            if (this.attributionText.equals("osm")) {
                abstractTileSource.setAttributionText(new OsmTileSource.Mapnik().getAttributionText(0, null, null));
            } else {
                abstractTileSource.setAttributionText(this.attributionText);
            }
        }
        if (this.attributionLinkURL != null) {
            if (this.attributionLinkURL.equals("osm")) {
                abstractTileSource.setAttributionLinkURL(new OsmTileSource.Mapnik().getAttributionLinkURL());
            } else {
                abstractTileSource.setAttributionLinkURL(this.attributionLinkURL);
            }
        }
        if (this.attributionImage != null && (imageIcon = ImageProvider.getIfAvailable(null, this.attributionImage)) != null) {
            abstractTileSource.setAttributionImage(imageIcon.getImage());
        }
        if (this.attributionImageURL != null) {
            abstractTileSource.setAttributionImageURL(this.attributionImageURL);
        }
        if (this.termsOfUseText != null) {
            abstractTileSource.setTermsOfUseText(this.termsOfUseText);
        }
        if (this.termsOfUseURL != null) {
            if (this.termsOfUseURL.equals("osm")) {
                abstractTileSource.setTermsOfUseURL(new OsmTileSource.Mapnik().getTermsOfUseURL());
            } else {
                abstractTileSource.setTermsOfUseURL(this.termsOfUseURL);
            }
        }
    }

    public ImageryType getImageryType() {
        return this.imageryType;
    }

    public void setImageryType(ImageryType imageryType) {
        this.imageryType = imageryType;
    }

    public boolean isBlacklisted() {
        return OsmApi.getOsmApi().getCapabilities().isOnImageryBlacklist(this.url);
    }

    public static class ImageryPreferenceEntry {
        @Preferences.pref
        String name;
        @Preferences.pref
        String type;
        @Preferences.pref
        String url;
        @Preferences.pref
        double pixel_per_eastnorth;
        @Preferences.pref
        String eula;
        @Preferences.pref
        String attribution_text;
        @Preferences.pref
        String attribution_url;
        @Preferences.pref
        String logo_image;
        @Preferences.pref
        String logo_url;
        @Preferences.pref
        String terms_of_use_text;
        @Preferences.pref
        String terms_of_use_url;
        @Preferences.pref
        String country_code = "";
        @Preferences.pref
        int max_zoom;
        @Preferences.pref
        int min_zoom;
        @Preferences.pref
        String cookies;
        @Preferences.pref
        String bounds;
        @Preferences.pref
        String shapes;
        @Preferences.pref
        String projections;
        @Preferences.pref
        String icon;

        public ImageryPreferenceEntry() {
        }

        public ImageryPreferenceEntry(ImageryInfo imageryInfo) {
            StringBuilder stringBuilder;
            this.name = imageryInfo.name;
            this.type = imageryInfo.imageryType.getTypeString();
            this.url = imageryInfo.url;
            this.pixel_per_eastnorth = imageryInfo.pixelPerDegree;
            this.eula = imageryInfo.eulaAcceptanceRequired;
            this.attribution_text = imageryInfo.attributionText;
            this.attribution_url = imageryInfo.attributionLinkURL;
            this.logo_image = imageryInfo.attributionImage;
            this.logo_url = imageryInfo.attributionImageURL;
            this.terms_of_use_text = imageryInfo.termsOfUseText;
            this.terms_of_use_url = imageryInfo.termsOfUseURL;
            this.country_code = imageryInfo.countryCode;
            this.max_zoom = imageryInfo.defaultMaxZoom;
            this.min_zoom = imageryInfo.defaultMinZoom;
            this.cookies = imageryInfo.cookies;
            this.icon = imageryInfo.icon;
            if (imageryInfo.bounds != null) {
                this.bounds = imageryInfo.bounds.encodeAsString(",");
                stringBuilder = new StringBuilder();
                for (Shape object : imageryInfo.bounds.getShapes()) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(";");
                    }
                    stringBuilder.append(object.encodeAsString(","));
                }
                if (stringBuilder.length() > 0) {
                    this.shapes = stringBuilder.toString();
                }
            }
            if (imageryInfo.serverProjections != null && !imageryInfo.serverProjections.isEmpty()) {
                stringBuilder = new StringBuilder();
                for (String string : imageryInfo.serverProjections) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(string);
                }
                this.projections = stringBuilder.toString();
            }
        }

        public String toString() {
            return "ImageryPreferenceEntry [name=" + this.name + "]";
        }
    }

    public static class ImageryBounds
    extends Bounds {
        private List<Shape> shapes = new ArrayList<Shape>();

        public ImageryBounds(String string, String string2) {
            super(string, string2);
        }

        public final void addShape(Shape shape) {
            this.shapes.add(shape);
        }

        public final void setShapes(List<Shape> list) {
            this.shapes = list;
        }

        public final List<Shape> getShapes() {
            return this.shapes;
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + (this.shapes == null ? 0 : ((Object)this.shapes).hashCode());
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!super.equals(object)) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ImageryBounds imageryBounds = (ImageryBounds)object;
            return !(this.shapes == null ? imageryBounds.shapes != null : !((Object)this.shapes).equals(imageryBounds.shapes));
        }
    }

    public static enum ImageryType {
        WMS("wms"),
        TMS("tms"),
        HTML("html"),
        BING("bing"),
        SCANEX("scanex"),
        WMS_ENDPOINT("wms_endpoint");

        private final String typeString;

        private ImageryType(String string2) {
            this.typeString = string2;
        }

        public final String getTypeString() {
            return this.typeString;
        }

        public static ImageryType fromString(String string) {
            for (ImageryType imageryType : ImageryType.values()) {
                if (!imageryType.getTypeString().equals(string)) continue;
                return imageryType;
            }
            return null;
        }
    }
}

